﻿#include "escritura_float.h"

static const char8_t* const polinomios_html_p[][2]={
	{NULL,NULL},
	{"s","s"},
	{"(2s<sup>3</sup> -s)","(3s<sup>2</sup> -2s)"},
	{"(4.8s<sup>5</sup> -4.7s<sup>3</sup> +0.9s)","(9s<sup>3</sup> -11.4s<sup>2</sup> +3.4s)"},
	{"(12.8s<sup>7</sup> -19.1s<sup>5</sup> +8.2s<sup>3</sup> -0.9s)","(29.2s<sup>4</sup> -53.1s<sup>3</sup> +30.1s<sup>2</sup> -5.2s)"},
	{"(38.4s<sup>9</sup> -76.2s<sup>7</sup> +50.5s<sup>5</sup> -12.6s<sup>3</sup> +0.9s)","(95.8s<sup>5</sup> -225.4s<sup>4</sup> +187.1s<sup>3</sup> -63.9s<sup>2</sup> +7.4s)"},
	{"","(320.3s<sup>6</sup> -922.1s<sup>5</sup> +1004.9s<sup>4</sup> -511.4s<sup>3</sup> +119.2s<sup>2</sup> -9.9s)"}
};
static const char8_t* const polinomios_html_pq[][2]={
	{NULL,NULL},
	{"s","s"},
	{"s<sup>2</sup>","s<sup>2</sup>"},
	{"(2s<sup>3</sup> -s)","(3s<sup>2</sup> -2s)"},
	{"(2.5s<sup>4</sup> -1.5s<sup>2</sup>)","(4s<sup>3</sup> -3s<sup>2</sup>)"},
	{"(4.8s<sup>5</sup> -4.7s<sup>3</sup> +0.9s)","(9s<sup>3</sup> -11.4s<sup>2</sup> +3.4s)"},
	{"(6.4s<sup>6</sup> -7.2s<sup>4</sup> +1.8s<sup>2</sup>)","(14.5s<sup>4</sup> -20.3s<sup>3</sup> +6.8s<sup>2</sup>)"},
	{"(12.8s<sup>7</sup> -19.1s<sup>5</sup> +8.2s<sup>3</sup> -0.9s)","(29.2s<sup>4</sup> -53.1s<sup>3</sup> +30.1s<sup>2</sup> -5.2s)"},
	{"(19.1s<sup>8</sup> -31.6s<sup>6</sup> +15.7s<sup>4</sup> -2.2s<sup>2</sup>)","(53.5s<sup>5</sup> -107.8s<sup>4</sup> +69.5s<sup>3</sup>-14.2s<sup>2</sup>)"},
	{"(38.4s<sup>9</sup> -76.2s<sup>7</sup> +50.5s<sup>5</sup> -12.6s<sup>3</sup> +0.9s)","(95.8s<sup>5</sup> -225.4s<sup>4</sup> +187.1s<sup>3</sup> -63.9s<sup>2</sup> +7.4s)"},
};

#define GCadds(gc,s) GC_adds(gc,s,return AT_NOMEM)
int crea_formula_simetrica_html(Growing_char *s, const char8_t* letra, u8int modelo, u16int params){
	bint b;

	b=false;
	if(params&1){
		GCadds(*s,letra); GCadds(*s,u8"1·s");
		b=true;
	}
	params>>=1;

	for(u8int i=2;i<=SIM_N;i++,params>>=1){
		if(!(params&1)) continue;
		if(b) GCadds(*s," + ");
		GCadds(*s,letra);
		GCadds(*s,"<sub>"); Gadd(*s,char8_t,(char8_t)(i+'0'),return AT_NOMEM); GCadds(*s,"</sub>");
		GCadds(*s,polinomios_html_p[i][modelo-1]);
		b=true;
	}
	return 0;
}

int crea_formula_asim_rt_html(Growing_char *s, const char8_t* letra, u8int modelo, u16int params){
	bint b;
	char8_t cc[6];
	char8_t coskA[8], sinkA[8];

	for(u8int i=4;i<8;i++) coskA[i]=0,sinkA[i]=0;
	cc[5]=cc[4]=0;

	coskA[0]='c'; coskA[1]='o'; coskA[2]='s';		coskA[4]='A';
	sinkA[0]='s'; sinkA[1]='e'; sinkA[2]='n';		sinkA[4]='A';
	b=false;
	for(u8int i=1;i<=ASIM_N;i++,params>>=1){
		if(!(params&1)) continue;
		u8int j; s8int k;
		if(b) GCadds(*s," + ");
		j=poli_asim[i];
		GCadds(*s,letra); GCadds(*s,"<sub>");
		if(i<10){
			cc[0]=(char8_t)(i+'0');
			if(j<3){cc[1]=u8"·"[0]; cc[2]=u8"·"[1]; cc[3]='\0';}
			else{cc[1]='\0';}
		}else{
			u8int ib=i/10;
			cc[0]=(char8_t)(ib+'0');
			cc[1]=(char8_t)(i-10*ib+'0');
			if(j<3){cc[2]=u8"·"[0]; cc[3]=u8"·"[1];}
			else{cc[2]='\0';}
		}
		GCadds(*s,cc); GCadds(*s,"</sub>");
		const char8_t *ss;
		ss=polinomios_html_pq[j][modelo-1];
		GCadds(*s,ss);
		if(j<3){GCadds(*s,cc+1);}
		k=S_asim[i];
		if(k==1) ss="cosA";
		elif(k==-1) ss="senA";
		elif(k>0){coskA[3]=(char8_t)(k+'0'); ss=coskA;}
		else{sinkA[3]=(char8_t)(-k+'0'); ss=sinkA;}
		GCadds(*s,ss);
		b=true;
	}
	return 0;
}

int crea_formula_asim_uv_html(Growing_char *s, const char8_t* letra, u8int modelo, u16int params, bint serie){
	bint b;
	char8_t cc[6];
	char8_t coskA[8], sinkA[8];

	for(u8int i=4;i<8;i++) coskA[i]=0,sinkA[i]=0;
	cc[5]=cc[4]=0;

	coskA[0]='u'; coskA[1]='(';		coskA[4]=')';
	sinkA[0]='v'; sinkA[1]='(';		sinkA[4]=')';
	if(serie==0){
		coskA[2]='-'; sinkA[2]='-';
	}else{
		coskA[2]='+'; sinkA[2]='+';
	}

	b=false;
	if(params&1){
		GCadds(*s,letra); GCadds(*s,"<sub>1</sub>s<sup>2</sup>cos2A");
		b=true;
	}
	if(params&2){
		if(b) GCadds(*s," + ");
		GCadds(*s,letra); GCadds(*s,"<sub>2</sub>s<sup>2</sup>·sen2A");
		b=true;
	}
	params>>=2;

	*(uint*)cc=0;
	for(u8int i=3;i<=ASIM_N;i++,params>>=1){
		if(!(params&1)) continue;
		u8int j; s8int k;
		if(b) GCadds(*s," + ");
		j=poli_asim[i];
		GCadds(*s,letra); GCadds(*s,"<sub>");
		if(i<10){
			cc[0]=(char8_t)(i+'0');
			if(j<3){cc[1]=u8"·"[0]; cc[2]=u8"·"[1]; cc[3]='\0';}
			else{cc[1]='\0';}
		}else{
			u8int ib=i/10;
			cc[0]=(char8_t)(ib+'0');
			cc[1]=(char8_t)(i-10*ib+'0');
			if(j<3){cc[2]=u8"·"[0]; cc[3]=u8"·"[1];}
			else{cc[2]='\0';}
		}
		GCadds(*s,cc); GCadds(*s,"</sub>");
		GCadds(*s,polinomios_html_pq[j][modelo-1]);
		if(j<3) GCadds(*s,cc+1);
		k=S_asim[i];
		const char8_t *ss;
		if(k>0){coskA[3]=(char8_t)(k+'0'); ss=coskA;}
		else{sinkA[3]=(char8_t)(-k+'0'); ss=sinkA;}
		GCadds(*s,ss);
		b=true;
	}
	return 0;
}
int crea_formula_uv_serie1_html(Growing_char *buf, const char8_t* letra, u8int modelo, u16int params){
	return crea_formula_asim_uv_html(buf,letra,modelo,params,0);
}
int crea_formula_uv_serie2_html(Growing_char *buf, const char8_t* letra, u8int modelo, u16int params){
	return crea_formula_asim_uv_html(buf,letra,modelo,params,1);
}

#define tablehead(finf) towrite8_many_strings(finf,"\t<table class=values>\n"\
		"\t\t<col><col align=char8_t><col align=right><col align=right>\n",\
		TEX_TOS[20],NULL);
#define towrite_s_semidiag(finf,unif,semidiag) \
	setbuf_noscientific(finf); setbuf_relativep(finf,6);\
	setbuf_limpio(finf);\
	towrite8(finf,'s'," (", 'w',unif, 's',"),&nbsp;&nbsp;s=r/", 'f',semidiag, 's'," (", 'w',unif, 's',")</p>\n", 0);\
	setbuf_nolimpio(finf);

void escribe_todo_dist_html(Bufferto8 *finf, u8int _idioma, Distorsion *dist, float vv,float* N,uint n,uint n0, bint correl_a2f, const char16_t *unif, s8int decf){
	u8int modelo;
	uint n1=n+1;
	uint k;
	float faux;
	float imp_total;
	const char8_t* stable_formula="\t<p style=\"padding-top:0.6em; padding-bottom:0.25em; padding-left:1.5em\">\n\t";

	if(_idioma>MAX_IDIOMA) _idioma=0;
	const char8_t* const *TEX_TOS=TEXTOS_calibracion[_idioma];

	modelo=dist->config.modelo_poli;
	if(modelo>2){
		towrite8_string(finf,"\n          Error: modelo polinómico fuera de rango");
		return;
	}
	if(modelo==0){
		towrite8_string(finf,TEX_TOS[7]);
		return;
	}
	html_H(finf,3,TEX_TOS[16],"Par.Función de distorsión");
	towrite8_many_strings(finf,TEX_TOS[17],TEX_TOS[modelo],"<br>\n",NULL);
	if(dist->config.modelo_asim!=0){
		if(dist->config.modelo_asim>2){
			towrite8_string(finf,"\n          Error: modelo asimétrico fuera de rango");
			return;
		}
		towrite8_many_strings(finf,TEX_TOS[18],TEX_TOS[8+dist->config.modelo_asim],"<br>\n",NULL);
	}

	imp_total=0;
	k=n0*n1;
	if(dist->config.param_radsim!=0){
		html_H(finf,3,TEX_TOS[19],"Autocalib.DRS");
		tablehead(finf);
		u16int l=dist->config.param_radsim;
		for(u8int i=0;i<SIM_N;i++,l>>=1){
			if(!(l&1)) continue;
			towrite8(finf,'s',"\t\t<tr><td>a<sub>", 'u',i+1, 's',"</sub>", 0);
			setbuf_absolutep(finf,decf);
			towrite8(finf,'s',"<td>",'f',dist->valores_radsim[i], 0);
			setbuf_relativep(finf,2);
			towrite8(finf,'s',"<td>",'f',sqrtf(vv*N[k]), 0);
			setbuf_absolutep(finf,decf);
			faux=fabsf(dist->valores_radsim[i])*Cantidad_p[modelo-1][i+1];
			imp_total+=faux*faux;
			towrite8(finf,'s',"<td>",'f',faux, '\n',0);
			k+=n1;
		}
		if(correl_a2f){
			uint k1=6*n1+3;
			if((dist->config.param_radsim&2) && N[k1]!=0){
				setbuf_relativep(finf,2);
				towrite8(finf,'s',"\t<tr class=intermezzo><td colspan=3>", 's',TEX_TOS[21], 'f',N[k1]/sqrtf(N[6*n1]*N[9*n1]), '\n',0);
			}
		}
		//towrite8(finf,'s',"\t<tr class=intermezzo><td colspan=4>",	//no funciona. No interpretan bien padding negativos
		towrite8_many_strings(finf,"\t</table>\n",stable_formula,"Dr= ",NULL);
		crea_formulac_simetricas(finf,true,modelo,dist->valores_radsim,decf);
		towrite_s_semidiag(finf,unif,dist->config.semidiag);
		//'s',"\t</table>\n");
	}

	if(dist->config.param_tansim!=0){
		html_H(finf,3,TEX_TOS[22],"Autocalib.DTS");
		tablehead(finf);
		u16int l=dist->config.param_tansim;
		for(u8int i=0;i<SIM_N;i++,l>>=1){
			if(!(l&1)) continue;
			towrite8(finf,'s',"\t\t<tr><td>b<sub>", 'u',i+1, 's',"</sub>", 0);
			setbuf_absolutep(finf,decf);
			towrite8(finf,'s',"<td>",'f',dist->valores_tansim[i], 0);
			setbuf_relativep(finf,2);
			towrite8(finf,'s',"<td>",'f',sqrtf(vv*N[k]), 0);
			setbuf_absolutep(finf,decf);
			faux=fabsf(dist->valores_tansim[i])*Cantidad_p[modelo-1][i+1];
			imp_total+=faux*faux;
			towrite8(finf,'s',"<td>",'f',faux, '\n',0);
			k+=n1;
		}
		//finf<<"\t\t<tr class=intermezzo><td colspan=4>";
		towrite8_many_strings(finf,"\t</table>\n",stable_formula,"Dt= ",NULL);
		crea_formulac_simetricas(finf,true,modelo,dist->valores_tansim,decf);
		towrite_s_semidiag(finf,unif,dist->config.semidiag);
		//finf<<"\t</table>"<<endl;
	}
	if(dist->config.modelo_asim==CAL_MODASIM_RADTAN){
		if(dist->config.param_asim1!=0){
			html_H(finf,3,TEX_TOS[23],"Autocalib.DA1");
			tablehead(finf);
			u16int l=dist->config.param_asim1;
			for(u8int i=0;i<ASIM_N;i++,l>>=1){
				if(!(l&1)) continue;
				towrite8(finf,'s',"\t\t<tr><td>c<sub>", 'u',i+1, 's',"</sub>", 0);
				setbuf_absolutep(finf,decf);
				towrite8(finf,'s',"<td>",'f',dist->valores_asim1[i], 0);
				setbuf_relativep(finf,2);
				towrite8(finf,'s',"<td>",'f',sqrtf(vv*N[k]), 0);
				setbuf_absolutep(finf,decf);
				float faux=Cantidad_pq[modelo-1][poli_asim[i+1]];
				faux*=0.707F*fabsf(dist->valores_asim1[i]);
				imp_total+=faux*faux;
				towrite8(finf,'s',"<td>",'f',faux, '\n',0);
				k+=n1;
			}
			//finf<<"\t\t<tr class=intermezzo><td colspan=4>";
			towrite8_many_strings(finf,"\t</table>\n",stable_formula,"Dr= ",NULL);
			crea_formulac_asimetrica_rt_s(finf,true,modelo,dist->valores_asim1,decf);
			towrite_s_semidiag(finf,unif,dist->config.semidiag);
			//finf<<"\t</table>"<<endl;
		}
		if(dist->config.param_asim2!=0){
			html_H(finf,3,TEX_TOS[24],"Autocalib.DA2");
			tablehead(finf);
			u16int l=dist->config.param_asim2;
			for(u8int i=0;i<ASIM_N;i++,l>>=1){
				if(!(l&1)) continue;
				towrite8(finf,'s',"\t\t<tr><td>d<sub>", 'u',i+1, 's',"</sub>", 0);
				setbuf_absolutep(finf,decf);
				towrite8(finf,'s',"<td>",'f',dist->valores_asim2[i], 0);
				setbuf_relativep(finf,2);
				towrite8(finf,'s',"<td>",'f',sqrtf(vv*N[k]), 0);
				setbuf_absolutep(finf,decf);
				float faux=Cantidad_pq[modelo-1][poli_asim[i+1]];
				faux*=0.707F*fabsf(dist->valores_asim2[i]);
				imp_total+=faux*faux;
				towrite8(finf,'s',"<td>",'f',faux, '\n',0);
				k+=n1;
			}
			towrite8_many_strings(finf,"\t</table>\n",stable_formula,"Dt= ",NULL);
			//finf<<"\t\t<tr class=intermezzo><td colspan=4>";
			crea_formulac_asimetrica_rt_s(finf,true,modelo,dist->valores_asim2,decf);
			towrite_s_semidiag(finf,unif,dist->config.semidiag);
			//finf<<"\t</table>"<<endl;
		}
	}elif(dist->config.modelo_asim==CAL_MODASIM_VECTOR){
		if(dist->config.param_asim1!=0){
			html_H(finf,3,TEX_TOS[25],"Autocalib.DA1");
			tablehead(finf);
			u16int l=dist->config.param_asim1;
			for(u8int i=0;i<ASIM_N;i++,l>>=1){
				if(!(l&1)) continue;
				towrite8(finf,'s',"\t\t<tr><td>c<sub>", 'u',i+1, 's',"</sub>", 0);
				setbuf_absolutep(finf,decf);
				towrite8(finf,'s',"<td>",'f',dist->valores_asim1[i], 0);
				setbuf_relativep(finf,2);
				towrite8(finf,'s',"<td>",'f',sqrtf(vv*N[k]), 0);
				setbuf_absolutep(finf,decf);
				float faux=Cantidad_pq[modelo-1][poli_asim[i+1]];
				faux*=fabsf(dist->valores_asim1[i]);
				if(i<2) faux*=0.707F;
				imp_total+=faux*faux;
				towrite8(finf,'s',"<td>",'f',faux, '\n',0);
				k+=n1;
			}
			towrite8_string(finf,"\t</table>\n");
		}
		if(dist->config.param_asim2!=0){
			html_H(finf,3,TEX_TOS[26],"Autocalib.DA2");
			tablehead(finf);
			u16int l=dist->config.param_asim2;
			for(u8int i=0;i<ASIM_N;i++,l>>=1){
				if(!(l&1)) continue;
				towrite8(finf,'s',"\t\t<tr><td>d<sub>", 'u',i+1, 's',"</sub>", 0);
				setbuf_absolutep(finf,decf);
				towrite8(finf,'s',"<td>",'f',dist->valores_asim2[i], 0);
				setbuf_relativep(finf,2);
				towrite8(finf,'s',"<td>",'f',sqrtf(vv*N[k]), 0);
				setbuf_absolutep(finf,decf);
				float faux=Cantidad_pq[modelo-1][poli_asim[i+1]];
				faux*=fabsf(dist->valores_asim2[i]);
				if(i<2) faux*=0.707F;
				imp_total+=faux*faux;
				towrite8(finf,'s',"<td>",'f',faux, '\n',0);
				k+=n1;
			}
			towrite8_string(finf,"\t</table>\n");
		}
		//finf<<"\t\t<tr class=intermezzo><td colspan=4>";
		towrite8_many_strings(finf,"\t</table>\n",stable_formula,"Dr= ",NULL);
		crea_formulac_radasim_uv(finf,true,modelo,dist->valores_asim1,dist->valores_asim2,decf);
		towrite_s_semidiag(finf,unif,dist->config.semidiag);
		//finf<<"\t\t<tr class=intermezzo><td colspan=4>";
		towrite8_many_strings(finf,"\t</table>\n",stable_formula,"Dt= ",NULL);
		crea_formulac_tanasim_uv(finf,true,modelo,dist->valores_asim1,dist->valores_asim2,decf);
		towrite_s_semidiag(finf,unif,dist->config.semidiag);
		//finf<<"\t</table>"<<endl;
	}
	setbuf_absolutep(finf,decf);
	setbuf_nolimpio(finf);
	towrite8(finf,'s',"\t<br>\n", 's',TEX_TOS[27], 'f',sqrtf(imp_total),' ', 'w',unif, '\n', 0);
}
#undef towrite_s_semidiag
