﻿//Añade el texto a los textos.
//Devuelve el número de texto que se le asigna, o AT_NOMEM.
int annade_texto(Growing_uint *tabla_textos, Growing_uint *bloque_textos, char8_t* nom){
	u16int c,t;

	c=strlen8(nom);
	t=NUINTS___NCHARS8(c+2);
	Greserve_n(*bloque_textos,uint,t+1,return AT_NOMEM);

	Gadd(*tabla_textos,uint,(pdif)(bloque_textos->next-bloque_textos->ppio),return AT_NOMEM);
	Gadd_blind(*bloque_textos,0xFF010000 | t);
	bloque_textos->next[t-1]=0;
	IO4char8_strpcpy_char8(bloque_textos->next, nom);
	bloque_textos->next+=t;
	return num_elem(tabla_textos,(pdif)((tabla_textos->next-1)-tabla_textos->ppio))-1;
}

//Añade el texto si su dirección aún no está en hnombres. Si ya existe incrementa ref_count
uint anade_en_nombres(Growing_uint *tabla_textos, Growing_uint *bloque_textos, char8_t* nom, Hash_hPtrUint *hnombres){
	int ntexto;
	uint *ppos;

	if(nom==NULL) return AT_NODATA;
	ppos=gethdata_hPtrUint(hnombres,nom);
	if(ppos==NULL){
		ntexto=annade_texto(tabla_textos,bloque_textos,nom);
		ifunlike(ntexto==AT_NOMEM) return (uint)AT_NOMEM;
		addh_keydata(hPtrUint,hnombres,nom,ntexto,return (uint)AT_NOMEM);
		return ntexto;
	}
	{uint *name=address_of_texto(tabla_textos->ppio,*ppos,bloque_textos->ppio);
	inc_refcount(name);}
	return *ppos;
}

#define annade_keyval_string(pkeyval,F,nombre,valor) \
	*pkeyval++=4; /*Tamaño de la entrada*/ \
	*pkeyval++=annade_texto(&F.CCLs.tabla_textos,&F.bloque_textos,nombre);\
	*pkeyval++=CODIGO_KEYVAL_TEXTO | (1<<8); /*1=número de elementos*/ \
	*pkeyval++=annade_texto(&F.CCLs.tabla_textos,&F.bloque_textos,valor);

#define annade_elemento_a_tablas(F,n_comp)\
	F.n_elem++;\
	Gadd(F.CCLs.orden_elementos,uint,F.n_elem,goto salida_outofmem);\
	Gadd(F.CCLs.tabla_elementos,uint,(pdif)(pint-F.bloquegra.ppio),goto salida_outofmem);\
	Gadd(F.CCLs.tabla_elementos,uint,n_comp,goto salida_outofmem);


bint realoja_pfdibujo(FGraBloqueGrafico *bloquegra){
	uint *prov, tamaño;
	if(bloquegra->capacidad>=0xAA00000) return 1;
	bloquegra->capacidad+=bloquegra->capacidad>>1;
	prov=(uint*)realloc(bloquegra->ppio,bloquegra->capacidad*usizeof(uint));
	if(prov==NULL) return 1;
	tamaño=(pdif)(pint-bloquegra->ppio);
	bloquegra->ppio=prov;
	pint=bloquegra->ppio+tamaño;
	bloquegra->hueco=bloquegra->capacidad-tamaño;
	return 0;
}

#define hueco(tamanno_elem) \
	if(bloquegra->hueco<tamanno_elem+1){ifunlike(realoja_pfdibujo(bloquegra)) return AT_NOMEM;}

#define annade_punto(P) \
	IO_DOUBLE___double(pdbl,(P).X);	pdbl++;\
	IO_DOUBLE___double(pdbl,(P).Y);	pdbl++;\
	IO_DOUBLE___double(pdbl,(P).Z);	pdbl++
#define annade_puntof(P) \
	IO_SINGLE___float(psingle,(P).X);	psingle++;\
	IO_SINGLE___float(psingle,(P).Y);	psingle++;\
	IO_SINGLE___float(psingle,(P).Z);	psingle++

#define comun_escribir(tamanno) \
	H.Tipo=pgra->Tipo;\
	H.pos_info=H.tamaño=tamanno;\
	H.Clase=pgra->Clase;\
	hueco(H.tamaño);\
	H.nombre=nnombre;\
	*((FGraElemenCabecera*)pint)=H;\
	pint+=uintsizeof(FGraElemenCabecera)

#define escribe_elemento_ARGS FGraBloqueGrafico *bloquegra, uint nnombre, GragenGenerico *pg, Extremos3D_dbl *ext
int escribe_punto(escribe_elemento_ARGS){
	FGraElemenCabecera H;
	GragenPunto *pgra=(GragenPunto*)pg;

	comun_escribir(TAMAÑOPUNTO);
	extremos3D_setonpoint(*ext,pgra->P);
	annade_punto(pgra->P);
	bloquegra->hueco-=H.tamaño;
	return 0;
}

int escribe_poligonal(escribe_elemento_ARGS){
	FGraElemenCabecera H;
	GragenPoligonal *pgra=(GragenPoligonal*)pg;

	uint n=pgra->npuntos;
	if(n==0) return 1;
	comun_escribir(TAMAÑOpoligonal(n));
	extremos3D_setonpoint(*ext,pgra->Ps[0]);
	*pint++=pgra->npuntos;
	{durchlaufei(PuntoXYZ_double,pgra->Ps,pgra->npuntos){
		extremos3D_updateonpoint(*ext,*ptri);
	}}
	n*=3;
	IO_DOUBLE_memcpy_double(pdbl,pgra->Ps,n);
	pdbl+=n;

	bloquegra->hueco-=H.tamaño;
	return 0;
}
int escribe_poligono(escribe_elemento_ARGS){
	FGraElemenCabecera H;
	GragenPoligono *pgra=(GragenPoligono*)pg;

	uint n=pgra->npuntos;
	comun_escribir(TAMAÑOpoligono(n));
	extremos3D_setonpoint(*ext,pgra->centro);
	annade_punto(pgra->centro);
	*pint++=pgra->npuntos;
	{durchlaufei(PuntoXYZ_double,pgra->borde,pgra->npuntos){
		extremos3D_updateonpoint(*ext,*ptri);
	}}
	n*=3;
	IO_DOUBLE_memcpy_double(pdbl,pgra->borde,n);
	pdbl+=n;

	bloquegra->hueco-=H.tamaño;
	return 0;
}

int escribe_vector(escribe_elemento_ARGS){
	FGraElemenCabecera H;
	GragenVector *pgra=(GragenVector*)pg;

	comun_escribir(TAMAÑOVECTOR);
	extremos3D_setonpoint(*ext,pgra->P);
	annade_punto(pgra->P);
	annade_puntof(pgra->dP);
	bloquegra->hueco-=H.tamaño;
	return 0;
}
int escribe_poligonal_escalable(escribe_elemento_ARGS){
	FGraElemenCabecera H;
	GragenPoligonal_Escalable *pgra=(GragenPoligonal_Escalable*)pg;

	uint n=pgra->npuntos;
	if(n==0) return 1;
	comun_escribir(TAMAÑOpoligonalesc(n));
	extremos3D_setonpoint(*ext,pgra->Ps[0]);
	*pint++=pgra->npuntos;
	{durchlaufe2(PuntoXYZ_double,pgra->Ps,pgra->npuntos,PuntoXYZ_float,pgra->dPs){
		extremos3D_updateonpoint(*ext,*ptr);
		annade_punto(*ptr);
		annade_puntof(*ptr_b);
	}}
	bloquegra->hueco-=H.tamaño;
	return 0;
}

int escribe_elipsoide(escribe_elemento_ARGS){
	FGraElemenCabecera H;
	GragenElipsoide *pgra=(GragenElipsoide*)pg;

	comun_escribir(TAMAÑOELIPSOIDE_F);
	extremos3D_setonpoint(*ext,pgra->centro);
	annade_punto(pgra->centro);
	IO_SINGLE_memcpy_float(psingle,&pgra->σxx,6);
	psingle+=6;
	bloquegra->hueco-=H.tamaño;
	return 0;
}
