﻿#ifndef ELIPSES_INCLUDED
#ifndef TypeR
	#include "matematicas.h"
	#include "polinomio3.h"

	#define polinomio3mn Addsufijo(polinomio3mn,suf)
	#define polinomio3 Addsufijo(polinomio3,suf)
	#define varianzas_a_alpha Addsufijo(varianzas_a_alpha,suf)
	#define alpha_a_matriz Addsufijo(alpha_a_matriz,suf)
	#define varianzas_a_matriz Addsufijo(varianzas_a_matriz,suf)
	#define autovalores3 Addsufijo(autovalores3,suf)
	#define semiejes3 Addsufijo(semiejes3,suf)

	#define TypeR float
	#define suf fl
	#define TGMATH_TYPE TGMATH_TYPE_FLOAT
	#include <ATcrt/pmtgmath.h>
		#include __FILE__
	#undef TypeR
	#undef suf

	#undef TGMATH_TYPE
	#include <ATcrt/pmtgmath.h>
	#define TypeR double
	#define suf dbl
		#include __FILE__
	#undef TypeR
	#undef suf

	#undef polinomio3mn
	#undef polinomio3
	#undef varianzas_a_alpha
	#undef alpha_a_matriz
	#undef varianzas_a_matriz
	#undef autovalores3
	#undef semiejes3
	#define varianzas_a_alpha varianzas_a_alpha_fl
	#define alpha_a_matriz alpha_a_matriz_fl
	#define varianzas_a_matriz varianzas_a_matriz_fl
	#define autovalores3 autovalores3_fl
	#define semiejes3 semiejes3_fl
	#define ELIPSES_INCLUDED
#else
void varianzas_a_alpha(TypeR x,TypeR xy,TypeR y,TypeR *a,TypeR *b,TypeR *cosα, TypeR *sinα){
	TypeR sum,res,R;

	sum=x+y;
	res=x-y;
	ifunlike(xy==0) R=res; //avoid R<res
	else{R=res*res+4*xy*xy;
		R=sqrt(R);}
	ifunlike(R>=sum){
		*a=R=sum;
		*b=0;
	}else{
		*a=sqrt(0.5F*(sum+R));
		*b=sqrt(0.5F*(sum-R));
	}
	ifunlike(R==0){ //hence xy=0, x=y
		if(res>=0) *cosα=1, *sinα=0;
		else *cosα=0, *sinα=1;
	}else{
		*sinα=1-res/R;
		*sinα=sqrt(*sinα*.5F);
		*cosα=xy/(*sinα*R);
	}
}
sinline void alpha_a_matriz(TypeR a,TypeR b,TypeR cosα,TypeR sinα,TypeR *ma,TypeR *mb,TypeR *mc,TypeR *md){
	*ma=a*cosα; *mb=-b*sinα;
	*mc=a*sinα; *md=b*cosα;
}
sinline void varianzas_a_matriz(TypeR x,TypeR xy,TypeR y,TypeR *a,TypeR *b,TypeR *c,TypeR *d){
	TypeR aa,bb,cosα,sinα;
	varianzas_a_alpha(x,xy,y,&aa,&bb,&cosα,&sinα);
	*a=aa*cosα; *b=-bb*sinα;
	*c=aa*sinα; *d=bb*cosα;
}

void autovalores3(TypeR ss[6], TypeR *l1,TypeR *l2,TypeR *l3){
#define x ss[0]
#define y ss[2]
#define z ss[5]
	TypeR a,b,c;
	TypeR xy2,yz2,zx2;
	xy2=ss[1]*ss[1];
	yz2=ss[4]*ss[4];
	zx2=ss[3]*ss[3];
	a=-(x+y+z);
	b=x*y+y*z+z*x;
	b-=xy2+yz2+zx2;
	c=-x*y*z;
	c+=x*yz2+y*zx2+z*xy2;
	c-=2*ss[1]*ss[4]*ss[3];
#undef x
#undef y
#undef z

	polinomio3(a,b,c,l1,l2,l3);
}

//Asume que al menos uno de sx,sy,sz es distintos de 0. Si sm1 no es 0, se interpreta
//como que sm1, sm2, sm3 ya contienen los autovalores y no se vuelven a calcular
void semiejes3(TypeR ss[6],TypeR *sm1, TypeR *sm2, TypeR *sm3,TypeR ejes[9]){
#define sx ss[0]
#define sxy ss[1]
#define sy ss[2]
#define sxz ss[3]
#define syz ss[4]
#define sz ss[5]
#define dx1 ejes[0]
#define dy1 ejes[1]
#define dz1 ejes[2]
#define dx2 ejes[3]
#define dy2 ejes[4]
#define dz2 ejes[5]
#define dx3 ejes[6]
#define dy3 ejes[7]
#define dz3 ejes[8]

	TypeR l1,l2,l3;
	TypeR dif1,dif2;
	if(*sm1==0){
		autovalores3(ss,&l1,&l2,&l3);
		if(l2<0) l2=0;
		if(l3<0) l3=0;
		*sm1=sqrt(l1);
		*sm2=sqrt(l2);
		*sm3=sqrt(l3);
	}else{
		l1=*sm1**sm1; l2=*sm2**sm2; l3=*sm3**sm3;
	}
	dif1=1-*sm2/ *sm1;
	dif2=1-*sm3/ *sm2;
	if(dif1<2E-6F && dif2<2E-6F){
		dx1=dy1=0;
		dy2=dz2=0;
		dz3=dx3=0;
		dz1=*sm1;
		dx2=*sm2;
		dy3=*sm3;
		return;
	}
	u8int l=0;
	if(dif2<2E-6F) l=1;
	elif(dif1<2E-6F) l=2;

	u8int k;
	TypeR sxy2,syz2,szx2, sxb,syb,szb;
	TypeR dif;

	sxy2=sxy*sxy;
	syz2=syz*syz;
	szx2=sxz*sxz;

	{TypeR faux=l1;
	if(l==2) faux=l3;
	sxb=sx-faux;
	syb=sy-faux;
	szb=sz-faux;}
	dif1=sxb*syb-sxy2;
	dif2=syb*szb-syz2;
	if(fabs(dif2)>fabs(dif1)){dif1=dif2; k=1;}
	else k=0;
	dif2=szb*sxb-szx2;
	if(fabs(dif2)>fabs(dif1)){dif1=dif2; k=2;}
	if(k==0){
		dz1=dif1;
		dx1=(sxy*syz-syb*sxz);
		dy1=(sxy*sxz-sxb*syz);
	}elif(k==1){
		dx1=dif1;
		dy1=(syz*sxz-szb*sxy);
		dz1=(syz*sxy-syb*sxz);
	}else{
		dy1=dif1;
		dz1=(sxz*sxy-sxb*syz);
		dx1=(sxz*syz-szb*sxy);
	}

	if(l){
		{TypeR faux;
		if(fabs(dy1)>fabs(dx1)){faux=fabs(dy1); k=1;}
		else{faux=fabs(dx1); k=0;}
		if(fabs(dz1)>faux) k=2;}
		if(k==0){
			dx2=0;
			if(dy1==0 && dz1==0){dy2=1; dz2=0;}
			else{dy2=-dz1; dz2=dy1;}
		}elif(k==1){
			dy2=0;
			if(dz1==0 && dx1==0){dz2=1; dx2=0;}
			else{dz2=-dx1; dx2=dz1;}
		}else{
			dz2=0;
			if(dx1==0 && dy1==0){dx2=1; dy2=0;}
			else{dx2=-dy1; dy2=dx1;}
		}
	}else{
		sxb=sx-l2;
		syb=sy-l2;
		szb=sz-l2;
		TypeR faux;
		dif=sxb*syb-sxy2;
		faux=syb*szb-syz2;
		if(fabs(faux)>fabs(dif)){dif=faux; k=1;}
		else k=0;
		faux=szb*sxb-szx2;
		if(fabs(faux)>fabs(dif)){dif=faux; k=2;}
		if(k==0){
			dz2=dif;
			dx2=(sxy*syz-syb*sxz);
			dy2=(sxy*sxz-sxb*syz);
		}elif(k==1){
			dx2=dif;
			dy2=(syz*sxz-szb*sxy);
			dz2=(syz*sxy-syb*sxz);
		}else{
			dy2=dif;
			dz2=(sxz*sxy-sxb*syz);
			dx2=(sxz*syz-szb*sxy);
		}
	}

	dx3=dy1*dz2-dz1*dy2;
	dy3=dz1*dx2-dx1*dz2;
	dz3=dx1*dy2-dy1*dx2;
	if(l==2){
		TypeR faux;
		faux=dx1; dx1=dx3; dx3=-faux;
		faux=dy1; dz1=dz3; dz3=-faux;
		faux=dz1; dz1=dz3; dz3=-faux;
	}
	//ajustar a la longitud de los semiejes
	TypeR faux;
	faux=dx1*dx1+dy1*dy1+dz1*dz1;
	faux=sqrt(faux);
	faux=*sm1/faux;
	dx1*=faux; dy1*=faux; dz1*=faux;
	faux=dx2*dx2+dy2*dy2+dz2*dz2;
	faux=sqrt(faux);
	faux=*sm2/faux;
	dx2*=faux; dy2*=faux; dz2*=faux;
	faux=dx3*dx3+dy3*dy3+dz3*dz3;
	faux=sqrt(faux);
	faux=*sm3/faux;
	dx3*=faux; dy3*=faux; dz3*=faux;
}
#undef sx
#undef sxy
#undef sy
#undef sxz
#undef syz
#undef sz
#undef dx1
#undef dy1
#undef dz1
#undef dx2
#undef dy2
#undef dz2
#undef dx3
#undef dy3
#undef dz3
#endif
#endif
