#include <time.h>
#include "struct_digi.h"

void calcula_max_min(TIPO_MINMAX *max,LPOINT3D *coor,uint np,int Fecha){
  /* Fecha=1  pone nueva fecha	*/
  /* Fecha=0  deja la fecha antigua */

	struct tm *fecha;
	time_t tiempo;

	if(np==0) return;

	if(Fecha){
		tiempo=time(NULL);
		fecha=localtime(&tiempo);
		max->xlib=(ssint)(fecha->tm_year*10000 + (fecha->tm_mon+1)*100 + fecha->tm_mday);
		max->ylib=(ssint)(fecha->tm_hour*10000 + fecha->tm_min*100 + fecha->tm_sec);
	}

	LPOINT3D *ptr=coor;
	max->xmax=max->xmin=ptr->x;
	max->ymax=max->ymin=ptr->y;
	max->zmax=max->zmin=ptr->z;
	dontimes(np-1,ptr++){
		if(ptr->x<max->xmin) max->xmin=ptr->x;
		elif(ptr->x>max->xmax) max->xmax=ptr->x;
		if(ptr->y<max->ymin) max->ymin=ptr->y;
		elif(ptr->y>max->ymax) max->ymax=ptr->y;
		if(ptr->z<max->zmin) max->zmin=ptr->z;
		elif(ptr->z>max->zmax) max->zmax=ptr->z;
	}
}

void guarda_entidad(Buffer_bo *fbin,TIPO_DAT *cabec, TIPO_MINMAX *max, LPOINT3D *coor, ATR *atr){
   uint np;
   LPOINT3D *latest=coor, *current=coor+1;
   ssint xc,xs,yc,ys;
   LPOINT3D co[4];

   cabec->tipo[1]='=';

   switch(cabec->tipo[0]){
   case 'C':
	if(cabec->npuntos==0) return;
	for(np=cabec->npuntos; --np; current++){
		if(memcmp_uint(current,latest,uintsizeof(LPOINT3D))){
			if(++latest!=current) *latest=*current;
		}
	}
	np=latest-coor;
	if(cabec->npuntos>1 && np==0){cabec->npuntos=0; return;}
	cabec->npuntos=np+1;
	calcula_max_min(max,coor,np+1,1);
	break;
   case 'T':
	{char8_t *texto=(char8_t*)(coor+DESP_TEXT);
	if(texto[0]=='\0') return;
	cabec->npuntos=(uint16m)strlen8(texto);
	double x,y,c,s;
	c=cos(max->zlib*0.000174533);
	s=sin(max->zlib*0.000174533);
	if(texto[0]=='@'){
		y=0.5*max->xlib;
		x=y*cabec->npuntos;
		xc=(ssint)(x*c);	ys=(ssint)(y*s);
		xs=(ssint)(x*s);	yc=(ssint)(y*c);
		co[0].x=coor->x -xc +ys;		co[0].y=coor->y -xs -yc;
		co[1].x=coor->x +xc +ys;		co[1].y=coor->y +xs -yc;
		co[2].x=coor->x +xc -ys;		co[2].y=coor->y +xs +yc;
		co[3].x=coor->x -xc -ys;		co[3].y=coor->y -xs +yc;
	}else{
		y=max->xlib;
		x=y*cabec->npuntos;
		xc=(ssint)(x*c);	ys=(ssint)(y*s);
		xs=(ssint)(x*s);	yc=(ssint)(y*c);
		co[0].x=coor->x;			co[0].y=coor->y;
		co[1].x=coor->x +xc;		co[1].y=coor->y +xs;
		co[2].x=coor->x +xc -ys;	co[2].y=coor->y +xs +yc;
		co[3].x=coor->x -ys;		co[3].y=coor->y +yc;
	}
	calcula_max_min(max,co,4,0);
	max->zmax=coor->z;
	max->zmin=coor->z;
	cabec->npuntos=DESP_TEXT+(uint16m)(strlen8(texto)/usizeof(LPOINT3D))+1;
	}
	break;
   default:
	return;
   }/*Fin switch*/

   char8_t *pu8=cabec->cod;
   boput_8888(fbin,pu8[1],pu8[0],cabec->tipo[1],cabec->tipo[0]);
   boput_8888(fbin,pu8[5],pu8[4],pu8[3],pu8[2]);
   boput_1688(fbin,cabec->npuntos,cabec->natr,pu8[6]);
   {durchlaufei(ssint,&max->xmin,9) boput_32(fbin,(uint)*ptri);}
   bowrite_ssints(fbin,&coor->x,3*cabec->npuntos);
   if(cabec->natr){bowrite_umints(fbin,atr->resto,12*cabec->natr);}

   cabec->npuntos=0;
   cabec->natr=0;
// cabec->tipo[0]=' ';
}
