﻿//cálculo de distancias en el sistema vista
#define DISTANCIA_GEN_ARGS 	GraElementoGenerico *_pelem,ElementoenVista *pvista,SolvedQualities* concreta, double X, double Y, double radio, Extremos2D_dbl *rect, PuntoXYZ_double *Q
double distancia_gen_punto(DISTANCIA_GEN_ARGS){
	GraPunto *pelem;
	double dd, aux;

	pelem=(GraPunto*)_pelem;
	*Q=pelem->P;
	dd=pelem->P.X-X;
	dd*=dd;
	aux=pelem->P.Y-Y;
	dd+=aux*aux;
	return dd;
}

/*double distancia2__segmento(TerrenoaInterno* Tc, double x,double y, double X1,double Y1, double X2,double Y2,Extremos2D_dbl extr, Puntoxy_double* Q){
	float dd;
	float X2_X1,Y2_Y1;
	float X1_x,Y1_y,X2_x,Y2_y;
	float s1,s2;
	float t1,t2;

	if(X1<X2){ if(X2<extr.mx || X1>extr.MX) return -1;}
	else{ if(X1<extr.mx || X2>extr.MX) return -1;}
	if(Y1<Y2){ if(Y2<extr.my || Y1>extr.MY) return -1;}
	else{ if(Y1<extr.my || Y2>extr.MY) return -1;}
	/*if(Tc!=NULL){
		Puntoxy_double P;
		P=terreno_a_interno(X1,Y1,Tc);	X1=P.x;	Y1=P.y;
		P=terreno_a_interno(X2,Y2,Tc);	X2=P.x;	Y2=P.y;
	}*/
/*
	X2_X1=(float)(X2-X1);
	Y2_Y1=(float)(Y2-Y1);
	X1_x=(float)(X1-x);
	Y1_y=(float)(Y1-y);
	s1=X2_X1*X1_x+Y2_Y1*Y1_y;
	X2_x=(float)(X2-x);
	Y2_y=(float)(Y2-y);
	s2=X2_X1*X2_x+Y2_Y1*Y2_y;
	if((s2<=0 && s1<=0) || (s2>=0 && s1>=0)){
		if(fabs(s1)<fabs(s2)){
			Q->x=X1; Q->y=Y1;
			dd=X1_x*X1_x;
			dd+=Y1_y*Y1_y;
		}else{
			Q->x=X2; Q->y=Y2;
			dd=X2_x*X2_x;
			dd+=Y2_y*Y2_y;
		}
	}else{
		t2=X2_X1*Y2_y-Y2_Y1*X2_x;
		t2*=t2;
		t1=X2_X1*X2_X1+Y2_Y1*Y2_Y1;
		dd=t2/t1;
		//t1: longitud2 de la base
		t2=s1/t1;
		if(t2<0) t2=-t2;
		s1=X2_X1*t2;
		s2=Y2_Y1*t2;
		Q->x=X1+s1;
		Q->y=Y1+s2;
	}
	return dd;
}*/

double distancia_gen__segmento(double x,double y, double X1,double Y1, double X2,double Y2, Puntoxy_double* Q){
	double dd;
	double X2_X1,Y2_Y1;
	double x_X1,y_Y1;
	double t;

	X2_X1=X2-X1;
	Y2_Y1=Y2-Y1;
	x_X1=x-X1;
	y_Y1=y-Y1;
	t=x_X1*X2_X1+y_Y1*Y2_Y1;
	if(t<=0) t=0;
	else{
		double u=X2_X1*X2_X1+Y2_Y1*Y2_Y1;
		if(t>=u) t=1;
		else t/=u;
	}

	Q->x=X1+t*X2_X1;
	Q->y=Y1+t*Y2_Y1;
	dd=t*X2_X1-x_X1;
	dd*=dd;
	{double aux=t*Y2_Y1-y_Y1;
	dd+=aux*aux;}

	return dd;
}

//One-point polygonals are ignored (but not those for which all the points are the same)
double distancia_gen_poligonal(DISTANCIA_GEN_ARGS){
	GraPoligonal *pelem;
	double dd;
	u8int u2;
	PuntoXYZ_double *pP;

	pelem=(GraPoligonal*)_pelem;
	if(pelem->n<2) return -1.0;

	dd=/*-1.0*/ FLT_MAX;
	pP=&pelem->P1;
	u2=region_dbl(rect,pP->X,pP->Y);
	dontimes(pelem->n-1,){
		u8int u1;
		double X1,Y1;
		u1=u2;
		X1=pP->X; Y1=pP->Y; pP++;
		/*if(pP->X==X1 && pP->Y==Y1) continue; //skip this check. This will happen seldom
		if(dd<0) dd=FLT_MAX;*/
		u2=region_dbl(rect,pP->X,pP->Y);

		if(!puede_cortar(u1,u2)) continue;
		double aux;
		Puntoxy_double P;
		aux=distancia_gen__segmento(X,Y,X1,Y1,pP->X,pP->Y,&P);
		if(aux<dd){dd=aux; Q->X=P.x; Q->Y=P.y;}
	}
	if(dd==FLT_MAX) return -1.0;
	/*if(dd<0){ //All the points were the same (the line is perpendicular to the view)
		dd=pP->X-X;	dd*=dd;
		aux=pP->Y-Y;
		dd+=aux*aux;
	}*/
	return dd;
}

double distancia_gen_poligono(DISTANCIA_GEN_ARGS){
	double dd;
	GraPoligono *pelem;
	float escala;
	u8int u2;
	PuntoXYZ_double *pP;
	double Yc,Xc;
	double X2,Y2;

	pelem=(GraPoligono*)_pelem;

	escala=1;
	if(concreta!=NULL){
		LinkedSolvedQuality *ptr=concreta->cualidades;
		while(ptr!=NULL){
			switch(ptr->nqual){
				case Q_Escala: escala=ptr->value.fl; break;
			}
			ptr=ptr->next;
	}	}

	*Q=pelem->centro;
	dd=pelem->centro.X-X;		dd*=dd;
	{double aux=pelem->centro.Y-Y;		dd+=aux*aux;}

	if(escala==0 || pelem->n<3) return dd;

	pP=&pelem->P1;
	Xc=Q->X*(1.0-escala);
	Yc=Q->Y*(1.0-escala);
	X2=pP->X*escala+Xc;
	Y2=pP->Y*escala+Yc;
	pP++;
	u2=region_dbl(rect,X2,Y2);
	dontimes(pelem->n-1,){
		double X1,Y1;
		u8int u1;
		X1=X2; Y1=Y2;
		u1=u2;
		X2=pP->X*escala+Xc;
		Y2=pP->Y*escala+Yc;
		pP++;
		u2=region_dbl(rect,X2,Y2);

		if(!puede_cortar(u1,u2)) continue;
		double aux;
		Puntoxy_double P;
		aux=distancia_gen__segmento(X,Y,X1,Y1,X2,Y2,&P);
		if(aux<dd){dd=aux; Q->X=P.x; Q->Y=P.y;}
	}
	return dd;
}
double distancia_gen_vector(DISTANCIA_GEN_ARGS){
	GraVector *pelem;
	ConfigVector config;
	u8int u1,u2;
	double X2,Y2;
	double dd;

	pelem=(GraVector*)_pelem;
	GetVars_vector(_pelem,&config,concreta,NULL);

	X2=pelem->P.X+config.escala*pelem->δp.X;
	Y2=pelem->P.Y+config.escala*pelem->δp.Y;
	u1=region_dbl(rect,pelem->P.X,pelem->P.Y);
	u2=region_dbl(rect,X2,Y2);
	if(!puede_cortar(u1,u2)) return -1;
	dd=distancia_gen__segmento(X,Y,pelem->P.X,pelem->P.Y,X2,Y2,(Puntoxy_double*)Q);
	return dd;
}

double distancia_gen_poligonal_escalable(DISTANCIA_GEN_ARGS){
	GraPoligonalEscalable *pelem;
	ConfigPoligonalEscalable config;
	double dd;
	union{
		PuntoXYZ_double *pP;
		PuntoXYZ_float *pδ;
	} mem;
	u8int u2;
	double X2,Y2;

	pelem=(GraPoligonalEscalable*)_pelem;
	GetVars_poligonalesc(_pelem,&config,concreta);

	ifunlike(pelem->n<2 || config.escala==0) return -1.0;

	dd=FLT_MAX;
	mem.pP=&pelem->P1;
	X2=mem.pP->X;
	Y2=mem.pP->Y;
	mem.pP++;
	X2+=config.escala*mem.pδ->X;
	Y2+=config.escala*mem.pδ->Y;
	mem.pδ++;
	u2=region_dbl(rect,X2,Y2);
	dontimes(pelem->n-1,){
		u8int u1;
		double X1,Y1;
		u1=u2;
		X1=X2; Y1=Y2;

		X2=mem.pP->X;
		Y2=mem.pP->Y;
		mem.pP++;
		X2+=config.escala*mem.pδ->X;
		Y2+=config.escala*mem.pδ->Y;
		mem.pδ++;
		u2=region_dbl(rect,X2,Y2);

		if(!puede_cortar(u1,u2)) continue;
		double aux;
		Puntoxy_double P;
		aux=distancia_gen__segmento(X,Y,X1,Y1,X2,Y2,&P);
		if(aux<dd){dd=aux; Q->X=P.x; Q->Y=P.y;}
	}
	if(dd==FLT_MAX) return -1.0;
	else return dd;
}

Puntoxy_float hiperbola_elipse(float aa,float bb, float xl,float yl){
	Puntoxy_float p;
	float a_b,xx,yy;
	float A,B,R,k,_k,α,ξ,υ;
	float r,s;

	if(aa==0){p.y=p.x=0; return p;}
	a_b=aa-bb;
	xx=xl*xl;					//La hipérbola xx/A-yy/B=1 es perpend. a la elipse
	yy=yl*yl;
	if(a_b>=xx && a_b>=yy){	k=a_b; _k=1/a_b;		α=1;  ξ=_k*xx;  υ=_k*yy;		r=ξ+υ;}
	elif(xx>=yy){				k=xx; _k=1/xx;		α=_k*a_b;  ξ=1;  υ=_k*yy;		r=α+υ;}
	else{						k=yy; _k=1/yy;		α=_k*a_b;  ξ=_k*xx;  υ=1;		r=α+ξ;}

	iflike(r>0.001){
		r=α-ξ-υ;
		R=sqrtf(r*r+4*α*υ);
		if(R>=ξ+υ) A=0.5F*(α+ξ+υ-R)*k, B=a_b-A;
		else B=0.5F*(r+R)*k, A=a_b-B;
	}else{
		if(α==1) A=xx*(1-υ), B=a_b-A;
		elif(ξ==1) B=a_b*υ, A=a_b-B;
		else A=a_b*ξ, B=a_b-A;
	}

	aa=bb/aa;				//Intersección de la hipér. y la elipse
	s=aa*A+B;
	p.y=aa*(bb+B)/s;  //p.y/B
	p.x=A*(1+p.y);
	p.y*=B;
	p.y=sqrtf(p.y); if(yl<0) p.y=-p.y;
	p.x=sqrtf(p.x); if(xl<0) p.x=-p.x;
	return p;
}

double distancia2__elipse(double X,double Y,float sx,float sxy,float sy,double x,double y,Extremos2D_dbl *rect,float r,Puntoxy_double* Q){
	float a,b,cosa,sina;
	float xl,yl;
	float aa,bb;
	float xx,yy,ss;

	varianzas_a_alpha(sx,sxy,sy,&a,&b,&cosa,&sina);
	if(b==0){
		double X1=X-sx, X2=X+sx,
				Y1=Y-sy, Y2=Y+sy;
		if(!puede_cortar(region_dbl(rect,X1,Y1),region_dbl(rect,X2,Y2))) return -1;
		else return distancia_gen__segmento(x,y,X1,Y1,X2,Y2,Q);
	}

	{float faux;
	xl=(float)(X-x); yl=(float)(Y-y);
	faux=xl*cosa+yl*sina;
	yl=-xl*sina+yl*cosa;
	xl=faux;}

	xx=xl*xl; yy=yl*yl;
	ss=xx+yy;
	if(r<b && ss<(b-r)*(b-r)) return -1;
	if(ss>(a+r)*(a+r)) return -1;

	aa=a*a;
	bb=b*b;
	if(ss<=bb*1e-6){	//<= in case all of them are zero (eventhough the case b=0 is handled above)
		iflike(bb>r*r) return -1;
		Q->x=X-b*sina;
		Q->y=Y+b*cosa;
		return bb;
	}
	if(ss>=aa*1e6){
		iflike(ss>r*r) return -1;
		if(xx>yy){
			if(xl<0) a=-a;
			Q->x=X+a*cosa;
			Q->y=Y+a*sina;
		}else{
			if(yl<0) b=-a;
			Q->x=X-b*sina;
			Q->y=Y+b*cosa;
		}
		return ss;
	}

	Puntoxy_float p;
	float dx,dy;
	p=hiperbola_elipse(aa,bb,xl,yl);
	dx=p.x-xl;
	dy=p.y-yl;
	xl=p.x*cosa-p.y*sina;
	yl=p.x*sina+p.y*cosa;
	Q->x=X+xl;
	Q->y=Y+yl;
	return dx*dx+dy*dy;
}

/*
double distancia2__elipse(double X,double Y,float sx,float sxy,float sy,double x,double y,Extremos2D_dbl *rect,float r,Puntoxy_double* Q){
	float aa_bb,_aa,_bb,e2,a4b4;
	float limite;

	distancia2__elipse(X,Y,sx,sxy,sy,x,y,rect,Q);  //El de arriba
	if(a>r) limite=r*0.1F;
	else limite=a*0.1F;

	_aa=1.0F/aa;
	_bb=1.0F/bb;
	aa_bb=aa-bb;

	e2=aa_bb/aa;
	a4b4=aa*aa/(bb*bb);
	for(;;){
		float cosφ, sinφ, ρ, faux;
		float cx,cy,dx,dy,dxx,dyy;
		float falsox,falsoy;
		float xelipse_n,yelipse_n;
		
		cosφ=xelipse*xelipse/(yelipse*yelipse);
		cosφ=1.0F/(1.0F+a4b4*cosφ);
		sinφ=1-cosφ;
		ρ=a*(1-e2);
		faux=1-e2*sinφ;
		ρ/=faux*sqrtf(faux);
		cosφ=sqrtf(cosφ);
		sinφ=sqrtf(sinφ);
		if(xelipse<0) cosφ=-cosφ;
		if(yelipse<0) sinφ=-sinφ;
		iflike(faux>=1.0E-5){
			dx=ρ*cosφ;
			dy=ρ*sinφ;
			cx=xelipse-dx;
			cy=yelipse-dy;

			dx=xl-cx; dy=yl-cy;
			dxx=dx*dx; dyy=dy*dy;
			faux=sqrtf(dxx+dyy);
			faux=ρ/faux;
			falsox=cx+dx*faux;
			falsoy=cy+dy*faux;
		}else{
			dx=xl-xelipse;
			dy=yl-yelipse;
			float R=dx*cosφ+dy*sinφ;
			falsox=xl-cosφ*R;
			falsoy=yl-sinφ*R;
			if(2*R<ρ){
				faux=0.75F*R*R+0.5F*(dx*dx+dy*dy);
				ρ=1/ρ;
				falsox+=ρ*(-dx*R+cosφ*faux);
				falsoy+=ρ*(-dy*R+sinφ*faux);
			}
		}

		xx=falsox*falsox;
		if(_likely(fabsf(cosφ)>=1.0e-3) || _unlikely(xx>=aa_bb)){ //_unlikely provided the first test was passed
			yy=falsoy*falsoy;
			faux=_aa*xx+_bb*yy;
			faux=1.0F/sqrtf(faux);
			xelipse_n=faux*xl;
			yelipse_n=faux*yl;
		}else{
			xelipse_n=xl;
			yelipse_n=bb*(1-_aa*xl*xl);
			yelipse_n=sqrtf(yelipse_n); if(yl<0) yelipse_n=-yelipse_n;
		}
		dx=fabsf(xelipse_n-xelipse);
		dx+=fabsf(yelipse_n-yelipse);
		xelipse=xelipse_n;
		yelipse=yelipse_n;
		if(dx<limite) break;
	}
	float dx,dy;
	dx=xelipse-xl;
	dy=yelipse-yl;

	xl=xelipse*cosa-yelipse*sina;
	yl=xelipse*sina+yelipse*cosa;
	Q->x=X+xl;
	Q->y=Y+yl;

	return dx*dx+dy*dy;
}

/*float distancia_gen_elipse_xy(DISTANCIA_GEN_ARGS){
	float escala;
	Puntoxy_double Pv;
	bint fl;
	u8int orientacion;

	pint++;
	fl=mask_float(*pint);
	if(!fl) escala=1;
	else escala=100;
	if(concreta!=NULL){
		LinkedSolvedQuality *ptr=concreta->cualidades;
		while(ptr!=NULL){
			switch(ptr->nqual){
				case Q_float_first+1: escala=ptr->value_fl; break;
			}
			ptr=ptr->next;
		}
	}
	if(escala==0) return -1;

	orientacion=set_byte0(pint);

	{double* paux=(double*)(pvista.pint32+17);
	Pv.x=*paux++; Pv.y=*paux;}

	float sx,sxy,sy;
	{
		float* pfaux=(float*)(pvista.pint32+21);
		sx=*pfaux++;
		sxy=*pfaux++;
		sy=*pfaux;
	}
	if(sx==0 && sy==0) return -1;
	if(orientacion==1){
		float faux=sqrtf(sx)*escala;
		return distancia_gen__segmento(Pi.X,Pi.Y,Pv.x,Pv.y-faux,Pv.x,Pv.y+faux,lx,ly,(Puntoxy_double*)Q);
	}elif(orientacion==2){
		float fauxb=sqrtf(sy)*escala;
		return distancia_gen__segmento(Pi.X,Pi.Y,Pv.x-fauxb,Pv.y,Pv.x+fauxb,Pv.y,lx,ly,(Puntoxy_double*)Q);
	}

	Pv.x=lx*(Pv.x-Pi.X)+Pi.X;
	Pv.y=ly*(Pv.y-Pi.Y)+Pi.Y;
	{float faux=(float)lx*escala;
	 float fauxb=(float)ly*escala;
	sx*=faux*faux;
	sxy*=faux*fauxb;
	sy*=fauxb*fauxb;}

	float dd=distancia2__elipse(Pi.X,Pi.Y,sx,sxy,sy,Pv.x,Pv.y,rect,radio,(Puntoxy_double*)Q);
	if(dd!=-1.0F){
		Q->X=(Q->X-Pi.X)/lx+Pi.X;
		Q->Y=(Q->Y-Pi.Y)/ly+Pi.Y;
	}
	return dd;
}

float distancia_gen_elipse(DISTANCIA_GEN_ARGS){
	return -1.0F;
}*/

double distancia_gen_elipsoide(DISTANCIA_GEN_ARGS){
	GraElipsoide *pelem;
	ConfigElipsoide config;
	double dd;

	pelem=(GraElipsoide*)_pelem;
	GetVars_elipsoide(_pelem,&config,concreta,NULL);
	config.escala*=config.escala;

	dd=-1.0;
	if(config.escala!=0){
		float sz=sqrtf(pelem->σzz*config.escala);
		Q->X=pelem->P.X;
		dd=(pelem->P.X-X);
		dd*=dd;
		if(Y>pelem->P.Y+sz || Y<pelem->P.Y-sz){
			if(Y>pelem->P.Y) Q->Y=pelem->P.Y+sz;
			else Q->Y=pelem->P.Y-sz;
			double auxb=Q->Y-Y;
			dd+=auxb*auxb;
		}else{
			Q->Y=Y;
		}
	}
	if(config.escala==0 || (pelem->σxx==0 && pelem->σyy==0)) return dd;
	double aux=distancia2__elipse(X,Y,config.escala*pelem->σxx,config.escala*pelem->σxy,config.escala*pelem->σyy,pelem->P.X,pelem->P.Y,rect,(float)radio,(Puntoxy_double*)Q);
	if(aux!=-1.0 && (dd==-1.0 || aux<dd)) dd=aux;
	return dd;
}
