#pragma once
#include <ATcrt/ATcrt_types.h>
#include <stdbool.h>
#include "ClasesGraficocfg.h"

struct strLinkedGrupoFormas;
typedef struct strLinkedstring{
	struct strLinkedstring* next;
	char16_t* s;
} Linkedstring;

#ifdef __cplusplus
extern "C"{
#endif

extern int set_nullconfig(Gra_Configuracion *config);

/*Lee el fichero de configuración, carga_ficherocfg, y lee todos los ficheros que venga indicados en él:
	formas:	carga_formas

Devuelven
	0,  AT_NOMEM
	ATREAD_NOOPEN (sólo para carga_fichero_configuracion)
	ATREAD_LINEA: Linea que empieza por \begin sin nada a continuación
	ATREAD_EOF: Falta un \end
	Un error en uno de los ficheros de recursos que no sea AT_NOMEM se ignora
*/
extern int carga_fichero_configuracion(char16_t* ficherocfg, Gra_Configuracion *configuracion, Linkedstring* *perror_first, char16_t* _mensaje, u8int _idioma);
extern int carga_configuracion_inmem(Bufferti16 *pbuffer, Gra_Configuracion *config, Linkedstring* *perror_first, char16_t* _mensaje, u8int _idioma);

/*Puede devolver...*/
extern int carga_formas(char16_t* fichero_formas, struct strLinkedGrupoFormas **p_list, char16_t* _mensaje, u8int idioma);
extern int annade_one_config(Vector_Gra_Configuracion *configs);
extern void free_linkedStrings(Linkedstring* first_next);

//Libera su contenido
extern void free_Configgra(Gra_Configuracion *config);

//Devuelve 0 o uno de los códigos de ATfileoutput.h. configname puede ser NULL
extern int escribe_configuracion(const char16_t *filename, Gra_FConfiguracion *mconfig,const char16_t *configname);

#ifdef __cplusplus
}
#endif
