#pragma once
#include <ATcrt/ATcrt_types.h>
#include <ATcrt/ATarrays.h>
#include <AT2D3D/Estructuras2d3d.h>
#include "grafico_memoria_shared.h"
#include "ClasesGraficocfg.h"
#include "gra_clases.h"

typedef struct{
	uint elem;	//número de elemento
	uint tipo;	//Tipo de opción especial
	uint valor;
} Gra_OpcionEspecial;
#define GraOpcionE_None 0
#define GraOpcionE_Seleccion 1	//tipo
	#define GraOpcionE_Seleccion_Seleccionado 1
	#define GraOpcionE_Seleccion_Candidato 2

//All the opciones especiales appertaining to the same element should be linked together
struct strGra_LinkedOpcionE;
typedef struct strGra_LinkedOpcionE{
	struct strGra_LinkedOpcionE *next, *prev;
	Gra_OpcionEspecial oe;
} Gra_LinkedOpcionE;

#ifdef __cplusplus
extern "C"{
#endif

extern int solveall_present(const EntradaTablaElems *elems,const uint *bloque_elems, Gra_Configuracion *config);
extern SolvedQualities* get_SolvedQualities(uint Tipo,bint bstipo,Gra_Configuracion *config);
extern SolvedSignificados* get_SolvedSignificados(uint Tipo,bint bstipo,Gra_Configuracion *config);
extern void free_linkedSolvedQuality(LinkedSolvedQuality *plist);

//Funciones que incluyen manejo de ConfigTipo
//Devuelven NULL si no hay memoria
//En las funciones get_... , si subtipo no es un número de subtipo válido, e.g. -1, devuelven la del tipo
extern SolvedTipo* compute_resuelta(uint Tipo,bint bstipo,Hash_hSolvedTipo *tipos_solved,Hash_hConfigTipo *tipos);
extern SolvedQualities* get_resuelta(u16int subtipo,SolvedTipo *sctipo);
extern SolvedTipo* compute_Significados(uint Tipo,bint bstipo,Hash_hSolvedTipo* tipos_solved,Hash_hConfigTipo *tipos);
extern SolvedSignificados* get_solved_significados(u16int subtipo,SolvedTipo *sctipo);
//Construye la string the Significado basándose en Significado y SignificadoR
//Hay que liberar la memoria del puntero devuelto. NULL si AT_NOMEM
extern char16_t* make_Significado_string(SolvedSignificados *S);
//Ver
extern int Set_Ver_offs(VerInfo *ver,uint *nums);
extern int Set_VerT_ons(VerInfo *ver,uint *nums);

#ifdef __cplusplus
}
#endif
