static char16_t fixed_msg[512];

TrabajoAerotri* get_trabajo_aerotri(void){
	TrabajoAerotri *tr=n_malloc(TrabajoAerotri,1);
	if(tr==NULL) return NULL;
	set_trabajoAT(tr);
	return tr;
}
struct strRelativaParams* get_relativa_params(void){		return n_malloc(struct strRelativaParams,1);}
struct strAbsolutaCallData* get_absoluta_calldata(void){	return n_malloc(struct strAbsolutaCallData,1);}

void ATtrabajos_free(void *p){freeif(p);}
void libera_trabajoAT(TrabajoAerotri *tr){
	char16_t *pruta;

	free_null_if(tr->ficheros.fotos);
	free_null_if(tr->ficheros.aproximadas);
	free_null_if(tr->ficheros.apoyo);
	free_null_if(tr->ficheros.gpsins);
	free_null_if(tr->ficheros.camara);

	pruta=tr->configsalida.fich_Digi.rutarel;
	if(pruta!=rutas_fijas[0]){
		if(pruta!=rutas_fijas[1] && pruta!=NULL) free(pruta);
		tr->configsalida.fich_Digi.rutarel=rutas_fijas[0];
	}

	pruta=tr->configsalida.fich_Digi.rutaf;
	if(pruta!=rutas_fijas[0]){
		if(pruta!=rutas_fijas[2] && pruta!=NULL) free(pruta);
		tr->configsalida.fich_Digi.rutaf=rutas_fijas[0];
	}

	pruta=tr->configsalida.fich_Imaster.rutarel;
	if(pruta!=rutas_fijas[0]){
		if(pruta!=rutas_fijas[3] && pruta!=NULL) free(pruta);
		tr->configsalida.fich_Imaster.rutarel=rutas_fijas[0];
	}

	pruta=tr->configsalida.fich_Imaster.rutaf;
	if(pruta!=rutas_fijas[0]){
		if(pruta!=rutas_fijas[4] && pruta!=NULL) free(pruta);
		tr->configsalida.fich_Imaster.rutaf=rutas_fijas[0];
	}

#define TESTPTR_GRA(p) (p!=graconfigs_main_0 && p!=graconfigs_main_1 && p!=graconfigs_residuos_0 && p!=graconfigs_residuos_1)

	char16_t* *ptr=tr->configsalida.fich_dibujo.configs_main;
	if(ptr!=NULL){
		while(*ptr!=NULL){
			if(TESTPTR_GRA(*ptr)) free_null(*ptr);
			ptr++;
		}
		if(tr->configsalida.fich_dibujo.configs_main!=Graconfigs_main_storage) free_null(tr->configsalida.fich_dibujo.configs_main);
	}
	ptr=tr->configsalida.fich_dibujo.configs_residuos;
	if(ptr!=NULL){
		while(*ptr!=NULL){
			if(TESTPTR_GRA(*ptr)) free_null(*ptr);
			ptr++;
		}
		if(tr->configsalida.fich_dibujo.configs_residuos!=Graconfigs_residuos_storage) free_null(tr->configsalida.fich_dibujo.configs_residuos);
	}
}

int calcula_relativa(Handler hwnd_main,int log_code, const struct strRelativaParams *params, InfoMalos *pinfomalos,char16_t *mensaje, u8int idioma){
	return mainrelativa(hwnd_main,log_code, params->log_level,params->modo_toma,params->modo_medida,
							params->fichero,params->mar,params->ficheroint,params->inm,
							params->ficherogps,params->gpm,params->signoins,params->tdgps,params->tdins,params->bgeograficas,
							params->vmin,params->param,params->uni,pinfomalos,mensaje,idioma);
}
int calcula_absoluta(Handler hwnd_main,int log_code, Bufferto8 *log_file,const struct strAbsolutaCallData *params, FicheroBnf *pinfo,char16_t *mensaje, u8int idioma){
	return mainabsoluta(hwnd_main,log_code,log_file,params->P.log_level,params->P.modo_ajuste,params->P.modo_toma,params->P.modo_medida,
							params->P.ficherof,params->P.mar,params->P.ficheroapr,params->P.prm,params->P.tdapr,params->P.ficheroapy,params->P.pym,
							params->P.ficherogps,params->P.gpm,params->P.signoins,params->P.tdgps,params->P.boffgps,params->P.tdins,params->P.boffins,params->P.bgirok,
							params->P.ficheroint,params->P.inm,params->P.flags_generate,
							params->P.apriori,params->P.conjuntas,params->P.estimador,params->P.profundidades,params->P.auto_calib,params->P.pInterna,params->P.flags0,
							params->P.sis,params->P.uni,params->P.Salida,params->P.pfnumero,params->P.flimites,params->P.fill_gps,params->P.interp_resgps,
							pinfo,mensaje,idioma);
}

char16_t* pointat(char16_t* fichero){
	char16_t *s, *fin;
	s=fichero; while(*s) s++; fin=s;
	while(*s!='.' && s!=fichero) s--;
	if(*s!='.' || (pdif)(fin-s)>4) s=fin;
	return s;
}

int calcula_trabajoAT(Handler hwnd_main,int log_code, TrabajoAerotri *tr, bint allow_empty, char16_t* mensaje, u8int idioma){
	struct strRelativaParams *rel;
	struct strAbsolutaCallData *abs;
	int nret;

	nret=0;
	rel=NULL;	//rel!=NULL will mean that ficheros.aproximadas has to be freed
	abs=NULL;
	if(mensaje==NULL) mensaje=fixed_msg;
	mensaje[0]='\0';
	if(tr->ficheros.aproximadas==NULL){
		rel=get_relativa_params();					if(rel==NULL) return AT_NOMEM;
		nret=prepara_trabajo_relativa(tr,rel);	if(nret) goto salida_rel;
		nret=calcula_relativa(hwnd_main,log_code,rel,NULL,mensaje,idioma);
		if(nret>0) nret+=1000;
salida_rel:	free(rel);
				if(nret) return nret;

		tr->ficheros.aproximadas=n_malloc(char16_t,strlen16(tr->ficheros.fotos)+4+1);	//.prm
		if(tr->ficheros.aproximadas==NULL) return AT_NOMEM;
		strcpy16(tr->ficheros.aproximadas,tr->ficheros.fotos);
		{char16_t *ext=pointat(tr->ficheros.aproximadas);
		*ext++='.'; *ext++='p'; *ext++='r'; *ext++='m'; *ext='\0';}
	}

	abs=get_absoluta_calldata();		if(abs==NULL){	if(rel!=NULL) free_null(tr->ficheros.aproximadas);
																		return AT_NOMEM;}
	nret=prepara_trabajo_absoluta(tr,abs,allow_empty);	if(nret){nret+=500; goto salida_abs;}
	nret=calcula_absoluta(hwnd_main,log_code,NULL,abs,NULL,mensaje,idioma);
	if(nret) nret+=2000;
salida_abs:
	free(abs);
	if(rel!=NULL) free_null(tr->ficheros.aproximadas);
	return nret;
}
