﻿enum TextosLecturaf_Cod{
	T_Formatodesconocido,
	T_defotogramas,
	T_devaloresaprox,
	T_deccpp,
	T_deapoyo,
	T_deGPSINS,
	T_file,
	T_Nocontienedatos,
	T_Faltamarca,
	T_queindica,
	T_Ningunamarca,
	T_queindican,
	T_delos_f,
	T_delos_ccpp,
	T_delos_pp,
	T_delos_ccpp_pp,
	T_delos_grupos,
	T_Eof_inesp,
	T_cabecera_foto,
	T_eof_header,
	T_punto,
	T_ccpp,
	T_cabecera_grupo,
	T_grupopars,
	T_sistema,
	T_Enfoto,
	T__punto,
	T_Enccpp,
	T_Enpunto,
	T_Engrupo,
	T_Engrupopars,
	T_Ensistema,
	T_Elfotograma,
	T_Elccpp,
	T_Elpunto,
	T_Eldato,
	T_repetido,
	T_Mientras,
	T_Mientras_parametro,
	T_seencontro,
	T_wasfound,
	T_unnumero,
	T_focal,
	T_marca,
	T_laprec,
	T_unaprec,
	T_coorX,
	T_coorY,
	T_coorZ,
	T_Omega,
	T_Phi,
	T_Kappa,
	T_tiempo,
	T_offsetX,
	T_offsetY,
	T_offsetZ,
	T_Roll,
	T_Pitch,
	T_Heading,
	T_tipogps,
	T_tipoins,
	T_grupogps,
	T_grupoins,
	T_vv,
	T_ensulugar,
	T_Lamarca0o1,
	T_Lamarcaentre,
	T_Lafocalno0,
	T_Unaprecno0,
	T_Tipogpsentre,
	T_Tipoinsentre,
	T_Uniqueser,
	T_Finaldelinea_raw,
	T_Finaldelinea,
	T_buscaba_unaprec,
	T_Faltancampos,
	T_Demasiadosptc,
	T_Nombrefotolargo,
	T_Palabralarga,
	T_Nombrepuntolargo,
	T_Nombrecplargo,
	T_Nombregpslargo,
	T_Elnombredeunpunto,
};

static const char16_t* const LTEXTOS_lecturaf_esp[]={
	[T_Formatodesconocido]=u"Formato desconocido indicado para el fichero ",
	[T_defotogramas]=u"de fotogramas",
	[T_devaloresaprox]=u"de valores aproximados",
	[T_deccpp]=u"de centros de proyección",
	[T_deapoyo]=u"de apoyo",
	[T_deGPSINS]=u"de GPS/INS",
	[T_file]=u"",
	[T_Nocontienedatos]=u"No contiene datos",
	[T_Faltamarca]=u"Falta la marca ",
	[T_queindica]=u" que indica el comienzo ",
	[T_Ningunamarca]=u"No hay ninguna de las marcas ",
	[T_queindican]=u" que indican el comienzo ",
	[T_delos_f]=u"de los fotogramas",
	[T_delos_ccpp]=u"de los centros de proyección",
	[T_delos_pp]=u"de los puntos",
	[T_delos_ccpp_pp]=u"\nde los centros de proyección / puntos",
	[T_delos_grupos]=u"de los conjuntos GPS/INS",
	[T_Eof_inesp]=u"Final de archivo inesperado mientras se estaba leyendo ",
	[T_cabecera_foto]=u"la cabecera del fotograma ",
	[T_eof_header]=u"",
	[T_punto]=u"el punto ",
	[T_ccpp]=u"el centro de proyección ",
	[T_cabecera_grupo]=u"la cabecera del conjunto nº ",
	[T_grupopars]=u"los parámetros del conjunto gps/ins ",
	[T_sistema]=u"el elemento Sistema",

	[T_Enfoto]=u"En el fotograma ",
	[T__punto]=u", punto ",
	[T_Enccpp]=u"En el centro de proyección ",
	[T_Enpunto]=u"En el punto ",
	[T_Engrupo]=u"En el conjunto nº ",
	[T_Engrupopars]=u"En los parámetros del conjunto gps/ins ",
	[T_Ensistema]=u"En el elemento Sistema",
	[T_Elfotograma]=u"El fotograma ",
	[T_Elccpp]=u"El centro de proyección ",
	[T_Elpunto]=u"El punto ",
	[T_Eldato]=u"El dato ",
	[T_repetido]=u" está repetido",
	[T_Mientras]=u"\nMientras se estaba leyendo ",
	//El que sigue es para parámetros que se escriben y leen por Aerotri, y que el usuario no debería tocar.
	//Tras esta frase se mostrará literalmente el nombre del parámetro
	[T_Mientras_parametro]=u"\nMientras se estaba leyendo el valor ",
	[T_seencontro]=u"\nse encontró el carácter '",
	[T_wasfound]=u"'",
	[T_unnumero]=u"un número",
	[T_focal]=u"la focal",
	[T_marca]=u"la marca",
	[T_laprec]=u"la precisión particular",
	[T_unaprec]=u"una precisión particular",
	[T_coorX]=u"la coordenada X",
	[T_coorY]=u"la coordenada Y",
	[T_coorZ]=u"la coordenada Z",
	[T_Omega]=u"el ángulo Ω",
	[T_Phi]=u"el ángulo Φ",
	[T_Kappa]=u"el ángulo K",
	[T_tiempo]=u"el tiempo",
	[T_offsetX]=u"el gpsoffset X",
	[T_offsetY]=u"el gpsoffset Y",
	[T_offsetZ]=u"el gpsoffset Z",
	[T_Roll]=u"El ángulo de Roll",
	[T_Pitch]=u"El ángulo de Pitch",
	[T_Heading]=u"El ángulo de Heading",
	[T_tipogps]=u"el tipogps",
	[T_tipoins]=u"el tipoins",
	[T_grupogps]=u"el grupogps",
	[T_grupoins]=u"el grupoins",
	[T_vv]=u"el valor de vv",

	[T_ensulugar]=u";\nen su lugar se encontró ",
	[T_Lamarca0o1]=u"\nLa marca tiene que ser 0 o 1",
	[T_Lamarcaentre]=u"\nLa marca tiene que estar entre ",
	[T_Lafocalno0]=u"\nLa focal no puede ser cero",
	[T_Unaprecno0]=u"\nUna precisión particular no puede ser cero",
	[T_Tipogpsentre]=u"\nEl tipo gps tiene que estar entre 0 y 2",
	[T_Tipoinsentre]=u"\nEl tipo ins tiene que estar entre 0 y 2",
	[T_Uniqueser]=u"En valor de uni tiene que ser rad, gon o sex",
	[T_Finaldelinea_raw]=u"\nFinal de línea inesperado",
	[T_Finaldelinea]=u"\nFinal de línea inesperado mientras se buscaba ",
	[T_buscaba_unaprec]=u"una precisión particular tras ';'",
	[T_Faltancampos]=u"\nFaltan valores. Tienen que estar: ",
	[T_Demasiadosptc]=u"\nHay demasiados ';'",

	[T_Nombrefotolargo]=u"\nNombre de fotograma demasiado largo: ",
	[T_Palabralarga]=u"\nPalabra anormalmente larga: ",
	[T_Nombrepuntolargo]=u"\nNombre de punto demasiado largo: ",
	[T_Nombrecplargo]=u"\nNombre de centro de proyección demasiado largo: ",
	[T_Nombregpslargo]=u"\nNombre de punto GPS/INS demasiado largo: ",
	[T_Elnombredeunpunto]=u"El nombre de un punto no puede empezar por '-'",
};
static const char16_t* const LTEXTOS_lecturaf_eng[]={
	[T_Formatodesconocido]=u"Unknown format specified for the ",
	[T_defotogramas]=u"photographs",
	[T_devaloresaprox]=u"approximate values",
	[T_deccpp]=u"projection centers",
	[T_deapoyo]=u"control",
	[T_deGPSINS]=u"GPS/INS",
	[T_file]=u" file",
	[T_Nocontienedatos]=u"Doesn't have data",
	[T_Faltamarca]=u"The key ",
	[T_queindica]=u" that marks the beginning ",
	[T_Ningunamarca]=u"There is neither of the keys ",
	[T_queindican]=u" that mark the beginning ",
	[T_delos_f]=u"of the photographs is missing",
	[T_delos_ccpp]=u"of the projection centers is missing",
	[T_delos_pp]=u"of the points is missing",
	[T_delos_ccpp_pp]=u"\nof the projection centers / points",
	[T_delos_grupos]=u"of the GPS/INS sets",
	[T_Eof_inesp]=u"Unexpected end of file found while reading ",
	[T_cabecera_foto]=u"photo's ",
	[T_eof_header]=u" header",
	[T_punto]=u"the point ",
	[T_ccpp]=u"the projection center ",
	[T_cabecera_grupo]=u"set's nº ",
	[T_grupopars]=u"the parameters of the gps/ins set ",
	[T_sistema]=u"the element Sistema",

	[T_Enfoto]=u"In the photograph ",
	[T__punto]=u", point",
	[T_Enccpp]=u"In the projection center ",
	[T_Enpunto]=u"In the point ",
	[T_Engrupo]=u"In the set nº ",
	[T_Engrupopars]=u"In the parameters of the gps/ins set ",
	[T_Ensistema]=u"In the element Sistema",
	[T_Elfotograma]=u"The photograph ",
	[T_Elccpp]=u"The projection center ",
	[T_Elpunto]=u"The point ",
	[T_Eldato]=u"The field ",
	[T_repetido]=u" appears twice",
	[T_Mientras]=u"\nWhile reading ",
	//El que sigue es para parámetros que se escriben y leen por Aerotri, y que el usuario no debería tocar.
	//Tras esta frase se mostrará literalmente el nombre del parámetro
	[T_Mientras_parametro]=u"\nWhile reading the value ",
	[T_seencontro]=u"\nthe character '",
	[T_wasfound]=u"' was found",
	[T_unnumero]=u"a number",
	[T_focal]=u"the phocal length",
	[T_marca]=u"the mark",
	[T_laprec]=u"the particular precision",
	[T_unaprec]=u"a particular precision",
	[T_coorX]=u"the X coordinate",
	[T_coorY]=u"the Y coordinate",
	[T_coorZ]=u"the Z coordinate",
	[T_Omega]=u"the Ω angle",
	[T_Phi]=u"the Φ angle",
	[T_Kappa]=u"the K angle",
	[T_tiempo]=u"the time value",
	[T_offsetX]=u"the X gpsoffset",
	[T_offsetY]=u"the Y gpsoffset",
	[T_offsetZ]=u"the Z gpsoffset",
	[T_Roll]=u"The Roll rotation",
	[T_Pitch]=u"The Pitch rotation",
	[T_Heading]=u"The Heading rotation",
	[T_tipogps]=u"the tipogps",
	[T_tipoins]=u"the tipoins",
	[T_grupogps]=u"the grupogps",
	[T_grupoins]=u"the grupoins",
	[T_vv]=u"the value of vv",

	[T_ensulugar]=u";\nit was found instead: ",
	[T_Lamarca0o1]=u"\nThe mark has to be either 0 or 1",
	[T_Lamarcaentre]=u"\nThe mark must fall between ",
	[T_Lafocalno0]=u"\nThe focal length cannot be zero",
	[T_Unaprecno0]=u"\nA particular precision cannot be zero",
	[T_Tipogpsentre]=u"\nThe gps type must lie between 0 and 2",
	[T_Tipoinsentre]=u"\nThe ins type must lie between 0 and 2",
	[T_Uniqueser]=u"The value of uni must be either rad, gon or sex",
	[T_Finaldelinea_raw]=u"\nUnexpected end of line",
	[T_Finaldelinea]=u"\nUnexpected end of line found while looking ",
	[T_buscaba_unaprec]=u"for a particular precision after ';'",
	[T_Faltancampos]=u"\nThere are missing fields. The format is: ",
	[T_Demasiadosptc]=u"There are too many ';'",
	
	[T_Nombrefotolargo]=u"\nPhotograph name too long: ",
	[T_Palabralarga]=u"\nAbnormally long word: ",
	[T_Nombrepuntolargo]=u"\nPoint name too long: ",
	[T_Nombrecplargo]=u"\nProjection center name too long: ",
	[T_Nombregpslargo]=u"\nGPS/INS point name too long: ",
	[T_Elnombredeunpunto]=u"\nA point name cannot begin with a '-'",
};
static const char16_t* const LTEXTOS_lecturaf_it[]={
	[T_Formatodesconocido]=u"Formato sconosciuto indicato per il file ",
	[T_defotogramas]=u"di fotogrammi",
	[T_devaloresaprox]=u"di valori approssimati",
	[T_deccpp]=u"di centri di proiezione",
	[T_deapoyo]=u"di appoggio",
	[T_deGPSINS]=u"di GPS/INS",
	[T_file]=u"",
	[T_Nocontienedatos]=u"Non contiene dati",
	[T_Faltamarca]=u"Manca il segno ",
	[T_queindica]=u" che  indica l'inizio ",
	[T_Ningunamarca]=u"Non c'è nesuno dei segni ",
	[T_queindican]=u" che  indicano l'inizio ",
	[T_delos_f]=u"delle fotografie",
	[T_delos_ccpp]=u"dei centri di proiezione",
	[T_delos_pp]=u"dei punti",
	[T_delos_ccpp_pp]=u"\ndei centri di proiezione / punti",
	[T_delos_grupos]=u"degli insiemi GPS/INS",
	[T_Eof_inesp]=u"Finale di archivo inaspettato mentre si stava a leggere ",
	[T_cabecera_foto]=u"il header del fotogramma ",
	[T_eof_header]=u"",
	[T_punto]=u"il punto ",
	[T_ccpp]=u"il centro di proiezione ",
	[T_cabecera_grupo]=u"il header dell'insieme nº ",
	[T_grupopars]=u"i parametri dell'insieme gps/ins ",
	[T_sistema]=u"l'elemento Sistema",

	[T_Enfoto]=u"Nel fotogramma ",
	[T__punto]=u", punto",
	[T_Enccpp]=u"Nel centro di proiezione ",
	[T_Enpunto]=u"Nel punto ",
	[T_Engrupo]=u"Nell'insieme nº ",
	[T_Engrupopars]=u"Nei parametri dell'insieme gps/ins ",
	[T_Ensistema]=u"Nell'elemento Sistema",
	[T_Elfotograma]=u"Il fotogramma ",
	[T_Elccpp]=u"Il centro di proiezione ",
	[T_Elpunto]=u"Il punto ",
	[T_Eldato]=u"Il dato ",
	[T_repetido]=u" compare due volte",
	[T_Mientras]=u"\nMentre si stava a leggere ",
	[T_Mientras_parametro]=u"\nMentre si stava a leggere il valore ",
	[T_seencontro]=u"\nsi trovò il carattere '",
	[T_wasfound]=u"'",
	[T_unnumero]=u"un numero",
	[T_focal]=u"la focale",
	[T_marca]=u"il segno",
	[T_laprec]=u"la precisione particolare",
	[T_unaprec]=u"una precisione particolare",
	[T_coorX]=u"la coordinata X",
	[T_coorY]=u"la coordinata Y",
	[T_coorZ]=u"la coordinata Z",
	[T_Omega]=u"l'angolo Ω",
	[T_Phi]=u"l'angolo Φ",
	[T_Kappa]=u"l'angolo K",
	[T_tiempo]=u"il tempo",
	[T_offsetX]=u"il gpsoffset X",
	[T_offsetY]=u"il gpsoffset Y",
	[T_offsetZ]=u"il gpsoffset Z",
	[T_Roll]=u"L'angolo di Roll",
	[T_Pitch]=u"L'angolo di Pitch",
	[T_Heading]=u"L'angolo di Heading",
	[T_tipogps]=u"il tipogps",
	[T_tipoins]=u"il tipoins",
	[T_grupogps]=u"il grupogps",
	[T_grupoins]=u"il grupoins",
	[T_vv]=u"il valore di vv",

	[T_ensulugar]=u";\nal suo posto si trovò",
	[T_Lamarca0o1]=u"\nIl segno deve essere 0 o 1",
	[T_Lamarcaentre]=u"\nIl segno deve essere fra ",
	[T_Lafocalno0]=u"\nLa focale non può essere zero",
	[T_Unaprecno0]=u"\nUna precisione particolare non può essere zero",
	[T_Tipogpsentre]=u"\nIl tipo gps deve essere fra 0 e 2",
	[T_Tipoinsentre]=u"\nIl tipo ins deve essere fra 0 e 2",
	[T_Uniqueser]=u"Il valore di uni deve essere rad, gon o sex",
	[T_Finaldelinea_raw]=u"\nFinale di linea inaspettato",
	[T_Finaldelinea]=u"\nFinale di linea inaspettato mentre si cercava ",
	[T_buscaba_unaprec]=u"una precisione particolare dopo ';'",
	[T_Faltancampos]=u"\nMancano valori. Devono essere: ",
	[T_Demasiadosptc]=u"Ci sono troppi ';'",

	[T_Nombrefotolargo]=u"\nNome di fotogramma tropo lungo: ",
	[T_Palabralarga]=u"\nParola anormalmente lunga: ",
	[T_Nombrepuntolargo]=u"\nNome di punto tropo lungo: ",
	[T_Nombrecplargo]=u"\nNome di centro di proiezione tropo lungo: ",
	[T_Nombregpslargo]=u"\nNome di punto GPS/INS tropo lungo: ",
	[T_Elnombredeunpunto]=u"\nIl nome di un punto non può cominciare da '-'",
};

#define MAX_IDIOMA Id_It
static const char16_t* const* LTEXTOS_lecturaf[3]={
	LTEXTOS_lecturaf_esp,
	LTEXTOS_lecturaf_eng,
	LTEXTOS_lecturaf_it
};

#define TEXTO_lecturaf(n)		global._LTEXTOS[n]
#define S_(s) TEXTO_lecturaf(T_##s)

#define wSS_Eof_in_foto		S_(Eof_inesp),'w',S_(cabecera_foto)  /*para usar con mixed build*/
#define wSS_Eof_in_punto		S_(Eof_inesp),'w',S_(punto)
#define wSS_Eof_in_ccpp		S_(Eof_inesp),'w',S_(ccpp)
#define SS_Eof_in_grupo		S_(Eof_inesp),S_(cabecera_grupo)
#define SS_Eof_in_grupopars	S_(Eof_inesp),S_(grupopars)
#define wSS_Eof_in_sistema	S_(Eof_inesp),'w',S_(sistema)
