﻿#include "clases_estimadores.h"
float f_normal(float x){
	float y;
	y=expf(-.5F*x*x);
	return y/sqrtf(6.2831853F);
}
float f_fotocoord(float x){	//2*dens(x)==dens|x|
	float z,y,x2;
	if(x<0) x=-x;
	x2=x*x;
	if(x<0.2F){
		y=1.086551F/(1.0F+1.9447711F*x2);
	}elif(x<3.0F){
		z=1.12418F*x+0.41873F*x2-0.10387F*x*x2+0.00071F*x2*x2;
		z=1.002597F*expf(-z);
		y=1.12418F+0.83746F*x-0.31161F*x2+0.00284F*x*x2;
		y*=z;
	}else{
		y=powf(x2-4.361205F*x+4.804955F,1.4F);
		y=(0.008647F*x-0.020775F)/y;
	}
	return y;
}

//Funciones peso1: raíz del peso
sinline float peso1_normal(float _unused(v), Estimador* _unused(estim)){
	return 1.0F;
}
/*float peso1_cuad(float v, Estimador* estim){
	if(v<0) v=-v;
	float p;
	if(v<estim->par1) p=1;
	else{
		p=estim->par1/v;
		p=powf(p,estim->par2/2);
	}
	return p;
}*/
float peso1_fotocoord(float v, Estimador* _unused(estim)){
	float p;
	if(v<0) v=-v;
	if(v<=0.76F){
		if(v<0.52F) p=1.4763923F+(0.52F-v)*0.2F;
		else p=1.5F-powf(v/1.1F, 5);
	}elif(v<=1.0F){v-=0.76F; p=1.3425638F+v*-0.77F+v*v*0.48F;}
	elif(v<=1.98F){v-=1.0F; p=1.1854118F+v*-0.36F+v*v*0.009F;}
	elif(v<=3.36F){v-=1.98F; p=0.8316946F+v*-0.32F+v*v*0.01F;}
	elif(v<=3.8F){v-=3.36F; p=0.4186994F+v*-0.247F+v*v*0.03F;}
	elif(v<=7.2F){p=29.5606558F/powf(v, 3.4F-(v-3.8F)*0.021F);}
	else p=2.1461601F/(v*v);
	return p;
}

void Estimador_setup(Estimador *E){
	switch(E->_f_dens){
		case 0: E->f_dens=f_normal; break;
		case 1: E->f_dens=f_fotocoord; break;
		//case 11: E->f_dens=f_apoyo; break;
		//case 21: E->f_dens=f_GPS; break;
		//case 31: E->f_dens=f_INS; break;
		default: E->f_dens=f_normal;
	}
	switch(E->_peso1){
		case 0: E->f_peso1=peso1_normal; break;
		//case 1: E->f_peso1=peso1_cuad; break;
		case 4: E->f_peso1=peso1_fotocoord; break;
		default: E->f_peso1=peso1_normal;
	}
	/*switch(E->_p_precision){
		case 0: E->peso1_normal; break;	//Una función que devuelve 1;
		case 1:
	}*/
	if(E->_peso1!=0){
		float x,y;
		E->kσ=0;
		for(x=0.01F;x<4.1F;x+=0.02F){
			y=x*E->f_peso1(x,E);
			y*=y;
			y*=E->f_dens(x);
			E->kσ+=y;
		}
		E->kσ=1/(0.02F*E->kσ);
		switch(E->_peso1){
			case 4: y=0.91F; break;
			default: y=1;
		}
		E->kσ*=y;
	}else{
		E->kσ=1;
	}
}
