﻿void escribe_cabecera_trans(Bufferto8 *finf,char16_t* ficheroapr1,char16_t* ficheroapr2,bint fijas1, bint fijas2, bint desconocidas, PrecFichero precf1, PrecFichero precf2, s8int uni, bint escala, bint grandes_rot, bint apriori){
	const char8_t* const *TEXTOS=TEXTOS_transformacion[gb.idioma];

	towrite8_string(finf,TEXTOS[0]);	towrite_string16_utf8(finf,ficheroapr1);
	towrite8_string(finf,TEXTOS[1]);	towrite_string16_utf8(finf,ficheroapr2);
	towrite8_string(finf,TEXTOS[2]);
	if(desconocidas){
		if(fijas1) towrite8_many_strings(finf,TEXTOS[3],TEXTOS[4],NULL);
		else towrite8_string(finf,TEXTOS[5]);
	}
	else{
		setbuf_limpio(finf);
		if(fijas1) towrite8_string(finf,TEXTOS[6]);
		else{
			towrite8(finf,'s',TEXTOS[7],
				's',TEXTOS[8],'f',precf1.cpXY,
				's',TEXTOS[9],'f',precf1.cpZ,
				's',TEXTOS[10],'f',precf1.pXY,
				's',TEXTOS[11],'f',precf1.pZ,
			0);
		}
		toput_char(finf,'\n');
		if(fijas2) towrite8_string(finf,TEXTOS[12]);
		else{
			towrite8(finf,'s',TEXTOS[13],
				's',TEXTOS[8],'f',precf2.cpXY,
				's',TEXTOS[9],'f',precf2.cpZ,
				's',TEXTOS[10],'f',precf2.pXY,
				's',TEXTOS[11],'f',precf2.pZ,
			0);
		}
		toput_char(finf,'\n');
		setbuf_nolimpio(finf);
	}
	toput_char(finf,'\n');
	toput_char(finf,'\n');
	if(escala) towrite8_string(finf,TEXTOS[14]);
	else towrite8_string(finf,TEXTOS[15]);
	if(grandes_rot) towrite8_string(finf,TEXTOS[16]);
	if(apriori) towrite8_string(finf,TEXTOS[17]);
	towrite8_string(finf,TEXTOS[18]);
	if(uni>2) uni=2;
	towrite8_string(finf,TEXTOS[19+uni]);
	towrite8_string(finf,"\n\n\n");
}
void escribe_estadisticas_trans(Bufferto8 *finf,uint ncp1,uint npm1,uint ncp2,uint npm2,uint nfc,uint npc){
	const char8_t* const *TEXTOS=TEXTOS_transformacion[gb.idioma];

	towrite8_string(finf,TEXTOS[22]); towrite8_aligned_uint(finf,ncp1,5);	toput_char(finf,'\n');
	towrite8_string(finf,TEXTOS[23]); towrite8_aligned_uint(finf,ncp2,5);	toput_char(finf,'\n');
	towrite8_string(finf,TEXTOS[24]); towrite8_aligned_uint(finf,nfc,5);	toput_char(finf,'\n');
	towrite8_string(finf,TEXTOS[25]); towrite8_aligned_uint(finf,npm1,5);	toput_char(finf,'\n');
	towrite8_string(finf,TEXTOS[26]); towrite8_aligned_uint(finf,npm2,5);	toput_char(finf,'\n');
	towrite8_string(finf,TEXTOS[27]); towrite8_aligned_uint(finf,npc,5);	toput_char(finf,'\n');
}

void escribe_sis_trans(Bufferto8 *finf, Sistema *sis1, Sistema *sis2, s8int dec1, s8int dec2){
	const char8_t* const *TEXTOS=TEXTOS_transformacion[gb.idioma];
	if(sis1!=NULL && sis1->sis.proy!=SIS_Rectangular){
		finf->prec.absol=dec1;
		towrite8_string(finf,TEXTOS[68]);
		towrite8(finf,'s',TEXTOS[70], '(','f',sis1->local.proy.x,',', 'f', sis1->local.proy.y, 's',",0)\n", 0);
		towrite8_string(finf,TEXTOS[71]);
	}
	if(sis2!=NULL && sis2->sis.proy!=SIS_Rectangular){
		finf->prec.absol=dec2;
		towrite8_string(finf,TEXTOS[69]);
		towrite8(finf,'s',TEXTOS[70], '(','f',sis2->local.proy.x,',', 'f', sis2->local.proy.y, 's',",0)\n", 0);
		towrite8_string(finf,TEXTOS[71]);
	}
}
void escribe_param_trans(Bufferto8 *finf, Hel3Dg_dbl Tr, s8int dec1,s8int dec2, s8int decl,s8int decg, bint escala){
	const char8_t* const *TEXTOS=TEXTOS_transformacion[gb.idioma];
	setbuf_absolute(finf);

	towrite8_many_strings(finf,TEXTOS[28],TEXTOS[29],"\n                (X1-CG1)=",NULL);
	if(escala) towrite8_string(finf,"l*");
	towrite8_string(finf,"R*(X2-CG2)\n\n");
	towrite8_many_strings(finf,TEXTOS[30],TEXTOS[31],TEXTOS[32],TEXTOS[33],TEXTOS[34],NULL);
	if(escala) towrite8_string(finf,TEXTOS[35]);
	finf->prec.absol=dec1;
	towrite8_string(finf,"\n\n           CG1: ");
	towrite8_aligned_double(finf,Tr.cg1.X,14); toput_char(finf,' ');
	towrite8_aligned_double(finf,Tr.cg1.Y,14); toput_char(finf,' ');
	towrite8_aligned_double(finf,Tr.cg1.Z,14); toput_char(finf,'\n');
	finf->prec.absol=dec2;
	towrite8_string(finf,"           CG2: ");
	towrite8_aligned_double(finf,Tr.cg2.X,14); toput_char(finf,' ');
	towrite8_aligned_double(finf,Tr.cg2.Y,14); toput_char(finf,' ');
	towrite8_aligned_double(finf,Tr.cg2.Z,14); toput_char(finf,'\n');
	towrite8_string(finf,TEXTOS[36]);
	finf->prec.absol=dec1;
	towrite8_aligned_double(finf,Tr.cg1.X-Tr.cg2.X,14); toput_char(finf,' ');
	towrite8_aligned_double(finf,Tr.cg1.Y-Tr.cg2.Y,14); toput_char(finf,' ');
	towrite8_aligned_double(finf,Tr.cg1.Z-Tr.cg2.Z,14); toput_char(finf,'\n');
	if(escala){
		finf->prec.absol=decl;
		towrite8_string(finf,"\n             l: ");
		towrite8_aligned_double(finf,Tr.esc,14); toput_char(finf,'\n');
	}
	towrite8_string(finf,TEXTOS[37]);
	if(decg>6) finf->prec.absol=decg;
	else finf->prec.absol=6;
	double *iM=Tr.M[0];
	for(u8int i=0;i<3;i++){
		if(i) towrite8_string(finf,TEXTOS[38]);
		towrite8_aligned_double(finf,*iM++,10); toput_char(finf,' ');
		towrite8_aligned_double(finf,*iM++,10); toput_char(finf,' ');
		towrite8_aligned_double(finf,*iM++,10); toput_char(finf,'\n');
	}
}

void escribe_res_cp_y_p(Bufferto8 *finf, char8_t** nombres, PuntoXYZ_float* res, uint nfc, uint npc,s8int decf, s8int decp){
	const char8_t* const *TEXTOS=TEXTOS_transformacion[gb.idioma];

	uint nc=nfc+npc;
	uint i;
	setbuf_absolute(finf);
	i=0;
	if(nfc){
		towrite8_string(finf,TEXTOS[39]);
		finf->prec.absol=decf;
		for(;i<nfc;i++){
			towrite8_string(finf,"    "); towrite8_aligned_string(finf,nombres[i],9); toput_char(finf,' ');
			towrite_aligned_float(finf,res[i].X,10); toput_char(finf,' ');
			towrite_aligned_float(finf,res[i].Y,10); toput_char(finf,' ');
			towrite_aligned_float(finf,res[i].Z,10); toput_char(finf,'\n');
		}
		if(npc) toput_char(finf,'\n');
	}
	if(npc){
		towrite8_string(finf,TEXTOS[40]);
		finf->prec.absol=decp;
		for(;i<nc;i++){
			towrite8_string(finf,"    "); towrite8_aligned_string(finf,nombres[i],9); toput_char(finf,' ');
			towrite_aligned_float(finf,res[i].X,10); toput_char(finf,' ');
			towrite_aligned_float(finf,res[i].Y,10); toput_char(finf,' ');
			towrite_aligned_float(finf,res[i].Z,10); toput_char(finf,'\n');
		}
	}
}

void escribe_res_mayores_cp_y_p(Bufferto8 *finf, char8_t** nombres, PuntoXYZ_float* res, uint nfc, s8int decf, s8int decp, uint* ind_resp, uint nperc){
	setbuf_absolute(finf);
	Durchlaufei(uint,ind_resp,nperc){
		uint k=*ptri++;
		if(k>=nfc) finf->prec.absol=decp;
		else finf->prec.absol=decf;
		towrite8_string(finf,"    "); towrite8_aligned_string(finf,nombres[k],9); toput_char(finf,' ');
		towrite_aligned_float(finf,res[k].X,10); toput_char(finf,' ');
		towrite_aligned_float(finf,res[k].Y,10); toput_char(finf,' ');
		towrite_aligned_float(finf,res[k].Z,10);
		if(k>=nfc) towrite8_string(finf,"   p.\n");
		else towrite8_string(finf,"   c.p.\n");
	}
}

void escribe_residuos(Bufferto8 *finf,ModelosConfigSalida *Salida, char8_t** nombres, char8_t** nombresc, PuntoXYZ_float* res1, PuntoXYZ_float* res2, uint nfc,uint npc,uint nfcc,uint npcc, DecTrans dec){
	const char8_t* const *TEXTOS=TEXTOS_transformacion[gb.idioma];

	Salida->fich_inf.infR&= ~8U|(nfcc!=0 || npcc!=0)<<3;
	if(ModelosSalida_hay_residuos(Salida)){
		towrite8_string(finf,TEXTOS[57]);
		towrite8_string(finf,TEXTOS[58]);
		if(Salida->fich_inf.infR&1){
			towrite8_string(finf,TEXTOS[54]);
			escribe_res_cp_y_p(finf,nombres,res1,nfc,npc,dec.res.f1,dec.res.p1);
		}
		if((Salida->fich_inf.infR&2)){
			towrite8_string(finf,TEXTOS[55]);
			escribe_res_cp_y_p(finf,nombres,res2,nfc,npc,dec.res.f1,dec.res.p1);
		}
	}
	if(nfcc+npcc!=0 && (Salida->fich_inf.infR&8)){
		towrite8_string(finf,TEXTOS[53]);
		towrite8_string(finf,TEXTOS[54]);
		escribe_res_cp_y_p(finf,nombresc,res1+(nfc+npc),nfcc,npcc,dec.res.f1,dec.res.p1);
		towrite8_string(finf,TEXTOS[55]);
		escribe_res_cp_y_p(finf,nombresc,res2+(nfc+npc),nfcc,npcc,dec.res.f2,dec.res.p2);
	}
}
sinline void escribe_residuos_mayores(Bufferto8 *finf, char8_t** nombres, PuntoXYZ_float* res1, PuntoXYZ_float* res2, uint nfc, DecTrans dec, uint nperc, uint* ind_resp){
	const char8_t* const *TEXTOS=TEXTOS_transformacion[gb.idioma];

	towrite8_string(finf,TEXTOS[62]);
	towrite8_string(finf,TEXTOS[54]);
	escribe_res_mayores_cp_y_p(finf,nombres,res1,nfc,dec.res.f1,dec.res.p1,ind_resp,nperc);
	towrite8_string(finf,TEXTOS[55]);
	escribe_res_mayores_cp_y_p(finf,nombres,res2,nfc,dec.res.f2,dec.res.p2,ind_resp,nperc);
}
void escribe_prec_trans(Bufferto8 *finf, PrecTrans prec, bint escala, bint grandes_rot, float fccpi){
	s8int dec1,dec2,decg;
	float aux;
	const char8_t* const *TEXTOS=TEXTOS_transformacion[gb.idioma];

	setbuf_absolute(finf);
	towrite8_string(finf,TEXTOS[44]);

	aux=fminf(prec.T1x,prec.T1y);
	if(prec.T1z<aux) aux=prec.T1z;
	dec1=decimales_f(aux);

	aux=fminf(prec.T2x,prec.T2y);
	if(prec.T2z<aux) aux=prec.T2z;
	dec2=decimales_f(aux);

	prec.Gw*=fccpi;	prec.Gfi*=fccpi;
	prec.Gk*=fccpi;
	aux=fminf(prec.Gw,prec.Gfi);
	if(prec.Gk<aux) aux=prec.Gk;
	decg=decimales_f(aux);

	if(!grandes_rot) towrite8_string(finf,TEXTOS[45]);
	else towrite8_string(finf,TEXTOS[46]);
	finf->prec.absol=dec1;
	towrite8_string(finf,"\n               ");
	towrite_aligned_float(finf,prec.T1x,9); toput_char(finf,' ');
	if(grandes_rot){towrite_aligned_float(finf,prec.T1y,9); toput_char(finf,' ');}
	towrite_aligned_float(finf,prec.T1z,9); toput_char(finf,' ');
	if(escala || grandes_rot){
		towrite8_string(finf,TEXTOS[47]);
		finf->prec.absol=dec2;
		towrite8_string(finf,"               ");
		towrite_aligned_float(finf,prec.T2x,9); toput_char(finf,' ');
		if(grandes_rot){towrite_aligned_float(finf,prec.T2y,9); toput_char(finf,' ');}
		towrite_aligned_float(finf,prec.T2z,9); toput_char(finf,' ');
		towrite8_string(finf,TEXTOS[48]);
	}
	towrite8_string(finf,TEXTOS[49]);
	towrite8_string(finf,"             W        PHI        K\n");
	finf->prec.absol=decg;
	towrite8_string(finf,"\n        ");
	towrite_aligned_float(finf,prec.Gw,9); toput_char(finf,' ');
	towrite_aligned_float(finf,prec.Gfi,9); toput_char(finf,' ');
	towrite_aligned_float(finf,prec.Gk,9); toput_char(finf,'\n');
	if(escala){
		towrite8_string(finf,TEXTOS[50]);
		towrite8_string(finf,TEXTOS[51]);
		finf->prec.absol=decimales_f(prec.esc);
		towrite_float(finf,prec.esc);
		finf->prec.absol-=6;
		towrite8_string(finf,TEXTOS[52]);
		towrite_float(finf,prec.esc*1000000); toput_char(finf,'\n');
	}
}

char8_t* texto_precision_explicacion(char8_t c1,char8_t c2){
	static char8_t* texto;
	static char8_t texto_eng[200]=u8"    If there be an errorless point in the system 1, with transformed coordinates CG2+(x,y,z) in the\n"
					  "    system 2, the precision of the latest would be given by the following matrix of variances:\n";
	static char8_t texto_it[200]=u8"    Sia un punto senza errore nel sistema 1, e siano CG2+(x,y,z) i sue coordinate trasformate\n"
					  "    nel sistema 2. La precisione di questi coordinate è espressa da questa matrice di varianze:\n";
	static char8_t texto_esp[200]=u8"    Sea un punto sin error en el sistema 1, cuyas coordenadas transformadas en el sistema 2\n"
					  "    son CG2+(x,y,z). La precisión de estas coordenadas viene dada por la siguiente matriz de varianzas:\n";
	switch(gb.idioma){
		case 1:  texto=texto_eng;  texto[49]=c1;  texto[83]=texto[111]=c2; break;
		case 2:  texto=texto_it;	    texto[42]=c1;  texto[55]=texto[110]=c2; break;
		default:texto=texto_esp;   texto[41]=c1;  texto[102]=texto[90]=c2; break;
	}
	return texto;
}

void comun_ejemplos_antes(Bufferto8 *finf, float Nt[],float precl,bint escala,float N[], float *d, float *dd, s8int *dec, uint *nd, u8int *cmax){
	float f, d_3;
	float sx,sy,sz, sxb,syb,szb;
	uint prev;
	const char8_t* const *TEXTOS=TEXTOS_transformacion[gb.idioma];

	*d=Nt[0];
	if(Nt[4]>*d) *d=Nt[4];
	if(Nt[8]>*d) *d=Nt[8];
	*d/=precl;
	*d=sqrtf(*d);
	d_3=*d*0.57735F;

	//Obtener la longitud de la cadena que ocupa más, y dejar dos huecos:
	*dec=log10n(d_3);
	f=pow10f(*dec);
	*nd=(uint)((*d/f)+0.8F);	//redondeamos hacia arriba;
	if(*nd==10) (*dec)++;
	if(*dec<0) *cmax=-3**dec+14+8;	//Añado los 8 espacios en blanco a la derecha
	else *cmax=3**dec+11+8;

	*dec=log10n(*d);
	f=pow10f(*dec);
	*nd=(uint)((*d/f)+0.8F);	//redondeamos hacia arriba;
	*d=f**nd;
	if(*nd==10) (*dec)++;
	if(*dec>=0) *nd=(uint)*d;
	*dd=*d**d;

	setbuf_relative(finf);
	finf->prec.signi=2;
	if(!escala) precl=0;
	towrite8_string(finf,TEXTOS[67]);
	sxb=Nt[0];	syb=Nt[4];	szb=Nt[8];

	towrite8_string(finf,"\n        (0,0,0)");
	prev=15;
	for(;prev<*cmax;prev++) toput_char(finf,' ');
	towrite_aligned_float(finf,sqrtf(sxb),8);
	towrite_aligned_float(finf,sqrtf(syb),8);
	towrite_aligned_float(finf,sqrtf(szb),8);
	toput_char(finf,'\n');

	sx=sxb+precl**dd;		sy=syb+*dd*N[8];	sz=szb+*dd*N[4];
	prev=to_writtenchars(finf);
	towrite8_string(finf,"\n        (");
	if(*dec<0) towrite_float(finf,*d);	else towrite8_uint(finf,*nd); //ATfileoutput ya admite valores de prec negativos, pero ahora no voy a cambiar esto
	towrite8_string(finf,",0,0)");
	prev=to_writtenchars(finf)-prev-1;
	for(;prev<*cmax;prev++) toput_char(finf,' ');
	towrite_aligned_float(finf,sqrtf(sx),8);
	towrite_aligned_float(finf,sqrtf(sy),8);
	towrite_aligned_float(finf,sqrtf(sz),8);
	toput_char(finf,'\n');

	sx=sxb+*dd*N[8];		sy=syb+precl**dd;	sz=szb+*dd*N[0];
	prev=to_writtenchars(finf);
	towrite8_string(finf,"\n        (0,");
	if(*dec<0) towrite_float(finf,*d);	else towrite8_uint(finf,*nd);
	towrite8_string(finf,",0)");
	prev=to_writtenchars(finf)-prev-1;
	for(;prev<*cmax;prev++) toput_char(finf,' ');
	towrite_aligned_float(finf,sqrtf(sx),8);
	towrite_aligned_float(finf,sqrtf(sy),8);
	towrite_aligned_float(finf,sqrtf(sz),8);
	toput_char(finf,'\n');

	sx=sxb+*dd*N[4];		sy=syb+*dd*N[0];	sz=szb+precl**dd;
	prev=to_writtenchars(finf);
	towrite8_string(finf,"\n        (0,0,");
	if(*dec<0) towrite_float(finf,*d);	else towrite8_uint(finf,*nd);
	toput_char(finf,')');
	prev=to_writtenchars(finf)-prev-1;
	for(;prev<*cmax;prev++) toput_char(finf,' ');
	towrite_aligned_float(finf,sqrtf(sx),8);
	towrite_aligned_float(finf,sqrtf(sy),8);
	towrite_aligned_float(finf,sqrtf(sz),8);
	toput_char(finf,'\n');

	*d=d_3;
	*dec=log10n(*d);
	f=pow10f(*dec);
	*nd=(uint)((*d/f)+0.8F);	//redondeamos hacia arriba;
	*d=f**nd;
	if(*nd==10) (*dec)++;
	if(*dec>=0) *nd=(uint)*d;
	*dd=*d**d;
}

void comun_ejemplos(Bufferto8 *finf, float sxb,float syb,float szb, float sxc,float syc,float szc, float slx,float sly,float slz, s8int prec, float d, uint nd, u8int cmax){
	float sx,sy,sz;
	uint prev;

	sx=sxb-sxc+sly-slz;	sy=syb-syc+slz-slx;	sz=szb-szc+slx-sly;
	prev=to_writtenchars(finf);
	towrite8_string(finf,"\n        (");
	if(prec<0) towrite8(finf,'f',d,',', 'f',d,',', 'f',d, 0);
	else towrite8(finf,'u',nd,',', 'u',nd,',', 'u',nd, 0);
	toput_char(finf,')');
	prev=to_writtenchars(finf)-prev-1;
	for(;prev<cmax;prev++) toput_char(finf,' ');
	towrite_aligned_float(finf,sqrtf(sx),8);
	towrite_aligned_float(finf,sqrtf(sy),8);
	towrite_aligned_float(finf,sqrtf(sz),8);
	toput_char(finf,'\n');

	sx=sxb-sxc+sly+slz;	sy=syb+syc-slz+slx;	sz=szb+szc-slx-sly;
	prev=to_writtenchars(finf);
	towrite8_string(finf,"\n        (");
	if(prec<0) towrite8(finf,'f',-d,',', 'f',d,',', 'f',d, 0);
	else towrite8(finf,'-','u',nd,',', 'u',nd,',', 'u',nd, 0);
	toput_char(finf,')');
	prev=to_writtenchars(finf)-prev-1;
	for(;prev<cmax;prev++) toput_char(finf,' ');
	towrite_aligned_float(finf,sqrtf(sx),8);
	towrite_aligned_float(finf,sqrtf(sy),8);
	towrite_aligned_float(finf,sqrtf(sz),8);
	toput_char(finf,'\n');

	sx=sxb+sxc-sly-slz;	sy=syb+syc+slz+slx;	sz=szb-szc-slx+sly;
	prev=to_writtenchars(finf);
	towrite8_string(finf,"\n        (");
	if(prec<0) towrite8(finf,'f',-d,',', 'f',-d,',', 'f',d, 0);
	else towrite8(finf,'-','u',nd,',','-', 'u',nd,',', 'u',nd, 0);
	toput_char(finf,')');
	prev=to_writtenchars(finf)-prev-1;
	for(;prev<cmax;prev++) toput_char(finf,' ');
	towrite_aligned_float(finf,sqrtf(sx),8);
	towrite_aligned_float(finf,sqrtf(sy),8);
	towrite_aligned_float(finf,sqrtf(sz),8);
	toput_char(finf,'\n');

	sx=sxb+sxc-sly+slz;	sy=syb-syc-slz-slx;	sz=szb+szc+slx+sly;
	prev=to_writtenchars(finf);
	towrite8_string(finf,"\n        (");
	if(prec<0) towrite8(finf,'f',d,',', 'f',-d,',', 'f',d, 0);
	else towrite8(finf,'u',nd,',','-', 'u',nd,',', 'u',nd, 0);
	toput_char(finf,')');
	prev=to_writtenchars(finf)-prev-1;
	for(;prev<cmax;prev++) toput_char(finf,' ');
	towrite_aligned_float(finf,sqrtf(sx),8);
	towrite_aligned_float(finf,sqrtf(sy),8);
	towrite_aligned_float(finf,sqrtf(sz),8);
	toput_char(finf,'\n');
}

void escribe_ejemplos(Bufferto8 *finf, float Nt[], float precl, bint escala, float N[]){
	float d,dd;
	s8int n;
	uint nd;
	float sxb,syb,szb, sxc,syc,szc;
	u8int cmax;

	comun_ejemplos_antes(finf,Nt,precl,escala,N, &d,&dd,&n,&nd, &cmax);

	if(!escala) precl=0;
	sxb=Nt[0]+dd*(precl+N[4]+N[8]);
	syb=Nt[4]+dd*(precl+N[8]+N[0]);
	szb=Nt[8]+dd*(precl+N[0]+N[4]);
	sxc=dd*(N[5]+N[7]);		syc=dd*(N[2]+N[6]);		szc=dd*(N[1]+N[3]);

	comun_ejemplos(finf, sxb,syb,szb, sxc,syc,szc, 0,0,0, n,d,nd,cmax);
}

void escribe_ejemplos_2(Bufferto8 *finf, float Nt[],float N[]){
	float d,dd;
	s8int n;
	uint nd;
	float sxb,syb,szb, sxc,syc,szc, slx,sly,slz;
	u8int cmax;
	float Na[9];
	{float *pNa=Na, *pN=N+5;
	*pNa++=*pN++; *pNa++=*pN++; *pNa++=*pN; pN+=2;	// pN termina en N[9]
	*pNa++=*pN++; *pNa++=*pN++; *pNa++=*pN; pN+=2;	// pN termina en N[13]
	*pNa++=*pN++; *pNa++=*pN++; *pNa=*pN;}

	comun_ejemplos_antes(finf,Nt,N[0],true,Na, &d,&dd,&n,&nd, &cmax);

	sxb=Nt[0]+dd*(N[0]+Na[4]+Na[8]);
	syb=Nt[4]+dd*(N[0]+Na[8]+Na[0]);
	szb=Nt[8]+dd*(N[0]+Na[0]+Na[4]);
	sxc=dd*(Na[5]+Na[7]);		syc=dd*(Na[2]+Na[6]);		szc=dd*(Na[1]+Na[3]);
	slx=2*dd*N[1];	sly=2*dd*N[2];	slz=2*dd*N[3];

	comun_ejemplos(finf, sxb,syb,szb, sxc,syc,szc, slx,sly,slz, n,d,nd,cmax);
}

void escribe_matriz_precision(Bufferto8 *finf, float *Nt,float *N, bint escala, float precl){
	setbuf_relative(finf);
	towrite8_string(finf,"    /");
	finf->prec.signi=3; towrite_aligned_float(finf,Nt[0],8);
	finf->prec.signi=2; finf->maschar=' ';
	towrite_aligned_float(finf,Nt[1],9);
	towrite_aligned_float(finf,Nt[2],9);
	towrite8_string(finf," \\");
	if(escala) towrite8_string(finf,"             / xx xy xz \\");
	towrite8_string(finf,"   / 0  z -y \\/");
	towrite_aligned_float(finf,N[0],8);
	towrite_aligned_float(finf,N[1],9);
	towrite_aligned_float(finf,N[2],9);
	towrite8_string(finf," \\/ 0 -z  y \\\n");

	towrite8_string(finf,"    |");
	towrite_aligned_float(finf,Nt[3],8);
	finf->prec.signi=3; finf->maschar='\0'; towrite_aligned_float(finf,Nt[4],9);
	finf->prec.signi=2; finf->maschar=' ';
	towrite_aligned_float(finf,Nt[5],9);
	towrite8_string(finf," |");
	if(escala){
		towrite8_string(finf," + ");
		finf->prec.signi=3; finf->maschar='\0'; towrite_aligned_float(finf,precl,9);
		towrite8_string(finf," | xy yy yz |");
		finf->prec.signi=2; finf->maschar=' ';
	}
	towrite8_string(finf," + |-z  0  x ||");
	towrite_aligned_float(finf,N[3],8);
	towrite_aligned_float(finf,N[4],9);
	towrite_aligned_float(finf,N[5],9);
	towrite8_string(finf," || z  0 -x |\n");

	towrite8_string(finf,"    \\");
	towrite_aligned_float(finf,Nt[6],8);
	towrite_aligned_float(finf,Nt[7],9);
	finf->prec.signi=3; finf->maschar='\0'; towrite_aligned_float(finf,Nt[8],9);
	finf->prec.signi=2; finf->maschar=' ';
	towrite8_string(finf," /");
	if(escala) towrite8_string(finf,"             \\ xz yz zz /");
	towrite8_string(finf,"   \\ y -x  0 /\\");
	towrite_aligned_float(finf,N[6],8);
	towrite_aligned_float(finf,N[7],9);
	towrite_aligned_float(finf,N[8],9);
	towrite8_string(finf," /\\-y  x  0 /\n");
	finf->maschar='\0';
}
void escribe_prec_punto_trans(Bufferto8 *finf,float* Nt1,float* Nt2,float precl,float* N1, float* N2, bint escala,bint ejemplos){
	towrite8_string(finf,texto_precision_explicacion('1','2'));
	toput_char(finf,'\n');
	escribe_matriz_precision(finf,Nt2,N2,escala,precl);
	if(ejemplos) escribe_ejemplos(finf,Nt2,precl,escala,N2);

	toput_char(finf,'\n');
	towrite8_string(finf,texto_precision_explicacion('2','1'));
	toput_char(finf,'\n');
	escribe_matriz_precision(finf,Nt1,N1,escala,precl);
	if(ejemplos) escribe_ejemplos(finf,Nt1,precl,escala,N1);
}

void escribe_matriz_precision_2(Bufferto8 *finf, float *Nt,float *N){
	setbuf_relative(finf);
	towrite8_string(finf,"    /");
	finf->prec.signi=3; towrite_aligned_float(finf,Nt[0],8);
	finf->prec.signi=2; finf->maschar=' ';
	towrite_aligned_float(finf,Nt[1],9);
	towrite_aligned_float(finf,Nt[2],9);
	towrite8_string(finf," \\   / x  0  z -y \\/");
	finf->prec.signi=3; towrite_aligned_float(finf,Nt[0],8);	towrite_aligned_float(finf,N[0],8);
	finf->prec.signi=2; finf->maschar=' ';
	towrite_aligned_float(finf,N[1],9);
	towrite_aligned_float(finf,N[2],9);
	towrite_aligned_float(finf,N[3],9);
	towrite8_string(finf," \\/ x  y  z \\\n");

	towrite8_string(finf,"    |");
	towrite_aligned_float(finf,Nt[3],8);
	finf->prec.signi=3; finf->maschar='\0'; towrite_aligned_float(finf,Nt[4],9);
	finf->prec.signi=2; finf->maschar=' ';
	towrite_aligned_float(finf,Nt[5],9);
	towrite8_string(finf," | + | y -z  0  x ||");
	towrite_aligned_float(finf,N[4],8);
	towrite_aligned_float(finf,N[5],9);
	towrite_aligned_float(finf,N[6],9);
	towrite_aligned_float(finf,N[7],9);
	towrite8_string(finf," || 0 -z  y |\n");

	towrite8_string(finf,"    \\");
	towrite_aligned_float(finf,Nt[6],8);
	towrite_aligned_float(finf,Nt[7],9);
	finf->prec.signi=3; finf->maschar='\0'; towrite_aligned_float(finf,Nt[8],9);
	finf->prec.signi=2; finf->maschar=' ';
	towrite8_string(finf," /   \\ z  y -x  0 /|");
	towrite_aligned_float(finf,N[8],8);
	towrite_aligned_float(finf,N[9],9);
	towrite_aligned_float(finf,N[10],9);
	towrite_aligned_float(finf,N[11],9);
	towrite8_string(finf," || z  0 -x |\n");

	towrite8_string(finf,"                                                  \\");
	towrite_aligned_float(finf,N[12],8);
	towrite_aligned_float(finf,N[13],9);
	towrite_aligned_float(finf,N[14],9);
	towrite_aligned_float(finf,N[15],9);
	towrite8_string(finf," /\\-y  x  0 /\n");
	finf->maschar='\0';
}

void escribe_prec_punto_trans_2(Bufferto8 *finf,float* Nt1,float* Nt2,float* N1, float* N2, bint escala,bint ejemplos){
	if((N1[1]==0 && N1[2]==0 && N1[3]==0) || (N2[1]==0 && N2[2]==0 && N2[3]==0)){
		float Na[9], Nb[9];
		{float *pNa=Na, *pN=N1+5;
		*pNa++=*pN++; *pNa++=*pN++; *pNa++=*pN; pN+=2;	// pN termina en N[9]
		*pNa++=*pN++; *pNa++=*pN++; *pNa++=*pN; pN+=2;	// pN termina en N[13]
		*pNa++=*pN++; *pNa++=*pN++; *pNa=*pN;}
		{float *pNa=Nb, *pN=N2+5;
		*pNa++=*pN++; *pNa++=*pN++; *pNa++=*pN; pN+=2;	// pN termina en N[9]
		*pNa++=*pN++; *pNa++=*pN++; *pNa++=*pN; pN+=2;	// pN termina en N[13]
		*pNa++=*pN++; *pNa++=*pN++; *pNa=*pN;}
		escribe_prec_punto_trans(finf,Nt1,Nt2,N1[0],Na,Nb,escala,ejemplos); return;
	}
	towrite8_string(finf,texto_precision_explicacion('1','2'));
	toput_char(finf,'\n');
	escribe_matriz_precision_2(finf,Nt2,N2);
	if(ejemplos) escribe_ejemplos_2(finf,Nt2,N2);

	toput_char(finf,'\n');
	towrite8_string(finf,texto_precision_explicacion('2','1'));
	toput_char(finf,'\n');
	escribe_matriz_precision_2(finf,Nt1,N1);
	if(ejemplos) escribe_ejemplos_2(finf,Nt1,N1);
}
