﻿#include <time.h>
#include "escritura_float.h"
//#define FILA towrite8_string(finf,"\t\t<tr><td>	//The C preprocessor is as poor as it can be

typedef struct{
	unsigned infR:16;
	unsigned infP:16;
} FicheroHtml;


sinline bint HTML_hay_residuos(FicheroHtml *f){return (f->infR!=0);}
sinline bint HTML_hay_avisos(FicheroHtml *f){return (f->infR&0x0021)!=0 || (f->infP&0x0021)!=0;}
sinline bint HTML_hay_parametros(FicheroHtml *f){return (f->infP&0x000F)!=0;}
sinline bint HTML_hay_precisiones(FicheroHtml *f){return (f->infP&0x0070)!=0;}

void HTML_cabecera_html(Bufferto8 *finf){
	time_t _t=time(NULL);
	struct tm *tiempo=localtime(&_t);
	char8_t stiempo[26];
	tiempo_html(tiempo,stiempo);
	towrite8_many_strings(finf,"<!Doctype html public \"-//W3C//DED HTML 4.01 TRANSITIONAL//EN\" \"http://www.w3.org/TR/html401/loose.dtd\">\n",
		TEXTOS[130],
		"<meta http-equiv=Content-Type content=\"text/html; charset=UTF-8\">\n",
		TEXTOS[131],
		"<meta name=Author content=\"Aerotri\">\n",
		"<meta name=Date content=\"",stiempo,"\">\n",
	NULL);
	towrite8_many_strings(finf,
		"\n<style>\n",
		"body{background:white; color:black; font-family:Verdana, Helvetica, sans-serif; font-size:small;\n",
		"\t\tmargin-left:5%; margin-right:5%}\n",
		"DIV#Title{font-family:Times, serif; font-size:x-large; text-align:center}\n",
		"span#tt{font-family:Sylfaen, Times, serif; font-size:xx-large}\n",
		"span.color{color:#F04B2C}\n",
		"A{text-decoration:none}\n",
		"\np{margin:0}\n",
		"DIV#Index{font-family:Times, serif; font-size:medium}\n",
		u8"p.Index1{margin-top:2em; color:#000058; font-weight:bold}\t/*Al ponerlo en negrita lo mezcla con blanco y parece #00088*/\n",
		"p.Index2{margin-left:1.85em; margin-top:0.6em; color:#000058; font-weight:bold;}\n",
		"p.Index3{margin-left:3.25em; margin-top:0.4em; color:#000088}\n",
		"DIV#Index A{color:inherit}\n",
		"\nH1, H2{font-family:Times, serif}\n",
		"H1{margin-top:2.5em; font-size:large}\n",
		"H2{margin-top:1.7em; font-size:large}\n",
		"H3{margin-top:1.5em; font-family:Verdana, Helvetica, sans-serif; font-style:oblique; font-weight:normal; font-size:small}\n",
		"H1+H2{margin-top:1.6em}\n",
		"H2+H3{margin-top:auto}\n",
		"\ntable{border-collapse:collapse}\n",
		"table.values{margin-left:1.5em}\n",
		"table.values td{padding-left:2em}\n",
		"tr.intermezzo td{padding-top:0.6em; padding-bottom:0.25em; padding-left:0em; padding-right:-1000mm}\n",
		"tr.space td{padding-top:0.5em;}\n",
		"tr td.indent{padding-left:3.5em}\n",
		"table+table{margin-top:1em}\n",
		"pre{font-family:Courier, monospace}\n",
		".zero{margin:0}\n",
		".margin{margin-left:1.5em}\n",
		".right{text-align:right}\n",
		"</style>\n",
	NULL);
}

void HTML_titulo(Bufferto8 *finf, const char8_t* cliente, const char16_t* titulo_trabajo){
#ifdef CLIENTE
	cliente=CLiente;
#endif
	towrite8_many_strings(finf,"\n<body>\n"
		"<DIV id=Title>\n"
		"\t<br>\n",
		TEXTOS[132],
		"\t<br>\n"
		"\t<span id=tt><span class=color>A</span>ero<span class=color>t</span>ri</span><br>\n",
	NULL);
	if(cliente!=NULL){
		towrite8_many_strings(finf,"\t<p style=\"margin:0; font-size:medium; font-style:italic; font-weight:bold\">",
			/*TEXTOS[133],*/cliente,"</p>\n",
		NULL);
	}
	towrite8_string(finf,"\t<br>\n\t<span style=\"font-variant:small-caps; color:#580028\"><b>&bull;&ensp;<span style=\"letter-spacing:1pt\">");
		towrite_string16_utf8(finf,titulo_trabajo);
		towrite8_string(finf,"</span>&ensp;&bull;</b></span>\n");
	towrite8_string(finf,"</DIV>\n");
}
void HTML_indice(Bufferto8 *finf, FicheroHtml Salidahtm, bint avisos, bint calib){
	towrite8_string(finf,"<br>\n<DIV id=Index>\n");
	html_index(finf,1,TEXTOS[134],"CABECERA");
	html_index(finf,2,TEXTOS[135],"Datos de entrada");
	html_index(finf,2,TEXTOS[136],"Estadísticas");
	if(avisos) html_index(finf,2,TEXTOS[137],"Avisos");
	if(HTML_hay_residuos(&Salidahtm)){
		html_index(finf,1,TEXTOS[138],"RESIDUOS");
		if(Salidahtm.infR&1) html_index(finf,2,TEXTOS[139],"Res.Fotocoordenadas");
		if(Salidahtm.infR&2) html_index(finf,2,TEXTOS[140],"Res.Apoyo");
		if(Salidahtm.infR&8) html_index(finf,2,TEXTOS[141],"Res.Puntos de control");
		if(Salidahtm.infR&4) html_index(finf,2,TEXTOS[142],"Res.GPS/INS");
		html_index(finf,2,TEXTOS[143],"Desviaciones típicas a posteriori");
		if(Salidahtm.infR&0x10){
			html_index(finf,2,TEXTOS[144],"Proporción de residuos que superan cada nivel");
			html_index(finf,2,TEXTOS[145],"Residuos medios en cada zona del fotograma");
		}
		if(Salidahtm.infR&0x20) html_index(finf,2,TEXTOS[146],"Puntos con algún residuo elevado");
	}
	if(HTML_hay_parametros(&Salidahtm) || calib){
		html_index(finf,1,TEXTOS[147],"PARÁMETROS AJUSTADOS");
		if(calib)  html_index(finf,2,TEXTOS[148],"Par.Autocalibración");
		if(Salidahtm.infP&1) html_index(finf,2,TEXTOS[149],"Par.Centros de proyección");
		if(Salidahtm.infP&2) html_index(finf,2,TEXTOS[150],"Par.Puntos");
		if(Salidahtm.infP&4) html_index(finf,2,TEXTOS[151],"Par.GPS/INS");
		if(Salidahtm.infP&8) html_index(finf,2,TEXTOS[152],"Par.Matrices");
	}
	if(HTML_hay_precisiones(&Salidahtm)){
		html_index(finf,1,TEXTOS[153],"PRECISIONES");
		if(Salidahtm.infP&0x10) html_index(finf,2,TEXTOS[149],"Prec.cc.pp.");
		if(Salidahtm.infP&0x20){
			html_index(finf,2,TEXTOS[150],"Prec.Puntos");
			html_index(finf,3,TEXTOS[154],"Precisiones medianas");
		}
		if(Salidahtm.infP&0x40) html_index(finf,2,TEXTOS[155],"Prec.GPS/INS");
	}
	towrite8_string(finf,"</DIV>\n");
}

void HTML_cabecera(Bufferto8 *finf, s8int dec, const char16_t* ficherof,const char16_t* ficheroapr,const char16_t* ficheroapy,u8int pym,const char16_t* ficherogps,u8int gpm,
					u8int tdgps,bint boffgps,u8int tdins,bint boffins, const char16_t* ficheroint,u8int inm, bint fijas, n_enes c, bint auto_calib,
					bint _unused(completo),Estimador_complejo estimador, EstimacionConjuntas conjuntas, Precisiones apriori,
					Sistema* sis,s8int uni,float fccpi, const char16_t* uniim,const char16_t* unit, const char8_t* cg,const char8_t* unig){
	html_H(finf,1,TEXTOS[134],u8"CABECERA");
	html_H(finf,2,TEXTOS[135],u8"Datos de entrada");
	html_H(finf,3,TEXTOS[158],u8"Ficheros de entrada");
	towrite8_string(finf,"\t<table class=values>\n");
	towrite8_string(finf,TEXTOS[159]); towrite_string16_utf8(finf,ficherof); toput_char(finf,'\n');
	towrite8_string(finf,TEXTOS[160]); towrite_string16_utf8(finf,ficheroapr); toput_char(finf,'\n');
	if(ficheroapy!=NULL){towrite8_string(finf,TEXTOS[161]); towrite_string16_utf8(finf,ficheroapy); toput_char(finf,'\n');}
	if(ficherogps!=NULL){towrite8_string(finf,TEXTOS[162]); towrite_string16_utf8(finf,ficherogps); toput_char(finf,'\n');}
	if(ficheroint!=NULL){towrite8_string(finf,TEXTOS[163]); towrite_string16_utf8(finf,ficheroint); toput_char(finf,'\n');}
	towrite8_string(finf,"\t</table>\n\n");

	html_H(finf,3,TEXTOS[164],u8"Tipo de ajuste");
	{uint i=estimador.tipo_usuario; if(i>4) i=4;
	towrite8(finf,'s',"\t<table class=values>\n",
		's',u8"\t\t<tr><td colspan=2 style=\"padding-bottom:1em\">Estimador: ",	's',TEXTOS[79+i], '\n',0);}
	//{uint i; if(completo) i=0; else i=1;\
	towrite8(finf,'s',TEXTOS[165], 's',TEXTOS[85+i], '\n',0);}
	if(auto_calib) towrite8_string(finf,TEXTOS[166]);
	if(c.npy){
		uint i; if(fijas) i=0; else i=1;
		towrite8(finf,'s',TEXTOS[167], 's',TEXTOS[85+i], '\n',0);
	}
	else towrite8_string(finf,TEXTOS[168]);
	if(c.ngps){
		towrite8_string(finf,TEXTOS[169]);
		if(boffgps) towrite8_string(finf,TEXTOS[91]);
		else{towrite8_uint(finf,tdgps); toput_char(finf,'\n');}
	}
	else towrite8_string(finf,TEXTOS[170]);
	if(c.nins){
		towrite8_string(finf,TEXTOS[171]);
		if(boffins) towrite8_string(finf,TEXTOS[91]);
		else{towrite8_uint(finf,tdins); toput_char(finf,'\n');}
	}
	else towrite8_string(finf,TEXTOS[172]);
	if(estimador.tipo_usuario!=0){
		towrite8_string(finf,TEXTOS[173]);
		towrite8_string(finf,TEXTOS[174]);
		if(!conjuntas.xy) towrite8_string(finf,TEXTOS[97]);
		else towrite8_string(finf,TEXTOS[98]);
		if(fijas && c.npy){
			towrite8_string(finf,TEXTOS[175]);
			if(!conjuntas.XY) towrite8_string(finf,TEXTOS[97]);
			else towrite8_string(finf,TEXTOS[98]);
			towrite8_string(finf,TEXTOS[176]);
			if(!conjuntas.planiZ) towrite8_string(finf,TEXTOS[97]);
			else towrite8_string(finf,TEXTOS[98]);
		}
	}
	towrite8_string(finf,"\t</table>\n");

	setbuf_relative(finf);
	html_H(finf,3,TEXTOS[177],u8"Precisiones");
	towrite8_many_strings(finf,"\t<table class=values>\n",TEXTOS[178],NULL); formatea_precisión(finf,apriori.im,uniim);
	if(c.npy){
		towrite8_string(finf,TEXTOS[179]); formatea_precisión(finf,apriori.pXY,unit);
		towrite8_string(finf,TEXTOS[180]); formatea_precisión(finf,apriori.pZ,unit);
	}
	if(c.ngps){
		towrite8_string(finf,TEXTOS[181]); formatea_precisión(finf,apriori.gpsXY,unit);
		towrite8_string(finf,TEXTOS[182]); formatea_precisión(finf,apriori.gpsZ,unit);
	}
	if(c.nins){
		void (*fequiv)(Bufferto8*,double,char16_t,char16_t);
		if(uni==2) fequiv=fGradoSex;
		else fequiv=NULL;
		towrite8_string(finf,TEXTOS[183]);
			if(apriori.insΩΦ<0) towrite8_string(finf,TEXTOS[21]);
			fPrecGiro(finf,fabsf(apriori.insΩΦ)*fccpi,cg,unig,fequiv); toput_char(finf,'\n');
		towrite8_string(finf,TEXTOS[184]);
			if(apriori.insK<0) towrite8_string(finf,TEXTOS[21]);
			fPrecGiro(finf,fabsf(apriori.insK)*fccpi,cg,unig,fequiv); toput_char(finf,'\n');
	}
	towrite8_string(finf,"\t</table>\n");

	html_H(finf,3,TEXTOS[185],u8"Otros");
	if(uni>2) uni=0;
	towrite8_many_strings(finf,"\t<table class=values><tr>\n",TEXTOS[186],TEXTOS[110+uni],"\t</table>\n",NULL);

	setbuf_absolute(finf);
	towrite8_string(finf,"\t<table class=values>\n"
		"\t\t<tr class=intermezzo><td colspan=2>");
	towrite8_string(finf,TEXTOS[187]);
	if(sis->sis.proy==SIS_Rectangular){
		towrite8_string(finf,TEXTOS[114]);
	}elif(sis->sis.proy==SIS_Conforme){
		towrite8_string(finf,TEXTOS[115]);
		finf->prec.absol=0;
		if(sis->sis.a==sis->sis.e){
			towrite8(finf,'s',"\t\t<tr><td>a<td>", 'f',sis->sis.a, ' ','w',unit, '\n',0);
		}else{
			towrite8(finf,'s',"\t\t<tr><td>N<td>", 'f',sis->sis.a, ' ','w',unit, '\n',0);
			towrite8(finf,'s',"\t\t<tr><td>rho<td>", 'f',sis->sis.e, ' ','w',unit, '\n',0);
			setbuf_relativep(finf,2);
			towrite8_string(finf,TEXTOS[188]); fGradoSexU8(finf,sis->sis.param1.conv0); toput_char(finf,'\n');
			setbuf_absolute(finf);
		}
		if(dec-2>0) finf->prec.absol=dec-2;
		else finf->prec.absol=0;
		towrite8(finf,'s',"\t\t<tr><td style=\"padding-bottom:0.4em\">\n", 's',TEXTOS[189], 'f',sis->sis.ond, ' ','w',unit, '\n',0);
		finf->prec.absol=7;
		towrite8(finf,'s',"\t\t<tr><td>k<td>", 'f',sis->sis.k0, '\n',0);
	}else{
		{uint i=0; if(sis->sis.proy<=SIS_Mercator_Transversa) i=116+sis->sis.proy;
		elif(sis->sis.proy==SIS_Geograficas) i=122;
		if(i!=0) towrite8_string(finf,TEXTOS[i]);}
		towrite8_string(finf,"\n\n");

		towrite8_string(finf,TEXTOS[190]);
		escribe_elip(finf,sis->infor.elip); toput_char(finf,'\n');
		finf->prec.absol=0;
		if(sis->sis.e==0){
			towrite8(finf,'s',"\t\t<tr><td class=indent>R<td>", 'f',sis->sis.a, ' ','w',unit, '\n',0);
		}else{
			towrite8(finf,'s',"\t\t<tr><td class=indent>a<td>", 'f',sis->sis.a, ' ','w',unit, '\n',0);
			finf->prec.absol=9;
			towrite8(finf,'s',"\t\t<tr><td class=indent>e<sup>2</sup><td>", 'f',sis->sis.e, '\n',0);
		}
		if(dec-2>0) finf->prec.absol=dec-2;
		else finf->prec.absol=0;
		towrite8(finf,'s',TEXTOS[191], 'f',sis->sis.ond, ' ','w',unit, '\n',0);
		towrite8_string(finf,"\t\t<tr><td style=\"padding-bottom:0.4em\">\n");

		if(sis->sis.proy==SIS_Geograficas) goto fin_sistema;

		finf->prec.absol=6;
		if(sis->sis.proy==SIS_Lambert){	//Lambert
			towrite8_string(finf,TEXTOS[192]); fGradoSexU8(finf,sis->sis.param1.φ0); toput_char(finf,'\n');
		}
		towrite8(finf,'s',TEXTOS[193], 'f',sis->sis.k0, '\n',0);
		finf->prec.absol=dec;
		if(sis->sis.proy!=SIS_Mercator){	//Mercator
			towrite8(finf,'s',TEXTOS[194], 'f',sis->sis.xO, ' ','w',unit, '\n',0);
		}
		towrite8(finf,'s',TEXTOS[195], 'f',sis->sis.yS, ' ','w',unit, '\n',0);
	}
fin_sistema:
	towrite8_string(finf,"\t</table>\n");
}

void HTML_estadisticas(Bufferto8 *finf, n_enes c,uint ntot, n_enes o){
	bint a=0;
	html_H(finf,2,TEXTOS[136],u8"Estadísticas");
	towrite8_string(finf,"\t<table class=values><col><col align=right>\n");
	towrite8(finf,'s',TEXTOS[196], 'u',c.nf, '\n',0);
	towrite8(finf,'s',TEXTOS[197], 'u',c.npm, '\n',0);
	if(o.npy!=0){
		towrite8(finf,'s',TEXTOS[198], 'u',c.npy, '\n',0);
	}
	towrite8(finf,'s',TEXTOS[199], 'u',ntot, '\n',0);
	if(o.ngps!=0){
		towrite8(finf,'s',TEXTOS[200], 'u',c.ngruposgps, '\n',0);
		towrite8(finf,'s',TEXTOS[201], 'u',c.ngps, '\n',0);
	}
	if(o.nins!=0){
		towrite8(finf,'s',TEXTOS[202], 'u',c.ngruposins, '\n',0);
		towrite8(finf,'s',TEXTOS[203], 'u',c.nins, '\n',0);
	}
	towrite8_string(finf,"\t</table>\n");

	if(c.nf!=o.nf || c.npm!=o.npm || c.npy!=o.npy ||
		c.ngruposgps!=o.ngruposgps || c.ngps!=o.ngps ||
		c.ngruposgps!=o.ngruposgps || c.ngps!=o.ngps
	    )a=1;
	if(a) towrite8_string(finf,"\t<table class=values><col><col align=right>\n");
	if(c.nf!=o.nf)			towrite8(finf,'s',TEXTOS[204], 'u',o.nf-c.nf, '\n',0);
	if(c.npm!=o.npm)	towrite8(finf,'s',TEXTOS[205], 'u',o.npm-c.npm, '\n',0);
	if(c.npy!=o.npy)		towrite8(finf,'s',TEXTOS[206], 'u',o.npy-c.npy, '\n',0);
	if(c.ngruposgps!=o.ngruposgps) towrite8(finf,'s',TEXTOS[207], 'u',o.ngruposgps-c.ngruposgps, '\n',0);
	if(c.ngps!=o.ngps)	towrite8(finf,'s',TEXTOS[208], 'u',o.ngps-c.ngps, '\n',0);
	if(c.ngruposins!=o.ngruposins)	towrite8(finf,'s',TEXTOS[209], 'u',o.ngruposins-c.ngruposins, '\n',0);
	if(c.nins!=o.nins)		towrite8(finf,'s',TEXTOS[210], 'u',o.nins-c.nins, '\n',0);
	if(a) towrite8_string(finf,"\t</table>\n");
}
void HTML_apariciones(Bufferto8 *finf, uint* pm_ppios, uint npm){
	uint apariciones[21];
	uint k,kb;

	zeroset_uint(apariciones,21);
	{uint ll=0;
	Durchlaufei(uint,pm_ppios+1,npm){
		uint l=ll;
		ll=*ptri++;
		l=ll-l-1;
		if(l>20) l=20;
		apariciones[l]++;
	}}
	for(k=20;!apariciones[k];k--);
	kb=++k;
	if(kb==21) kb=20;

	towrite8_many_strings(finf,"\t<table class=values><col><col align=right>\n"
		"\t\t<tr class=intermezzo><td colspan=2>",
		TEXTOS[211],
		"\t\t<tr><td>",
		TEXTOS[212],
	NULL);
	towrite8_uint(finf,apariciones[1]); toput_char(finf,'\n');
	for(uint i=2;i<kb;i++){
		towrite8(finf,'s',"\t\t<tr><td>", 'u',i, 's',TEXTOS[213], 'u',apariciones[i], '\n',0);
	}
	if(k==21) towrite8(finf,'s',"\t\t<tr><td>20+ ", 's',TEXTOS[214], 'u',apariciones[20], '\n',0);
	towrite8_string(finf,"\t</table>");
}

void HTML_avisos(Bufferto8 *finf, Avisos avisos, bint aviso, u8int blibre){
	if(avisos.interna_novalida==0 && avisos.maxiter==0 && aviso==0 && blibre==0) return;
	html_H(finf,2,TEXTOS[137],u8"Avisos");
	towrite8_string(finf,"\t<ul>\n");
		if(avisos.interna_novalida){
			towrite8_string(finf,"\t\t<li>");
			if(avisos.interna_novalida==1){
				towrite8_many_strings(finf,TEXTOS[24],"\t\t",TEXTOS[25],NULL);
			}else{
				towrite8_string(finf,TEXTOS[26]);
				if(avisos.interna_novalida&2) towrite8_string(finf,TEXTOS[27]);
				if(avisos.interna_novalida&4) towrite8_string(finf,TEXTOS[28]);
				towrite8_string(finf,TEXTOS[216]);
			}
		}
		if(avisos.maxiter) towrite8_string(finf,TEXTOS[217]);
		if(blibre){
			towrite8_string(finf,"\t\t<li>");
			if(blibre==1) towrite8_string(finf,TEXTOS[249]);
			else towrite8_string(finf,TEXTOS[248]);
		}
		if(aviso){towrite8_string(finf,"\t\t<li>"); towrite8_string(finf,TEXTOS[32]);}
	}

