﻿void escribe_elip(Bufferto8 *finf, const char8_t* elip);

void formatea_precisión(Bufferto8 *finf, float prec,const char16_t* suni){
	if(prec<0) towrite8_string(finf,TEXTOS[21]);
	towrite8(finf,'f',fabsf(prec), ' ', 'w',suni, '\n',0);
}

void cabecera(Bufferto8 *finf, s8int dec, const char16_t* ficherof,const char16_t* ficheroapr,const char16_t* ficheroapy,u8int pym,const char16_t* ficherogps,u8int gpm,
					u8int tdgps,bint boffgps,u8int tdins,bint boffins, const char16_t* ficheroint,u8int inm, bint fijas, n_enes c, bint blibre, bint auto_calib,
					bint _unused(completo),Estimador_complejo estimador, EstimacionConjuntas conjuntas, Precisiones apriori,
					Sistema* sis,s8int uni,float fccpi, const char16_t* uniim,const char16_t* unit, const char8_t* cg, const char8_t* unig){

	towrite8_string(finf,TEXTOS[72]); towrite_string16_utf8(finf,ficherof); toput_char(finf,'\n');
	towrite8_string(finf,TEXTOS[73]); towrite_string16_utf8(finf,ficheroapr); toput_char(finf,'\n');
	if(ficheroapy!=NULL){towrite8_string(finf,TEXTOS[74]); towrite_string16_utf8(finf,ficheroapy); toput_char(finf,'\n');}
	if(ficherogps!=NULL){towrite8_string(finf,TEXTOS[75]); towrite_string16_utf8(finf,ficherogps); toput_char(finf,'\n');}
	if(ficheroint!=NULL){towrite8_string(finf,TEXTOS[76]); towrite_string16_utf8(finf,ficheroint); toput_char(finf,'\n');}

	{uint i=estimador.tipo_usuario; if(i>4) i=4;
	towrite8(finf,'s',TEXTOS[77], 's',TEXTOS[78], 's',TEXTOS[79+i], '\n',0);}
	//{uint i; if(completo) i=0; else i=1;\
	towrite8(finf,'s',TEXTOS[84], 's',TEXTOS[85+i], '\n',0);}
	if(auto_calib) towrite8_string(finf,TEXTOS[87]);
	toput_char(finf,'\n');
	if(c.npy){
		uint i; if(fijas) i=0; else i=1;
		towrite8(finf,'s',TEXTOS[88], 's',TEXTOS[85+i], '\n',0);
	}
	else towrite8_string(finf,TEXTOS[89]);
	if(c.ngps){
		towrite8_string(finf,TEXTOS[90]);
		if(boffgps) towrite8_string(finf,TEXTOS[91]);
		else{towrite8_uint(finf,tdgps); toput_char(finf,'\n');}
	}
	else towrite8_string(finf,TEXTOS[92]);
	if(c.nins){
		towrite8_string(finf,TEXTOS[93]);
		if(boffins) towrite8_string(finf,TEXTOS[91]);
		else{towrite8_uint(finf,tdins); toput_char(finf,'\n');}
	}
	else towrite8_string(finf,TEXTOS[94]);
	if(estimador.tipo_usuario!=0){
		towrite8_string(finf,TEXTOS[95]);
		towrite8_string(finf,TEXTOS[96]);
		if(!conjuntas.xy) towrite8_string(finf,TEXTOS[97]);
		else towrite8_string(finf,TEXTOS[98]);
		if(fijas && c.npy){
			towrite8_string(finf,TEXTOS[99]);
			if(!conjuntas.XY) towrite8_string(finf,TEXTOS[97]);
			else towrite8_string(finf,TEXTOS[98]);
			towrite8_string(finf,TEXTOS[100]);
			if(!conjuntas.planiZ) towrite8_string(finf,TEXTOS[97]);
			else towrite8_string(finf,TEXTOS[98]);
		}
	}
	setbuf_relative(finf);
	towrite8_string(finf,TEXTOS[101]);
	towrite8_string(finf,TEXTOS[102]); formatea_precisión(finf,apriori.im,uniim);
	if(fijas && c.npy){
		towrite8_string(finf,TEXTOS[103]); formatea_precisión(finf,apriori.pXY,unit);
		towrite8_string(finf,TEXTOS[104]); formatea_precisión(finf,apriori.pZ,unit);
	}
	if(c.ngps){
		towrite8_string(finf,TEXTOS[105]); formatea_precisión(finf,apriori.gpsXY,unit);
		towrite8_string(finf,TEXTOS[106]); formatea_precisión(finf,apriori.gpsZ,unit);
	}
	if(c.nins){
		void (*fequiv)(Bufferto8*,double,char16_t,char16_t);
		if(uni==2) fequiv=fGradoSex;
		else fequiv=NULL;
		towrite8_string(finf,TEXTOS[107]);
			if(apriori.insΩΦ<0) towrite8_string(finf,TEXTOS[21]);
			fPrecGiro(finf,fabsf(apriori.insΩΦ)*fccpi,cg,unig,fequiv); toput_char(finf,'\n');
		towrite8_string(finf,TEXTOS[108]);
			if(apriori.insK<0) towrite8_string(finf,TEXTOS[21]);
			fPrecGiro(finf,fabsf(apriori.insK)*fccpi,cg,unig,fequiv); toput_char(finf,'\n');
	}
	if(uni>2) uni=0;
	towrite8_many_strings(finf,TEXTOS[109],TEXTOS[110+uni],"\n\n\n",NULL);

	if(blibre){
		if(c.npy || c.ngps) towrite8_string(finf,TEXTOS[249]);
		else towrite8_string(finf,TEXTOS[248]);
	}
	setbuf_absolute(finf);
	towrite8_string(finf,TEXTOS[113]);
	if(sis->sis.proy==SIS_Rectangular){
		towrite8_string(finf,TEXTOS[114]);
	}elif(sis->sis.proy==SIS_Conforme){
		towrite8_string(finf,TEXTOS[115]);
		finf->prec.absol=0;
		if(sis->sis.a==sis->sis.e){
			towrite8(finf,'s',"         a= ", 'f',sis->sis.a, ' ','w',unit, '\n',0);
		}else{
			towrite8(finf,'s',"         N= ", 'f',sis->sis.a, ' ','w',unit, '\n',0);
			towrite8(finf,'s',"       rho= ", 'f',sis->sis.e, ' ','w',unit, '\n',0);
			setbuf_relativep(finf,2);
			towrite8_string(finf,TEXTOS[116]); fGradoSexU8(finf,sis->sis.param1.conv0); toput_char(finf,'\n');
			setbuf_absolute(finf);
		}
		if(dec-2>0) finf->prec.absol=dec-2;
		else finf->prec.absol=0;
		towrite8(finf,'s',TEXTOS[117], 'f',sis->sis.ond, ' ','w',unit, '\n',0);
		finf->prec.absol=7;
		towrite8(finf,'s',"         k= ", 'f',sis->sis.k0, '\n',0);
	}else{
		{uint i=0; if(sis->sis.proy<=SIS_Mercator_Transversa) i=116+sis->sis.proy;
		elif(sis->sis.proy==SIS_Geograficas) i=122;
		if(i!=0) towrite8_string(finf,TEXTOS[i]);}
		towrite8_string(finf,"\n\n");

		towrite8_string(finf,TEXTOS[123]);
		escribe_elip(finf,sis->infor.elip); toput_char(finf,'\n');
		finf->prec.absol=0;
		if(sis->sis.e==0){
			towrite8(finf,'s',"          R= ", 'f',sis->sis.a, ' ','w',unit, '\n',0);
		}else{
			towrite8(finf,'s',"          a= ", 'f',sis->sis.a, ' ','w',unit, '\n',0);
			finf->prec.absol=9;
			towrite8(finf,'s',"        e^2= ", 'f',sis->sis.e, '\n',0);
		}
		if(dec-2>0) finf->prec.absol=dec-2;
		else finf->prec.absol=0;
		towrite8(finf,'s',TEXTOS[117], 'f',sis->sis.ond, ' ','w',unit, '\n',0);
		toput_char(finf,'\n');

		if(sis->sis.proy==SIS_Geograficas) goto fin_sistema;

		finf->prec.absol=6;
		if(sis->sis.proy==SIS_Lambert){	//Lambert
			towrite8_string(finf,TEXTOS[125]); fGradoSexU8(finf,sis->sis.param1.φ0); toput_char(finf,'\n');
		}
		towrite8(finf,'s',TEXTOS[126], 'f',sis->sis.k0, '\n',0);
		finf->prec.absol=dec;
		if(sis->sis.proy!=SIS_Mercator){	//Mercator
			towrite8(finf,'s',TEXTOS[127], 'f',sis->sis.xO, ' ','w',unit, '\n',0);
		}
		towrite8(finf,'s',TEXTOS[128], 'f',sis->sis.yS, ' ','w',unit, '\n',0);
	}
fin_sistema:
	towrite8_string(finf,"\n\n\n");
}

void escribe_elip(Bufferto8 *finf, const char8_t* elip){
	const char8_t *s;
	if(elip==NULL) s=TEXTOS[83];
	else s=elip;
	towrite8_string(finf,s);
}

void escribe_estadisticas(Bufferto8 *finf, n_enes c,uint ntot, n_enes o){
	bint a=0;
	towrite8_string(finf,TEXTOS[0]); towrite8_aligned_uint(finf,c.nf,5);		toput_char(finf,'\n');
	towrite8_string(finf,TEXTOS[1]); towrite8_aligned_uint(finf,c.npm,5);	toput_char(finf,'\n');
	if(o.npy!=0){
		towrite8_string(finf,TEXTOS[2]); towrite8_aligned_uint(finf,c.npy,5);	toput_char(finf,'\n');
	}
	towrite8_string(finf,TEXTOS[3]); towrite8_aligned_uint(finf,ntot,5);		toput_char(finf,'\n');
	if(o.ngps!=0){
		towrite8_string(finf,TEXTOS[4]); towrite8_aligned_uint(finf,c.ngruposgps,5);toput_char(finf,'\n');
		towrite8_string(finf,TEXTOS[5]); towrite8_aligned_uint(finf,c.ngps,5);		toput_char(finf,'\n');
	}
	if(o.nins!=0){
		towrite8_string(finf,TEXTOS[6]); towrite8_aligned_uint(finf,c.ngruposins,5);	toput_char(finf,'\n');
		towrite8_string(finf,TEXTOS[7]); towrite8_aligned_uint(finf,c.nins,5);			toput_char(finf,'\n');
	}
	toput_char(finf,'\n');
	if(c.nf!=o.nf){ a=1;
		towrite8_string(finf,TEXTOS[8]); towrite8_aligned_uint(finf,o.nf-c.nf,4); toput_char(finf,'\n');
	}
	if(c.npm!=o.npm){ a=1;
		towrite8_string(finf,TEXTOS[9]); towrite8_aligned_uint(finf,o.npm-c.npm,4); toput_char(finf,'\n');
	}
	if(c.npy!=o.npy){ a=1;
		towrite8_string(finf,TEXTOS[10]); towrite8_aligned_uint(finf,o.npy-c.npy,4); toput_char(finf,'\n');
	}
	if(c.ngruposgps!=o.ngruposgps){ a=1;
		towrite8_string(finf,TEXTOS[11]); towrite8_aligned_uint(finf,o.ngruposgps-c.ngruposgps,4); toput_char(finf,'\n');
	}
	if(c.ngps!=o.ngps){ a=1;
		towrite8_string(finf,TEXTOS[12]); towrite8_aligned_uint(finf,o.ngps-c.ngps,4); toput_char(finf,'\n');
	}
	if(c.ngruposins!=o.ngruposins){ a=1;
		towrite8_string(finf,TEXTOS[13]); towrite8_aligned_uint(finf,o.ngruposins-c.ngruposins,4); toput_char(finf,'\n');
	}
	if(c.nins!=o.nins){ a=1;
		towrite8_string(finf,TEXTOS[14]); towrite8_aligned_uint(finf,o.nins-c.nins,4); toput_char(finf,'\n');
	}
	if(a) toput_char(finf,'\n');
}
void escribe_apariciones(Bufferto8 *finf, uint* pm_ppios, uint npm){
	uint apariciones[21];
	uint k,kb;

	zeroset_uint(apariciones,21);
	{uint ll=0;
	Durchlaufei(uint,pm_ppios+1,npm){
		uint l=ll;
		ll=*ptri++;
		l=ll-l-1;
		if(l>20) l=20;
		apariciones[l]++;
	}}
	for(k=20;!apariciones[k];k--);
	kb=++k;
	if(kb==21) kb=20;

	towrite8_string(finf,TEXTOS[17]);
	towrite8_string(finf,TEXTOS[18]);
	towrite8_aligned_uint(finf,apariciones[1],4); toput_char(finf,'\n');
	for(uint i=2;i<kb;i++){
		towrite8_string(finf,"                     ");
		towrite8_aligned_uint(finf,i,2);
		towrite8_string(finf,TEXTOS[19]);
		towrite8_aligned_uint(finf,apariciones[i],4); toput_char(finf,'\n');
	}
	if(k==21){
		towrite8_string(finf,TEXTOS[20]);
		towrite8_aligned_uint(finf,apariciones[20],4); toput_char(finf,'\n');
	}
}

void escribe_avisos(Bufferto8 *finf, Avisos avisos){
	toput_char(finf,'\n');
	if(avisos.interna_novalida){
		if(avisos.interna_novalida==1){
			towrite8_many_strings(finf,"\n    ",TEXTOS[24],"    ",TEXTOS[25],NULL);
		}else{
			towrite8_string(finf,"\n    "); towrite8_string(finf,TEXTOS[26]); toput_char(finf,'\n');
			if(avisos.interna_novalida&2){towrite8_string(finf,"    "); towrite8_string(finf,TEXTOS[27]); toput_char(finf,'\n');}
			if(avisos.interna_novalida&4){towrite8_string(finf,"    "); towrite8_string(finf,TEXTOS[28]); toput_char(finf,'\n');}
			towrite8_string(finf,TEXTOS[29]);
		}
	}
	if(avisos.maxiter){
		toput_char(finf,'\n');
		towrite8_many_strings(finf,TEXTOS[30],TEXTOS[31],TEXTOS[30],NULL);
	}
}

//default for decs: gps:2, ins:-127 (guess)
void escribe_res_gps(Bufferto8 *finf, bint html, GrupoGPSINS* grupos, uint ngrupos, uint* grupocalc_a_orig, uint* grupos_acum, PuntoGPSINS* gpss, float* Lgps,float* Lgps_norm, float* Lins,float* Lins_norm, float fccpi, bint asteriscos, float* limites, u8int nasterisco, s8int decgps, s8int decins){
	if(decins==-127){
		if(fccpi>50) decins=-4;
		elif(fccpi>5) decins=-5;
		else decins=-6;
	}

	if(html){
		html_H(finf,2,TEXTOS[39],"Res.GPS/INS");
		towrite8_string(finf,"\t<pre>");
	}else{
		towrite8_string(finf,TEXTOS[40]);
	}
	uint k2,ll;
	k2=0;
	ll=0;
	for(uint i=0;i<ngrupos;i++){
		bint b0g,b0i;
		uint l=ll;
		ll=grupos_acum[i];
		b0g=grupos[i].bg;
		b0i=grupos[i].bi;
		if(!b0g && !b0i) continue;
		towrite8(finf,'s',TEXTOS[41], 'u',grupocalc_a_orig[i]+1, 's',"  -",0);
		if(b0g) towrite8_string(finf,"gps");
		if(b0i) towrite8_string(finf,"ins");
		toput_char(finf,'\n');
		toput_char(finf,'\n');
		for(uint j=l,k1=3*j;j<ll;j++,k1+=3){
			towrite8_string(finf,"    ");
			towrite8_aligned_string(finf,gpss[j].nom,9); toput_char(finf,' ');
			if(b0g){
				if(!gpss[j].bg){
					towrite8_string(finf,"     --         --         --   ");
				}else{
					if(decgps<=0) setbuf_absolutep(finf,-decgps);
					else setbuf_relativep(finf,(u8int)decgps);
					towrite8_aligned_float(finf,Lgps[k1],10); toput_char(finf,' ');
					towrite8_aligned_float(finf,Lgps[k1+1],10); toput_char(finf,' ');
					towrite8_aligned_float(finf,Lgps[k1+2],10);
				}
			}
			if(b0i){
				if(!gpss[j].bi){
					towrite8_string(finf,"     --         --         --   ");
				}else{
					if(decins<=0) setbuf_absolutep(finf,-decins);
					else setbuf_relativep(finf,(u8int)decins);
					towrite8_aligned_float(finf,fccpi*Lins[k2],10); toput_char(finf,' ');
					towrite8_aligned_float(finf,fccpi*Lins[k2+1],10); toput_char(finf,' ');
					towrite8_aligned_float(finf,fccpi*Lins[k2+2],10);
				}
			}
			if(asteriscos){
				if(b0g){
					if(!gpss[j].bg){
						towrite8_string(finf,"   .   .   .");
					}else{
						u8int n;
						towrite8_string(finf,"  ");
						n=numero(Lgps_norm[k1],limites);
						if(n==0) towrite8_string(finf," .");
						elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
						else towrite8_string(finf," *");
						//
						towrite8_string(finf,"  ");
						n=numero(Lgps_norm[k1+1],limites);
						if(n==0) towrite8_string(finf," .");
						elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
						else towrite8_string(finf," *");
						//
						towrite8_string(finf,"  ");
						n=numero(Lgps_norm[k1+2],limites);
						if(n==0) towrite8_string(finf," .");
						elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
						else towrite8_string(finf," *");
					}
				}
				if(b0i){
					if(b0g) towrite8_string(finf,"    ");
					if(!gpss[j].bi){
						towrite8_string(finf,"   .   .   .");
					}else{
						u8int n;
						towrite8_string(finf,"  ");
						n=numero(Lins_norm[k2],limites);
						if(n==0) towrite8_string(finf," .");
						elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
						else towrite8_string(finf," *");
						//
						towrite8_string(finf,"  ");
						n=numero(Lins_norm[k2+1],limites);
						if(n==0) towrite8_string(finf," .");
						elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
						else towrite8_string(finf," *");
						//
						towrite8_string(finf,"  ");
						n=numero(Lins_norm[k2+2],limites);
						if(n==0) towrite8_string(finf," .");
						elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
						else towrite8_string(finf," *");
					}
				}
			}
			toput_char(finf,'\n');
			if(b0i)k2+=3;
		}
	}
	if(html) towrite8_string(finf,"</pre>\n");
}

//imu:  0:ins, 1:imu_x,  2:imu_y
void escribe_par_centros_ajbloque(Bufferto8 *finf, bint html, const char8_t *margen, CentroProy* centros, CentroProy* centros_interp, uint ncp, uint* orden_cp, u8int imu, float* Hmedias, float tamaño_pixel, s8int dec,s8int decz, double ccpi, s8int decg, s8int marca, bint avisa, bint codigo){
	if(imu && ccpi<0) ccpi=-ccpi;
	if(html){	//Sólo se usa con imu=0
		html_H(finf,2,TEXTOS[49],"Par.Centros de proyección");
		towrite8_many_strings(finf,"\t<pre>\n",margen,"                  X             Y              Z           &Omega;           &Phi;           K",NULL);
		if(Hmedias!=NULL) towrite8_string(finf,TEXTOS[250]);
		toput_char(finf,'\n'); toput_char(finf,'\n');
	}elif(codigo){
		towrite8_string(finf,margen); towrite8_string(finf,"-ccpp\n");
	}
	setbuf_absolute(finf);
	for(uint ib=0;ib<ncp;ib++){
		uint i;
		CentroProy* puncp;
		PuntoXYZ_double P;
		Giro3D_double G;
		char8_t *s;

		if(orden_cp!=NULL) i=orden_cp[ib];
		else i=ib;
		if(ispos(i)){
			puncp=centros+i;
			if(!puncp->b) continue;
			s=puncp->fot->nom;
		}else{
			puncp=centros_interp+~i;
			s=puncp->nom;
		}
		P=puncp->P;
		if(imu==0) G=Gmatriz_ωφκ_seg(puncp->M);
		elif(imu==1) G=Gmatriz_imu_x_seg(puncp->M);
		else G=Gmatriz_imu_r_seg(puncp->M);
		towrite8_string(finf,margen); towrite8_aligned_string(finf,s,9); toput_char(finf,' ');
		finf->prec.absol=dec;
		towrite8_aligned_double(finf,P.X,13); toput_char(finf,' ');
		towrite8_aligned_double(finf,P.Y,13); toput_char(finf,' ');
		finf->prec.absol=decz;
		towrite8_aligned_double(finf,P.Z,13); toput_char(finf,' ');
		finf->prec.absol=decg;
		towrite8_aligned_double(finf,G.ω*ccpi,11); toput_char(finf,' ');
		towrite8_aligned_double(finf,G.φ*ccpi,11); toput_char(finf,' ');
		towrite8_aligned_double(finf,G.κ*ccpi,11);
		if(Hmedias!=NULL && ispos(i)){
			finf->prec.absol=decz-2;
			toput_char(finf,' ');
			towrite8_aligned_float(finf,Hmedias[i],11); toput_char(finf,' ');
			finf->prec.absol=dec;
			towrite8_aligned_float(finf,Hmedias[i]*tamaño_pixel/(float)puncp->fot->focal,9);
		}
		if(marca) towrite8_string(finf,"   1");
		if(avisa && isneg(i)){
			if(puncp->b==1) towrite8_string(finf,"   interp.");
			else towrite8_string(finf,"   extrap.");
		}
		toput_char(finf,'\n');
	}
	if(html) towrite8_string(finf,"</pre>\n");
}
void escribe_ori_ajbloque(Bufferto8 *finf, CentroProy* centros,CentroProy* centros_interp,uint ncp, uint* orden_cp, s8int dec,s8int decz,s8int decrot){
	towrite8_string(finf,TEXTOS[51]);
	setbuf_absolute(finf);
	for(uint ib=0;ib<ncp;ib++){
		uint i;
		CentroProy* puncp;
		PuntoXYZ_double P;
		double *pM;

		i=orden_cp[ib];
		if(ispos(i)){
			puncp=centros+i;
			if(!puncp->b) continue;
			towrite8(finf,'s',"\n    ", 's',puncp->fot->nom, '\n',0);
		}else{
			puncp=centros_interp+~i;
			towrite8(finf,'s',"\n    ", 's',puncp->nom, 's','\n',0);
		}
		P=puncp->P;
		finf->prec.absol=dec;
		towrite8_string(finf,"       ");
		towrite8_aligned_double(finf,P.X,13); toput_char(finf,' ');
		towrite8_aligned_double(finf,P.Y,13); toput_char(finf,' ');
		finf->prec.absol=decz;
		towrite8_aligned_double(finf,P.Z,9); toput_char(finf,'\n');
		toput_char(finf,'\n');
		pM=puncp->M[0];
		finf->prec.absol=decrot;
		for(u8int j=0;j<3;j++){
			towrite8_string(finf,"          ");
			towrite8_aligned_double(finf,*pM++,10); toput_char(finf,' ');
			towrite8_aligned_double(finf,*pM++,10); toput_char(finf,' ');
			towrite8_aligned_double(finf,*pM++,10); toput_char(finf,'\n');
		}
	}
}
//imu:  0:ins, 1:imu_x,  2:imu_y
void escribe_ori_oe_ajbloque(Bufferto8 *fajs, CentroProy* centros,CentroProy* centros_interp,uint ncp,uint* orden_cp, u8int imu, s8int dec,s8int decz, double ccpi, s8int decg){
	if(imu==0) ccpi=-ccpi;
	escribe_par_centros_ajbloque(fajs,false,"    ",centros,centros_interp,ncp,orden_cp,imu,NULL,1.0F,dec,decz,ccpi,decg,0,0,0);
}
void escribe_par_puntos_ajbloque(Bufferto8 *finf, bint html, PuntoM* puntosM,uint npm,uint* orden_pm, s8int dec,s8int decz, bint marca, bint avisa, uint* pm_ppios, uint* pM_a_pA, PuntoM* puntosA, bint codigo){
	if(html){
		html_H(finf,2,TEXTOS[50],"Par.Puntos");
		towrite8_string(finf,"\t<pre>\n"
			"                      X             Y              Z\n\n");
	}elif(codigo){
		towrite8_string(finf,"    -pp\n");
	}

	setbuf_absolutep(finf,dec);
	for(uint ib=0;ib<npm;ib++){
		uint i;
		PuntoM* punpm;
		uint j,l,naux;

		if(orden_pm!=NULL) i=orden_pm[ib];
		else i=ib;
		if(!puntosM[i].bbb) continue;
		punpm=puntosM+i;
		towrite8_string(finf,"    ");
		towrite8_aligned_string(finf,punpm->nom,9); toput_char(finf,' ');
		towrite8_aligned_double(finf,punpm->P.X,13); toput_char(finf,' ');
		towrite8_aligned_double(finf,punpm->P.Y,13); toput_char(finf,' ');
		finf->prec.absol=decz;
		towrite8_aligned_double(finf,punpm->P.Z,13);
		finf->prec.absol=dec;
		if(marca) towrite8_string(finf,"   1");
		if(avisa){
			j=pM_a_pA[i];
			l=0;
			if(j!=Я) l=puntosA[j].bbb;
			char8_t s[7]="      ";
			if(l){
				if(l&1) s[3]='X';
				if(l&2) s[4]='Y';
				if(l&4) s[5]='Z';
			}
			towrite8_string(finf,s);
			naux=pm_ppios[i+1]-pm_ppios[i]-1;
			if(naux==2 && (l<3 || l==4)) towrite8_string(finf,"  !");
			elif(naux==1) towrite8_string(finf,"  !!");
		}
		toput_char(finf,'\n');
	}
	if(html) towrite8_string(finf,"</pre>\n");
}
void escribe_par_grupos(Bufferto8 *finf, GrupoGPSINS* grupos, uint ngrupos, uint* grupocalc_a_orig, uint* grupos_acum, PuntoGPSINS* gpss, s8int dec, double ccpi){
	uint i,ll;
	GrupoGPSINS* pungrupo;
	PuntoXYZ_double P;
	float t;
	s8int d;
	if(ccpi>50) d=4;
	elif(ccpi>5) d=5;
	else d=6;
	float fccpi=(float)ccpi;

	for(i=0;i<ngrupos;i++){
		if(grupos[i].bg!=0 && grupos[i].tipoGPS>1) break;
		if(grupos[i].bi!=0 && grupos[i].tipoINS>1) break;
	}

	towrite8_string(finf,TEXTOS[52]);
	if(i!=ngrupos) towrite8_string(finf,TEXTOS[53]);

	setbuf_absolute(finf);
	pungrupo=grupos;
	ll=0;
	for(i=0;i<ngrupos;i++,pungrupo++){
		uint l=ll;
		uint j,k;
		ll=grupos_acum[i];
		if(!pungrupo->bg && !pungrupo->bi) continue;
		towrite8(finf,'s',TEXTOS[54], 'u',grupocalc_a_orig[i]+1, 's',"  (", 's',gpss[l].nom, '-', 's',gpss[ll-1].nom, 's',")\n\n", 0);

		if(pungrupo->bg){
			finf->prec.absol=dec;
			P=pungrupo->offset;
			towrite8_string(finf,TEXTOS[55]);
			towrite8_aligned_double(finf,P.X,11); toput_char(finf,' ');
			towrite8_aligned_double(finf,P.Y,11); toput_char(finf,' ');
			towrite8_aligned_double(finf,P.Z,11); toput_char(finf,'\n');

			if(pungrupo->tipoGPS<1) goto fingps;
			P=pungrupo->despl;
			if(pungrupo->tipoGPS<2) towrite8_string(finf,TEXTOS[56]);
			else towrite8_string(finf,TEXTOS[57]);
			towrite8_aligned_double(finf,P.X,11); toput_char(finf,' ');
			towrite8_aligned_double(finf,P.Y,11); toput_char(finf,' ');
			towrite8_aligned_double(finf,P.Z,11); toput_char(finf,'\n');

			if(pungrupo->tipoGPS<2) goto fingps;
			P=pungrupo->deriva;
			if(pungrupo->param==0){
				towrite8_string(finf,TEXTOS[58]);
				finf->prec.absol=dec+2;
				towrite8_aligned_double(finf,P.X,11); toput_char(finf,' ');
				towrite8_aligned_double(finf,P.Y,11); toput_char(finf,' ');
				towrite8_aligned_double(finf,P.Z,11);
			}else{
				towrite8_string(finf,TEXTOS[59]);
				finf->prec.absol=1;
				towrite8_aligned_double(finf,P.X*1E6,11); toput_char(finf,' ');
				towrite8_aligned_double(finf,P.Y*1E6,11); toput_char(finf,' ');
				towrite8_aligned_double(finf,P.Z*1E6,11);
			}
			towrite8_string(finf,"      (");
			for(j=l;j<ll;j++){
				if(gpss[j].bg) break;
			}
			for(k=ll;k>l;){
				if(gpss[--k].bg) break;
			}
			t=(float)(gpss[k].t-gpss[j].t);
			finf->prec.absol=dec;
			towrite8_float(finf,t*(float)P.X); toput_char(finf,' ');
			towrite8_aligned_float(finf,t*(float)P.Y,9); toput_char(finf,' ');
			towrite8_aligned_float(finf,t*(float)P.Z,9); towrite8_string(finf,")\n");
		}
	fingps:
		if(pungrupo->bi){
			towrite8_string(finf,TEXTOS[60]);
			if(pungrupo->tipoINS<1){
				towrite8_string(finf,TEXTOS[61]);
				goto finins;
			}
			toput_char(finf,'\n');
			u8int c;
			P=Getoffset_matriz(pungrupo->desplins,&Gmatriz_ωφκ_seg,&c);

			if(pungrupo->tipoINS<2) towrite8_string(finf,TEXTOS[56]);
			else towrite8_string(finf,TEXTOS[57]);
			finf->prec.absol=d;
			towrite8_aligned_double(finf,P.ω*ccpi,11); toput_char(finf,' ');
			towrite8_aligned_double(finf,P.φ*ccpi,11); toput_char(finf,' ');
			if(c==0){
				towrite8_aligned_double(finf,P.κ*ccpi,11);
			}else{
				setbuf_limpio(finf);
				uint prev=to_writtenchars(finf);
				if(c==2){
					if(fccpi==1) towrite8_string(finf,"PI");
					else towrite8_float(finf,ccpi*PI);
				}else{
					if(c==3) toput_char(finf,'-');
					if(fccpi==1) towrite8_string(finf,"PI/2");
					else towrite8_float(finf,ccpi*PI_2);
				}
				setbuf_nolimpio(finf);
				finf->maschar='+';
				prev=to_writtenchars(finf)-prev; if(prev>11) prev=11;
				towrite8_aligned_double(finf,P.κ*ccpi,11-(u8int)prev);
				finf->maschar='\0';
			}
			toput_char(finf,'\n');

			if(pungrupo->tipoINS<2) goto finins;
			P=*(PuntoXYZ_double*)&pungrupo->derivains;
			if(pungrupo->param==0){
				towrite8_string(finf,TEXTOS[58]);
				finf->prec.absol=d+2;
				towrite8_aligned_double(finf,P.ω*ccpi,11); toput_char(finf,' ');
				towrite8_aligned_double(finf,P.φ*ccpi,11); toput_char(finf,' ');
				towrite8_aligned_double(finf,P.κ*ccpi,11);
			}else{
				towrite8_string(finf,TEXTOS[59]);
				finf->prec.absol=d-2;
				towrite8_aligned_double(finf,P.ω*ccpi*1E6,11); toput_char(finf,' ');
				towrite8_aligned_double(finf,P.φ*ccpi*1E6,11); toput_char(finf,' ');
				towrite8_aligned_double(finf,P.κ*ccpi*1E6,11);
			}
			towrite8_string(finf,"      (");
			for(j=l;j<ll;j++){
				if(gpss[j].bi) break;
			}
			for(k=ll;k>l;){
				if(gpss[--k].bi) break;
			}
			t=(float)(gpss[k].t-gpss[j].t)*fccpi;
			finf->prec.absol=d;
			towrite8_float(finf,t*(float)P.X); toput_char(finf,' ');
			towrite8_aligned_float(finf,t*(float)P.Y,9); toput_char(finf,' ');
			towrite8_aligned_float(finf,t*(float)P.Z,9); towrite8_string(finf,")\n");
		}
	finins:;
	}
}
void escribe_par_gruposajs(Bufferto8 *fo, GrupoGPSINS* grupos, uint ngrupos, uint* ng, uint* ni, uint* insiemegps, uint* insiemeins, uint* infogn, uint* infoin, uint* grupos_giro, bint* boffsetgps, uint* grupos_acum, PuntoGPSINS* gpss, s8int dec, double ccpi){
	GrupoGPSINS* pungrupo;
	s8int d;
	if(ccpi>50) d=4;
	elif(ccpi>5) d=5;
	else d=6;

	towrite8_string(fo,"    -gruposgi\n");
	pungrupo=grupos;
	for(uint i=0;i<ngrupos;i++,pungrupo++){
		if(!pungrupo->bg && !pungrupo->bi) continue;
		uint l;
		PuntoXYZ_double P;

		if(i==0) l=0;
		else l=grupos_acum[i-1];
		{uint k=strlen8(gpss[l].nom);
		if(k<10) k=15-k;
		else k=6;
		towrite8_aligned_string(fo,"    f ",(u8int)k); towrite8_string(fo,gpss[l].nom);
		}

		if(pungrupo->bg){
			uint k=insiemegps[i];
			if(ng[i]!=infogn[k]){
				towrite8_string(fo,"    grupogps ");
				towrite8_aligned_uint(fo,k,3);
			}
		}
		if(pungrupo->bi){
			uint k=insiemeins[i];
			if(ni[i]!=infoin[k]){
				towrite8_string(fo,"    grupoins ");
				towrite8_aligned_uint(fo,k,3);
			}
		}
		if((pungrupo->bg && pungrupo->tipoGPS>1) || (pungrupo->bi && pungrupo->tipoINS>1)){
			towrite8_string(fo,"    param "); towrite8_uint(fo,pungrupo->param);
			if(pungrupo->param==0) fo->prec.absol=4;
			else fo->prec.absol=dec;
			towrite8_string(fo,"    t0 "); towrite8_aligned_double(fo,pungrupo->tiempo0,13);
		}
		if(pungrupo->bg){
			fo->prec.absol=dec;
			P=pungrupo->offset;
			if(boffsetgps[i]) towrite8_string(fo,"    gpsoffsetJ ");
			else towrite8_string(fo,"    gpsoffset ");
			towrite8_aligned_double(fo,P.X,11); toput_char(fo,' ');
			towrite8_aligned_double(fo,P.Y,11); toput_char(fo,' ');
			towrite8_aligned_double(fo,P.Z,11);

			if(pungrupo->tipoGPS<1) goto fingps;
			P=pungrupo->despl;
			towrite8_string(fo,"    gpsdespl ");
			towrite8_aligned_double(fo,P.X,11); toput_char(fo,' ');
			towrite8_aligned_double(fo,P.Y,11); toput_char(fo,' ');
			towrite8_aligned_double(fo,P.Z,11);

			if(pungrupo->tipoGPS<2) goto fingps;
			P=pungrupo->deriva;
			towrite8_string(fo,"    gpsderiva ");
			if(pungrupo->param==0) fo->prec.absol=dec+2;
			else fo->prec.absol=7;
			towrite8_aligned_double(fo,P.X,11); toput_char(fo,' ');
			towrite8_aligned_double(fo,P.Y,11); toput_char(fo,' ');
			towrite8_aligned_double(fo,P.Z,11);
		}
	fingps:
		if(pungrupo->bi){
			fo->prec.absol=d;
			if(pungrupo->tipoINS==0){
				uint k,kk;
				char8_t s[5]="0000";
				towrite8_string(fo,"    situacion ");
				kk=grupos_giro[i];
				k=kk&0xFF;
				if(k==0x01) s[0]='+';	elif(k==0xFF) s[0]='-';
				k=(kk>>8)&0xFF;
				if(k==0x01) s[1]='+';	elif(k==0xFF) s[1]='-';
				k=(kk>>16)&0xFF;
				if(k==0x01) s[2]='+';	elif(k==0xFF) s[2]='-';
				k=(kk>>24)&0xFF;
				if(k==0x01) s[3]='+';	elif(k==0xFF) s[3]='-';
				towrite8_string(fo,s);
			}else{
				P=Gmatriz_ωφκ_seg(pungrupo->desplins);
				towrite8_string(fo,"    insdespl ");
				towrite8_aligned_double(fo,P.X*ccpi,11); toput_char(fo,' ');
				towrite8_aligned_double(fo,P.Y*ccpi,11); toput_char(fo,' ');
				towrite8_aligned_double(fo,P.Z*ccpi,11);
			}
			if(pungrupo->tipoINS<2) goto finins;
			P=*(PuntoXYZ_double*)&pungrupo->derivains;
			towrite8_string(fo,"    insderiva ");
			if(pungrupo->param==0) fo->prec.absol=d+2;
			else fo->prec.absol=d+3;
			towrite8_aligned_double(fo,P.X*ccpi,11); toput_char(fo,' ');
			towrite8_aligned_double(fo,P.Y*ccpi,11); toput_char(fo,' ');
			towrite8_aligned_double(fo,P.Z*ccpi,11);
		}
	finins:
		toput_char(fo,'\n');
	}
}
void escribe_precisiones_grupos(Bufferto8 *finf, GrupoGPSINS* grupos, uint ngrupos, uint* grupocalc_a_orig, uint* insiemegps, uint* insiemeins, uint* grupos_acum, PuntoGPSINS* gpss, s8int dec, double* Qgrupos1, double* Qgrupos4, double** Nins_gi, float fccpi, float vv){
	uint ll;
	GrupoGPSINS* pungrupo;
	s8int d;
	if(fccpi>50) d=4;
	elif(fccpi>5) d=5;
	else d=6;
	float vvcp=vv*fccpi;

	towrite8_string(finf,TEXTOS[63]);
	pungrupo=grupos;
	ll=0;
	for(uint i=0;i<ngrupos;i++,pungrupo++){
		uint l=ll;
		ll=grupos_acum[i];
		if(!pungrupo->bg && !pungrupo->bi) continue;
		if((!pungrupo->bg || pungrupo->tipoGPS==0) && (!pungrupo->bi || pungrupo->tipoINS==0))
				continue;
		towrite8(finf,'s',TEXTOS[54], 'u',grupocalc_a_orig[i]+1, 's',"  (", 's',gpss[l].nom, '-', 's',gpss[ll-1].nom, 's',")\n\n",0);

		if(pungrupo->bg && pungrupo->tipoGPS>0){
			uint k=3*insiemegps[i];
			PuntoXYZ_float Pf;
			towrite8_string(finf,TEXTOS[64]);
			towrite8_string(finf,TEXTOS[56]);
			setbuf_absolutep(finf,dec);
			Pf.X=vv*sqrtf((float)Qgrupos1[k]);
			Pf.Y=vv*sqrtf((float)Qgrupos1[k+1]);
			Pf.Z=vv*sqrtf((float)Qgrupos1[k+2]);
			towrite8_aligned_float(finf,Pf.X,9); toput_char(finf,' ');
			towrite8_aligned_float(finf,Pf.Y,9); toput_char(finf,' ');
			towrite8_aligned_float(finf,Pf.Z,9);

			setbuf_relative(finf);
			Pf.X/=fabsf((float)pungrupo->despl.X);
			Pf.Y/=fabsf((float)pungrupo->despl.Y);
			Pf.Z/=fabsf((float)pungrupo->despl.Z);
			towrite8_string(finf,"      (");
			if(Pf.X<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_float(finf,Pf.X); toput_char(finf,' ');
			if(Pf.Y<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_aligned_float(finf,Pf.Y,6); toput_char(finf,' ');
			if(Pf.Z<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_aligned_float(finf,Pf.Z,6); towrite8_string(finf,")\n");

			if(pungrupo->tipoGPS<2) goto fingps;
			setbuf_absolute(finf);
			Pf.X=vv*sqrtf((float)Qgrupos4[k]);
			Pf.Y=vv*sqrtf((float)Qgrupos4[k+1]);
			Pf.Z=vv*sqrtf((float)Qgrupos4[k+2]);
			if(pungrupo->param==0){
				towrite8_string(finf,TEXTOS[58]);
				finf->prec.absol=dec+2;
				towrite8_aligned_float(finf,Pf.X,9); toput_char(finf,' ');
				towrite8_aligned_float(finf,Pf.Y,9); toput_char(finf,' ');
				towrite8_aligned_float(finf,Pf.Z,9);
			}else{
				towrite8_string(finf,TEXTOS[59]);
				finf->prec.absol=1;
				towrite8_aligned_float(finf,Pf.X*1E6,9); toput_char(finf,' ');
				towrite8_aligned_float(finf,Pf.Y*1E6,9); toput_char(finf,' ');
				towrite8_aligned_float(finf,Pf.Z*1E6,9);
			}
			setbuf_relative(finf);
			Pf.X/=fabsf((float)pungrupo->deriva.X);
			Pf.Y/=fabsf((float)pungrupo->deriva.Y);
			Pf.Z/=fabsf((float)pungrupo->deriva.Z);
			towrite8_string(finf,"      (");
			if(Pf.X<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_float(finf,Pf.X); toput_char(finf,' ');
			if(Pf.Y<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_aligned_float(finf,Pf.Y,6); toput_char(finf,' ');
			if(Pf.Z<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_aligned_float(finf,Pf.Z,6); towrite8_string(finf,")\n");
		}
	fingps:
		if(pungrupo->bi && pungrupo->tipoINS>0){
			double* pN=Nins_gi[insiemeins[i]];
			uint ndiag=3*pungrupo->tipoINS+1;
			PuntoXYZ_float Pf;
			Giro3D_double G;
			towrite8_string(finf,TEXTOS[65]);
			towrite8_string(finf,TEXTOS[56]);
			setbuf_absolutep(finf,d);
			Pf.X=sqrtf((float)*pN); pN+=ndiag;
			Pf.Y=sqrtf((float)*pN); pN+=ndiag;
			Pf.Z=sqrtf((float)*pN); pN+=ndiag;
			towrite8_aligned_float(finf,vvcp*Pf.X,9); toput_char(finf,' ');
			towrite8_aligned_float(finf,vvcp*Pf.Y,9); toput_char(finf,' ');
			towrite8_aligned_float(finf,vvcp*Pf.Z,9);

			setbuf_relative(finf);
			G=Gmatriz_ωφκ_seg(pungrupo->desplins);
			G.ω=fabs(G.ω);	if(G.ω>PI_4){if(G.ω>PI3_4) G.ω-=PI;	else G.ω-=PI_2;}
			G.φ=fabs(G.φ);	if(G.φ>PI_4){if(G.φ>PI3_4) G.φ-=PI;		else G.φ-=PI_2;}
			G.κ=fabs(G.κ);	if(G.κ>PI_4){if(G.κ>PI3_4) G.κ-=PI;		else G.κ-=PI_2;}
			Pf.X*=vv/fabsf((float)G.ω);
			Pf.Y*=vv/fabsf((float)G.φ);
			Pf.Z*=vv/fabsf((float)G.κ);
			towrite8_string(finf,"      (");
			if(Pf.X<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_float(finf,Pf.X); toput_char(finf,' ');
			if(Pf.Y<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_aligned_float(finf,Pf.Y,6); toput_char(finf,' ');
			if(Pf.Z<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_aligned_float(finf,Pf.Z,6); towrite8_string(finf,")\n");

			if(pungrupo->tipoINS<2) goto finins;
			setbuf_absolute(finf);
			Pf.X=sqrtf((float)*pN); pN+=ndiag;
			Pf.Y=sqrtf((float)*pN); pN+=ndiag;
			Pf.Z=sqrtf((float)*pN); pN+=ndiag;
			if(pungrupo->param==0){
				towrite8_string(finf,TEXTOS[58]);
				finf->prec.absol=d+2;
				towrite8_aligned_float(finf,vvcp*Pf.X,9); toput_char(finf,' ');
				towrite8_aligned_float(finf,vvcp*Pf.Y,9); toput_char(finf,' ');
				towrite8_aligned_float(finf,vvcp*Pf.Z,9);
			}else{
				towrite8_string(finf,TEXTOS[59]);
				finf->prec.absol=d-2;
				towrite8_aligned_float(finf,vvcp*Pf.X*1E6,9); toput_char(finf,' ');
				towrite8_aligned_float(finf,vvcp*Pf.Y*1E6,9); toput_char(finf,' ');
				towrite8_aligned_float(finf,vvcp*Pf.Z*1E6,9);
			}
			setbuf_relative(finf);
			P_mul(Pf,vv);
			Pf.X/=fabsf((float)pungrupo->derivains.X);
			Pf.Y/=fabsf((float)pungrupo->derivains.Y);
			Pf.Z/=fabsf((float)pungrupo->derivains.Z);
			towrite8_string(finf,"      (");
			if(Pf.X<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_float(finf,Pf.X); toput_char(finf,' ');
			if(Pf.Y<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_aligned_float(finf,Pf.Y,6); toput_char(finf,' ');
			if(Pf.Z<0.1F) finf->prec.signi=1; else finf->prec.signi=2;		towrite8_aligned_float(finf,Pf.Z,6); towrite8_string(finf,")\n");
		}
		finins:;
	}
}
#define fo (&_fo)
int escribe_ori_patb_ajbloque(char16_t* ficheroori, CentroProy* centros, uint ncp, CentroProy* centros2, uint ncp2, u8int modo, s8int dec,s8int decz,s8int decrot, char16_t *mensaje, u8int idioma){
	int nret;
	Bufferto8 _fo;
	CentroProy* puncp;
	bint b;

	nret=toopen_mixed(fo,ficheroori);
	ifunlike(nret){
		char16_t* pc=strbuild16(mensaje,S_Elfichero,ficheroori,S_no_se_pudo_abrir_para_escribir,NULL);
		strcpy16(pc,TEXTOS_fileopen[nret][idioma]);
		return nret;
	}

	b=0;
	puncp=centros;
	for(uint i=0;;i++,puncp++){
		PuntoXYZ_double P;
		double (*M)[3];
		double m;
ori_patb_1:
		if(i==ncp){
			if(b) break;
			iflike(centros2==NULL) break;
			b=1;
			ncp=ncp2;
			puncp=centros2;
			i=0;
			goto ori_patb_1;
		}
		if(!b){
			if(!puncp->b) continue;
			towrite8_aligned_string(fo,puncp->fot->nom,10);
		}else{
			towrite8_aligned_string(fo,puncp->nom,10);
		}
		toput_char(fo,' ');
		P=puncp->P;
		{const char8_t *s;
		if(!modo) s="       0 "; else s="       1 ";
		towrite8_string(fo,s);}
		fo->prec.absol=dec;
		towrite8_aligned_double(fo,P.X,12); toput_char(fo,' ');
		towrite8_aligned_double(fo,P.Y,13); toput_char(fo,' ');
		fo->prec.absol=decz;
		towrite8_aligned_double(fo,P.Z,13); toput_char(fo,'\n');
		M=puncp->M;
		fo->prec.absol=decrot;
		if(!modo) m=-M[0][0];	else m=M[0][0];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[1][0];	else m=M[0][1];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=M[2][0];	else m=M[0][2];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[0][1];	else m=M[1][0];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[1][1];	else m=M[1][1];		towrite8_aligned_double(fo,m,10); toput_char(fo,'\n');
		if(!modo) m=M[2][1];		else m=M[1][2];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[0][2];	else m=M[2][0];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[1][2];	else m=M[2][1];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=M[2][2];		else m=M[2][2];	towrite8_aligned_double(fo,m,10); toput_char(fo,'\n');
	}

	toclose(fo);
	ifunlike(fo->error_code){
		strbuild16(mensaje,S_Hubo_un_error_al_escribir_el_fichero,ficheroori,S_El_fichero_generado_no_es_correcto,NULL);
	}
	return fo->error_code;
}
#undef fo

//Si no hace falta grupos_giros, los tres últimos parámetros se pasarán NULL
void calcula_res_zonas(float* L,uint ntot,int4* mafp, CentroProy* centros, Extremos2D_fl dimf, Puntoxy_float* Lzonas, uint* cp_a_gps,PuntoGPSINS* gpss,uint* grupos_giro){
	uint nx[9];
	uint ny[9];
	double divx1,divx2, divy1,divy2;

	divx2=(dimf.MX-dimf.mx)/3;
	divx1=dimf.mx+divx2;
	divx2=dimf.MX-divx2;
	divy2=(dimf.MY-dimf.my)/3;
	divy1=dimf.my+divy2;
	divy2=dimf.MY-divy2;

	zeroset_uint(nx,9);
	zeroset_uint(ny,9);
	zeroset_uint(Lzonas,uintsizeof(*Lzonas)*9);

	for(uint i=0,kk=0;i<ntot;i++){
		uint cp;
		Fotograma* punf;
		Puntof ob;
		double x,y;
		float resx, resy;
		uint k;

		cp=mafp[i].n3;
		punf=centros[cp].fot;
		ob=punf->puntos.ppio[mafp[i].n4];
		if(ob.bb!=3) continue;
		x=ob.p.x;
		y=ob.p.y;
		resx=L[kk++];
		resy=L[kk++];
		if(cp_a_gps!=NULL && (k=cp_a_gps[cp])!=Я){
		   k=grupos_giro[gpss[k].grupo];
		   if(k!=0x01000001){
			if(k==0xFF0000FF){
				x=-x; y=-y;
				resx=-resx; resy=-resy;
			}else{
				uint l=k&0xFF;
				double aux;
				float faux;
				aux=x; faux=resx;
				if(l==0){x=0; resx=0;}
				elif(l==0x01){x=aux; resx=faux;}
				else{x=-aux; resx=-faux;}
				l=k&0xFF00;
				if(l!=0){
					if(l==0x0100){x+=y; resx+=resy;}
					else{x-=y; resx-=resy;}
				}
				l=k&0xFF000000;
				if(l==0){y=0; resy=0;}
				elif(l==0xFF000000){y=-y; resy=-resy;}
				//else{y=y;}
				l=k&0xFF0000;
				if(l!=0){
					if(l==0x010000){y+=aux; resy+=faux;}
					else{y-=aux; resy-=faux;}
				}
			}}
		}

		u8int zx,zy,z;
		zy=zx=2;
		if(x<divx2){
			zx=x<divx1? 0:1;
		}
		if(y<divy2){
			zy=y<divy1? 0:1;
		}
		z=3*zy+zx;
		Lzonas[z].x+=resx;
		nx[z]++;
		Lzonas[z].y+=resy;
		ny[z]++;
	}

	for(u8int i=0;i<9;i++){
		if(nx[i]!=0) Lzonas[i].x=Lzonas[i].x/nx[i];		else NOTFINITE_f(Lzonas[i].x);
		if(ny[i]!=0) Lzonas[i].y=Lzonas[i].y/ny[i];		else NOTFINITE_f(Lzonas[i].y);
	}
}

void escribe_fijo_std(Bufferto8 *fstd, bint hayapoyo, bint haygps, bint hayins, Precisiones apriori, Precisiones apost,
						  s8int uni,float fccpi, const char16_t* uniim,const char16_t* unit, const char8_t* cg,const char8_t* unig){
	void (*fequiv)(Bufferto8*,double,char16_t,char16_t);
	if(uni==2) fequiv=fGradoSex;
	else fequiv=NULL;

	setbuf_relativep(fstd,3);
	setbuf_limpio(fstd);
	towrite8(fstd,'s',TEXTOS[129], 's',TEXTOS[43], 'f',fabsf(apriori.im),' ', 'w',uniim, '\n',0);
	if(hayapoyo){
		towrite8(fstd,'s',TEXTOS[44], 'f',fabsf(apriori.pXY), ' ', 'w',unit,'\n', 's',TEXTOS[45], 'f',fabsf(apriori.pZ), 'w',unit, '\n',0);
	}
	if(haygps){
		towrite8(fstd,'s',TEXTOS[46], 'f',fabsf(apriori.gpsXY),' ', 'w',unit,'\n', 's',TEXTOS[45], 'f',fabsf(apriori.gpsZ),' ', 'w',unit, '\n',0);
	}
	if(hayins){
		towrite8_string(fstd,TEXTOS[47]);
		fPrecGiro(fstd,fabsf(apriori.insΩΦ)*fccpi,cg,unig,fequiv);
		towrite8_string(fstd,"\n                           K: ");
		fPrecGiro(fstd,fabsf(apriori.insK)*fccpi,cg,unig,fequiv);
		toput_char(fstd,'\n');
	}
	setbuf_nolimpio(fstd);
	fstd->prec.signi=2;
	towrite8(fstd,'s',TEXTOS[42], 's',TEXTOS[43], 'f',apost.im,' ', 'w',uniim, 's'," (", 'f',apost.im/fabsf(apriori.im), 's',")\n",0);
	if(hayapoyo){
		towrite8(fstd,'s',TEXTOS[44], 'f',apost.pXY,' ', 'w',unit, 's'," (", 'f',apost.pXY/fabsf(apriori.pXY),'s',")\n", 's',TEXTOS[45], 'f',apost.pZ,' ', 'w',unit, '\n',0);
	}
	if(haygps){
		towrite8(fstd,'s',TEXTOS[46], 'f',apost.gpsXY,' ', 'w',unit, 's'," (", 'f',apost.gpsXY/fabsf(apriori.gpsXY),'s',")\n", 's',TEXTOS[45], 'f',apost.gpsZ,' ', 'w',unit, '\n',0);
	}
	if(hayins){
		towrite8_string(fstd,TEXTOS[47]);
		fPrecGiro(fstd,apost.insΩΦ*fccpi,cg,unig,fequiv);
		towrite8(fstd,'s'," (", 'f',apost.insΩΦ/fabsf(apriori.insΩΦ),')',0);
		towrite8_string(fstd,"\n                           K: ");
		fPrecGiro(fstd,apost.insK*fccpi,cg,unig,fequiv);
		toput_char(fstd,'\n');
	}
}
void escribe_posibles_puntos_malos(Bufferto8 *finf,u8int* pAmalos, uint npy,PuntoM* puntosA){
	uint i,k;
	k=0;
	for(i=0;i<npy;i++){
		if(pAmalos[i]>10){
			if(!k){k=1; towrite8_string(finf,TEXTOS[33]);}
			towrite8(finf,'s',"        ", 's',puntosA[i].nom, '\n', 0);
	}	 }
	if(!k){
		for(i=0;i<npy;i++){
			if(pAmalos[i]>7){
				if(!k){k=1; towrite8_string(finf,TEXTOS[34]);}
				towrite8(finf,'s',"        ", 's',puntosA[i].nom, '\n', 0);
		}	 }
	}
	if(!k){
		for(i=0;i<npy;i++){
			if(pAmalos[i]>4){
				if(!k){k=1; towrite8_string(finf,TEXTOS[35]);}
				towrite8(finf,'s',"        ", 's',puntosA[i].nom, '\n', 0);
		}	 }
	}
	if(!k) towrite8_string(finf,TEXTOS[36]);
}
