﻿#include <ATcrt/ATchar816.h>
#include "grafico_gen.h"
#include "f-fotograma.h"
#define pbyte pufd.pint8
#define pint16 pufd.pint16
#define pint pufd.pint32
#define pdbl pufd.pdbl2
#define psingle pufd.pfloat1
#define TAMAÑOFOT 31
#define TAMAÑORESIDUO 9

Puntoxy_float calc_distorsion_gra(float sx,float sy,Distorsion *dist){
	u8int modelo=dist->config.modelo_poli;
	float r2,dr,dt;
	Puntoxy_float dp;
	r2=sx*sx+sy*sy;
	dp.y=dp.x=0;
	dr=dt=0;
	if(dist->valores_radsim!=NULL) dr=Simetrica_r(modelo,dist->config.param_radsim,dist->valores_radsim,r2);
	if(dist->valores_tansim!=NULL) dt=Simetrica_r(modelo,dist->config.param_tansim,dist->valores_tansim,r2);
	if(dist->config.modelo_asim==0){
		dp.x=dr*sx-dt*sy;
		dp.y=dr*sy+dt*sx;
	}elif(dist->config.modelo_asim==1){
		if(dist->valores_asim1!=NULL) dr+=Asim_radtan_entre_r(modelo,dist->config.param_asim1,dist->valores_asim1,sx,sy);
		if(dist->valores_asim2!=NULL) dt+=Asim_radtan_entre_r(modelo,dist->config.param_asim2,dist->valores_asim2,sx,sy);
		dp.x=dr*sx-dt*sy;
		dp.y=dr*sy+dt*sx;
	}elif(dist->config.modelo_asim==2){
		dp.x=dr*sx-dt*sy;
		dp.y=dr*sy+dt*sx;
		if(dist->valores_asim1!=NULL){
			Puntoxy_float dp2=Asim_uvmenos(modelo,dist->config.param_asim1,dist->valores_asim1,sx,sy);
			dp.x+=dp2.x;
			dp.y+=dp2.y;
		}
		if(dist->valores_asim2!=NULL){
			Puntoxy_float dp2=Asim_uvmas(modelo,dist->config.param_asim2,dist->valores_asim2,sx,sy);
			dp.x+=dp2.x;
			dp.y+=dp2.y;
		}
	}
	return dp;
}

//c ya incluye el +1 del fin de cadena
#define Nombre(nombre,c) \
	if(c==1) set_byte0(pint,0); else set_byte0(pint,(umint)((c>>2)+1));\
	set_byte1(pint,0);  /*byte libre*/ \
	set_bytes23(pint,0);	pint++; /*codif.*/ \
	*(pint+(c>>2))=0;\
	uint_strpcpy_char(pint,nombre);\
	pint+=(c>>2)+1;

int escribe_grafico_calibracion(char16_t* ficherogra, char8_t* fotograma, s8int dec, float f,Extremos2D_fl S, CalibracionConfigGrafico cgra,Distorsion *dist,
										int2* fm,uint ntot,Puntof* puntosf,char8_t* nombres, float* L){
	GragenFconfig gconfigs[3];
	GragenPoligono gfoto[2];
	PuntoXYZ_double borde[4];
	GragenVector *vectores;
	GragenPoligonal_Escalable *lineas;
	PuntoXYZ_double* malla_puntos;
	PuntoXYZ_float* malla_distorsion;
	int nret=0;

	float _semi,minsx,minsy;
	if(cgra.nx<2) cgra.nx=2;
	if(cgra.ny<2) cgra.ny=2;
	if(cgra.rednx<2 || cgra.redny<2) cgra.rednx=cgra.redny=0;
	else{
		if(cgra.npy<2) cgra.npy=2;
		if(cgra.npx<2) cgra.npx=2;
	}
	aj_malloc_return(vectores,GragenVector,ntot+cgra.nx*cgra.ny+1);
	checked_malloc_n(lineas,GragenPoligonal_Escalable,cgra.rednx+cgra.redny+1, nret=AT_NOMEM; goto bad_lineas);
	checked_malloc_n(malla_puntos,PuntoXYZ_double,cgra.rednx*cgra.npy+cgra.redny*cgra.npx, nret=AT_NOMEM; goto bad_pmalla);
	checked_malloc_n(malla_distorsion,PuntoXYZ_float,cgra.rednx*cgra.npy+cgra.redny*cgra.npx, nret=AT_NOMEM; goto bad_pdist);

	_semi=1.F/dist->config.semidiag;
	minsx=S.mx*_semi;
	minsy=S.my*_semi;

	borde[3].X=borde[0].X=S.mx;
	borde[2].X=borde[1].X=S.MX;
	borde[1].Y=borde[0].Y=S.my;
	borde[3].Y=borde[2].Y=S.MY;
	borde[3].Z=borde[2].Z=borde[1].Z=borde[0].Z=0;

	gfoto[0].Clase=CGRA_Poligono;
	gfoto[0].Tipo=MASK_TIPO(0);
	gfoto[0].nombre=fotograma;
	gfoto[0].npuntos=4;
	gfoto[0].centro=(PuntoXYZ_double){0,0,f};
	gfoto[0].borde=&borde[0];
	*(GragenGenerico*)&gfoto[1]=GRAGEN_EMPTY;

	GragenVector *ptrv=vectores;
	//Distorsiones
	{float pasox,pasoy,pasosx,pasosy;
	 pasox=(S.MX-S.mx)/(cgra.nx-1);	 pasosx=pasox*_semi;
	 pasoy=(S.MY-S.my)/(cgra.ny-1);	 pasosy=pasoy*_semi;
	 float x=S.mx, sx=minsx;
	 dontimes(cgra.nx,(x+=pasox,sx+=pasosx)){
		float y=S.my, sy=minsy;
		dontimes(cgra.ny,(y+=pasoy,sy+=pasosy,ptrv++)){
			Puntoxy_float dp=calc_distorsion_gra(sx,sy,dist);
			ptrv->Tipo=MASK_TIPO(2);
			ptrv->nombre=NULL;
			ptrv->Clase=CGRA_Vector;
			ptrv->P=(PuntoXYZ_double){x,y,0};
			ptrv->dP=(PuntoXYZ_float){dp.x,dp.y,0};
	 }	}
	}
	//Residuos
	{int2 *pfm=fm;
	float *iL=L;
	dontimes(ntot,ptrv++){
		Puntof* punpf;
		Puntoxy_float q;
		punpf=puntosf+pfm++->n1;
		q.x=*iL++;	q.y=*iL++;

		ptrv->Tipo=MASK_TIPO(1);
		ptrv->nombre=nombres+punpf->index;
		ptrv->Clase=CGRA_Vector;
		ptrv->P=(PuntoXYZ_double){punpf->p.x-q.x,punpf->p.y-q.y,0}; //Punto ajustado
		ptrv->dP=(PuntoXYZ_float){q.x,q.y,0};
	}}
	*(GragenGenerico*)ptrv=GRAGEN_EMPTY;

	//Red de distorsión
	GragenPoligonal_Escalable *plinea=lineas;
	PuntoXYZ_double *pmalla=malla_puntos;
	PuntoXYZ_float *pdist=malla_distorsion;
	if(cgra.rednx!=0){
		float pasox,pasoy,pasosx,pasosy;

		pasox=(S.MX-S.mx)/(cgra.rednx-1);	pasosx=pasox*_semi;
		pasoy=(S.MY-S.my)/(cgra.npy-1);		pasosy=pasoy*_semi;
		float x=S.mx, sx=minsx;
		dontimes(cgra.rednx,(x+=pasox,sx+=pasosx,plinea++)){
			plinea->Clase=CGRA_Poligonal_escalable;
			plinea->Tipo=MASK_TIPO(3);
			plinea->nombre=NULL;
			plinea->npuntos=cgra.npy;
			plinea->Ps=pmalla;
			plinea->dPs=pdist;

			float y=S.my, sy=minsy;
			dontimes(cgra.npy,(y+=pasoy,sy+=pasosy, pmalla++,pdist++)){
				*pmalla=(PuntoXYZ_double){x,y,0};
				Puntoxy_float q=calc_distorsion_gra(sx,sy,dist);
				*pdist=(PuntoXYZ_float){q.x,q.y,0};
			}
		}
	}
	if(cgra.redny!=0){
		float pasox,pasoy,pasosx,pasosy;

		pasoy=(S.MY-S.my)/(cgra.redny-1);	pasosy=pasoy*_semi;
		pasox=(S.MX-S.mx)/(cgra.npx-1);		pasosx=pasox*_semi;
		float y=S.my, sy=minsy;
		dontimes(cgra.redny,(y+=pasoy,sy+=pasosy,plinea++)){
			plinea->Clase=CGRA_Poligonal_escalable;
			plinea->Tipo=MASK_TIPO(3);
			plinea->nombre=NULL;
			plinea->npuntos=cgra.npx;
			plinea->Ps=pmalla;
			plinea->dPs=pdist;

			float x=S.mx, sx=minsx;
			dontimes(cgra.npx,(x+=pasox,sx+=pasosx, pmalla++,pdist++)){
				*pmalla=(PuntoXYZ_double){x,y,0};
				Puntoxy_float q=calc_distorsion_gra(sx,sy,dist);
				*pdist=(PuntoXYZ_float){q.x,q.y,0};
			}
		}
	}
	*(GragenGenerico*)plinea=GRAGEN_EMPTY;

	gconfigs[0].nombre=u"Fondo claro";
	gconfigs[0].fichero=cgra_fotograma_claro;
	gconfigs[1].nombre=u"Fondo negro";
	gconfigs[1].fichero=cgra_fotograma_negro;
	gconfigs[2].nombre=NULL;
	gconfigs[2].fichero=NULL;
	if(dec<0) dec=0;
	Crea_fdibujo(ficherogra,dec,NULL,gconfigs,(GragenGenerico*)gfoto,(GragenGenerico*)vectores,(GragenGenerico*)lineas,NULL,NULL);

	free(malla_distorsion);	bad_pdist:
	free(malla_puntos);		bad_pmalla:
	free(lineas);					bad_lineas:
	free(vectores);
	return nret;
}

#undef pbyte
#undef pint16
#undef pint
#undef pdbl
#undef psingle
