﻿#define finf (&_finf)
#define devuelve_info_PARS GraficoenMemoria *pfichero, GraElementoGenerico *pelem,InformaciondeElemento *infor,u8int _idioma, s8int dec,s8int decX,s8int decY
void devuelveinfo_minima_nueva(devuelve_info_PARS,LinkedSignificados *lS){
	uint *texto;
	infor->Tipo=pelem->H.Tipo;
	//memcpy_double(infor->extremos,&pelem->H.bound,6);
	texto=get_texto(pfichero,pelem->H.nombre);
	if(texto==NULL) infor->nombre=NULL;
	else{
		u16int t=get_tamañotexto(texto);
		if(t==0) t=1;
		infor->nombre=(char8_t*)malloc(t*usizeof(uint));
		if(infor->nombre!=NULL) memcpy_uint(infor->nombre,texto+1,t);
	}
	infor->nombre_tipo=NULL;
	infor->nombre_subtipo=NULL;
	if(lS!=NULL){
		if(lS->S.Significado!=NULL) infor->nombre_tipo=lS->S.Significado;	//nombre_tipo no se libera
		else infor->nombre_tipo=lS->S.SignificadoR;
		if(lS->S.SignificadoR!=NULL || lS->next!=NULL){
			uint k=0;
			LinkedSignificados *ptr=lS;
			while(ptr->next!=NULL){
				ptr=ptr->next;
				if(ptr->S.Significado!=NULL) k+=strlen16(ptr->S.Significado)+2;
			}
			if(ptr->S.SignificadoR!=NULL) k+=strlen16(ptr->S.SignificadoR);
			//else k-=2;	2 extras para que sea más fácil copiar
			k++;

			infor->nombre_subtipo=(const char16_t*)malloc(k*usizeof(char16_t));
			char16_t* psig=(char16_t*)infor->nombre_subtipo;
			ptr=lS;
			while(ptr->next!=NULL){
				ptr=ptr->next;
				if(ptr->S.Significado!=NULL){psig=strpcpy16(psig,ptr->S.Significado); *psig++=u';'; *psig++=u' ';}
			}
			if(ptr->S.SignificadoR!=NULL) psig=strpcpy16(psig,ptr->S.SignificadoR);
			else psig-=2;
			*psig=u'\0';
		}
	}
	infor->descripcion=NULL;
	infor->adicional=NULL;
	return;
}

#define pint pufd.pint32
void devuelveinfo_gen_poligonal(devuelve_info_PARS){
	return;
}
void devuelveinfo_gen_poligono(devuelve_info_PARS){
	const char8_t *s;
	Bufferto8 _finf;
	pufldbl pufd;
	infor->descripcion=NULL;
	infor->adicional=NULL;
	toopen_mixed(finf,NULL);
	ifunlike(finf->error_code) return;
	pufd.pint32=(uint*)&pelem->VLA_partegrafica;

	switch(_idioma){
		case 1:  s="Coordinates of the centre:\n"; break;
		case 2:  s="Coordinate del centro:\n"; break;
		default:s="Coordenadas del centro:\n";
	}
	towrite_string(finf,s);
	setbuf_absolute(finf);
	finf->prec.absol=decX; towrite(finf,'s',"X= ", 'f',*pufd.pdbl++, 'c','\n',0);
	finf->prec.absol=decY; towrite(finf,'s',"Y= ", 'f',*pufd.pdbl++, 'c','\n',0);
	finf->prec.absol=dec; towrite(finf,'s',"Z= ", 'f',*pufd.pdbl++, 'c','\n',0);
	switch(_idioma){
		case 1:  s="\nApproximate coordinates of the corners in the point system:\n"; break;
		case 2:  s="\nCoordinate approssimate degli angoli nel sistema dei punti:\n"; break;
		default:s="\nCoordenadas aproximadas de las esquinas en el sistema de los puntos:\n";
	}
	towrite_string(finf,s);

	if(decX>0) decX--;
	if(decY>0) decY--;
	if(dec>0) dec--;
	uint n=*pint++;
	n>>=2; if(n) n--;
	n*=3;
	finf->prec.absol=decX; towrite(finf,'s',"e1: X= ", 'f',*pufd.pdbl++, 0);
	finf->prec.absol=decY; towrite(finf,'s',"  Y= ", 'f',*pufd.pdbl++, 0);
	finf->prec.absol=dec; towrite(finf,'s',"  Z= ", 'f',*pufd.pdbl++, 'c','\n',0);
	pufd.pdbl+=n;
	finf->prec.absol=decX; towrite(finf,'s',"e2: X= ", 'f',*pufd.pdbl++, 0);
	finf->prec.absol=decY; towrite(finf,'s',"  Y= ", 'f',*pufd.pdbl++, 0);
	finf->prec.absol=dec; towrite(finf,'s',"  Z= ", 'f',*pufd.pdbl++, 'c','\n',0);
	pufd.pdbl+=n;
	finf->prec.absol=decX; towrite(finf,'s',"e3: X= ", 'f',*pufd.pdbl++, 0);
	finf->prec.absol=decY; towrite(finf,'s',"  Y= ", 'f',*pufd.pdbl++, 0);
	finf->prec.absol=dec; towrite(finf,'s',"  Z= ", 'f',*pufd.pdbl++, 'c','\n',0);
	pufd.pdbl+=n;
	finf->prec.absol=decX; towrite(finf,'s',"e4: X= ", 'f',*pufd.pdbl++, 0);
	finf->prec.absol=decY; towrite(finf,'s',"  Y= ", 'f',*pufd.pdbl++, 0);
	finf->prec.absol=dec; towrite(finf,'s',"  Z= ", 'f',*pufd.pdbl++, 'c','\n',0);

	uint t=(pdif)(finf->ptr-finf->base);
	infor->descripcion=n_malloc(char8_t,t+1);
	iflike(infor->descripcion!=NULL){memcpy_char8(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}

void devuelveinfo_gen_punto(devuelve_info_PARS){
	return;
}
#define psingle pufd.pfloat
void devuelveinfo_gen_segmento_escalable(devuelve_info_PARS){
	float sx,sy,sz;
	Bufferto8 _finf;
	pufldbl pufd;
	infor->descripcion=NULL;
	infor->adicional=NULL;
	toopen_mixed(finf,NULL);
	ifunlike(finf->error_code) return;
	pufd.pint32=(uint*)&pelem->VLA_partegrafica;

	setbuf_absolute(finf);
	finf->prec.absol=decX; towrite(finf,'s',"X= ", 'f',*pufd.pdbl++, 'c','\n',0);
	finf->prec.absol=decY; towrite(finf,'s',"Y= ", 'f',*pufd.pdbl++, 'c','\n',0);
	finf->prec.absol=dec; towrite(finf,'s',"Z= ", 'f',*pufd.pdbl++, 'c','\n',0);
	sx=*psingle++;
	sy=*psingle++;
	sz=*psingle;

	setbuf_relative(finf);
	finf->prec.signi=3;
	towrite(finf,'s',"\ndx= ", 'f',sx, 's',"\ndy= ", 'f',sy, 's',"\ndz= ", 'f',sz, 'c','\n',0);
	uint t=(pdif)(finf->ptr-finf->base);
	infor->descripcion=n_malloc(char8_t,t+1);
	iflike(infor->descripcion!=NULL){memcpy_char8(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}
void devuelveinfo_gen_poligonal_escalable(devuelve_info_PARS){
	return;
}
void devuelveinfo_gen_elipse_xy(devuelve_info_PARS){
	u8int orientacion;
	float sx,sxy,sy;
	float a,b,cosa,sina;
	const char8_t *s;
	Bufferto8 _finf;
	pufldbl pufd;
	pufd.pint32=(uint*)&pelem->VLA_partegrafica;

	infor->descripcion=NULL;
	infor->adicional=NULL;
	toopen_mixed(finf,NULL);
	ifunlike(finf->error_code) return;

	switch(_idioma){
		case 1:  s="Coordinates of the centre:\n"; break;
		case 2:  s="Coordinate del centro:\n"; break;
		default:s="Coordenadas del centro:\n";
	}
	towrite_string(finf,s);
	setbuf_absolute(finf);
	finf->prec.absol=decX; towrite(finf,'s',"X= ", 'f',*pufd.pdbl++, 'c','\n',0);
	finf->prec.absol=decY; towrite(finf,'s',"Y= ", 'f',*pufd.pdbl++, 'c','\n',0);
	finf->prec.absol=dec; towrite(finf,'s',"Z= ", 'f',*pufd.pdbl++, 'c','\n',0);

	toput_char(finf,'\n');
	orientacion=get_byte0(pint); pint++;
	sx=*psingle++;
	sxy=*psingle++;
	sy=*psingle;

	setbuf_relative(finf);
	finf->prec.signi=3;
	{const char8_t *s1, *s2, *s3;
	switch(orientacion){
		case 0: s1="sx^2= "; s2="\nsxy= "; s3="\nsy^2= "; break;
		case 1: s1="sy^2= "; s2="\nsyz= "; s3="\nsz^2= "; break;
		case 2: s1="sz^2= "; s2="\nszx= "; s3="\nsx^2= "; break;
	}
	towrite(finf,'s',s1,'f',sx, 's',s2,'f',sxy, 's',s3,'f',sy, 'c','\n',0);
	}
	switch(_idioma){
		case 1:  s="\nSemiaxes of the standard ellipse\n"; break;
		case 2:  s="\nSemiassi dell'ellisse standard\n"; break;
		default:s="\nSemiejes de la elipse estándar\n";
	}
	towrite_string(finf,s);
	varianzas_a_alpha(sx,sxy,sy,&a,&b,&cosa,&sina);
	towrite(finf,'s',"  a= ", 'f',a, 's',"\n  b= ", 'f',b,0);
	setbuf_absolute(finf);
	finf->prec.absol=2;
	towrite(finf,'s',"\n  alpha= ", 'f',atan2(sina,cosa)*360/PI2_FL, 'c','\xB0', 'c','\n',0);	// 00B0: °

	uint t=(pdif)(finf->ptr-finf->base);
	infor->descripcion=n_malloc(char8_t,t+1);
	iflike(infor->descripcion!=NULL){memcpy_char8(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}
void devuelveinfo_gen_elipse(devuelve_info_PARS){
	return;
}
void devuelveinfo_gen_giro(devuelve_info_PARS){
	return;
}
void devuelveinfo_gen_elipsoide(devuelve_info_PARS){
	float sx,sxy,sy,sxz,syz,sz;
	float a,b,cosa,sina;
	const char8_t *s;
	Bufferto8 _finf;
	pufldbl pufd;
	pufd.pint32=(uint*)&pelem->VLA_partegrafica;

	infor->descripcion=NULL;
	infor->adicional=NULL;
	toopen_mixed(finf,NULL);
	ifunlike(finf->error_code) return;

	switch(_idioma){
		case 1:  s="Coordinates of the centre:\n"; break;
		case 2:  s="Coordinate del centro:\n"; break;
		default:s="Coordenadas del centro:\n";
	}
	towrite_string(finf,s);
	setbuf_absolute(finf);
	finf->prec.absol=decX; towrite(finf,'s',"X= ", 'f',*pufd.pdbl++, 'c','\n',0);
	finf->prec.absol=decY; towrite(finf,'s',"Y= ", 'f',*pufd.pdbl++, 'c','\n',0);
	finf->prec.absol=dec; towrite(finf,'s',"Z= ", 'f',*pufd.pdbl++, 'c','\n',0);

	toput_char(finf,'\n');
	sx=*psingle++;
	sxy=*psingle++;	sy=*psingle++;
	sxz=*psingle++;	syz=*psingle++;	sz=*psingle;

	setbuf_relative(finf);
	finf->prec.signi=3;
	towrite(finf, 's',"sx^2= ", 'f',sx,
		's',"\nsxy= ", 'f',sxy, 's',"   sy^2= ", 'f',sy,
		's',"\nsxz= ", 'f',sxz, 's',"   syz= ", 'f',syz, 's',"   sz^2= ", 'f',sz,'c','\n',
	0);

	switch(_idioma){
		case 1:  s="\nSemiaxes of the standard xy ellipse\n"; break;
		case 2:  s="\nSemiassi dell'ellisse xy standard\n"; break;
		default:s="\nSemiejes de la elipse xy estándar\n";
	}
	towrite_string(finf,s);
	varianzas_a_alpha(sx,sxy,sy,&a,&b,&cosa,&sina);
	towrite(finf,'s',"  a= ", 'f',a, 's',"\n  b= ", 'f',b, 0);
	setbuf_absolute(finf);
	finf->prec.absol=2;
	towrite(finf,'s',"\n  alpha= ", 'f',atan2(sina,cosa)*360/PI2_FL, 'c','\xB0', 'c','\n',0);	// 00B0: °
	setbuf_relative(finf);
	finf->prec.signi=3;
	switch(_idioma){
		case 1:  s="\nHalf length of the standard interval in z\n"; break;
		case 2:  s="\nSemi-lunghezza dell'intervalo standard in z\n"; break;
		default:s="\nSemilongitud del intervalo estándar en z\n";
	}
	if(sz>0) sz=sqrtf(sz);	else sz=0;
	towrite(finf,'s',s, 's',"  sz= ", 'f',sz, 'c','\n',0);

	uint t=(pdif)(finf->ptr-finf->base);
	infor->descripcion=(char8_t*)malloc((t+1)*usizeof(char8_t));
	iflike(infor->descripcion!=NULL){memcpy_char8(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}
