char16_t XYZ[4]=u"XYZ";
const char16_t* const NombresTipo[][3]={
	{u"Fotograma",u"Photograph",u"Fotogramma"},//0
	{u"Centro de proyeccin",u"Projection centre",u"Centro di proiezione"},//1
	{u"Punto",u"Point",u"Punto"},//2
	{u"Punto de apoyo",u"Control point",u"Punto di appoggio"},//3
	{u"Punto de control",u"Check point",u"Punto di controllo"},//4
	{u"Elipse de precisin",u"Precision ellipse",u"Ellisse di precisione"},//5
	{u"Segmento de precisin",u"Precision segment",u"Segmento di precisione"},//6
	{u"Componentes de precisin",u"Precision components",u"Componenti di precisione"},//7
	{u"Residuo o sim., dos componentes",u"Residual o sim., two components",u"Residui o sim., due componenti"},//8
	{u"Fotocoordenada",u"Photo coordinate",u"Coordinate immagine"},//9
	{u"Distorsin",u"Distortion",u"Distorsione"},//10
	{u"Residuo o sim., tres componentes",u"Residual o sim., three components",u"Residuo o sim., tre componenti"},//11
	{u"Centro de proyeccin, punto",u"Projection centre, point",u"Centro di proiezione, punto"},//12
	{u"Centro de proyeccin, giro",u"Projection centre, rotation",u"Centro di proiezione, giro"},//13
};

#define finf (&_finf)
void devuelveinfo_minima(pUFD pufd,InformaciondeElemento* _infor){
	u8int t;
	uint* pnombre;

	_infor->tipo=bytes01(pint);
	pint+=2;
	memcpy_Double(_infor->extremos,pdbl,6);
	pint+=12;
	t=byte0(pint); pint++;
	if(!t) t=1;
	pnombre=(uint*)malloc(t*usizeof(uint));
	_infor->nombre=(char*)pnombre;
	while(t--) *pnombre++=*pint++;

	_infor->nombre_tipo=NULL;
	_infor->nombre_subtipo=NULL;
	_infor->descripcion=NULL;
	_infor->adicional=NULL;
	return;
}
void devuelveinfo_foto(pUFD pufd,Global* global,s8int dec){
	uint t;	//porque tambin se emplea en texto.pcount
	uint* pnombre;
	Double X,Y,Z;
	const char *s;
	Bufferto8 _finf;
	infor->descripcion=NULL;
	infor->adicional=NULL;

	infor->tipo=bytes01(pint);
	pint+=2;
	memcpy_Double(infor->extremos,pdbl,6);
	pint+=12;
	infor->nombre_tipo=NombresTipo[0][idioma];
	infor->nombre_subtipo=NULL;

	t=byte0(pint); pint++;
	if(!t) t=1;
	pnombre=(uint*)malloc(t*usizeof(uint));
	infor->nombre=(char*)pnombre;
	while(t--) *pnombre++=*pint++;

	toopen_mixed(NULL,finf);
	if(finf->error_code) return;

	X=*pdbl++;
	Y=*pdbl++;
	Z=*pdbl++;
	switch(idioma){
		case 1:  s="Coordinates of the projection centre:\n"; break;
		case 2:  s="Coordinate del centro di proiezione:\n"; break;
		default:s="Coordenadas del centro de proyeccin:\n";
	}
	towrite_string(finf,s);
	setbuf_absolute(finf);
	finf->prec=dec;
	towrite(finf,'s',"X= ", 'f',X, 's',"\nY= ", 'f',Y, 's',"\nZ= ", 'f',Z, 'c','\n',0);
	switch(idioma){
		case 1:  s="\nApproximate coordinates of the corners in the point system:\n"; break;
		case 2:  s="\nCoordinate approssimate degli angoli nel sistema dei punti:\n"; break;
		default:s="\nCoordenadas aproximadas de las esquinas en el sistema de los puntos:\n";
	}
	towrite_string(finf,s);
	if(dec>0) finf->prec=dec-1;
	t=*pint++;
	towrite(finf,'s',"e1: X= ", 'f',pdbl[0], 's',"  Y= ", 'f',pdbl[1], 's',"  Z= ", 'f',pdbl[2], 'c','\n',0); pdbl+=3;
	if(t==12) pdbl+=6;
	towrite(finf,'s',"e2: X= ", 'f',pdbl[0], 's',"  Y= ", 'f',pdbl[1], 's',"  Z= ", 'f',pdbl[2], 'c','\n',0); pdbl+=3;
	if(t==12) pdbl+=6;
	towrite(finf,'s',"e3: X= ", 'f',pdbl[0], 's',"  Y= ", 'f',pdbl[1], 's',"  Z= ", 'f',pdbl[2], 'c','\n',0); pdbl+=3;
	if(t==12) pdbl+=6;
	towrite(finf,'s',"e4: X= ", 'f',pdbl[0], 's',"  Y= ", 'f',pdbl[1], 's',"  Z= ", 'f',pdbl[2], 'c','\n',0); pdbl+=3;

	t=finf->ptr-finf->base;
	infor->descripcion=(char*)malloc((t+1)*usizeof(char));
	if(infor->descripcion!=NULL){memcpy(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}


void devuelveinfo_puntoM(pUFD pufd,Global* global){
	devuelveinfo_minima(pufd,infor);
	infor->nombre_tipo=NombresTipo[2][idioma];
}
void devuelveinfo_puntoA(pUFD pufd,Global* global){
	devuelveinfo_minima(pufd,infor);
	u8int subtipo;
	uint t;
	if((infor->tipo&0x700)!=0){
		infor->nombre_tipo=NombresTipo[3][idioma];
		subtipo=(u8int)((infor->tipo>>8) &0xFF);
	}else{
		infor->nombre_tipo=NombresTipo[4][idioma];
		subtipo=(u8int)((infor->tipo>>11) &0xFF);
	}
	infor->nombre_subtipo=new char16_t[4];
	t=0;
	if(subtipo&1) XYZ[t++]=u'X';
	if(subtipo&2) XYZ[t++]=u'Y';
	if(subtipo&4) XYZ[t++]=u'Z';
	XYZ[t]=u'\0';
	infor->nombre_subtipo=XYZ;

	if((infor->tipo&0x700) && (subtipo=(infor->tipo>>11)&7)!=0){
		const char *s;
		Bufferto8 _finf;
		toopen_mixed(NULL,finf);
		if(finf->error_code) return;

		switch(idioma){
			case 1:  s="The point is also a check point for "; break;
			case 2:  s="Il punto anche  un punto di controllo in "; break;
			default:s="El punto es tambin un punto de control en ";
		}
		towrite_string(finf,s);
		if(subtipo&1) toput_char(finf,'X');
		if(subtipo&2) toput_char(finf,'Y');
		if(subtipo&4) toput_char(finf,'Z');

		uint t=finf->ptr-finf->base;
		infor->descripcion=(char*)malloc((t+1)*usizeof(char));
		if(infor->descripcion!=NULL){memcpy(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
		toclose(finf);
	}
}
void devuelveinfo_elipse(pUFD pufd,Global* global){
	uint* pnombre;
	uint t;
	u8int orientacion;
	float sx,sxy,sy;
	float a,b,alpha;
	const char *s;
	Bufferto8 _finf;

	infor->tipo=bytes01(pint);
	pint+=2;
	memcpy_Double(infor->extremos,pdbl,6);
	pint+=12;

	infor->nombre_tipo=NombresTipo[5][idioma];
	switch(infor->tipo&0xFF00){
		case 0x0000: infor->nombre_subtipo=NombresTipo[1][idioma]; break;
		case 0x0100: infor->nombre_subtipo=NombresTipo[2][idioma]; break;
		case 0x0200: infor->nombre_subtipo=NombresTipo[3][idioma]; break;
	}

	t=byte0(pint); pint++;
	if(!t) t=1;
	pnombre=(uint*)malloc(t*usizeof(uint));
	infor->nombre=(char*)pnombre;
	while(t--) *pnombre++=*pint++;

	infor->descripcion=NULL;
	infor->adicional=NULL;
	toopen_mixed(NULL,finf);
	if(finf->error_code) return;

	pdbl+=3;	//Nos saltamos el centro
	orientacion=byte0(pint); pint++;
	sx=*psingle++;
	sxy=*psingle++;
	sy=*psingle++;
	setbuf_relative(finf);
	finf->prec=3;
	{const char *s1, *s2, *s3;
	switch(orientacion){
		case 0: s1="sx^2= "; s2="\nsxy= "; s3="\nsy^2= "; break;
		case 1: s1="sy^2= "; s2="\nsyz= "; s3="\nsz^2= "; break;
		case 2: s1="sz^2= "; s2="\nszx= "; s3="\nsx^2= "; break;
	}
	towrite(finf,'s',s1,'f',sx, 's',s2,'f',sxy, 's',s3,'f',sy, 'c','\n',0);
	}
	switch(idioma){
		case 1:  s="\nSemiaxes of the standard ellipse\n"; break;
		case 2:  s="\nSemiassi dell'ellisse standard\n"; break;
		default:s="\nSemiejes de la elipse estndar\n";
	}
	towrite_string(finf,s);
	varianzas_a_alpha(sx,sxy,sy,&a,&b,&alpha);
	towrite(finf,'s',"  a= ", 'f',a,
		's',"\n  b= ", 'f',b,
		's',"\n  alpha= ", 'f',alpha*360/PI2_FL, 'c','', 'c','\n',
	0);
	t=finf->ptr-finf->base;
	infor->descripcion=(char*)malloc((t+1)*usizeof(char));
	if(infor->descripcion!=NULL){memcpy(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}
void devuelveinfo_segmento(pUFD pufd,Global* global){
	uint* pnombre;
	uint t;
	u8int orientacion;
	float l;
	const char *s;
	Bufferto8 _finf;

	infor->tipo=bytes01(pint);
	pint+=2;
	memcpy_Double(infor->extremos,pdbl,6);
	pint+=12;

	infor->nombre_tipo=NombresTipo[6][idioma];
	switch(infor->tipo&0xFF00){
		case 0x0000: infor->nombre_subtipo=NombresTipo[1][idioma]; break;
		case 0x0100: infor->nombre_subtipo=NombresTipo[2][idioma]; break;
		case 0x0200: infor->nombre_subtipo=NombresTipo[3][idioma]; break;
	}

	t=byte0(pint); pint++;
	if(!t) t=1;
	pnombre=(uint*)malloc(t*usizeof(uint));
	infor->nombre=(char*)pnombre;
	while(t--) *pnombre++=*pint++;

	infor->descripcion=NULL;
	infor->adicional=NULL;
	toopen_mixed(NULL,finf);
	if(finf->error_code) return;

	pdbl+=3;	//Nos saltamos el centro
	l=*psingle++; if(l){orientacion=1; psingle+=2;}
	else{
		l=*psingle++;
		if(l){orientacion=2; psingle++;}
		else{l=*psingle++; orientacion=0;}
	}
	setbuf_relative(finf);
	finf->prec=3;
	switch(idioma){
		case 1:  s="Orientation: "; break;
		case 2:  s="Orientazoine: "; break;
		default:s="Orientacin: "; break;
	}
	towrite_string(finf,s);
	char c;
	switch(orientacion){
		case 0: c='z'; break;
		case 1: c='x'; break;
		case 2: c='y'; break;
	}
	toput_char(finf,c);
	switch(idioma){
		case 1:  s="\nHalf lenght= "; break;
		case 2:  s="\nSemi-lunghezza= "; break;
		default:s="\nSemilongitud= ";
	}
	towrite(finf,'s',s, 'f',l, 's',"\n\n",0);

	t=finf->ptr-finf->base;
	infor->descripcion=(char*)malloc((t+1)*usizeof(char));
	if(infor->descripcion!=NULL){memcpy(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}
void devuelveinfo_elipsoide(pUFD pufd,Global* global){
	uint* pnombre;
	uint t;
	float sx,sxy,sy,sxz,syz,sz;
	float a,b,alpha;
	const char *s;
	Bufferto8 _finf;

	infor->tipo=bytes01(pint);
	pint+=2;
	memcpy_Double(infor->extremos,pdbl,6);
	pint+=12;

	infor->nombre_tipo=NombresTipo[7][idioma];
	switch(infor->tipo&0xFF00){
		case 0x0000: infor->nombre_subtipo=NombresTipo[1][idioma]; break;
		case 0x0100: infor->nombre_subtipo=NombresTipo[2][idioma]; break;
		case 0x0200: infor->nombre_subtipo=NombresTipo[3][idioma]; break;
	}

	t=byte0(pint); pint++;
	if(!t) t=1;
	pnombre=(uint*)malloc(t*usizeof(uint));
	infor->nombre=(char*)pnombre;
	while(t--) *pnombre++=*pint++;

	infor->descripcion=NULL;
	infor->adicional=NULL;
	toopen_mixed(NULL,finf);
	if(finf->error_code) return;

	pdbl+=3;	//Nos saltamos el centro
	sx=*psingle++;
	sxy=*psingle++;
	sy=*psingle++;
	sxz=*psingle++;
	syz=*psingle++;
	sz=*psingle++;

	setbuf_relative(finf);
	finf->prec=3;
	towrite(finf, 's',"sx^2= ", 'f',sx,
		's',"\nsxy= ", 'f',sxy, 's',"   sy^2= ", 'f',sy,
		's',"\nsxz= ", 'f',sxz, 's',"   syz= ", 'f',syz, 's',"   sz^2= ", 'f',sz,'c','\n',
	0);

	switch(idioma){
		case 1:  s="\nSemiaxes of the standard xy ellipse\n"; break;
		case 2:  s="\nSemiassi dell'ellisse xy standard\n"; break;
		default:s="\nSemiejes de la elipse xy estndar\n";
	}
	towrite_string(finf,s);
	varianzas_a_alpha(sx,sxy,sy,&a,&b,&alpha);
	towrite(finf,'s',"  a= ", 'f',a, 's',"\n  b= ", 'f',b, 0);
	setbuf_absolute(finf);
	finf->prec=2;
	towrite(finf,'s',"\n  alpha= ", 'f',alpha*360/PI2_FL, 'c','', 'c','\n',0);
	setbuf_relative(finf);
	finf->prec=3;
	switch(idioma){
		case 1:  s="\nHalf length of the standard interval in z\n"; break;
		case 2:  s="\nSemi-lunghezza dell'intervalo standard in z\n"; break;
		default:s="\nSemilongitud del intervalo estndar en z\n";
	}
	if(sz>0) sz=sqrtf(sz);	else sz=0;
	towrite(finf,'s',s, 's',"  sz= ", 'f',sz, 'c','\n',0);

	t=finf->ptr-finf->base;
	infor->descripcion=(char*)malloc((t+1)*usizeof(char));
	if(infor->descripcion!=NULL){memcpy(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}

void devuelveinfo_residuoxy(pUFD pufd,Global* global){
	uint* pnombre;
	uint t;
	float sx,sy;
	Bufferto8 _finf;

	infor->tipo=bytes01(pint);
	pint+=2;
	memcpy_Double(infor->extremos,pdbl,6);
	pint+=12;

	infor->nombre_tipo=NombresTipo[8][idioma];
	switch(infor->tipo&0xFF00){
		case 0x0000: infor->nombre_subtipo=NombresTipo[9][idioma]; break;
		case 0x0100: infor->nombre_subtipo=NombresTipo[10][idioma]; break;
	}

	t=byte0(pint); pint++;
	if(!t) t=1;
	pnombre=(uint*)malloc(t*usizeof(uint));
	infor->nombre=(char*)pnombre;
	while(t--) *pnombre++=*pint++;

	infor->descripcion=NULL;
	infor->adicional=NULL;
	toopen_mixed(NULL,finf);
	if(finf->error_code) return;

	pdbl+=3;	//Nos saltamos el centro
	sx=*psingle++;
	sy=*psingle;
	setbuf_relative(finf);
	finf->prec=3;
	towrite(finf,'s',"x= ", 'f',sx, 's',"\ny= ", 'f',sy, 'c','\n',0);

	t=finf->ptr-finf->base;
	infor->descripcion=(char*)malloc((t+1)*usizeof(char));
	if(infor->descripcion!=NULL){memcpy(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}

void devuelveinfo_residuo3d(pUFD pufd,Global* global){
	uint* pnombre;
	uint t;
	float sx,sy,sz;
	Bufferto8 _finf;

	infor->tipo=bytes01(pint);
	pint+=2;
	memcpy_Double(infor->extremos,pdbl,6);
	pint+=12;

	infor->nombre_tipo=NombresTipo[11][idioma];
	switch(infor->tipo&0xFF00){
		case 0x0000: infor->nombre_subtipo=NombresTipo[12][idioma]; break;
		case 0x0100: infor->nombre_subtipo=NombresTipo[13][idioma]; break;
		case 0x0200: infor->nombre_subtipo=NombresTipo[3][idioma]; break;
		case 0x0300: infor->nombre_subtipo=NombresTipo[4][idioma]; break;
	}

	t=byte0(pint); pint++;
	if(!t) t=1;
	pnombre=(uint*)malloc(t*usizeof(uint));
	infor->nombre=(char*)pnombre;
	while(t--) *pnombre++=*pint++;

	infor->descripcion=NULL;
	infor->adicional=NULL;
	toopen_mixed(NULL,finf);
	if(finf->error_code) return;

	pdbl+=3;	//Nos saltamos el centro
	sx=*psingle++;
	sy=*psingle++;
	sz=*psingle;
	setbuf_relative(finf);
	finf->prec=3;

	if((infor->tipo&0xFF00)==1)
		towrite(finf,'s',"w= ", 'f',sx, 's',"\nphi= ", 'f',sy, 's',"\nk= ", 'f',sz, 'c','\n',0);
	else towrite(finf,'s',"x= ", 'f',sx, 's',"\ny= ", 'f',sy, 's',"\nz= ", 'f',sz, 'c','\n',0);

	t=finf->ptr-finf->base;
	infor->descripcion=(char*)malloc((t+1)*usizeof(char));
	if(infor->descripcion!=NULL){memcpy(infor->descripcion,finf->base,t); infor->descripcion[t]='\0';}
	toclose(finf);
}
