//Además establece pconfig
int combrueba_grafico(GraficoCompleto _grafico){
	if(_grafico.fgrafico==NULL) return 1;
	if(_grafico.configs.ppio==NULL || _grafico.kconfig>=_grafico.configs.n) return 1;

	_grafico.pconfig=_grafico.configs.ppio+_grafico.kconfig;
	if(_grafico.pconfig==NULL || _grafico.pconfig->fconfig==NULL || _grafico.pconfig->fconfig->tipos.ppio==NULL
	   || _grafico.pconfig->fconfig->ver_info.ver.ppio==NULL || _grafico.pconfig->fconfig->ver_info.verT.ppio==NULL
	   || _grafico.pconfig->solved.ppio==NULL) return 1; //pconfig->pformas puede ser NULL

	return 0;
}

//Configuraciones desarrolladas. Esto es, no se guarda un número de estilo
//de línea, por ejemplo, sino (el puntero a) los datos que definen el estilo.
struct ConfigLinea{
	uint _color;
	float grosor;		//Si es positivo es en píxeles (grosor), si negativo en unid. del archivo gra (grosorT)
	u16int estilol;	//Por lo tanto esto hay que cambiarlo. Pero aún no están program. los est. de línea
};
struct ConfigPunto{
	uint _color;
	FormaPunto forma;
};
struct ConfigPoligonal{
	ConfigLinea linea;
	//u8int modo_esquinas;
};
struct ConfigPoligono{
	float escala;
	ConfigPunto centro;
	ConfigPoligonal poligonal;
};
struct ConfigVector{
	float escala;
	ConfigPunto origen;
	ConfigLinea linea;
};
struct ConfigPoligonalEscalable{
	float escala;
	ConfigPoligonal poligonal;
	ConfigLinea vectores;
};
struct ConfigElipse{
	float escala;
	ConfigLinea linea;
};
struct ConfigElipsoide{
	u16int estilo;	//estilo global de representación
	float escala;
	ConfigPunto centro;
	ConfigLinea linea, linea2;
};

namespace Defaults{
	const ConfigPunto config_punto={
		0x00807890,
		default_forma_punto
	};
	const ConfigPoligonal config_poligonal={
		{0x00D0D0D0, 1.0F, 0}	//línea
		/*modo_esquinas*/
	};
	const ConfigPoligono config_poligono={
		1.0F,	//escala
		{0x00FFFF00,default_forma_centro},	//centro
		{ //poligonal
			{0x00BBFF, 1.0F, 0}	//línea
			/*modo_esquinas*/
		}
	};
	const ConfigVector config_vector={
		1.0F,	//escala
		{0x00D0D0D0,forma_nula},	//origen
		{0x00D0D0D0, 1.0F, 0}	//línea
	};
	const ConfigPoligonalEscalable config_poligonalesc={
		1.0F,	//escala
		{/*Poligonal*/
			{0x00D0D0D0, 1.0F, 0}	//línea
			/*modo_esquinas*/
		},
		{0x00FF0088, 1.0F, 0}		//vectores (línea)
	};
	const ConfigElipse config_elipse={
		1.0F, //escala
		{0x000070, 1.0F, 0}	//línea
	};
	const ConfigElipsoide config_elipsoide={
		0,	//estilo
		1.0F, //escala
		{0x8C0064,forma_nula},	//centro
		{0x000070, 1.0F, 0},	//línea
		{0x8C0064, 1.0F, 0}	//línea2
	};
};

//A programar con #ifequal para el modo de devolver la forma cuando lo programe,
//definir ...pforma... como ....xforma,PUNTERO,... Análog. nforma.
#define color_nforma_escala_y_otros(col,n_forma,escala,otros) \
	if(concreta!=NULL){\
		LinkedSolvedQuality *ptr=concreta->cualidades;\
		while(ptr!=NULL){\
			switch(ptr->nqual){\
				case Q_FormaP: n_forma=(u16int)ptr->value.n; break;\
				case Q_Color: col=ptr->value.n; break;\
				case Q_Escala: escala=ptr->value.fl; break;\
				otros \
			}\
			ptr=ptr->next;\
		}\
	}

#define color_grosor_nforma_escala_y_otros(col,ancho,n_forma,escala,otros) \
	if(concreta!=NULL){\
		LinkedSolvedQuality *ptr=concreta->cualidades;\
		while(ptr!=NULL){\
			switch(ptr->nqual){\
				case Q_FormaP: n_forma=(u16int)ptr->value.n; break;\
				case Q_Grosor: ancho=ptr->value.fl; break;\
				case Q_Color: col=ptr->value.n; break;\
				case Q_Escala: escala=ptr->value.fl; break;\
				otros \
			}\
			ptr=ptr->next;\
		}\
	}

sinline float GetVar_escala(SolvedQualities* concreta){
	float escala=1.0F;
	if(concreta!=NULL){
		LinkedSolvedQuality *ptr=concreta->cualidades;
		while(ptr!=NULL && ptr->nqual!=Q_Escala) ptr=ptr->next;
		if(ptr!=NULL) escala=ptr->value.fl;
	}
	return escala;
}
void GetVars_punto(GraElementoGenerico *pelem,ConfigPunto *config, SolvedQualities* concreta, LinkedGrupoFormas *pformas){
	if(config==NULL) return;
	*config=Defaults::config_punto;
	u16int n_forma=0xFFFF;
	if(concreta!=NULL){
		LinkedSolvedQuality *ptr=concreta->cualidades;
		while(ptr!=NULL){
			switch(ptr->nqual){
				case Q_FormaP: n_forma=(u16int)ptr->value.n; break;
				case Q_ColorP: config->_color=ptr->value.n; break;
			}
			ptr=ptr->next;
		}
	}
	if(n_forma!=0xFFFF) find_forma(&config->forma,pformas,n_forma);
}

void GetVars_poligonal(GraElementoGenerico *pelem,ConfigPoligonal *config, SolvedQualities* concreta){
	if(config==NULL) return;
	*config=Defaults::config_poligonal;
	if(concreta!=NULL){
		LinkedSolvedQuality *ptr=concreta->cualidades;
		while(ptr!=NULL){
			switch(ptr->nqual){
				case Q_Color: config->linea._color=ptr->value.n; break;
				case Q_Grosor: config->linea.grosor=ptr->value.fl; break;
			}
			ptr=ptr->next;
		}
	}
}

void GetVars_poligono(GraElementoGenerico *pelem,ConfigPoligono *config, SolvedQualities* concreta, LinkedGrupoFormas *pformas){
	if(config==NULL) return;
	*config=Defaults::config_poligono;
	u16int n_forma=0xFFFF;
	color_grosor_nforma_escala_y_otros(config->poligonal.linea._color,config->poligonal.linea.grosor,
		n_forma,config->escala,
		case Q_ColorP:	config->centro._color=ptr->value.n; break;
	)
	if(n_forma!=0xFFFF) find_forma(&config->centro.forma,pformas,n_forma);
}

void GetVars_vector(GraElementoGenerico *pelem, ConfigVector *config, SolvedQualities* concreta, LinkedGrupoFormas *pformas){
	if(config==NULL) return;
	*config=Defaults::config_vector;
	u16int n_forma=0xFFFF;
	color_nforma_escala_y_otros(config->linea._color,n_forma,config->escala,
		case Q_ColorP:	config->origen._color=ptr->value.n; break;
	)
	if(n_forma!=0xFFFF) find_forma(&config->origen.forma,pformas,n_forma);
}

void GetVars_poligonalesc(GraElementoGenerico *pelem,ConfigPoligonalEscalable *config, SolvedQualities* concreta){
	if(config==NULL) return;
	*config=Defaults::config_poligonalesc;
	if(concreta!=NULL){
		LinkedSolvedQuality *ptr=concreta->cualidades;
		while(ptr!=NULL){
			switch(ptr->nqual){
				case Q_Escala: config->escala=ptr->value.fl; break;
				case Q_Color: config->poligonal.linea._color=ptr->value.n; break;
				case Q_Grosor: config->poligonal.linea.grosor=ptr->value.fl; break;
			}
			ptr=ptr->next;
		}
	}
}

void GetVars_elipse(GraElementoGenerico * _unused(pelem), ConfigElipse *config, SolvedQualities* concreta, LinkedGrupoFormas *pformas){
	if(config==NULL) return;
	*config=Defaults::config_elipse;
	if(concreta!=NULL){
		LinkedSolvedQuality *ptr=concreta->cualidades;
		while(ptr!=NULL){
			switch(ptr->nqual){
				case Q_Escala: config->escala=ptr->value.fl; break;
				case Q_Color: config->linea._color=ptr->value.n; break;
				case Q_Grosor: config->linea.grosor=ptr->value.fl; break;
			}
			ptr=ptr->next;
		}
	}
}

void GetVars_elipsoide(GraElementoGenerico * _unused(pelem), ConfigElipsoide *config, SolvedQualities* concreta, LinkedGrupoFormas *pformas){
	if(config==NULL) return;
	*config=Defaults::config_elipsoide;
	u16int n_forma=0xFFFF;
	color_grosor_nforma_escala_y_otros(config->linea._color,config->linea.grosor,
		n_forma,config->escala,
		case Q_ColorP:	config->centro._color=ptr->value.n; break;
		case Q_Color2:	config->linea2._color=ptr->value.n; break;
	)
	if(n_forma!=0xFFFF) find_forma(&config->centro.forma,pformas,n_forma);
}
