﻿#include "Modelo.h"

typedef struct{
 u16int hacha;
 u16int hacha_mf, hacha_mm;
 u16int hacha_2, hacha_3;
 u16int contrahacha_mm;
} Hachas;

typedef struct{
 uint m1;
 uint m2;
 uint npc;
 uint pf, fp, ff;
 uint scentros;
 union{
	uint valor;
	struct{
		unsigned puntuacion: 28;
		unsigned pref: 4;
	};
 };
} Par_modmod;

sinline bint modmod_less(Par_modmod *izq, Par_modmod *par){
	if(izq->valor<par->valor) return true;
	if(izq->valor>par->valor || izq->pref==3) return false;
	return izq->scentros>par->scentros;
 }
sinline bint modmod_plus(Par_modmod *izq, Par_modmod *par){
	if(izq->valor>par->valor) return true;
	if(izq->valor<par->valor || izq->pref==3) return false;
	return izq->scentros<par->scentros;
 }

//m1 y m2 asignados de manera que pf>=fp.
//I.	    Pref=3:			npc > que contrahacha_mm (pref. o normal)
//			a) ncp>
//II.   Preferente:	pf>=hacha_2 y fp>=hacha_3
//			a) pf> combinado con scentros<
//			b) scentros<
//III. Normal			pf>0 y fp>0
//			a) npc>=hacha_mm
//			b) scentros<
//IV. Deprec.
//			a) npc>=hacha
//			b) scentros<
//
sinline void asigna_pref_modelo(Par_modmod* ppar, Hachas* H){
	if(ppar->pf + ppar->ff==ppar->npc) ppar->pref=0;
	elif(ppar->npc>=H->contrahacha_mm) ppar->pref=3;
	elif(ppar->pf>=H->hacha_2 && ppar->fp>=H->hacha_3) ppar->pref=2;
	else ppar->pref=1;
}
void puntua_parmodelo(Par_modmod* ppar, Hachas* H){
	uint k,r;
	if(ppar->pref==3) ppar->puntuacion=ppar->npc;
	elif(ppar->pref==2){
		k=ppar->scentros>>3;
		r=ppar->pf;
		while(k!=0 && r!=0){r--; k>>=1;}
		ppar->puntuacion=r;
	}elif(ppar->pref==1){
		if(ppar->npc>=H->hacha_mm) ppar->puntuacion=H->hacha_mm;
		else ppar->puntuacion=ppar->npc;
	}else{
		if(ppar->npc>=H->hacha) ppar->puntuacion=H->hacha;
		else ppar->puntuacion=ppar->npc;
	}
	return;
}

typedef struct{
 uint m1;
 uint f;
 uint npc;
 uint pf, ff;		//cap->ff;   cap2->pf
 uint scentros;
 union{
	uint valor;
	struct{
		unsigned puntuacion: 28;
		unsigned pref: 4;
	};
 };
} Par_modfot;

sinline bint modfot_less(Par_modfot *izq, Par_modfot *par){
	if(izq->valor<par->valor) return true;
	if(izq->valor>par->valor || izq->pref==3) return false;
	return izq->scentros>par->scentros;
 }
sinline bint modfot_plus(Par_modfot *izq, Par_modfot *par){
	if(izq->valor>par->valor) return true;
	if(izq->valor<par->valor || izq->pref==3) return false;
	return izq->scentros<par->scentros;
 }

//I.	    Pref=3.:		pf y ff >=hacha_2 y scentros<=3
//			a) scentros=2
//II.   Preferente:	pf y ff >=hacha_3, y uno de ellos >=hacha_2
//			a) pf>=hacha2:
//			b) scentros<
//III. Normal:		pf>0
//			a) npc>=hacha_mf
//			b) scentros<
//IV. Deprec.
//			a) npc>=hacha
//			b) scentros<
//
sinline void asigna_pref_modfot(Par_modfot* ppar, Hachas* H){
	uint kk,k2;
	if(ppar->pf>ppar->ff){k2=ppar->pf; kk=ppar->ff;}
	else{k2=ppar->ff; kk=ppar->pf;}
	if(k2>=H->hacha_2 && kk>=H->hacha_3){
		if(ppar->pf>=H->hacha_2 && ppar->npc>=H->hacha && ppar->scentros<=3) ppar->pref=3;
		else ppar->pref=2;
	}elif(ppar->pf) ppar->pref=1;
	else ppar->pref=0;
}
void puntua_parmodfot(Par_modfot* ppar, Hachas* H){
	if(ppar->pref==3) ppar->puntuacion=10-ppar->scentros;
	elif(ppar->pref==2){
		if(ppar->pf>=H->hacha_2) ppar->puntuacion=H->hacha_2;
		else ppar->puntuacion=ppar->pf;
	}elif(ppar->pref==1){
		if(ppar->npc>=H->hacha_mf) ppar->puntuacion=H->hacha_mm; //hacha_mm para poder compararlo con modmod.
		else ppar->puntuacion=ppar->npc;
	}else{
		if(ppar->npc>=H->hacha) ppar->puntuacion=H->hacha;
		else ppar->puntuacion=ppar->npc;
	}
	return;
}

defineVector(Par_modfot)
