#define MODELOS
//ESTRUCTURAS EXPUESTAS AL EXTERIOR
typedef struct{
	struct{
		unsigned ajs:1;
		unsigned inf:1;
		unsigned xml:1;
	} ficheros;
	struct{
		unsigned stdP:16;	//0: cc.pp.; 1: puntos
	} fich_ajs;
	struct{
			//1: en el sistema de referencia
			//2: en el sistema a transformar
			//4: puntos con mayor residuo (%)
			//8: puntos de control
		unsigned infR:16;
		unsigned infP:16;
		float percent;
	} fich_inf;
} ModelosConfigSalida;

sinline bint ModelosSalida_hay_residuos(const ModelosConfigSalida *S){ return S->fich_inf.infR!=0; }
sinline bint ModelosSalida_hay_parametros(const ModelosConfigSalida *S){ return (S->fich_inf.infP&0x0003)!=0; }
sinline bint ModelosSalida_hay_precisiones(const ModelosConfigSalida *S){ return (S->fich_inf.infP&0x000C)!=0; }

typedef struct{
	float cpXY, cpZ;
	float pXY, pZ;
} PrecFichero;
//HASTA AQUÍ

typedef struct{
	float T1x, T1y, T1z;
	float T2x, T2y, T2z;
	float esc;
	float Gw, Gfi, Gk;
} PrecTrans;

struct _DecFich {s8int f1,p1,f2,p2;};
typedef struct{
	s8int T1, T2, esc, G;
	struct _DecFich ajs;
	struct _DecFich res;
} DecTrans;
