﻿typedef struct{
	uint u0;
	uint u1;
	uint pos_enteros;
	uint pos_indice_punteros;
	uint pos_pequenos;
	uint pos_indice_grandes;
	uint pos_textos8;
	uint pos_textos16;
} IndiceBnf;
#define TAMAÑO_INDICE_BNF 8
#define TAMAÑO_ENTERO 1
#define TAMAÑO_ENTRADA_INDICE_PUN 4
#define TAMAÑO_PEQUENO 2
#define TAMAÑO_ENTRADA_INDICE_G 2

typedef struct{
	uint tipo;
	uint nom;	//desde el ppio de textos8
	uint n;		//número de elementos
	uint pos;	//desde el ppio del fichero
}BnfPuntero;

typedef uint BnfEntero;

typedef struct{
	uint nom;
	union{IO_SINGLE f; uint n32; u16int n16; u8int n8; bint b;} dato;
}BnfPequeno;

typedef struct{
	uint nom;
	uint pos;	//desde el ppio del fichero
}BnfGrande;

defineGrowing(NamedPointer)

#undef Index
#define Index uint index
typedef struct _PuntoXYZ_DUBL{
 union{IO_DOUBLE X, w;};
 union{IO_DOUBLE Y, fi;};
 union{IO_DOUBLE Z, k;};
} PuntoXYZ_IO_DOUBLE, Giro3D_IO_DOUBLE;

typedef struct{
	uint index;
	PuntoXYZM_BODY(IO_DOUBLE)
	umint gggppp;
	umint gggppp2;
	umint b;
	uint peso;	//!=0 si apunta a algún peso
} CentroProy_32;

typedef struct{
 PuntoXYZn_BODY(IO_DOUBLE)
 umint bbb;
 uint peso;
} PuntoM_32;

typedef struct{
 PuntoXYZMn_BODY(IO_DOUBLE)
 IO_DOUBLE t;
 PuntoXYZ_IO_DOUBLE offset;
 umint bg;
 umint bi;
 uint grupo;
 umint tipoGPS;
 umint tipoINS;
 umint param;	//v. GrupoGPS
 uint peso;
} PuntoGPSINS_32;

typedef struct{
 Index;	//Se deja =Я y no apunta a nada
 umint tipoGPS;
 umint tipoINS;
 umint param;	//0, tiempo; 1, distancia (norma 1).
 IO_DOUBLE tiempo0;
 PuntoXYZ_IO_DOUBLE offset;
 PuntoXYZ_IO_DOUBLE despl;
 PuntoXYZ_IO_DOUBLE deriva;
 IO_DOUBLE desplins[3][3];
 Giro3D_IO_DOUBLE derivains;
 uint n;	//número de observaciones que incluye este grupo
 umint bg;
 umint bi;
 uint peso;	//apuntará al mismo array de pesos que los puntos_gps.
} GrupoGPSINS_32;
#undef Index

void CentroProy_a_32(CentroProy_32* pfich, const CentroProy* pmem, uint n, const char8_t* nombres){
	while(n){ n--;
		pfich->index=(pdif)(pmem->nom-nombres);
		IO_DOUBLE_memcpy_double(&pfich->P.X,&pmem->P.X,12);
		*(uint*)&pfich->gggppp=*(uint*)&pmem->gggppp;  //gp, gp2 y b
		pfich->peso=pmem->peso;
		pmem++, pfich++;
	}
}
void PuntoM_a_32(PuntoM_32* pfich, PuntoM* pmem, uint n, const char8_t* nombres){
	while(n){ n--;
		pfich->index=(pdif)(pmem->nom-nombres);
		IO_DOUBLE_memcpy_double(&pfich->P.X,&pmem->P.X,3);
		pfich->bbb=pmem->bbb;
		pfich->peso=pmem->peso;
		pmem++, pfich++;
	}
}
void PuntoGPSINS_a_32(PuntoGPSINS_32* pfich, PuntoGPSINS* pmem, uint n, const char8_t* nombres){
	while(n){n--;
		pfich->index=(pdif)(pmem->nom-nombres);
		IO_DOUBLE_memcpy_double(&pfich->P.X,&pmem->P.X,16);
		*(uint*)&pfich->bg=*(uint*)&pmem->bg; //bg y bi
		pfich->grupo=pmem->grupo;
		*(uint*)&pfich->tipoGPS=*(uint*)&pmem->tipoGPS; //tipoGPS, tipoINS y param
		pfich->peso=pmem->peso;
		pmem++, pfich++;
	}
}
void GrupoGPSINS_a_32(GrupoGPSINS_32* pfich, GrupoGPSINS* pmem, uint n, const char8_t* nombres){
	while(n){n--;
		pfich->index=(pdif)(pmem->nom-nombres);
		*(uint*)&pfich->tipoGPS=*(uint*)&pmem->tipoGPS; //tipoGPS, tipoINS y param
		IO_DOUBLE_memcpy_double(&pfich->tiempo0,&pmem->tiempo0,22);
		pfich->n=pmem->n;
		*(uint*)&pfich->bg=*(uint*)&pmem->bg; //bg y bi
		pfich->peso=pmem->peso;
		pmem++, pfich++;
	}
}

void CentroProy32_a_ptr(CentroProy* pmem, CentroProy_32* pfich, uint n, char8_t* nombres){
	while(n){ n--;
		pmem->nom=nombres+pfich->index;
		double_memcpy_IO_DOUBLE(&pmem->P.X,&pfich->P.X,12);
		*(uint*)&pmem->gggppp=*(uint*)&pfich->gggppp;  //gp, gp2 y b
		pmem->peso=pfich->peso;
		pfich++, pmem++;
	}
}
void PuntoM32_a_ptr(PuntoM* pmem, PuntoM_32* pfich, uint n, char8_t* nombres){
	while(n){ n--;
		pmem->nom=nombres+pfich->index;
		double_memcpy_IO_DOUBLE(&pmem->P.X,&pfich->P.X,3);
		pmem->bbb=pfich->bbb;
		pmem->peso=pfich->peso;
		pfich++, pmem++;
	}
}
void PuntoGPSINS32_a_ptr(PuntoGPSINS* pmem, PuntoGPSINS_32* pfich, uint n, char8_t* nombres){
	while(n){n--;
		pmem->nom=nombres+pfich->index;
		double_memcpy_IO_DOUBLE(&pmem->P.X,&pfich->P.X,16);
		*(uint*)&pmem->bg=*(uint*)&pfich->bg; //bg y bi
		pmem->grupo=pfich->grupo;
		*(uint*)&pmem->tipoGPS=*(uint*)&pfich->tipoGPS; //tipoGPS, tipoINS y param
		pmem->peso=pfich->peso;
		pfich++, pmem++;
	}
}
void GrupoGPSINS32_a_ptr(GrupoGPSINS* pmem, GrupoGPSINS_32* pfich, uint n, char8_t* nombres){
	while(n){n--;
		pmem->nom=nombres+pfich->index;
		*(uint*)&pmem->tipoGPS=*(uint*)&pfich->tipoGPS; //tipoGPS, tipoINS y param
		double_memcpy_IO_DOUBLE(&pmem->tiempo0,&pfich->tiempo0,22);
		pmem->n=pfich->n;
		*(uint*)&pmem->bg=*(uint*)&pfich->bg; //bg y bi
		pmem->peso=pfich->peso;
		pfich++, pmem++;
	}
}

static const uint FicheroBnfSizeof[]={	//Sizeof de cada elemento en el fichero, en 4-bytes
	0,
	1, 2, 3, 4,				//Para char8_t y char16_t es menor que 1, y como no hay más casos no merece
	0, 0,					//la pena un tratamiento general, p.e. escribiendo -1, -2.
	1, 2,
	uintsizeof(CentroProy_32),
	uintsizeof(PuntoM_32),
	uintsizeof(PuntoGPSINS_32),
	uintsizeof(GrupoGPSINS_32),
};

typedef struct{
	SistemaInformacion infor;
	SistemaDefinicion sis;
} BnfSistema;


#define TIPOBNFV_U 1 //uint
#define TIPOBNFV_U8 2 //u8int
#define TIPOBNFV_W 3 //char16_t
#define TIPOBNFV_F 4 //float
#define TIPOBNFV_O 0 //otro

typedef struct{
	const char8_t* nom;
	uint offset;
	uint tipo;
}Varios_Field;

static const Varios_Field varios_fields[]={
	{"Ncalc CentrosProy", offsetof(BnfVarios,ncalc.ncp), TIPOBNFV_U}, //0
	{"Ncalc PuntosM", offsetof(BnfVarios,ncalc.npm), TIPOBNFV_U}, //1
	{"Ncalc puntosA", offsetof(BnfVarios,ncalc.npy), TIPOBNFV_U}, //2
	{"Ncalc GruposGPS", offsetof(BnfVarios,ncalc.ngruposgps), TIPOBNFV_U}, //3
	{"Ncalc GruposINS", offsetof(BnfVarios,ncalc.ngruposins), TIPOBNFV_U}, //4
	{"Ncalc puntosGPS", offsetof(BnfVarios,ncalc.ngps), TIPOBNFV_U}, //5
	{"Ncalc puntosINS", offsetof(BnfVarios,ncalc.nins), TIPOBNFV_U}, //6
	{"Ncalc Autocalibracion", offsetof(BnfVarios,ncalc.ngruposcalib), TIPOBNFV_U}, //7 //Conjuntos de parámetros, Sólo puede valer 0 o 1
	{"Sigma_a_priori coordenadas_imagen", offsetof(BnfVarios,apriori.im), TIPOBNFV_F}, //8
	{"Sigma_a_priori apoyoXY", offsetof(BnfVarios,apriori.pXY), TIPOBNFV_F}, //9
	{"Sigma_a_priori apoyoZ", offsetof(BnfVarios,apriori.pZ), TIPOBNFV_F}, //10
	{"Sigma_a_priori gpsXY", offsetof(BnfVarios,apriori.gpsXY), TIPOBNFV_F}, //11
	{"Sigma_a_priori gpsZ", offsetof(BnfVarios,apriori.gpsZ), TIPOBNFV_F}, //12
	{"Sigma_a_priori insWF", offsetof(BnfVarios,apriori.insΩΦ), TIPOBNFV_F}, //13
	{"Sigma_a_priori insK", offsetof(BnfVarios,apriori.insK), TIPOBNFV_F}, //14
	{"Sigma_a_posteriori global", offsetof(BnfVarios,σ_aposteriori), TIPOBNFV_F}, //15
	{"Sigma_a_posteriori coordenadas_imagen", offsetof(BnfVarios,aposteriori.im), TIPOBNFV_F}, //16
	{"Sigma_a_posteriori apoyoXY", offsetof(BnfVarios,aposteriori.pXY), TIPOBNFV_F}, //17
	{"Sigma_a_posteriori apoyoZ", offsetof(BnfVarios,aposteriori.pZ), TIPOBNFV_F}, //18
	{"Sigma_a_posteriori gpsXY", offsetof(BnfVarios,aposteriori.gpsXY), TIPOBNFV_F}, //19
	{"Sigma_a_posteriori gpsZ", offsetof(BnfVarios,aposteriori.gpsZ), TIPOBNFV_F}, //20
	{"Sigma_a_posteriori insWF", offsetof(BnfVarios,aposteriori.insΩΦ), TIPOBNFV_F}, //21
	{"Sigma_a_posteriori insK", offsetof(BnfVarios,aposteriori.insK), TIPOBNFV_F}, //22
	{"Redundancia_parcial coordenadas_imagen", offsetof(BnfVarios,redun_parciales.foto), TIPOBNFV_F}, //23
	{"Redundancia_parcial apoyo", offsetof(BnfVarios,redun_parciales.apoyo), TIPOBNFV_F}, //24
	{"Redundancia_parcial gps", offsetof(BnfVarios,redun_parciales.gps), TIPOBNFV_F}, //25
	{"Redundancia_parcial ins", offsetof(BnfVarios,redun_parciales.ins), TIPOBNFV_F}, //26
	{"Numero observaciones", offsetof(BnfVarios,nobs), TIPOBNFV_U}, //27
	{"Numero incognitas", offsetof(BnfVarios,nincog), TIPOBNFV_U}, //28
	{"Unidades_giros", offsetof(BnfVarios,uni), TIPOBNFV_U8}, //29
	{"Tipo_de_fichero fotogramas", offsetof(BnfVarios,tipos_fich.mar), TIPOBNFV_U8}, //30
	{"Tipo_de_fichero aproximadas", offsetof(BnfVarios,tipos_fich.prm), TIPOBNFV_U8}, //31
	{"Tipo_de_fichero apoyo", offsetof(BnfVarios,tipos_fich.pym), TIPOBNFV_U8}, //32
	{"Tipo_de_fichero gps/ins", offsetof(BnfVarios,tipos_fich.gpm), TIPOBNFV_U8}, //33
	{"Tipo_de_fichero camara", offsetof(BnfVarios,tipos_fich.inm), TIPOBNFV_U8}, //34
	{"Estimador", offsetof(BnfVarios,estimador), TIPOBNFV_U8}, //35
	{"Fichero fotogramas", offsetof(BnfVarios,ficherof), TIPOBNFV_W}, //36
	{"Fichero aproximadas", offsetof(BnfVarios,ficheroapr), TIPOBNFV_W}, //37
	{"Fichero apoyo", offsetof(BnfVarios,ficheroapy), TIPOBNFV_W}, //38
	{"Fichero gps/ins", offsetof(BnfVarios,ficherogps), TIPOBNFV_W}, //39
	{"Fichero camara", offsetof(BnfVarios,ficheroint), TIPOBNFV_W}, //40
	{"Sistema_coordenadas", offsetof(BnfVarios,sis), TIPOBNFV_O}, //41
	{NULL,0,0}
};
#define N_ENTEROS BNF_N_ENTEROS
#define N_PEQUENOS 35
#define N_GRANDES 7
#define N_VARIOS (N_PEQUENOS+N_GRANDES)
