﻿#include "grafico_memoria_shared.h"

typedef struct{
	ElemenCabecera H;
	PuntoXYZ_double P;
} GraPunto;

typedef struct{
	ElemenCabecera H;
	uint n;
	PuntoXYZ_double P1; //Primer punto
} GraPoligonal;

typedef struct{
	ElemenCabecera H;
	PuntoXYZ_double centro;
	uint n;
	PuntoXYZ_double P1; //Primer punto
} GraPoligono;

typedef struct{
	ElemenCabecera H;
	PuntoXYZ_double P;
	PuntoXYZ_float δp;
} GraVector;

typedef struct{
	ElemenCabecera H;
	PuntoXYZ_double P;
	uint n;
	PuntoXYZ_float δp1; //Primer punto
} GraRayos;

typedef struct{
	ElemenCabecera H;
	uint n;
	PuntoXYZ_double P1; //Primer punto
	PuntoXYZ_float δp1; //primer punto
} GraPoligonalEscalable;

typedef struct{
	ElemenCabecera H;
	PuntoXYZ_double P;
	PuntoXYZ_float δa;
	PuntoXYZ_float δb;
} GraElipse;

typedef struct{
	ElemenCabecera H;
	PuntoXYZ_double P;
	float σxx;
	float σxy, σyy;
	float σxz, σyz, σzz;
} GraElipsoide;

#define Gra_VALUE_MAX /*0x1P125*/ 4.25E+37  //Valor máximo para cualquier coordenada almacenada en el fichero y en el sistema
						//interno, sea IO_SINGLE o IO_DOUBLE. En el sistema vista, debido al giro, alguna coordenada puede llegar
						//a raiz(3) por este valor, y un valor de σ_xx, etc. a (1.5)*2^126, que sigue siendo representable en float.
						//Este visor también emplea este límite para el valor l que pasa al sistema lienzo, de manera
						//que la operación, efectuada en doubles, X*l+Tx no se hace infinito en ningún paso. La limitación
						//a Tx y Ty viene de manera indirecta a través de la limitación de los valores máximos de los bordes de
						//la ventana en el sistema vista.
#define MAX_ZOOM	1.0E+14		//Límite para Tx y Ty
#define MAX_LIENZO 1000000000	//Valor máximo para las coordenadas en el sistema lienzo un elemento puntual a dibujar
									//y los extremos de la ventana en el sistema lienzo.

//tamaño, en 4-bytes, de cada clase de elem. gráfico en memoria
#define TAMAÑOmemPUNTO uintsizeof(GraPunto)
#define TAMAÑOmemPOLIGONAL_BASE uintoffsetof(GraPoligonal,P1)
#define TAMAÑOmempoligonal(n) (TAMAÑOmemPOLIGONAL_BASE+uintsizeof(PuntoXYZ_double)*(n))
#define TAMAÑOmemPOLIGONO_BASE uintoffsetof(GraPoligono,P1)
#define TAMAÑOmempoligono(n) (TAMAÑOmemPOLIGONO_BASE+uintsizeof(PuntoXYZ_double)*(n))
#define TAMAÑOmemVECTOR uintsizeof(GraVector)
#define TAMAÑOmemRAYOS_BASE uintoffsetof(GraRayos,δp1)
#define TAMAÑOmemrayos(n) (TAMAÑOmemRAYOS_BASE+uintsizeof(PuntoXYZ_float)*(n))
#define TAMAÑOmemPOLIGONALESC_BASE uintoffsetof(GraPoligonalEscalable,P1)
#define TAMAÑOmempoligonalesc(n) (TAMAÑOmemPOLIGONALESC_BASE+(uintsizeof(PuntoXYZ_double)+uintsizeof(PuntoXYZ_float))*(n))
#define TAMAÑOmemELIPSE uintsizeof(GraElipse)
#define TAMAÑOmemELIPSOIDE uintsizeof(GraElipsoide)

typedef struct{
	u8int btipo;	//0: just translation; 2:Espec. para geog. X<-->Y. 1: none of the prec.;
	double X0, Y0;	//si btipo=0, todos salvo X0 e Y0 pueden estar unset. Para >=1
	double cos_conv0, sin_conv0;	//deben estar todos asignados
	double k0x, k0y;	//these must be positive
	double kxδx, kxδy;
	double kyδx, kyδy;	//ky∂x, etc. Pero el compilador no lo permite, así que δ en lugar de ∂
} TerrenoaInterno;
sinline double TerrInterno_katx(const TerrenoaInterno *T,double X,double Y){return T->k0x+T->kxδx*X+T->kxδy*Y;}
sinline double TerrInterno_katy(const TerrenoaInterno *T,double X,double Y){return T->k0y+T->kyδx*X+T->kyδy*Y;}
sinline double TerrInterno_kxmedio(const TerrenoaInterno *T,double X,double Y){return T->k0x+0.5*(T->kxδx*X+T->kxδy*Y);}
sinline double TerrInterno_kymedio(const TerrenoaInterno *T,double X,double Y){return T->k0y+0.5*(T->kyδx*X+T->kyδy*Y);}

defineGrowing(EntradaTablaElems)
defineGrowing(EntradaTablaCompuestos)
defineGrowing(EntradaTablaTextos)
typedef Growing_EntradaTablaElems TablaElementos;
typedef Growing_EntradaTablaCompuestos TablaCompuestos;
typedef Growing_EntradaTablaTextos TablaTextos;

typedef struct{uint *pos; uint tamaño;} GraBloque;

typedef struct strGra_Graficoenmemoria{
	struct{
		uint *cabecera; //FGraCabecera*
		uint* keyvals;
		uint *sistema; //FGraSistema*
	} file;
	TerrenoaInterno sis_interno;
	Growing_uint orden_elementos;
	TablaElementos tabla_elementos;	//Se guardará el elemento de cierre (pos=0), para poder recorrerlo sin necesidad del puntero next
	TablaCompuestos tabla_compuestos;
	TablaTextos tabla_textos;
	GraBloque bloque_compuestos;
	GraBloque bloque_textos;
	GraBloque bloque_grafico;	//Con las coordenadas en el sistema interno. Elems. de tipo GraElementoGenerico. Todos los valores "reales" son double
	Extremos3D_dbl minmaxI;	//En el sistema interno, dependen de la configuración
} Gra_GraficoenMemoria;
