﻿/*Elemento intermedio entre el fichero y la estructura en memoria.
Al leer un fichero de gráfico se devuelve una instancia de esta estructura
con punteros a posiciones que hay que liberar. Los bloques de memoria
apuntados por los punteros se rellenan con la parte del contenido del
fichero que corresponda tal cual.
Para las tablas (elementos de tipo LGraTabla) se copia a partir
del primer registro, almacenando el tamaño en una variable a parte.
*/
typedef struct{
	uint tipo;	//tiene que ser CODIGO_CCL_FCONFIG
	uint tamaño;
	uint uint2;
	uint nombre[125];
	uint ARRAY_fichero;
} GraFConfig;

typedef struct{uint tamaño; uint *registros;} LGraTabla;

typedef struct{
	FGraCabecera *cabecera;
	uint* keyvals;
	FGraSistema *sistema;
	GraFConfig *fichero_config[16];	//NULL marca el final. El último se deja permanentemente a NULL
	LGraTabla orden_elementos;
	LGraTabla tabla_elementos;
	LGraTabla tabla_compuestos;
	LGraTabla tabla_textos;
	/*alignas(sizeof(void*))*/ GraBloque bloque_grafico;
	/*alignas(sizeof(void*))*/ GraBloque bloque_compuestos;
	/*alignas(sizeof(void*))*/ GraBloque bloque_textos;
} GraficoLeido;
