#pragma once

//FGraCabecera está aquí porque se almacena en memoria tal cual
typedef struct{
	IO_DOUBLE mx, MX,
			my, MY,
			mz, MZ;
} Extremos3D_DBL;

typedef struct{
	uint uint0;
	uint uint1;
	Extremos3D_DBL extremos;
} FGraCabecera;
#define TAMAÑO_CABECERA 14

#define TIPO_MAX 0xFFFFF  //El tipo máximo no está permitido. Por tanto, el máximo posible es 0xFFFFE. Véase la documentación
#define TIPO_RANGE 0x100000
#define SUBTIPO_MAX 0xFFF
#define SUBTIPO_RANGE 0x1000
#define MASK_TIPO(n) ((n)<<12)
#define MASK_SUBTIPO(n) (n)
#define mask_tipo(Tipo) (((Tipo)>>12)&TIPO_MAX)
#define mask_subtipo(Tipo) ((Tipo)&SUBTIPO_MAX)
#define tipo_is_especial(tipo) ((tipo)>=0xFFFFA)

#define MASK_APAGADO 0x80000000
#define MASK_FLOAT 0x80
#define mask_clase(Clase) ((Clase)&0x7F)
#define mask_float(Clase) (((Clase)&0x80)!=0)
#define mask_apagado(Clase) (((Clase)&0x80000000)!=0)

#define CGRA_Punto		0
#define CGRA_Poligonal	1
#define CGRA_Poligono	2
#define CGRA_Vector		3
#define CGRA_Rayos		4
#define CGRA_Poligonal_escalable	5
#define CGRA_Elipse		6
#define CGRA_Elipsoide	7
#define CGRA_Spline		8
#define CGRA_Texto2D	9
#define CGRA_Texto3D	10

#define CODIGO_KEYVAL_ENTERO 0
#define CODIGO_KEYVAL_FLOAT 1
#define CODIGO_KEYVAL_DOUBLE 2
#define CODIGO_KEYVAL_TEXTO 3

/*Sistema de coordenadas*/
#define SubTIPO_SISTEMA_Rectangular 0
#define SubTIPO_SISTEMA_ConformeG 1
#define SubTIPO_SISTEMA_Lambert 2
#define SubTIPO_SISTEMA_UTM 3
#define SubTIPO_SISTEMA_Estereográfica 4
#define SubTIPO_SISTEMA_Geográficas 10
#define SubTIPO_SISTEMA_OrtogonalG 11

struct EntradaTablaMinima{uint pos;};
typedef struct{uint pos; uint compuesto;} EntradaTablaElems, EntradaTablaCompuestos;
typedef struct EntradaTablaMinima EntradaTablaTextos;
//orden_elementos es uint, y así sería cualquier otro orden_... que hubiese

#define get_refcount get_byte2
#define set_refcount set_byte2
#define inc_refcount(texto) set_refcount((texto),get_refcount(texto)+1)
#define get_tamañotexto(texto) get_bytes01(texto)
#define get_cadenatexto(texto) ((texto)+1)
