﻿//Elementos según están en el fichero.
//uint:		1 4-byte
//IO_SINGLE:		1 4-byte
//IO_DOUBLE:		2 4-byte
#include "Clases_genDibujo.h" //La parte que se expone al exterior
#include "Clases_grafico_independiente.h" //Estructuras que son iguales en el fichero y en memoria

#define POS_TIPO	0	 //tipo y subtipo
#define POS_TAMAÑO 1
#define POS1 2	//posición de la primera entrada de la tabla

#define CODIGO_INDICEGENERAL 0xFFFFD000
#define CODIGO_CCL_SISTEMA 0xFFFFE000
#define CODIGO_CCL_KEYVALS 0xFFFFD001
#define CODIGO_CCL_FCONFIG 0xFFFFD002
#define CODIGO_CCL_TABLA_ELEMENTOS 0xFFFFD003
#define CODIGO_CCL_TABLA_COMPUESTOS 0xFFFFD004
#define CODIGO_CCL_TABLA_TEXTOS 0xFFFFD005
#define CODIGO_CCL_ORDEN_ELEMENTOS 0xFFFFD00A
#define CODIGO_BLOQUE_GRAFICO 8
#define CODIGO_BLOQUE_COMPUESTOS 9
#define CODIGO_BLOQUE_TEXTOS 10

#define FCONFIG_MAX_NOMBRE 125
#define TAMANNOFCONFIG_BASE (3+FCONFIG_MAX_NOMBRE)
typedef struct{
	uint Tipo;
	uint tamaño;
	uint prenombre;
	uint nombre[FCONFIG_MAX_NOMBRE];
	Growing_char16_t fichero;	//se pasa a uints al final
} FGraFConfigInsertado;
typedef struct{
	FGraFConfigInsertado fconfig[5];
	Growing_uint orden_elementos;
	Growing_uint tabla_elementos;
	Growing_uint tabla_compuestos;
	Growing_uint tabla_textos;
} FGraElementosCCL;

typedef struct{
	uint Tipo;
	uint tamaño;
} FGraSistema_Rectangular;

typedef struct{
	uint Tipo;
	uint tamaño;
	IO_DOUBLE X0, Y0;
	IO_DOUBLE ond;
	IO_DOUBLE N, ρ;
	IO_DOUBLE cosγ0, sinγ0;
	IO_DOUBLE k0;
	IO_DOUBLE k[5];
} FGraSistema_ConformeGenerico;

typedef struct{
	uint Tipo;
	uint tamaño;
	IO_DOUBLE a, e, ond;
	IO_DOUBLE φ0;
	IO_DOUBLE k0;
	IO_DOUBLE xO, yS;
	IO_SINGLE λ0;	//Opcional
} FGraSistema_Lambert;

typedef struct{
	uint Tipo;
	uint tamaño;
	IO_DOUBLE a, e, ond;
	IO_DOUBLE k0;
	IO_DOUBLE xO, yS;
	IO_SINGLE λ0;	//Opcional
} FGraSistema_UTM;

typedef struct{
	uint Tipo;
	uint tamaño;
	IO_DOUBLE R, e, ond;
	IO_DOUBLE k0;
	IO_DOUBLE xO, yS;
	IO_SINGLE λ0;	//Opcional. [-360 - -0] en el h. N. [0-360] en el h. Sur.
} FGraSistema_Estereográfica;

typedef struct{
	uint Tipo;
	uint tamaño;
	IO_DOUBLE a, e, ond;
	uint orden;	//el bit bajo indica: =0 (φ,λ), =1 (λ,φ)
} FGraSistema_Geográficas;

typedef struct{
	uint Tipo;
	uint tamaño;
	IO_DOUBLE X0, Y0;
	IO_DOUBLE ond;
	IO_DOUBLE φ0, N, ρ;
	IO_DOUBLE cosγ0, sinγ0;
	IO_DOUBLE k0x, k0y;
	IO_DOUBLE k[4];
} FGraSistema_OrtogonalGenerico;

typedef union{
	FGraSistema_Rectangular Rectangular;
	FGraSistema_ConformeGenerico ConformeG;
	FGraSistema_Lambert Lambert;
	FGraSistema_UTM UTM;
	FGraSistema_Estereográfica Estereográfica;
	FGraSistema_Geográficas Geográficas;
	FGraSistema_OrtogonalGenerico OrtogonalG;
} FGraSistema;

#define TAMAÑO_SISTEMA 30
#define TAMAÑOSISTEMA_Rectangular 2
#define TAMAÑOSISTEMA_ConformeG 28
#define TAMAÑOSISTEMA_Lambert 17
#define TAMAÑOSISTEMA_UTM 15
#define TAMAÑOSISTEMA_Estereográfica 15
#define TAMAÑOSISTEMA_Geográficas 9
#define TAMAÑOSISTEMA_OrtogonalG 30
/*Fin Sistema de coordenadas*/

//Entradas de cada tabla
typedef struct{uint Cod; uint pos; uint tamaño_bloque;} FGraEntradaIndice;

//Macros para el tamaño y número de entradas de los distintos índices
//El primer elementos siempre es el 1. nt y num_elem son inversos
#define nt(tabla,n) ((POS1-tamaño_entrada_##tabla) +tamaño_entrada_##tabla*(n))
#define isaligned_n(tabla,n) ((n)>=POS1 && (((n)-POS1)%tamaño_entrada_##tabla==0))
#define num_elem(tabla,pos_elem) (((pos_elem)-POS1)/tamaño_entrada_##tabla+1)
#define num_elementos(tabla,nombre_tabla) ((tabla[POS_TAMAÑO]-POS1)/tamaño_entrada_##nombre_tabla)

#define tamaño_entrada_indicegeneral 3
#define tamaño_entrada_keyvaks 1	//
#define tamaño_entrada_tabla_elems 2
#define tamaño_entrada_tabla_compuestos 2
#define tamaño_entrada_tabla_textos 1
#define tamaño_entrada_orden_elementos 1

//ntexto tiene que ser valido
sinline uint* address_of_texto(uint* tabla_textos, uint ntexto, uint* bloque_textos){
	uint add=tabla_textos[nt(tabla_textos,ntexto)]&0x7FFFFFFU;
	return bloque_textos+add;
}

/*Elementos gráficos*/
typedef struct{
	uint *ppio;
	pUFD next;
	uint capacidad;
	uint hueco;
} FGraBloqueGrafico;

typedef struct{
	uint Tipo;	//tipo y subtipo
	uint tamaño;
	uint pos_info;
	uint Clase;	//El segundo bit más alto es el bit es el de simple precisión.
					//Los cuatro bit más bajos indican la clase geométrica
	uint nombre;
} FGraElemenCabecera;

typedef struct{
	FGraElemenCabecera H;
	uint VLA_partegrafica;	//primer 4-byte de la parte gráfica
} FGraElementoGenerico;

typedef struct{
	FGraElemenCabecera H;
	IO_DOUBLE X,Y,Z;
} FGraPunto;

typedef struct{
	FGraElemenCabecera H;
	uint n;
	IO_DOUBLE X1,Y1,Z1; //Primer punto
} FGraPoligonal;

typedef struct{
	FGraElemenCabecera H;
	IO_DOUBLE cX,cY,cZ;
	uint n;
	IO_DOUBLE X1,Y1,Z1; //Primer punto
} FGraPoligono;

typedef struct{
	FGraElemenCabecera H;
	IO_DOUBLE X,Y,Z;
	IO_SINGLE δx,δy,δz;
} FGraVector;

typedef struct{
	FGraElemenCabecera H;
	uint n;
	IO_DOUBLE X1,Y1,Z1; //Primer punto
	IO_SINGLE δx1,δy1,δz1; //Primer punto
} FGraPoligonalEscalable;

typedef struct{
	FGraElemenCabecera H;
	IO_DOUBLE X,Y,Z;
	IO_DOUBLE ax, ay, az;
	IO_DOUBLE bx, by, bz;
} FGraElipse_d;

typedef struct{
	FGraElemenCabecera H;
	IO_DOUBLE X,Y,Z;
	IO_SINGLE ax, ay, az;
	IO_SINGLE bx, by, bz;
} FGraElipse_f;

typedef struct{
	FGraElemenCabecera H;
	IO_DOUBLE X,Y,Z;
	IO_DOUBLE σxx;
	IO_DOUBLE σxy, σyy;
	IO_DOUBLE σxz, σyz, σzz;
} FGraElipsoide_d;

typedef struct{
	FGraElemenCabecera H;
	IO_DOUBLE X,Y,Z;
	IO_SINGLE σxx;
	IO_SINGLE σxy, σyy;
	IO_SINGLE σxz, σyz, σzz;
} FGraElipsoide_f;

//tamaño, en 4-bytes, de cada clase de elem. gráfico
#define TAMAÑOPUNTO uintsizeof(FGraPunto)
#define TAMAÑOPOLIGONAL_BASE uintsizeof(FGraPoligonal)-6
#define TAMAÑOpoligonal(n) (TAMAÑOPOLIGONAL_BASE+6*(n))
#define TAMAÑOPOLIGONO_BASE uintsizeof(FGraPoligono)-6
#define TAMAÑOpoligono(n) (TAMAÑOPOLIGONO_BASE+6*(n))
#define TAMAÑOVECTOR uintsizeof(FGraVector)
#define TAMAÑOPOLIGONALESC_BASE uintsizeof(FGraElemenCabecera)+1
#define TAMAÑOpoligonalesc(n) (TAMAÑOPOLIGONALESC_BASE+9*(n))
#define TAMAÑOELIPSE_F uintsizeof(FGraElipse_f)
#define TAMAÑOELIPSE_D uintsizeof(FGraElipse_d)
#define TAMAÑOELIPSOIDE_F uintsizeof(FGraElipsoide_f)
#define TAMAÑOELIPSOIDE_D uintsizeof(FGraElipsoide_d)
