﻿#pragma once
#include <AT2D3D/AT2D3D.h>

typedef struct{
	const char16_t *nombre; //Si >250 se trunca. Si nombre!=NULL fichero es un string que se copia tal cual al fichero de gráfico.
	const char16_t *fichero;  //Si nombre=NULL fichero es el numbre de un fichero que se lee y cuyo contenido se copia.
} GragenFconfig;				//El final de un array viene marcado por un elemento con nombre=NULL y fichero=NULL.

#define TIPO_MAX 0xFFFFF
#define TIPO_RANGE 0x100000
#define SUBTIPO_MAX 0xFFF
#define SUBTIPO_RANGE 0x1000
#define MASK_TIPO(n) ((n)<<12)
#define MASK_SUBTIPO(n) (n)
#define mask_tipo(Tipo) (((Tipo)>>12)&TIPO_MAX)
#define mask_subtipo(Tipo) ((Tipo)&SUBTIPO_MAX)

//Códigos de las clases
#define CGRA_Punto		0
#define CGRA_Poligonal	1
#define CGRA_Poligono	2
#define CGRA_Vector		3
#define CGRA_Rayos		4
#define CGRA_Poligonal_escalable	5
#define CGRA_Elipse		6
#define CGRA_Elipsoide	7
#define CGRA_Spline		8
#define CGRA_Texto2D	9
#define CGRA_Texto3D	10

#define MASK_FLOAT 0x80 //For texts. Not yet available as GraGen... elements
#define mask_clase(Clase) ((Clase)&0x7F)
#define mask_float(Clase) (((Clase)&0x80)!=0) //The same as above

typedef struct{
	uint Clase;
	uint Tipo;
	char8_t* nombre;
} GragenGenerico;

typedef struct{
	uint Clase; // =CGRA_Punto
	uint Tipo;
	char8_t* nombre;
	PuntoXYZ_double P;
} GragenPunto;

typedef struct{
	uint Clase; // =CGRA_Poligonal
	uint Tipo;
	char8_t* nombre;
	uint npuntos;
	PuntoXYZ_double* Ps;
} GragenPoligonal;

typedef struct{
	uint Clase; // =CGRA_Poligono
	uint Tipo;
	char8_t* nombre;
	uint npuntos;
	PuntoXYZ_double centro;
	PuntoXYZ_double* borde;
} GragenPoligono;

typedef struct{
	uint Clase; // =CGRA_Vector
	uint Tipo;
	char8_t* nombre;
	PuntoXYZ_double P;
	PuntoXYZ_float dP;
} GragenVector;

typedef struct{
	uint Clase; // =CGRA_Poligonal_escalable
	uint Tipo;
	char8_t* nombre;
	uint npuntos;
	PuntoXYZ_double* Ps;
	PuntoXYZ_float* dPs;
} GragenPoligonal_Escalable;

typedef struct{
	uint Clase; // =CGRA_Elipsoide
	uint Tipo;
	char8_t* nombre;
	PuntoXYZ_double centro;
	float σxx;
	float σxy,σyy;
	float σxz,σyz,σzz;
} GragenElipsoide;

#define GRAGEN_EMPTY (GragenGenerico){AT_NODATA,AT_NODATA,NULL}
