﻿#pragma once
#include <stdbool.h>
#include <ATcrt/ATarrays.h>

#define Q_None		Я		//No se especifica cualidad. Se aplica en las cláusulas from
enum GraphicQuality{  /*unsigned char8_t (umint)*/
	Q_All=0,
	Q_Color=1, Q_FormaP, Q_Escala,
	Q_Grosor, Q_GrosorT, Q_Estilol,
	Q_EstiloV, Q_ColorP, Q_ModoRadios,
	Q_Color2, Q_Grosor2, Q_GrosorT2, Q_Estilol2,
	Q_ModoBR, Q_SizeT, Q_Font,
	Q_Size,
	Q_unknown //Unknowns are read as strings, up to the end of the line
};

typedef struct{
	const char16_t *name;
	umint val_type;
	umint category;
} GraphicQualityInfo;

#define QValtype_None 0
#define QValtype_dec 1		//by default decimal
#define QValtype_hex 2		//hexadecimal
#define QValtype_float 3
#define QValtype_flags 4
#define QValtype_string 5

//Las categorías se emplean para saber para cada cualidad de qué otras
//puede tomar el valor.
#define QCat_All 0
#define QCat_Color 1
#define QCat_Size 2
#define QCat_SizeT 3
#define QCat_FormaP 4
#define QCat_Escala 5
#define QCat_Estilol 6
#define QCat_EstiloV 7
#define QCat_ModoRadios 8
#define QCat_ModoBR 9
#define QCat_FontName 10
#define QCat_Desconocido 20

//e.g. KnownQualityNames[Q_Color]=u"Color"
extern
#ifdef __cplusplus
"C"
#endif
GraphicQualityInfo QualityInfos[];

typedef union{	//same as the 'val' from KeyVal
	void* ptr;
	uint n;
	float fl;
} ValorQuality;

/*Valores posibles de kind*/
#define QFrom_None 0
#define QFrom_Tipo 1
#define QFrom_Tipo_text 2
#define QFrom_TipoSubtipo 3
#define QFrom_TipoSubtipo_text 4
#define QFrom_Subtipo 5
#define QFrom_Subtipo_text 6
#define QFrom_this 7
#define QFrom_this_text 8
#define QFrom_MAX 8

#define QFrom_istexto(kind) ((kind)>0 && !((kind)&1))
#define QFrom_hasTipo(kind) ((kind)>=1 && (kind)<=4)
#define QFrom_hasSubtipo(kind) ((kind)>=3 && (kind)<=6)

//Valores de flags para fromQ abajo cuando nqual es Q_All
//Si from All aparece dentro de \Representación o \Texto
//El tipo será siempre fromQAll_OnlyQualities
#define fromQAll_OnlyQualities 0
#define fromQAll_Texto 1
#define fromQAll_Significado 2
#define fromQAll_Subtipos 2

typedef struct{
	u8int kind;
	uint Tipo;	//Se usa si 1<=kind<=6. In all these cases Tipo may equal this one. mask_tipo(Tipo) y mask_subtipo(Tipo) devuelven los valores respectivos.
} FromClause;
typedef struct _Quality{
	FromClause from;
	uint nqual;	//index into an array of GraphicQualityInfos.
	union{
		ValorQuality value;		//If from.kind is zero (QFrom_None), this holds the value.
		uint fromQ;		//Otherwise from.kind is not zero. (1) If nqual!=Q_All fromQ holds the code
	};						/*Q_... of the name of the quality specified in the from clause. If there was none, wherefore
							the quality is the same as this one, fromQ==Q_None. The slight difference between
							fromQ==name and fromQ==Q_None is to be able to write back the cfg file as
							the user wrote it.
								(2) Si name==Q_All fromQ&1 indica si también afecta a Texto,
							y fromQ&2 si afecta a Significado y, en un tipo, a los subtipos. Si Quality está dentro
							del LinkedQualities de cualid_texto, from.kind=1,2,5 equiv. a 3,4,6 resp. Se mantienen los
							valores originales para poder escribir el fichero cfg como lo tenía el usuario.*/
} Quality;
typedef struct _LinkedQuality{
	struct _LinkedQuality *next;
	bint file;	//v. infra
	Quality q;
} LinkedQuality;

/*Valores de kind*/
#define CriterioSub_Numero 0		//Un valor exacto, que se almacena en number (exactamente, valor&SUBTIPO_MAX).
#define CriterioSub_Rango 1			//min<= s <=max. number&SUBTIPO_MAX=min; number&(SUBTIPO_MAX<<16)=max;
#define CriterioSub_Ormask 2		//mask. s&valor must not be zero.
#define CriterioSub_Andmask 3		//Mask. s&valor must equal valor.
#define CriterioSub_Array 4			//Pointer to an array of CriterioSub_ArrayLength uint, which make SUBTIPO_RANGE bits, each for each subtype.
#define CriterioSub_Expression 5	//Pointer to a boolean expression.
#define CriterioSub_ArrayLength (SUBTIPO_RANGE>>5)
typedef struct{	//En solved subtipos el tipo 5º no se usará: se evaluará y se almacenará como tipo 4.
	u8int kind;
	union{
		uint number;
		uint* array;
		char16_t* expr;
	} valor;
} CriterioSubtipo;
//Generic struct for generic functions
typedef struct _LinkedSubtipos{
	struct _LinkedSubtipos *next;
	CriterioSubtipo criterio;
} LinkedSubtipos;

typedef struct{
	struct{bint file; char16_t* string;} Significado;
	struct{bint file; char16_t* string;} SignificadoR;
	LinkedQuality *cualidades;
	LinkedQuality *cualid_texto;
} ConfigSubtipo;

typedef struct _LinkedConfigSubtipo{
	struct _LinkedConfigSubtipo *next;
	CriterioSubtipo criterio;
	bint file;
	ConfigSubtipo S;
} LinkedConfigSubtipo;

typedef struct{
	struct{bint file; char16_t* string;} Significado;
	struct{bint file; char16_t* string;} SignificadoR;
	LinkedQuality *cualidades;
	LinkedQuality *cualid_texto;
	LinkedConfigSubtipo *subtipos;
} ConfigTipo;

typedef struct{
	char16_t* Significado;
	/*to be defined*/
} Agrupacion;

typedef struct{
	uint n;
	/*to be defined*/
} Seleccion;

typedef struct _LinkedSeleccionVer{
	struct _LinkedSeleccionVer *next;
	u8int towhat;	//bit0: the element (.); bit1: the text; bit8: 0=positive selection, 1=negative
	Seleccion criterio;
} LinkedSeleccionVer;

typedef struct{
	Hash_huint ver;		//Los elementos presentes son los que están off
	Hash_huint verT;	//Los elementos presentes son los que están on
	LinkedSeleccionVer *criterios;
} VerInfo;

typedef struct _LinkedJerarquia{
	struct _LinkedJerarquia *next;
	bint towhat;	//0, la agrupacion,; 1, el tipo
	Seleccion criterio;
} LinkedJerarquia;

#define datatype ConfigTipo
#define htype hConfigTipo
#include <ATcrt/hash_uintdata.cod>

//Todos los campos `file' indican si el valor (del significado, de la cualidad, etc.) se ha tomado de este fichero
//o procede de algún otro incluido a través de \input. 0: este; 1: otro.
typedef struct strGra_FConfiguracion{
	char16_t** files_depend;	//ficheros de los que depende este a través de comandos \input.
									//NULL si no hay. Si hay, un NULL indica el final.
	struct{
		char16_t *fformas;
	} ficheros;
	uint fondo;
	uint resalte;
	//GraphicQualityInfo* qualityinfos;
	Hash_hConfigTipo tipos;
	Agrupacion* (*agrupaciones)[256];
	LinkedJerarquia *jerarquias;
	VerInfo ver_info;
} Gra_FConfiguracion;

/*Formas*/
struct FormaPunto{
	u16int id;
	uint dim;	//ancho, alto
	float cx, cy;	//with respect to the center of  the top-left pixel
	const umint* matrix;	//ancho x alto.
};

static const struct FormaPunto forma_nula={0200,0,0,0,NULL};

static const umint default_punto[25]={\
		0,0,1,0,0,\
		0,1,1,1,0,\
		1,1,1,1,1,\
		0,1,1,1,0,\
		0,0,1,0,0};
static const struct FormaPunto default_forma_punto={0xFFF0,0x00050005,2.0F,2.0F,default_punto};

static const umint default_centro[9]={\
		0,1,0,\
		1,1,1,\
		0,1,0};
static const struct FormaPunto default_forma_centro={0xFFF1,0x00030003,1.0F,1.0F,default_centro};

typedef struct strLinkedGrupoFormas{
	struct strLinkedGrupoFormas *next;
	uint rango;	//números mínimo y máximo de formas a los que este grupo se aplica
	uint dim;	//ancho, alto
	float cx, cy;	//with respect to the center of  the top-left pixel
	umint* matrices; //una tras otra, cada una de ancho x alto.
} LinkedGrupoFormas;
/*Fin formas*/
/** Fin Verbatim **/

/** Solved **/
typedef struct _LinkedSolvedQuality{
	struct _LinkedSolvedQuality *next;
	uint nqual;
	ValorQuality value;
} LinkedSolvedQuality;

typedef struct{				//NULL significa que no se han resuelto. Si se resuelve y no hay ninguna
	LinkedSolvedQuality *cualidades;	//se apuntará a No_solved_quality, cuyo nombre está a 0. Esto
	LinkedSolvedQuality *cualid_texto; //indica que no hay que liberar la linked list. No vale comparar
} SolvedQualities;			//el puntero con &No_solved_quality, porque la asignación y la comparación
								//pueden ser en dll distintas, con instancias distintas de No_solved_quality
typedef struct{
	const char16_t* Significado;	//NULL significa que aún no se ha resuelto. Si se resuelve
	const char16_t* SignificadoR;	//y resulta que no hay se hará apuntar a cadena_vacia;
} SolvedSignificados;
static LinkedSolvedQuality No_solved_quality={NULL,0,0};	//const omitted to allow its asigment to a (non-const) LinkedSolvedQuality *.
static const char16_t cadena_vacia[1]=u"";

typedef struct{
	SolvedSignificados S;
	SolvedQualities Q;
} SolvedSubtipo;

typedef struct _LinkedSolvedSubtipo{
	struct _LinkedSolvedSubtipo *next;
	CriterioSubtipo criterio;
	SolvedSubtipo sub;
} LinkedSolvedSubtipo;

static inline void setnull_SolvedSubtipo(SolvedSubtipo *psubtipo){
	psubtipo->S.Significado=NULL;
	psubtipo->S.SignificadoR=NULL;
	psubtipo->Q.cualidades=NULL;
	psubtipo->Q.cualid_texto=NULL;
}

#define SSubtipo_NoWhere 0
#define SSubtipo_AtSolved 1
#define SSubtipo_AtOrphan 2
typedef struct{
	u8int where;	//0: no-where; 1: solved_subtipo; 2: orphan_subtipo
	union{
		LinkedSolvedSubtipo *psolved;
		u16int *puint;	//puntero a dentro de orphan_subtipos, o NULL si el vector no existe
	};
} Subtipo_en_SolvedTipo;

typedef struct{
	bint needs_update;
	uint* tipos_depend;	//NULL si no hay. Si hay, un -1 indica el final
} SolvedStatus;

defineVector(u16int)
typedef struct{
	SolvedStatus statusS;
	SolvedStatus statusQ;
	SolvedSignificados S;
	SolvedQualities Q;
	Vector_u16int orphan_subtipos;	//Normalmente por un tipo que no especifica subtipos
	LinkedSolvedSubtipo *subtipos;
} SolvedTipo;

void setnull_SolvedTipo(SolvedTipo *ptipo){
	ptipo->statusS.tipos_depend=NULL;
	ptipo->statusS.needs_update=false;
	ptipo->statusQ.tipos_depend=NULL;
	ptipo->statusQ.needs_update=false;
	ptipo->S.Significado=NULL;
	ptipo->S.SignificadoR=NULL;
	ptipo->Q.cualidades=NULL;
	ptipo->Q.cualid_texto=NULL;
	ptipo->orphan_subtipos.ppio=NULL;
	ptipo->orphan_subtipos.n=ptipo->orphan_subtipos.N=0;
	ptipo->subtipos=NULL;
}

#define datatype SolvedTipo
#define htype hSolvedTipo
#include <ATcrt/hash_uintdata.cod>
/** Fin Solved **/

typedef struct strGra_Configuracion{
	uint vbyte0;
	char16_t* nombre;
	Gra_FConfiguracion *fconfig;
	LinkedGrupoFormas *pformas;
	Hash_hSolvedTipo solved;
} Gra_Configuracion;

defineVector(Gra_Configuracion)

typedef struct _LinkedSignificados{	//For inherited series of Significados
	struct _LinkedSignificados *next;
	SolvedSignificados S;
} LinkedSignificados;
