#include "WPrompt.h"
#define ID_Aceptar 0
#define ID_Cancelar 1
#define BotA_Width 60

__declspec(dllexport) WPrompt::WPrompt(){
	SetWBorderStyle(WBORDER_SYSTEM_FIXED);
	borderparams=(WBorderParams*)&BorderPars_color0;
	backcolor=AT_color0;
	bcancelar=false;
	bset=false;
	idioma=0;
}

#define STYLE 0
__declspec(dllexport) void WPrompt::Setup(void){
	Aceptar=new StdButton();
	Cancelar=new StdButton();
	if(!bcancelar){
		Aceptar->set_Rectangle((this->clientwidth-BotA_Width)/2-2,this->clientheight-40,BotA_Width,21);
	}else{
		int k=(this->clientwidth-30)/2-BotA_Width-2;
		Aceptar->set_Rectangle(k,this->clientheight-40,BotA_Width,21);
		Aceptar->set_Rectangle(k+60,this->clientheight-40,BotA_Width,21);
	}
	Aceptar->AddTo(this,ID_Aceptar);
	if(bcancelar) Cancelar->AddTo(this,ID_Aceptar);
	Aceptar->make_default();
	bset=true;
	update_idioma(idioma);
}
#undef STYLE

__declspec(dllexport) int WPrompt::Show(void){
	if(!bset) this->Setup();
	HWND hwnd_par=GetParent(this->hwnd);
	SetWStyle(hwnd_par,GetWStyle(hwnd_par) | WS_DISABLED);
	ShowWindow(this->hwnd,SW_NORMAL);
	close_sent=false;
	MSG msg;
	do{
		GetMessage(&msg,NULL,0,0);
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		if(close_sent) break;
		if(msg.message==WM_CLOSE || msg.message==WM_DESTROY) break;
	}while(1);
	SetWStyle(hwnd_par,GetWStyle(hwnd_par)&~WS_DISABLED);
	BringWindowToTop(hwnd_par);
	return MB_OK;
}

__declspec(dllexport) LRESULT WPrompt::HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
	switch(message){
		case WM_CLOSE:
			ShowWindow(hwnd,SW_HIDE);
			close_sent=true;
			return 0;
		case WM_COMMAND_CLICK:
			if((wParam==ID_Aceptar && this->Aceptar_Clicked.isEmpty())
			    ||(wParam!=ID_Cancelar && this->Cancelar_Clicked.isEmpty()) ){
				::PostMessage(hwnd,WM_CLOSE,0,0);
				return 0;
			}
	}
	return ATWindow::HostedWndProc(message,wParam,lParam);
}

__declspec(dllexport) void WPrompt::update_idioma(u8int _idioma){
	idioma=_idioma;
	if(bset) do_update_idioma();
}
#define variable_idioma idioma
__declspec(dllexport) void WPrompt::do_update_idioma(void){
	SetWindowText_u16(Aceptar->hwnd,getG_texto(GT_Aceptar));
	SetWindowText_u16(Cancelar->hwnd,getG_texto(GT_Cancelar));
}
#undef variable_idioma
