﻿class  PanelCompleto;

typedef void CallbackReport(PanelCompleto *panel, uint code, uintptr_t par1);
typedef PanelCompleto* FuncCreatePanel(CallbackReport *report);

//La función cierra. Return valores:
#define PANELC_CERRAR_Cerrado  0		//Se ha cerrado. La función tiene que haber llamado a Destroy
#define PANELC_CERRAR_Esperando 1	//Esperando a ver qué decide el usuario.
#define PANELC_CERRAR_Cancelado 2	//Cancelado. No se cierra

class  PanelCompleto : public Control{
public:
	virtual int Setup(int mode, char16_t* args) =0;
	virtual int ProcessCmdLine(char16_t* _unused(args)){return 0;}
	virtual void Destroy(void) =0;
	virtual void update_idioma(u8int idioma) =0;
	virtual LRESULT HandleKeys(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) =0;
	virtual const char16_t* get_mensaje_estado(void){return u"";}
	virtual int cierra(void) =0;
	virtual void cerrarcerrar(void){Destroy();}
	CallbackReport *Report;
	PanelCompleto() : Report(NULL) {refy=refx=0;}
};

class VentanaPrincipal : public ATWindow{
protected:
	IMP_EXP LRESULT HostedWndProc(HWP_PARAMS);
public:
	HICON Icono, Iconosm;
	PanelCompleto *panel;
	u8int idioma;
	char16_t AppPath[MAX_PATH];

	IMP_EXP VentanaPrincipal();
	virtual ~VentanaPrincipal(){if(panel!=NULL){delete panel; panel=NULL;}}
};
IMP_EXP int SetupIndependent(VentanaPrincipal *ventana);

#define GetVentana(panel) ((VentanaPrincipal*)GetParentPointer(panel))
