#include "VentanaPrincipal.h"

__declspec(dllexport) VentanaPrincipal::VentanaPrincipal(){
	wchar_t *runpath;
	_get_wpgmptr(&runpath);
	strcpy16(AppPath,(char16_t*)runpath);
	path_remove_file16(AppPath);
}

__declspec(dllexport) int SetupIndependent(VentanaPrincipal *ventana){
	ventana->idioma=0;
	ventana->backcolor=AT_color0;
	ventana->SetWBorderStyle(WBORDER_SYSTEM_FIXED);
	ventana->borderparams=(WBorderParams*)&BorderPars_color0;
	ventana->hwnd= CreateWindowEx(/*WS_EX_COMPOSITED | WS_EX_LAYERED*/0,(const char8_t*)ATW_WINDOW, "", WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
		100,100, NULL,NULL,NULL,NULL);
	if(!ventana->hwnd) return 1;
	SetWindowPointer(ventana);
	SendMessage(ventana->hwnd,WM_SETICON,ICON_BIG,(LPARAM)ventana->Icono);
	SendMessage(ventana->hwnd,WM_SETICON,ICON_SMALL,(LPARAM)ventana->Iconosm);
	return 0;
}

LRESULT VentanaPrincipal::HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
	switch(message){
	case WM_SIZE:
		{int wd=LOWORD(lParam);
		int ht=HIWORD(lParam);
		this->clientwidth=wd-(this->wd_iz+this->wd_de);
		this->clientheight=ht-(this->wd_ar+this->wd_ab);
		SetWRect(panel->hwnd,this->wd_ar,this->wd_iz,this->clientwidth,this->clientheight);
		}
		return this->ATWindow::HostedWndProc(message, wParam, lParam);
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return this->ATWindow::HostedWndProc(message, wParam, lParam);
	}
	return 0;
}
