﻿typedef LRESULT __stdcall TYPE_WndProc(HWND hwnd, UINT message, WPARAM,LPARAM);

//The hwnd is Window's
class StdControl : public Control{
protected:
	IMP_EXP LRESULT HostedWndProc(HWP_PARAMS);
	TYPE_WndProc *StdControlWndProc;	//per-class. However, keeping a copy of it with each object makes message processing faster.
	virtual HWND AddStdControlTo(HWND parent,int Id)=0;
public:
	IMP_EXP void AddTo(RootGraphicWindow *parent,int Id);
};

IMP_EXP LRESULT SendNotificationtoParent(StdControl *stdcontrol, WORD msg_code);

class StdButton : public StdControl{
protected:
	HWND AddStdControlTo(HWND parent_hwnd,int Id){
		POINT pt=this->get_Location();
		return CreateWindowExA(0,(const char8_t*)ATW_Button,NULL,D_CCStyle | BS_PUSHBUTTON, pt.x,pt.y, this->width,this->height, parent_hwnd,(HMENU)Id,NULL,NULL);
	}
public:
	void make_default(void){FlagOnWStyle(hwnd,BS_DEFPUSHBUTTON);}
};

class StdComboBox : public StdControl{
protected:
	HWND AddStdControlTo(HWND parent_hwnd,int Id){
		POINT pt=this->get_Location();
		return CreateWindowExA(0,(const char8_t*)ATW_CBox,NULL,D_CCStyle | CBS_DROPDOWNLIST, pt.x,pt.y, this->width,this->height, parent_hwnd,(HMENU)Id,NULL,NULL);
	}
};

class StdTextBox : public StdControl{
protected:
	HWND AddStdControlTo(HWND parent_hwnd,int Id){
		POINT pt=this->get_Location();
		return CreateWindowExA(0,(const char8_t*)ATW_TextBox,NULL,D_CCStyle | ES_AUTOHSCROLL | ES_RIGHT, pt.x,pt.y, this->width,this->height, parent_hwnd,(HMENU)Id,NULL,NULL);
	}
public:
	char8_t restriction;	//'\0': none; 'u': natural number; 'n': integer; 'f': float number
							//unknown: 'none'
	StdTextBox(){restriction='\0'; Control();}
};
