#include "StdControls.h"

sinline TYPE_WndProc* Redirect_WndProc(HWND hwnd, TYPE_WndProc *_new){
	TYPE_WndProc *old=(TYPE_WndProc *)GetWindowLongPtr(hwnd,GWLP_WNDPROC);
	SetWindowLongPtr(hwnd,GWLP_WNDPROC,(LONG_PTR)_new);
	return old;
}

void RegisterStdControls(){
	GetClassInfoEx(NULL,"Button",&wcex);
	wcex.cbSize= usizeof(wcex);
	wcex.style|=CS_GLOBALCLASS;
	wcex.cbWndExtra+=usizeof(void*);
	wcex.lpszClassName="ATW_Button";
	Atoms.StdButton=RegisterClassEx(&wcex);

	GetClassInfoEx(NULL,"ComboBox",&wcex);
	wcex.cbSize= usizeof(wcex);
	wcex.style|=CS_GLOBALCLASS;
	wcex.cbWndExtra+=usizeof(void*);
	wcex.lpszClassName="ATW_CBox";
	Atoms.StdCBox=RegisterClassEx(&wcex);

	GetClassInfoEx(NULL,"Edit",&wcex);
	wcex.cbSize= usizeof(wcex);
	wcex.style|=CS_GLOBALCLASS;
	wcex.cbWndExtra+=usizeof(void*);
	wcex.lpszClassName="ATW_Edit";
	Atoms.StdTextBox=RegisterClassEx(&wcex);
}

__declspec(dllexport) void StdControl::AddTo(RootGraphicWindow *parent,int Id){
	hwnd=AddStdControlTo(parent->hwnd,Id);
	SetWindowLongPtr(this->hwnd,GetClassLongPtr(hwnd,GCL_CBWNDEXTRA)-usizeof(void*),(LONG_PTR)(Window*)this);
	SetWFont(this->hwnd,AT_Font_mssans);
	StdControlWndProc=Redirect_WndProc(this->hwnd,Window_WndProc);
}

__declspec(dllexport) LRESULT SendNotificationtoParent(StdControl *stdcontrol, WORD msg_code){
	HWND hwnd=GetParentHwnd(stdcontrol);
	if(hwnd==NULL) return 0;
	return SendMessageW(hwnd,WM_COMMAND,(msg_code<<16) | GetControlID(stdcontrol),(LPARAM)stdcontrol->hwnd);
}

__declspec(dllexport) LRESULT StdControl::HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
	switch(message){
	case WM_SIZE:
		if(wParam==SIZE_MINIMIZED) break;
		this->width=LOWORD(lParam);
		this->height=HIWORD(lParam);
		break;
	/*case WM_KEYDOWN:
	case WM_KEYUP:
		{HWND hwnd_p=(HWND)GetWindowLongPtr(hwnd,GWLP_HWNDPARENT);
		if(hwnd_p!=NULL) return SendMessage(hwnd_p,message,wParam,lParam);}
		break;*/
	}
	return CallWindowProc(StdControlWndProc,hwnd,message,wParam,lParam);
}
