//For MS Window's classes.


/* ******* class Window ******* */
class Window;
#define HWP_PARAMS     UINT message, WPARAM,LPARAM
typedef LRESULT (Window::*pTYPE_HostedWndProc)(HWP_PARAMS);
typedef bool (Window::*pTYPE_hookWndProc)(Window *caller,HWP_PARAMS,LRESULT *);
#define SET_WNDPROC_HOOK(where,func) Set_WndProc_hook(where,(pTYPE_hookWndProc)(func))

class Window{
public:
	HWND hwnd;
	Window(){
		precall_wndproc.whereto=NULL;
		precall_wndproc.hook=NULL;
	}
	virtual ~Window(){
		SetWindowLongPtr(hwnd,0,(LONG_PTR)NULL);
		DestroyWindow(hwnd);
	}
//protected:
protected:
	struct{
		Window *whereto;
		pTYPE_hookWndProc hook;
	} precall_wndproc;
	virtual LRESULT HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
		return DefWindowProc(this->hwnd,message,wParam,lParam);
	}
	friend IMP_EXP LRESULT __stdcall Window_WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
public:
	void Set_WndProc_hook(Window *where, pTYPE_hookWndProc func_hook){
		precall_wndproc.whereto=where;
		precall_wndproc.hook=func_hook;
	}
};
//Window_WndProc defined in RootWindow.cpp.h, redirects to HostedWndProc.
//The pointer to the object is retrived by GetWindowLongPtr(hwnd,0). See the definition
//of Add_Window at GDIWin32_defs.h


//The ones without the Window::* specification are to be used at the function declaration within the class, for the <Class>::* is then implicit
typedef LRESULT (Window::*pGenericMessageHandler)(Window *caller, WPARAM wParam, LPARAM lParam);
typedef LRESULT GenericMessageHandler(Window *caller, WPARAM wParam, LPARAM lParam);

struct DelegateGeneric{Window *wherewithin; pGenericMessageHandler f; DelegateGeneric *next;};
#define CALL(del) ((del)->wherewithin->*((del)->f))
//The avobe implementation is valid C++, but that cannot be guessed upon a reading of the standard.
//class A{/*...*/};  class B : public A{/*...*/};
/*
Casting an A::* function pointer to a B::* one is automatic, and the reverse is allowed by means of a static_cast.
However, it being allowed does not mean that the cast pointer can be de-referenced without a prior de-casting.
If this were to be supposed, by the same token it should be suposed that, since casting an (int*) to (void*) is valid,
the following code:

int i, *p=&i;
void *q=(void*)i;
*q=2;

should be valid.
The standard fails to mention that a pointer to member function stores (or behaves as if it did) the address of the function
and the type the function's "this" pointer is, that is, the class the function pointed to lies in, which may be different from
the member function pointer declared cointainer class type (i.e., the type before ::* in the declaration), and that when the
function is called via that pointer the object through which the pointer is de-referenced is adjusted to the actual type of
the function pointed to by the pointer. This is not the case of void* pointer: they do not "remember" the original pontee.

Indeed, given that the standard says that a pointer A::* may be converted to B::*, which must be de-referenced using an
object of type B, the result being the same as if the A subobject of B where used to de-reference the original pointer
(with B for A and D for B in the standard wording), but says nothing on the reverse de-referencing, nothing can be supposed.
Standards often fail to say what they intend to mean, presuming that a dry, stripped out wording transmits the same message
just more precisely, not realising they are assuming facts they are skipping in the writing.

The implementation above uses a Window* pointer to derrefrence a "pointer to Window member function", the latter
actually expecting a this pointer of a derived type, so I had for some time assumed that it worked because

"It relies on pointers not changing their values when converted to Window*, for it is the result of that convertion
what would be passed as the this pointer to the function f, which will lie in a derived class (i.e., expect this to be of a
particular <Class> type, where <Class> inherits from Window)."

Even if the type used to de-reference were the derived type nothing changes, for a pointer of X::* can _only_ be
dereferenced using a pointer of type X*, so that the use of a derived type is an illusion, an implicit conversion to
the base type taking place in-between.

The standard dismisses pointers to member functions together with pointers to member objects, which are totally
different concepts. The former are actual addresses, while the latter are called pointers just for syntactic convenience,
since in struct A{int i;}; there is nothing like &A::i. This can only mean the offset of i within A, so that casing to a
pointer to a derived class's member is trivial (adding the offset of A within the derived class B), and so is the de-referncing
via an object of type B, which need not know at all that the original pointer was of A::* type, and which obviously yields
the same as B *b; b->*pi; where pi is of type A::*int, since it is the copy of A within B what is used for the de-referencing.
All this is anything but trivial when dealing with pointers to member functions.
*/

/*Handling of messages via registering functions. A Message handler should be declared as such within the class, i.e., not
as a pointer to be initialized by new, unless the class destructor explicitely deletes it. This is so that the memory allocated
by them is freed upon an automatic call to the destructor.
Message handlers are usually committed to handling just one function call, so the object itself includes memory for one
registered function. This has the drawback of making unnecessary "fat" objects when the handlers are not assigned any
function. There would tipically be more unset handlers than used ones, so an implementation reserving no memory
whatsoever would be more adequate for a memory saving / new calls avoiding compromise, but these days memory is
so cheaply available that the compromise falls entirely on the side of avoiding new calls.
*/
class MessageHandler{
protected:
	DelegateGeneric first;						//The test for it being empty is .f==NULL.
public:
	bool isEmpty(){return first.f==NULL;}	//The test for there not being more than one is first.next=NULL.
	MessageHandler(){first.f=NULL; first.next=NULL;}
	~MessageHandler(){
		DelegateGeneric *ptr=first.next;
		while(ptr!=NULL){void *p=ptr; ptr=ptr->next; free(p);}
	}
	LRESULT Call(Window *caller, WPARAM wParam, LPARAM lParam){
		LRESULT l;
		if(first.f==NULL) return 0;
		DelegateGeneric *del=&first;
		do{l=CALL(del)(caller,wParam,lParam); del=del->next;}
		while(del!=NULL);
		return l;
	}
	void SetToFunc(Window *wherewithin, pGenericMessageHandler func){
		this->~MessageHandler();
		first.wherewithin=wherewithin;
		first.f=func;
		first.next=NULL;
	}
	IMP_EXP int AddFuncFirst(Window *wherewithin, pGenericMessageHandler func);
	IMP_EXP int AddFuncLast(Window *wherewithin, pGenericMessageHandler func);
};
#define SetToThisFunc(h,func) (h).SetToFunc(this,static_cast<pGenericMessageHandler>(&func))

/*The usual claim that virtual static fields make no sense is itself non-sense. A fortiori, virtual
only makes sense if applied to statically allocated memory, not for per-object allocated memory,
and it is as such that it is applied to functions and would apply verbatim to static fields. "virtual"
simply means resolved at run-time via a pointer to a struct holding class-information including,
among other stuff, the address of the to be called function / to be retrived field.
virtual static const fields are the ideal type for storing metadata for the class, such as
virtual static const char8_t* const name="RootGraphicWindow",
								description="Base class of all actual windows, i.e., non- message only windows, and controls whithin",
								lastrevised="01/01/2010";
virtual static const size_t thissize;
...};
const size_t A::thissize=sizeof(A);

and non-const ones all that should have the same value for all the objects of the same class, such
as font, but that may vary by some global change, such us the graphic style of the application (themes),
the language, etc., or just because its permanent value cannot be known/acessed at the place of
their declaration at compile-time.
*/
class RootGraphicWindow : public Window{
protected:
	IMP_EXP virtual LRESULT HostedWndProc(HWP_PARAMS) override;
public:
	/*virtual static*/ COLORREF backcolor;
	//Default routine for painting the control for each class
	virtual void Paint(PAINTSTRUCT *_unused(ps)){return;}	//The background has been erased
	MessageHandler Painting;	//Specialization. May call Paint()
};
