#include "RootWindow.h"

__declspec(dllexport) LRESULT __stdcall Window_WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){
	if(message==WM_COMMAND){
		if(HIWORD(wParam)==BN_CLICKED) message=WM_COMMAND_CLICK;
		if(message!=WM_COMMAND) wParam=LOWORD(wParam);	//The low word carries the control Id.
	}
	//pobject es NULL desde la asignacin de un hwnd al control hasta que se escribe el puntero con SetWindowLongPtr, y desde
	Window *pobject=(Window*)GetWindowLongPtr(hwnd,GetClassLongPtr(hwnd,GCL_CBWNDEXTRA)-usizeof(void*));	 //que se borra con SetWindowLongPtr
	if(pobject==NULL) return DefWindowProc(hwnd,message,wParam,lParam);					//hasta que se destruye la ventana
	LRESULT returned;
	bool done=false;
	if(pobject->precall_wndproc.whereto!=NULL && pobject->precall_wndproc.hook!=NULL)
		done=((pobject->precall_wndproc.whereto)->*(pobject->precall_wndproc.hook))(pobject,message,wParam,lParam,&returned);
	if(done) return returned;
	return pobject->HostedWndProc(message,wParam,lParam);
}

/*MessageHandler*/
__declspec(dllexport) int MessageHandler::AddFuncFirst(Window *wherewithin, pGenericMessageHandler func){
	DelegateGeneric del;
	del.wherewithin=wherewithin;
	del.f=func;
	del.next=NULL;
	if(first.f!=NULL){
		del.next=n_malloc(DelegateGeneric,1);
		ifunlike(del.next==NULL) return AT_NOMEM;
		*del.next=first;
	}
	first=del;
	return 0;
}

__declspec(dllexport) int MessageHandler::AddFuncLast(Window *wherewithin, pGenericMessageHandler func){
	DelegateGeneric del, *last;
	del.wherewithin=wherewithin;
	del.f=func;
	last=&first;
	if(first.f!=NULL){
		del.next=n_malloc(DelegateGeneric,1);
		ifunlike(del.next==NULL) return AT_NOMEM;
		while(last->next!=NULL) last=last->next;
		last->next=del.next;
	}
	del.next=NULL;
	*last=del;
	return 0;
}
/**/

__declspec(dllexport) LRESULT RootGraphicWindow::HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
	if(message==WM_ERASEBKGND){
		if(this->backcolor==0xFF000000){
			RootGraphicWindow *ptr=this;
			do ptr=GetParentPointer(ptr);
			while(ptr!=NULL && ptr->backcolor==0xFF000000);
			if(ptr!=NULL) this->backcolor=ptr->backcolor;
		}
		return 0;
	}
	if(message==WM_PAINT){
		{PAINTSTRUCT ps;
		BeginPaint(hwnd, &ps);
		if(ps.fErase){
			//if(this->backcolor==0xFF000000) break;
			SelectObject(ps.hdc, GetStockObject(DC_BRUSH));
			SetDCBrushColor(ps.hdc,this->backcolor);
			FillRect(ps.hdc,&ps.rcPaint,(HBRUSH)GetStockObject(DC_BRUSH));
		}
		if(this->Painting.isEmpty()) Paint(&ps);
		else this->Painting.Call(this,(WPARAM)(&ps),0);
		EndPaint(hwnd, &ps);}
		return 0;
	}
	return DefWindowProc(hwnd, message, wParam, lParam);
}
