﻿class SubMenu;
struct MenuItem{
	const char16_t *text;
	bool visible;
	bool enabled;
	SubMenu *submenu;
	pGenericMessageHandler function;	//only paid attention to if submenu=NULL
			//whereto will be taken from the menu window
			//caller: la ventana de menú en la que se encuentra el item. No sirve para nada (se pasa esto porque ha de ser un Window*, y un SubMenu no lo es)
			//wParam: SubMenu*. El submenú al que pertenece
			//lParam: int. El índice dentro del submenú. El menuitem es ((SubMenu*)wParam)->menuitems[lParam]
	MenuItem(){visible=enabled=true; text=NULL; submenu=NULL; function=NULL;}
};
class SubMenu{
public:
	uint n;
	MenuItem* *menuitems;
	int maxwidth;	//of text. Updated from elsewhere

	SubMenu() : n(0), maxwidth(0){}
	~SubMenu(){if(n!=0) free(menuitems);}
	IMP_EXP int Create(uint n, MenuItem *item1,...);
};

class MenuWindow : public ATWindow{
protected:
	IMP_EXP virtual LRESULT HostedWndProc(HWP_PARAMS) override;
public:
	static IMP_EXP HFONT hfont;
	static const int itemheight=19;
	static const int baselineheight=14;
	static const int marginleft=12;
	static const int marginright=12;
	static const int marginright_arrow=18;
	MenuWindow *prev, *next;
	SubMenu *menu;
	Window *whereto;	//control or window that handles the click messages
	int activeindex;
	int visibleindex(){
		if(activeindex<0 || (uint)activeindex>=menu->n) return -1;
		int ipos=0;
		for(int i=0;i<activeindex;i++){
			if(menu->menuitems[i]->visible) ipos++;
		}
		return ipos;
	}

	MenuWindow(){backcolor=AT_color7;}
	IMP_EXP void Show(SubMenu *_menu, POINT p);
	void Hide(){
		if(this->next!=NULL) this->next->Hide();
		ShowWindow(hwnd,SW_HIDE);
	}
	IMP_EXP virtual void Paint(PAINTSTRUCT *ps) override;
	IMP_EXP void SetActiveIndex(int t);
};

class MainMenu : public Control{
protected:
	IMP_EXP virtual LRESULT HostedWndProc(HWP_PARAMS) override;
public:
	IMP_EXP static HFONT hfont;
	MenuWindow *menuW;
	uint n;
	MenuItem* *menuitems;
	int *widths;	//n+1 elems. 1º=0 always
	int sep;
	int vpos;

	IMP_EXP virtual void Paint(PAINTSTRUCT *ps) override;
	MainMenu() : Control(){
		backcolor=AT_color6;
		n=0, sep=8, height=17;
	}
	virtual ~MainMenu(){
		if(n!=0){free(widths); free(menuitems);}
	}
	IMP_EXP int Create(MenuItem *item1,...);
	inline int GetItemAt(int x){
		fallthru(i,int,this->widths+1,this->n){if(*ptri>x) break;}
		if(FALLED(i)) return -1;
		i++; return this->n-i;
	}
	IMP_EXP void Update(bool);
};
