#include "Menus.h"
#include <cstdarg>

typedef COLORREF color;
#define F 0xFF000000
#define C 0xAA000000
#define A 0x77000000
#define c 0x44000000
#define a 0x22000000
const color matriz_flecha[MenuWindow::itemheight][MenuWindow::marginright_arrow]={
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,A,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,0,A,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,0,a,C,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,a,0,a,A,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,c,0,0,0,a,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,a,0,a,A,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,0,a,C,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,0,A,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,A,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
	{F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F},
};
#undef F
#undef C
#undef A
#undef c
#undef a

/** Fonts **/
__declspec(dllexport) HFONT MenuWindow::hfont;
__declspec(dllexport) HFONT MainMenu::hfont;

void RegisterMenus(){
	MenuWindow::hfont=AT_Font_mssans;
	MainMenu::hfont=AT_Font_constantia;

	wcex.style |= CS_SAVEBITS | CS_DROPSHADOW;	//Eliminar CS_SAVEBITS no funciona
	wcex.lpszClassName="MenuWindow";
	RegisterClassEx(&wcex);
	wcex.style=CS_GLOBALCLASS;
}

/** SubMenu **/
__declspec(dllexport) int SubMenu::Create(uint n,MenuItem *item1,...){
	va_list ap;

	if(this->n!=0){
		free(this->menuitems);
		this->n=0;
	}

	if(n==0) return 0;
	aj_malloc_n(this->menuitems,MenuItem*,n);
	this->n=n;

	va_start(ap, item1);
	MenuItem* *ptr=this->menuitems;
	*ptr++=item1;
	dontimes(n-1,){
		*ptr++=va_arg(ap,MenuItem*);
	}
	va_end(ap);
	return 0;

salida_outofmem:
	return AT_NOMEM;
}

__declspec(dllexport) void MenuWindow::Show(SubMenu *_menu, POINT p){
	this->backcolor=AT_color7;
	menu=_menu;
	if(menu==NULL || menu->n==0) return;
	uint n1=menu->n;
	{durchlaufei(MenuItem*,menu->menuitems,menu->n) if(!(*ptri)->visible) n1--;}
	this->clientheight=MenuWindow::itemheight*n1;
	this->activeindex=-1;
	if(menu->maxwidth==0){
		HDC hdc=GetDC(this->hwnd);
		TEXTMETRIC textm;
		int max;
		SelectObject(hdc,this->hfont);
		SetTextAlign(hdc,TA_BASELINE);
		GetTextMetrics(hdc,&textm);

		max=marginright;
		durchlaufei(MenuItem*,menu->menuitems,menu->n){
			if((*ptri)->visible==false || (*ptri)->text==NULL) continue;
			SIZE _size;
			GetTextExtentPoint_u16(hdc,(*ptri)->text,strlen16((*ptri)->text),&_size);
			if((*ptri)->submenu==NULL) _size.cx+=marginright;
			else _size.cx+=marginright_arrow;
			if(_size.cx>max) max=_size.cx;
		}
		menu->maxwidth=max+marginleft;
		ReleaseDC(hwnd,hdc);
	}
	this->clientwidth=menu->maxwidth;
	SetWindowPos(this->hwnd,0,p.x,p.y,this->GetWidth(),this->GetHeight(),SWP_SHOWWINDOW);
	return;
}

__declspec(dllexport) void MenuWindow::SetActiveIndex(int y){
	if(this->activeindex==y) return;
	if(this->next!=NULL) this->next->Hide();
	if(!IsWindowVisible(this->hwnd)){
		this->activeindex=y;
		return;
	}
	int oldtop=this->visibleindex();
	this->activeindex=y;
	RECT rect;
	rect.left=this->wd_iz;
	rect.right=this->wd_iz+this->clientwidth;
	rect.top=this->wd_ar+this->visibleindex()*this->itemheight;
	rect.bottom=rect.top+this->itemheight;
	if(this->activeindex!=-1) InvalidateRect(this->hwnd,&rect,false);
	if(oldtop!=-1){
		rect.top=this->wd_ar+oldtop*this->itemheight;
		rect.bottom=rect.top+this->itemheight;
		InvalidateRect(this->hwnd,&rect,true);
	};
}

__declspec(dllexport) void MenuWindow::Paint(PAINTSTRUCT *ps){
	this->ATWindow::Paint(ps);
	if(this->activeindex!=-1){
		SelectObject(ps->hdc, GetStockObject(DC_BRUSH));
		SetDCBrushColor(ps->hdc,AT_color9);
		RECT rect;
		rect.left=this->wd_iz;
		rect.right=this->wd_iz+this->clientwidth;
		rect.top=this->wd_ar+this->visibleindex()*this->itemheight;
		rect.bottom=rect.top+this->itemheight;
		FillRect(ps->hdc,&rect,(HBRUSH)GetStockObject(DC_BRUSH));
	}
	PrepareForText(ps->hdc,this->hfont,GetSysColor(COLOR_MENUTEXT));

	uint i=0;
	int pos=this->wd_ar;
	while(pos<ps->rcPaint.top && i<this->menu->n){
		if(menu->menuitems[i]->visible) pos+=this->itemheight;
		i++;
	}
	if(i<this->menu->n){
		int posr=this->GetWidth()-this->wd_de-marginright_arrow;
		MenuItem* *mitems=this->menu->menuitems+i;
		for(i=this->menu->n-i; i-- && pos<ps->rcPaint.bottom; pos+=this->itemheight, mitems++){
			if(!(*mitems)->visible){pos-=this->itemheight; continue;}
		const char16_t *s=(*mitems)->text;
		if(s==NULL) continue;
		if(!(*mitems)->enabled) SetTextColor(ps->hdc,GetSysColor(COLOR_GRAYTEXT));
		TextOut_u16(ps->hdc,this->wd_iz+this->marginleft,pos+this->baselineheight,s,strlen16(s));
		if(!(*mitems)->enabled) SetTextColor(ps->hdc,GetSysColor(COLOR_MENUTEXT));
		if((*mitems)->submenu!=NULL && posr<ps->rcPaint.right){
			uint filas,cols;
			HDC hdc_copia;
			HBITMAP bitmap;
			BITMAPINFO bitsinfo;
			color *seccion_hdc;
			const color *pmatriz;
			color fondo;

			fondo=GetPixel(ps->hdc,posr,pos);
			{color aux=(fondo&0xFF0000)>>16; aux|=(fondo&0xFF)<<16; aux|=fondo&0xFF00;
			fondo=aux;}
			filas=this->itemheight;
			cols=marginright_arrow;

			bitsinfo.bmiHeader.biSize=usizeof(BITMAPINFOHEADER);
			bitsinfo.bmiHeader.biWidth=cols;
			bitsinfo.bmiHeader.biHeight=-(ssint)filas;
			bitsinfo.bmiHeader.biPlanes=1;
			bitsinfo.bmiHeader.biBitCount=CHAR_BIT*usizeof(color);
			bitsinfo.bmiHeader.biCompression=BI_RGB;
			bitsinfo.bmiHeader.biSizeImage=filas*cols*usizeof(color);

			hdc_copia=CreateCompatibleDC(ps->hdc);
			bitmap=CreateDIBSection(ps->hdc, &bitsinfo, DIB_RGB_COLORS, (void**)&seccion_hdc, NULL, 0x0);
			if(bitmap!=NULL){
				SelectObject(hdc_copia,bitmap);
				pmatriz=&matriz_flecha[0][0];
				dontimes(filas,){
					dontimes(cols,(seccion_hdc++,pmatriz++)){
						u8int dens=(u8int)((*pmatriz&0xFF000000U)>>24);
						if(dens==0) *seccion_hdc=*pmatriz;
						elif(dens==0xFF) *seccion_hdc=fondo;
						else{
							*seccion_hdc=fondo;
							float f=(1.0F-(float)dens/256.F);	//255.F
							merge_pixel(seccion_hdc,f,*pmatriz);
						}
				}	}
				seccion_hdc-=filas*cols;
				BitBlt(ps->hdc,posr,pos,cols,filas,hdc_copia,0,0,SRCCOPY);
				DeleteObject(bitmap);
			}
			DeleteDC(hdc_copia);
		}
	}}
}

__declspec(dllexport) LRESULT MenuWindow::HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
	switch(message){
	case WM_CREATE:
		FlagOnWStyle(this->hwnd,CS_SAVEBITS | CS_DROPSHADOW);
		return 0;
	case WM_ACTIVATEAPP:
		if(wParam!=FALSE) break;
		if(!IsWindowVisible(this->hwnd)) break;
		{MenuWindow *wnext=this;
		while(wnext->prev!=NULL) wnext=wnext->prev;
		wnext->Hide();}
		return 0;
	case WM_ACTIVATE:
		if(LOWORD(wParam)!=WA_INACTIVE) break;
		{MenuWindow *wnext=this->next;
		while(wnext!=NULL && wnext->hwnd!=(HWND)lParam) wnext=wnext->next;
		if(wnext==NULL){
			wnext=this;
			while(wnext->prev!=NULL && wnext->prev->hwnd!=(HWND)lParam) wnext=wnext->prev;
			wnext->Hide();
		}}
		return 0;
	case WM_NCMOUSEMOVE:
		{POINT p;
		p.x=LOWORD(lParam);
		p.y=HIWORD(lParam);
		ScreenToClient(hwnd,&p);
		int y,x;
		y=p.y; x=p.x;
	case WM_MOUSEMOVE:
		if(message==WM_MOUSEMOVE){y=HIWORD(lParam), x=LOWORD(lParam);}
		if(x<this->wd_iz) y=-1;
		elif(x>=this->wd_iz+this->clientwidth && (this->next==NULL || !IsWindowVisible(this->next->hwnd)) ) y=-1;
		else y-=this->wd_ar;
		if(y>=0){
			int rtop=this->visibleindex()*this->itemheight;
			if(y>=rtop && y<rtop+this->itemheight) return 0;
			y/=this->itemheight;
		}
		{MenuItem **pmenus=this->menu->menuitems;
		for(uint i=0;i<=(uint)y;i++,pmenus++){
			if(i==this->menu->n) break;
			if(!(*pmenus)->visible) y++;
		}}
		if(y<0 || (uint)y>=this->menu->n) y=-1;
		elif(this->menu->menuitems[y]->enabled==false) y=-1;
		if(this->activeindex!=y && y!=-1 && this->menu->menuitems[y]->submenu!=NULL){
			TRACKMOUSEEVENT track;
			track.cbSize=usizeof(TRACKMOUSEEVENT);
			track.dwFlags=TME_HOVER;
			track.hwndTrack=hwnd;
			track.dwHoverTime=350;	//msec
			TrackMouseEvent(&track);
		}
		this->SetActiveIndex(y);
		}
		return 0;
	case WM_MOUSEHOVER:
		if(this->next==NULL || this->activeindex==-1) return 0;
		this->next->menu=this->menu->menuitems[this->activeindex]->submenu;
		if(this->next->menu!=NULL){
			POINT p;
			p.x=this->GetWidth()-2;
			p.y=this->wd_ar+this->visibleindex()*this->itemheight;
			ClientToScreen(hwnd,&p);
			this->next->Show(this->next->menu,p);
		}
		return 0;
	case WM_LBUTTONUP:
		if(this->activeindex==-1) return 0;
		{MenuItem *menui=this->menu->menuitems[this->activeindex];
		if(menui->enabled==false) return 0;
		if(menui->submenu!=NULL){
			this->next->menu=menui->submenu;
			POINT p;
			p.x=this->GetWidth()-2;
			p.y=this->wd_ar+this->activeindex*this->itemheight;
			ClientToScreen(hwnd,&p);
			this->next->Show(this->next->menu,p);
			return 0;
		}
		MenuWindow *wnext=this;
		while(wnext->prev!=NULL) wnext=wnext->prev;
		wnext->Hide();
		if(menui->function!=NULL) return (this->whereto->*(menui->function))((Window*)this,(WPARAM)this->menu,activeindex);
		}
		break;
	case WM_RBUTTONDOWN:
		break;
	}
	return this->ATWindow::HostedWndProc(message, wParam, lParam);
}

/** MainMenu **/
__declspec(dllexport) void MainMenu::Paint(PAINTSTRUCT *ps){
	PrepareForText(ps->hdc,MainMenu::hfont,0);
	uint i=0;
	while(i<this->n && this->widths[i+1]<=ps->rcPaint.left) i++;
	while(i<this->n && this->widths[i]<=ps->rcPaint.right){
		const char16_t *s=this->menuitems[i]->text;
		if(s==NULL) continue;
		bool b=this->menuitems[i]->enabled;
		if(!b) SetTextColor(ps->hdc,GetSysColor(COLOR_GRAYTEXT));
		TextOut_u16(ps->hdc,this->widths[i]+this->sep,this->vpos,s,strlen16(s));
		if(!b) SetTextColor(ps->hdc,0);
		i++;
	}
}
__declspec(dllexport) LRESULT MainMenu::HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
	switch(message){
	case WM_LBUTTONDOWN:
		{int i=this->GetItemAt(LOWORD(lParam));
		if(i==-1) return 0;
		if(!this->menuitems[i]->enabled) return 0;
		if(this->menuitems[i]->submenu!=NULL){
			POINT p;
			p.x=this->widths[i];
			p.y=this->height;
			ClientToScreen(hwnd,&p);
			this->menuW->Show(this->menuitems[i]->submenu,p);
		}}
		return 0;
	case WM_MOUSEMOVE:
		if(!IsWindowVisible(this->menuW->hwnd)) break;
		{int i=this->GetItemAt(LOWORD(lParam));
		if(i==-1) return 0;
		if(this->menuitems[i]->enabled==false) return 0;
		SubMenu *psub=this->menuitems[i]->submenu;
		if(this->menuW->menu!=psub){
			POINT p;
			p.x=this->widths[i];
			p.y=this->height;
			ClientToScreen(hwnd,&p);
			this->menuW->Hide();
			this->menuW->Show(psub,p);
		}}
		return 0;
	}
	return this->Control::HostedWndProc(message,wParam,lParam);
}

__declspec(dllexport) int MainMenu::Create(MenuItem *item1,...){
	va_list ap;
	uint t;
	MenuItem* mm[16];

	if(this->n!=0){
		free(this->widths);
		free(this->menuitems);
		this->n=0;
	}

	va_start(ap, item1);
	t=0;
	mm[0]=item1;
	while(mm[t]!=NULL){
		t++;
		mm[t]=va_arg(ap,MenuItem*);
		if(t==15) break;
	}
	va_end(ap);

	if(t==0) return 0;
	aj_malloc_n(this->menuitems,MenuItem*,t);
	aj_malloc_n(this->widths,int,t+1);
	n=t;
	this->widths[0]=0;

	MenuItem* *ptr_b=mm;
	for(MenuItem* *ptr=this->menuitems; *ptr_b!=NULL; *ptr++=*ptr_b++);
	return 0;

salida_outofmem:
	freeif(this->menuitems);
	return AT_NOMEM;
}

__declspec(dllexport) void MainMenu::Update(bool rpaint){
	TEXTMETRIC textm;
	HDC hdc=GetDC(this->hwnd);
	SelectObject(hdc,hfont);
	SetTextAlign(hdc,TA_BASELINE);
	GetTextMetrics(hdc,&textm);

	{int h=textm.tmHeight-textm.tmInternalLeading;
	this->vpos=(this->height+h)/2-textm.tmDescent;}
	this->sep<<=1;
	durchlaufe2(MenuItem*,this->menuitems,this->n,int,this->widths){
		if((*ptr)->text==NULL || (*ptr)->visible==false){*(ptr_b+1)=*ptr_b; continue;}
		SIZE _size;
		GetTextExtentPoint_u16(hdc,(*ptr)->text,strlen16((*ptr)->text),&_size);
		*(ptr_b+1)=*ptr_b+_size.cx+this->sep;
	}
	this->sep>>=1;

	ReleaseDC(hwnd,hdc);
	if(rpaint) InvalidateRect(this->hwnd,NULL,true);
}
