#include "Global_texts.h"

#define MAX_STRING 512
char16_t buffer[MAX_STRING];
struct PerIdioma{
	int n_textos;
	int n_textos_s;
	const char16_t* const *textos;
	const char16_t* (* const get_compose_texto)(int n,const char16_t* s);
};
#include <ATcrt\ATstring.h>
#include "Global_texts_esp.h"
#include "Global_texts_eng.h"
#include "Global_texts_it.h"

const PerIdioma InfoIdiomas[MAX_IDIOMA+1]={
	{usizeof(textos_esp)/usizeof(char16_t*),4,&textos_esp[0],get_compose_texto_esp},
	{usizeof(textos_eng)/usizeof(char16_t*),4,&textos_eng[0],get_compose_texto_eng},
	{usizeof(textos_it)/usizeof(char16_t*),4,&textos_it[0],get_compose_texto_it},
};

__declspec(dllexport) const char16_t* _getG_texto(u8int idioma,int n){
	const PerIdioma *pidioma;
	const char16_t* texto;
	if(n>=InfoIdiomas[0].n_textos) return u"";
	if(idioma>MAX_IDIOMA) idioma=0;

	pidioma=InfoIdiomas+idioma;
	if(n>=pidioma->n_textos){
		idioma=0;
		pidioma=InfoIdiomas;
	}
	texto=pidioma->textos[n];
	if(texto==NULL && idioma!=0){
		texto=InfoIdiomas[0].textos[n];
	}
	return texto;
}

__declspec(dllexport) const char16_t* _getG_compose_texto(u8int idioma,int n,const char16_t* s){
	const PerIdioma *pidioma;
	const char16_t* texto;
	if(n>=InfoIdiomas[0].n_textos_s) return u"";

	pidioma=InfoIdiomas+idioma;
	if(n>=pidioma->n_textos_s){
		idioma=0;
		pidioma=InfoIdiomas;
	}
	texto=pidioma->get_compose_texto(n,s);
	if(texto==NULL && idioma!=0){
		texto=InfoIdiomas[0].get_compose_texto(n,s);
	}
	return texto;
}
