#ifndef _DEBUG
#define NDEBUG
#endif
#include <assert.h>

#undef _unused
#define _unused(x)
//#define nclass class __declspec(novtable)

//Specializations of WM_COMMAND
#define WMCOMN_BASE WM_USER
#define WM_COMMAND_CLICK	(WMCOMN_BASE+1)

#define SetWindowPointer(wnd) SetWindowLongPtr((wnd)->hwnd,0,(LPARAM)(Window*)(wnd))
#define GetWindowPointer(hwnd) ((Window*)GetWindowLongPtr(hwnd,0))

#define Add_Window(hinst,parent_hwnd,RegisteredClassName, object,style,Id, x,y,width,height) \
	(object)->hwnd=CreateWindowExA(0,(const char8_t*)RegisteredClassName, NULL, style, x,y, width,height, parent_hwnd,(HMENU)Id,hinst,NULL);\
	SetWindowPointer(object);

#define GetParentHwnd(wnd) ((HWND)GetWindowLongPtr((wnd)->hwnd,GWLP_HWNDPARENT))
#define GetParentPointer(wnd) (RootGraphicWindow*)GetWindowPointer(GetParentHwnd(wnd))
#define CtrSetParent(child,parent) SetWindowLongPtr((child)->hwnd,GWLP_HWNDPARENT,(LONG)(parent)->hwnd)
#define GetControlID(control) GetWindowLongPtr(control->hwnd,GWLP_ID)

#define D_CCStyle /*Default child-control style*/ WS_CHILD | WS_VISIBLE
#define AddTreeViewTo(parent,tree,x,y,ancho,alto) tree=CreateWindowExA(0,WC_TREEVIEWA,NULL,STYLE | D_CCStyle, x,y, ancho,alto, parent->hwnd,(HMENU)ID_##tree,NULL,NULL);

/*Overlapped shows up the window at a point not (0,0), but ignores Owner. Popup keeps owner*/
#define AddOwnedWindow(parent_hwnd,owwindow) \
	{RECT wrect; \
	wrect.top=100; wrect.bottom=100+(owwindow)->GetHeight(); \
	wrect.left=100; wrect.right=100+(owwindow)->GetWidth(); \
	AdjustWindowRectEx(&wrect, WS_EX_TOOLWINDOW,TRUE,WS_POPUP | WS_SYSMENU | WS_CAPTION);\
	(owwindow)->hwnd=CreateWindowExA(WS_EX_TOOLWINDOW | WS_EX_LAYERED,(const char8_t*)ATW_WINDOW, NULL, WS_POPUP | WS_SYSMENU | WS_CAPTION, 100,100, wrect.right-wrect.left, wrect.bottom-wrect.top, parent_hwnd,NULL,NULL,NULL);}\
	SetWindowPointer(owwindow); \
	SetLayeredWindowAttributes((owwindow)->hwnd,0,255,LWA_ALPHA);

#define Add_InheritedControl(hinst,parent,RegisteredClassName,control,Id) \
	{assert(parent->hwnd);\
	POINT pt=control->get_Location();\
	Add_Window(hinst,parent->hwnd,RegisteredClassName,control,D_CCStyle,Id, pt.x,pt.y, (control)->width,(control)->height);}
#define Add_Control(parent,control,Id) Add_InheritedControl(NULL,parent,ATW_WINDOW,control,Id)

#define SWP_NOFLAGS SWP_NOZORDER | SWP_NOACTIVATE
#define SetWPos(hwnd,x,y) SetWindowPos(hwnd,NULL,x,y,0,0, SWP_NOSIZE | SWP_NOFLAGS)
#define SetWSize(hwnd,wd,ht) SetWindowPos(hwnd,NULL,0,0,wd,ht, SWP_NOMOVE | SWP_NOFLAGS)
#define SetWRect(hwnd,x,y,wd,ht) MoveWindow(hwnd,x,y,wd,ht,1) //SetWindowPos(hwnd,NULL,x,y,wd,ht, SWP_NOFLAGS)
#define GetWStyle(hwnd) GetWindowLongPtr(hwnd,GWL_STYLE)
#define SetWStyle(hwnd,style) SetWindowLongPtr(hwnd,GWL_STYLE,style)
#define FlagOnWStyle(hwnd,flags) SetWStyle(hwnd,GetWStyle(hwnd)|flags)
#define FlagOffWStyle(hwnd,flags) SetWStyle(hwnd,GetWStyle(hwnd)&~(flags))
#define SetWFont(hwnd,font) SendMessage(hwnd,WM_SETFONT,(WPARAM)(font),0);

//Workaround for missing TVN_ITEMCHANGED in Windows XP
#define TVN_ASYNC_ITEMCHANGED 0x9000

#define pure_merge_pixel(ppixel,f,col) \
	float g=1-f; color col2;\
	set_byte0(ppixel,(umint)(get_byte0(ppixel)*g));\
	set_byte1(ppixel,(umint)(get_byte1(ppixel)*g));\
	set_byte2(ppixel,(umint)(get_byte2(ppixel)*g));\
	set_byte0(&col2,(umint)(get_byte0(&col)*f));\
	set_byte1(&col2,(umint)(get_byte1(&col)*f));\
	set_byte2(&col2,(umint)(get_byte2(&col)*f));\
	set_byte0(ppixel,get_byte0(ppixel)+get_byte0(&col2));\
	set_byte1(ppixel,get_byte1(ppixel)+get_byte1(&col2));\
	set_byte2(ppixel,get_byte2(ppixel)+get_byte2(&col2))

#define merge_pixel(ppixel,f,col) \
	{bint bb; float ff;\
	if(*ppixel==0) bb=1; elif(*ppixel==0x00FFFFFF) bb=0;\
	else bb=((u16int)get_byte0(ppixel)+get_byte1(ppixel)+get_byte2(ppixel) <= (u16int)get_byte0(&col)+get_byte1(&col)+get_byte2(&col));\
	if(bb) ff=f*(2.0F-f); else ff=0.5F*(f+f*f);\
	 pure_merge_pixel(ppixel,ff,col);\
	}

#define COLOR_BLACK 0
#define COLOR_DEFAULT GetSysColor(COLOR_WINDOWTEXT)
#define PrepareForText(hdc,hfont,col) \
	SelectObject(hdc,hfont);\
	SetTextAlign(hdc,TA_BASELINE); SetBkMode(hdc,TRANSPARENT);\
	SetTextColor(hdc,col);

#define SetWindowText_u16(hwnd,texto) SetWindowTextW(hwnd,(LPCWSTR)texto)
#define MessageBox_u16(hwnd,mensaje,caption,buttons) MessageBoxW(hwnd,(LPCWSTR)mensaje,(LPCWSTR)caption,buttons)
