#include "Dialogos.h"
//From "shlwapi.h"
extern "C" BOOL __stdcall PathFileExistsW(LPCWSTR pszPath);

DialogoAbrir::DialogoAbrir(){
	setup_done=0;
	WinDialog.lStructSize=usizeof(OPENFILENAMEW);
	WinDialog.lpstrCustomFilter=NULL;
	WinDialog.nMaxCustFilter=0;
	WinDialog.lpstrFile=(LPWSTR)FullFileName;
	WinDialog.nMaxFile=MAX_PATH;
	WinDialog.lpstrFileTitle=NULL;	//No hace falta
	WinDialog.nMaxFileTitle=0;
	WinDialog.lpstrInitialDir=NULL;
	WinDialog.Flags=OFN_EXPLORER;
	WinDialog.lpstrDefExt=NULL;
	WinDialog.lCustData=NULL;
	WinDialog.lpfnHook=NULL;
	WinDialog.lpTemplateName=NULL;
	WinDialog.pvReserved=NULL;
	WinDialog.dwReserved=0;
	WinDialog.FlagsEx=OFN_EX_NOPLACESBAR;

	estado=DLGA_SOLOABRIR;
	option_flags=0;
	owner=NULL;
	titulo_abrir=u"Abrir";
	titulo_guardar=u"Guardar";
	filtro=u"*.*\0*.*\0";
	FullFileName[0]=u'\0';
	filtro_i=0;
	index_to_filename=0;
	index_to_extension=0;
}

//Solamente se llama si el dilogo es para crear un fichero.
//Hay que comprobar que el fichero no existe.
UINT_PTR CALLBACK DialogoAbrir_HookProc(HWND _unused(hwnd), UINT msg, WPARAM _unused(wParam), LPARAM lParam){
	OFNOTIFYW *ptr;
	switch(msg){
		case WM_NOTIFY:
			ptr=(OFNOTIFYW*)lParam;
			if(ptr->hdr.code!=CDN_FILEOK) return 0;
			if(PathFileExistsW(ptr->lpOFN->lpstrFile)){
				SetWindowLongPtr(ptr->hdr.hwndFrom,DWLP_MSGRESULT,FNERR_INVALIDFILENAME);
				return 1;
			}
			return 0;
		default:
			return 0;
	}
}

bool DialogoAbrir::Mostrar(void){
	WinDialog.hwndOwner=owner->hwnd;
	WinDialog.lpstrFilter=(LPCWSTR)filtro;
	WinDialog.nFilterIndex=filtro_i;
	DWORD flag=OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST;
	if(estado!=DLGA_SOLOABRIR) WinDialog.Flags |= flag;
	else WinDialog.Flags &= ~flag;
	if(option_flags | DLGA_F_READONLY) WinDialog.Flags &= ~OFN_HIDEREADONLY;
	else WinDialog.Flags |= OFN_HIDEREADONLY;
	if(estado==DLGA_SOLONUEVO) WinDialog.lpfnHook=DialogoAbrir_HookProc;
	else WinDialog.lpfnHook=NULL;

	bool bret;
	if(estado!=DLGA_GUARDAR){
		WinDialog.lpstrTitle=(LPCWSTR)titulo_abrir;
		bret=GetOpenFileNameW(&WinDialog)!=0;
	}else{
		WinDialog.lpstrTitle=(LPCWSTR)titulo_guardar;
		bret=GetSaveFileNameW(&WinDialog)!=0;
	}
	//if(FullFileName[MAX_PATH-1]!=u'\0') bret=0;	//no es necesario. Ya lo hace Windows
	FullFileName[MAX_PATH-1]=u'\0';
	if(bret){
		filtro_i=(u8int)WinDialog.nFilterIndex;
		index_to_filename=WinDialog.nFileOffset;
		index_to_extension=WinDialog.nFileExtension;
		if(index_to_extension==0) index_to_extension=strlen16(FullFileName);
	}
	return bret;
}
