int __declspec(dllexport) makeCursorBN(NativeCursor *resultado, const CursorBN *cursor){
	uint nF, nC;
	bint empty_cols;
	nF=((cursor->width+15) &~0xFU)>>3;
	nC=(cursor->height+15) &~0xFU;
	resultado->and_mask=n_malloc(BYTE,nF*nC);
	resultado->xor_mask=n_malloc(BYTE,nF*nC);
	ifunlike(resultado->and_mask==NULL || resultado->xor_mask==NULL){
		freeif(resultado->and_mask);
		freeif(resultado->xor_mask);
		return AT_NOMEM;
	}
	empty_cols=(cursor->width+7)&0x8;

	const umint *pmatriz=cursor->matriz;
	BYTE *pand=resultado->and_mask;
	BYTE *pxor=resultado->xor_mask;
	dontimes(cursor->height,){
		dontimes(cursor->width>>3,(pand++,pxor++)){
			dontimes(8,pmatriz++){
				*pand<<=1;	*pand |=(BYTE)((*pmatriz>>1)&1);
				*pxor<<=1;	if(*pmatriz==0 || *pmatriz==3) *pxor|=1;
			}
		}
		if(cursor->width&7){
			dontimes(cursor->width&7,pmatriz++){
				*pand<<=1;	*pand |=(BYTE)((*pmatriz>>1)&1);
				*pxor<<=1;	if(*pmatriz==0 || *pmatriz==3) *pxor|=1;
			}
			dontimes(8-(cursor->width&7),){
				*pand<<=1; *pand|=1;
				*pxor<<=1;
			}
			pand++, pxor++;
		}
		if(empty_cols){
			*pand++=0xFF; *pxor++=0;
		}
	}
	if(nC!=cursor->height){
		uint N=(nC-cursor->height)*nF*usizeof(BYTE);
		oneset(pand,N);
		zeroset(pxor,N);
	}
	resultado->cur=CreateCursor(NULL,cursor->xcenter,cursor->ycenter,nF<<3,nC,resultado->and_mask,resultado->xor_mask);
	return 0;
}
int __declspec(dllexport) makeCursorBN_Bitmap(NativeCursor *resultado, const Bitmap *cursor){
	if(cursor->type>=2) return 1;
	uint nF, nC;
	u8int w7, ex_f, fnot8, ex_c, resto;
	bint empty_cols;
	nF=((cursor->width+15) &~0xFU)>>3;
	nC=(cursor->height+15) &~0xFU;
	ex_f=(u8int)((nF<<3)-cursor->width);
	ex_c=(u8int)(nC-cursor->height);
	resultado->and_mask=n_malloc(BYTE,nF*nC);
	resultado->xor_mask=n_malloc(BYTE,nF*nC);
	ifunlike(resultado->and_mask==NULL || resultado->xor_mask==NULL){
		freeif(resultado->and_mask);
		freeif(resultado->xor_mask);
		return AT_NOMEM;
	}
	empty_cols=(cursor->width+7)&0x8;
	fnot8=8-(ex_f>>1);
	w7=cursor->width&7;
	resto=ex_f-(ex_f>>1);

	zeroset(resultado->xor_mask,nF*nC*usizeof(BYTE));
	const umint *pmatriz=(umint*)cursor->matriz;
	BYTE *pand=resultado->and_mask;
	oneset(pand,nF*(ex_c>>1));
	pand+=nF*(ex_c>>1);
	dontimes(cursor->height,){
		*pand=0xFF;
		dontimes(cursor->width>>3,){
			dontimes(fnot8,pmatriz++){*pand<<=1; *pand|= (*pmatriz^1);}
			pand++;
			dontimes(ex_f>>1,pmatriz++){*pand<<=1; *pand|= (*pmatriz^1);}
		}
		if(w7){
			u8int k;
			if(w7<=fnot8) k=w7;
			else k=fnot8;
			dontimes(k,pmatriz++){*pand<<=1; *pand|= (*pmatriz^1);}
			if(w7>fnot8){
				pand++;
				dontimes(w7-fnot8,pmatriz++){*pand<<=1; *pand|= (*pmatriz^1);}
			}
		}
		if(resto==8) *pand++=0xFF;
		elif(resto){
			dontimes(resto,){*pand<<=1; *pand|=1;}
			pand++;
		}
	}
	if(nC!=cursor->height){
		uint N=(ex_c-(ex_c>>1))*nF*usizeof(BYTE);
		oneset(pand,N);
	}
	resultado->cur=CreateCursor(NULL,ex_f>>1,ex_c>>1,nF<<3,nC,resultado->and_mask,resultado->xor_mask);
	return 0;
}
void __declspec(dllexport) destroyCursor(NativeCursor *cursor){
	free(cursor->and_mask);
	free(cursor->xor_mask);
	DestroyCursor(cursor->cur);
}
