#include "Control.h"

__declspec(dllexport) LRESULT Control::HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
	switch(message){
	case WM_SIZE:
		if(wParam==SIZE_MINIMIZED) break;
		this->width=LOWORD(lParam);
		this->height=HIWORD(lParam);
		if(this->Resized.isEmpty()) break;
		this->Resized.Call(this,0,0);
		return 0;
	case WM_COMMAND_CLICK:
		if(this->ButtonClicked.isEmpty()) break;
		return this->ButtonClicked.Call(this, wParam,lParam);
	case WM_KEYDOWN:
	case WM_KEYUP:
		{HWND hwnd_p=(HWND)GetWindowLongPtr(hwnd,GWLP_HWNDPARENT);
		if(hwnd_p!=NULL) return SendMessage(hwnd_p,message,wParam,lParam);}
		break;
	}
	return this->RootGraphicWindow::HostedWndProc(message, wParam, lParam);
}

__declspec(dllexport) void DrawBitmap(HDC hdc, int control_wd, int control_ht, uint background_color, const Bitmap *imagen){
	HDC hdc_copia;
	BITMAPINFO bitsinfo;
	COLORREF *seccion_hdc;
	HBITMAP bitmap;

	bitsinfo.bmiHeader.biSize=usizeof(BITMAPINFOHEADER);
	bitsinfo.bmiHeader.biWidth=imagen->width;
	bitsinfo.bmiHeader.biHeight=-(ssint)imagen->height;
	bitsinfo.bmiHeader.biPlanes=1;
	bitsinfo.bmiHeader.biBitCount=CHAR_BIT*usizeof(COLORREF);
	bitsinfo.bmiHeader.biCompression=BI_RGB;
	bitsinfo.bmiHeader.biSizeImage=imagen->width*imagen->height*usizeof(COLORREF);

	hdc_copia=CreateCompatibleDC(hdc);
	bitmap=CreateDIBSection(hdc, &bitsinfo, DIB_RGB_COLORS, (void**)&seccion_hdc, NULL, 0);
	if(bitmap==NULL){
		DeleteDC(hdc_copia);
		return;
	}
	SelectObject(hdc_copia,bitmap);

	{umint a=get_byte0(&background_color);
	set_byte0(&background_color,get_byte2(&background_color));
	set_byte2(&background_color,a);}
	if(imagen->type==0){
		umint *pmatriz=(umint*)imagen->matriz;
		dontimes(imagen->height,){
		dontimes(imagen->width,){
			if(*pmatriz==0) *seccion_hdc=background_color;
			else *seccion_hdc=0;
			seccion_hdc++, pmatriz++;
		}}
	}elif(imagen->type==1){
		umint *pmatriz=(umint*)imagen->matriz;
		dontimes(imagen->height,){
		dontimes(imagen->width,){
			float fl, ratio;
			ratio=1.0F-(float)*pmatriz/255;
			fl=get_byte0(seccion_hdc)*ratio;	set_byte0(seccion_hdc,(umint)(fl+0.5F));
			fl=get_byte1(seccion_hdc)*ratio;	set_byte1(seccion_hdc,(umint)(fl+0.5F));
			fl=get_byte2(seccion_hdc)*ratio;	set_byte2(seccion_hdc,(umint)(fl+0.5F));
			seccion_hdc++, pmatriz++;
		}}
	}else{
		uint *pmatriz=(uint*)imagen->matriz;
		dontimes(imagen->height,){
		dontimes(imagen->width,){
			*seccion_hdc++=*pmatriz++;
		}}
	}
	seccion_hdc-=imagen->width*imagen->height;
	BitBlt(hdc,(control_wd-imagen->width)/2,(control_ht-imagen->height)/2,imagen->width,imagen->height,hdc_copia,0,0,SRCCOPY);

	DeleteObject(bitmap);
	DeleteDC(hdc_copia);
}
__declspec(dllexport) void Dibuja_Icono_en_Control(HWND hwnd,const Bitmap *icono){
	HDC hdc=GetDC(hwnd);
	RECT rect;
	GetClientRect(hwnd,&rect);
	DrawBitmap(hdc,rect.right,rect.bottom,AT_color6,icono);
	ReleaseDC(hwnd,hdc);
}
