﻿struct Margenes{
	int left, right;
	int top, bottom;
	inline int H(){return left+right;}
	inline int V(){return top+bottom;}
};
struct TwoDimAlignment{
	float horz, vert;
};

enum PositionModeVert{
	PMV_None,					//Ignore lines. Use ContentAlignment.y normally, setting the alignment point at RefPos.y
	PMV_FirstBaseline,		//Set the first baseline to RefPos.y
	PMV_LastBaseline,		//Set the last baseline to RefPos.y
	PMV_Midline,				//Set to RefPos.y either the middle baseline, if the number of lines is odd
									//or the midpoint between the two central baselines, if it is even
	PMV_NearestBaseline,	//Compute the location according to ContentAlignment.y, then move the content so that the nearest baseline to RefPos.y coincides with the position thus computed
};

struct Box{
	POINT pos;
	SIZE sz;
};

struct Boxed{
	Box box;
	uint first, n;	//subset of characters from the whole text this box contains
	ssint baselinepos;	//With respect to top of box
};

struct VStack{
	Boxed* boxes;
	uint n;
};

/* Label con punto de referencia a elegir, así como la posición del texto dentro de ella.

	Las coordenadas del punto de referencia son RefPos. La posición de este punto
	en relación al rectángulo que ocupa el control es refleft, reftop, heredado de "Control",

	La alineación del texto dentro de la etiqueta es ContentAlignment. Son float que van
	de 0 a 1 (normalmente). La variable Autoref controla si un cambio se ContentAlignment
	cambia automáticamente refleft y reftop al mismo valor.

	ContentAlignment.horz alinea cada línea dentro del ancho total (InteriorWidth)
	ContentAlignment.vert alinea el conjunto del texto dentro del ancho total (InteriorHeight).
	En realidad, el modo de alinear en vertical puede ser distinto. Depende del valor de valignmode.
	Algunos de estos modos usan ContentAlignment.vert y otros no.
*/
class BasicLabel : public ControlF{
protected:
	const char16_t* texto;
	Box onelinebox;
	int totalheight;	//total height of stacked boxes
	Boxed* boxes;
	uint nboxes;
public:
	PositionModeVert valignmode;
	TwoDimAlignment contentalignment;
	int maxwidth;
	int maxheight;
	bool autosizex, autosizey;
	Margenes margins;
	int interlinespace;
	bool wordwrap;
	bool Autoref;	//Whether a change of alignmentxy automatically changes refpostionx/y to the same values

	IMP_EXP virtual void Paint(PAINTSTRUCT *ps) override;
	BasicLabel() :
		valignmode(PMV_None),
		maxwidth(10000),
		maxheight(10000),
		autosizex(true),
		autosizey(true),
		wordwrap(true),
		interlinespace(0),
		totalheight(0),
		boxes(NULL),
		nboxes(0),
		Autoref(true)
	{
		contentalignment.horz=0;
		contentalignment.vert=0;
		margins.left=margins.right=0;
		margins.top=margins.bottom=0;
	}
	virtual ~BasicLabel(){
		freeif(boxes);
	}

	int InteriorWidth(void){return width-margins.H();}
	int InteriorHeight(void){return height-margins.V();}
	const char16_t* get_texto(void) const{return texto;}
	void set_texto(const char16_t* t){texto=t; setlabel();}

protected:
	struct BreakPoint{
		uint previous;	//Index into possiblebreaks. If ==(uint)-1 this is the first line
		ssint pos;
		ssint width;	//Width of this line
		ssint wmax;	//Maximum width of the remaining lines
	};

	void update_aligny(void);
	static VStack decide_boxes(HDC hdc, ssint maxhsize,ssint baseline,bool wordwrap, const char16_t* texto, int *w1);
	IMP_EXP void setlabel(void);
	void setvlabel(void);
	void placeboxes(void);
};
