#include "BasicLabel.h"
#include <math.h>


void BasicLabel::update_aligny(void){
	int offsety;
	if(valignmode==PMV_None) return;
	if(nboxes==0){alignv=0; return;}

	if(nboxes==1 || valignmode==PMV_FirstBaseline){offsety=boxes[0].box.pos.y+boxes[0].baselinepos;}
	elif(valignmode==PMV_LastBaseline){offsety=boxes[nboxes-1].box.pos.y+boxes[nboxes-1].baselinepos;}
	elif(valignmode==PMV_Midline){
		int k=nboxes>>1;
		if(nboxes&1) offsety=boxes[k].box.pos.y+boxes[k].baselinepos;
		else offsety=(boxes[k-1].box.pos.y+boxes[k-1].baselinepos+boxes[k].box.pos.y+boxes[k].baselinepos+1)/2;
	}else{//Nearestbaseline
		int k1,k2;		//Lo de siempre. Estpido compilador!
		offsety=(int)floorf(alignv*this->height+0.5F);
		k2=boxes[0].box.pos.y+boxes[0].baselinepos;
		for(uint i=1;i<nboxes;i++){
			k1=k2;
			k2=boxes[0].box.pos.y+boxes[0].baselinepos;
			if(k2>=offsety) break;
		}
		if(k2-offsety<offsety-k1) offsety=k2;	//this also works for offsety<0 or >lastbaseline
		else offsety=k1;
	}
	alignv=(float)this->height/(float)offsety;
}

#define isblank(c) ((c)==' ' || (c)=='\t')
#define absbreak(i) ((i)&~0x80000000U)
#define isblankbreak(i) ((i)&0x80000000U)
VStack BasicLabel::decide_boxes(HDC hdc, ssint maxhsize,ssint baselinepos, bool wordwrap, const char16_t* texto, int *w1){
	const char16_t *end, *Texto;
	char16_t* copia;	//needed ouside the block that creates it for freeing (Texto is const cannot be passed to free)
	SIZE onelinesize;
	VStack vstack;
	uint i,n,k;
	vstack.boxes=NULL;

	for(end=texto;*end!='\0';end++);
	iflike(end!=texto){
		for(end--; end>=texto && isblank(*end);end--);
		end++;
	}
	ifunlike(end==texto){
		*w1=0;
		vstack.boxes=new Boxed[0];
		vstack.n=0;
		return vstack;
	}

	n=(pdif)(end-texto);
	if(*end!='\0'){	//we went back
		copia=n_malloc(char16_t,n);
		memcpy_char16(copia,texto,n);
		Texto=copia;
	}else{
		Texto=texto;
	}

	GetTextExtentPoint_u16(hdc,Texto,n,&onelinesize);

	if(onelinesize.cx<=maxhsize || wordwrap==false){
oneline:
		vstack.boxes= new Boxed[1];
		vstack.n=1;
		vstack.boxes[0].box.sz=onelinesize;
		vstack.boxes[0].first=0;
		vstack.boxes[0].n=n;
		vstack.boxes[0].baselinepos=baselinepos;
		*w1=onelinesize.cx;
		if(Texto!=texto) free(copia);
		return vstack;
	}

	uint *prov, *possiblebreaks;
	//Feasible break points. The break point is placed before the position indexed by the integer.
	//Thus, 10 indicates ten characters before the break, and the remaining ones after.
	//If the element at the position indexed is a space, tab it disappears after the break, and the index is stored negative;
	prov= n_malloc(uint,n);
	{const char16_t *ptr=Texto+1;
	uint *pprov=prov;
	for(;*ptr!='\0';ptr++){
		char16_t c=*ptr;
		if(isblank(c) || c=='-' || c=='\\'){
			*pprov=(pdif)(ptr-Texto);
			if(isblank(c)) *pprov|=0x80000000U;
			pprov++;
		}
	}
	k=(pdif)(pprov-prov);
	}
	if(k==0){
		free(prov);
		goto oneline;
	}
	possiblebreaks= new uint[k+1];
	memcpy_uint(possiblebreaks,prov,k);
	possiblebreaks[k]=n;
	free(prov);

	uint j,k1,l1;
	int w0,v0,v1;
	SIZE sizeaux;
	//mirar a ver si cabe en dos lineas (o si no queda ms remedio)
	bool b=false;
	if(k==1){i=0; b=true;} if(k==1) goto b_decidido;
	j=n/2;
	for(i=0;i<k;i++){
		if(absbreak(possiblebreaks[i])>j) break;
	}
	if(i==k) i=k-1;
	l1=k1=absbreak(possiblebreaks[i]);
	if(isblankbreak(possiblebreaks[i])) l1++;
	GetTextExtentPoint_u16(hdc,Texto,k1,&sizeaux);		w0=sizeaux.cx;
	GetTextExtentPoint_u16(hdc,Texto+l1,n-l1,&sizeaux);	*w1=sizeaux.cx;
	if(w0>maxhsize && *w1>maxhsize){b=false; goto b_decidido;}
	if(w0==*w1 && w0<=maxhsize){b=true; goto b_decidido;}
	if(w0<*w1){
		for(i++;i<k;i++){
			v0=w0;
			v1=*w1;
			l1=k1=absbreak(possiblebreaks[i]);
			if(isblankbreak(possiblebreaks[i])) l1++;
			GetTextExtentPoint_u16(hdc,Texto,k1,&sizeaux);		w0=sizeaux.cx;
			GetTextExtentPoint_u16(hdc,Texto+l1,n-l1,&sizeaux);	*w1=sizeaux.cx;
			if(w0>=*w1) break;
		}
		if(i==k){
			if(w0<=maxhsize){i--; b=true;}
			else{b=false;}
			goto b_decidido;
		}
	}else{
		v0=w0; v1=*w1;
		while(i--){
			w0=v0;
			*w1=v1;
			l1=k1=absbreak(possiblebreaks[i]);
			if(isblankbreak(possiblebreaks[i])) l1++;
			GetTextExtentPoint_u16(hdc,Texto,k1,&sizeaux);		v0=sizeaux.cx;
			GetTextExtentPoint_u16(hdc,Texto+l1,n-l1,&sizeaux);	v1=sizeaux.cx;
			if(v0<=v1) break;
		}
		if(++i==0){
			if(*w1<=maxhsize) b=true;
			else b=false;
			goto b_decidido;
		}
	}
	if(v1<w0){w0=v0; *w1=v1; i--;}
	if(w0<=maxhsize && *w1<=maxhsize) b=true;
b_decidido:
	if(b==true){
		vstack.boxes=new Boxed[2];
		vstack.n=2;
		vstack.boxes[0].first=0;
		vstack.boxes[1].first=vstack.boxes[0].n=absbreak(possiblebreaks[i]);
		if(isblankbreak(possiblebreaks[i])) vstack.boxes[1].first++;
		vstack.boxes[1].n=n-vstack.boxes[1].first;
		GetTextExtentPoint_u16(hdc,Texto,vstack.boxes[0].n,&vstack.boxes[0].box.sz);
		GetTextExtentPoint_u16(hdc,Texto+vstack.boxes[1].first,vstack.boxes[1].n,&vstack.boxes[1].box.sz);
		vstack.boxes[1].baselinepos=vstack.boxes[0].baselinepos=baselinepos;
		*w1=vstack.boxes[0].box.sz.cx;
		if(vstack.boxes[1].box.sz.cx>*w1) *w1=vstack.boxes[1].box.sz.cx;
		free(possiblebreaks);
		if(Texto!=texto) free(copia);
		return vstack;
	}
//3 or more lines
	uint nlines,lx,kk;
	BreakPoint *breakpoints, *candidates;
	bool retrying=false;
	*w1=maxhsize;
retry:
	candidates=new BreakPoint[k+1];
	k1=0;
	for(nlines=0,i=-1;;){
		candidates[nlines].previous=i;
		for(i++;i<=k;i++){
			l1=absbreak(possiblebreaks[i]);
			GetTextExtentPoint_u16(hdc,Texto+k1,l1-k1,&sizeaux);		w0=sizeaux.cx;
			if(w0>*w1) break;
			v0=w0;
		}
		i--;
		if(i==candidates[nlines].previous){v0=w0; i++;}
		candidates[nlines].pos=i;
		candidates[nlines++].width=v0;
		if(i==k) break;
		k1=absbreak(possiblebreaks[i]);
		if(isblankbreak(possiblebreaks[i])) k1++;
	}
	breakpoints= new BreakPoint[nlines];
	memcpy_uint(breakpoints,candidates,nlines*uintsizeof(BreakPoint));

	b=false;
	breakpoints[nlines-1].wmax=0;
	*w1=breakpoints[nlines-1].width;
	lx=nlines-1;
	for(i=nlines-1;i>0;){
		i--;
		breakpoints[i].wmax=*w1;
		if(breakpoints[i].width>*w1){*w1=breakpoints[i].width; lx=i;}
	}
	if(retrying) goto lines_decided;
	free(candidates);
	if(*w1>maxhsize){
		free(breakpoints);
		retrying=true; goto retry;
	}
	candidates=new BreakPoint[nlines];
	while(true){
		if(lx==nlines-1 || (breakpoints[lx].pos-breakpoints[lx].previous==1)) goto lines_decided;
		v1=*w1;
		memcpy_uint(candidates,breakpoints,(lx+1)*uintsizeof(BreakPoint));
		i=breakpoints[lx].previous;
		if(lx==0) k1=0;
		else{
			k1=absbreak(possiblebreaks[i]);
			if(isblank(possiblebreaks[i])) k1++;
		}
		for(j=lx;j<nlines-1;){
			candidates[j].previous=i;
			kk=breakpoints[j].pos;
			for(i++;i<=kk;i++){
				l1=absbreak(possiblebreaks[i]);
				GetTextExtentPoint_u16(hdc,Texto+k1,l1-k1,&sizeaux);	w0=sizeaux.cx;
				if(w0>=v1) break;
				v0=w0;
			}
			i--;
			if(i==candidates[j].previous) goto lines_decided;
			candidates[j].pos=i;
			candidates[j].width=v0;
			if(i==kk){
				candidates[j].wmax=breakpoints[j].wmax;
				memcpy_uint(breakpoints+lx,candidates+lx,(j+1-lx)*uintsizeof(BreakPoint));
				break;
			}
			j++;
			k1=absbreak(possiblebreaks[i]);
			if(isblank(possiblebreaks[i])) k1++;
		}
		if(j==nlines-1){
			GetTextExtentPoint_u16(hdc,Texto+k1,n-k1,&sizeaux);	v0=sizeaux.cx;
			if(v0>=v1) goto lines_decided;
			memcpy_uint(breakpoints,candidates,(nlines-1)*uintsizeof(BreakPoint));
			breakpoints[j].previous=i;
			*w1=breakpoints[nlines-1].width=v0;
			lx=nlines-1;
		}else{
			*w1=breakpoints[j].wmax;
			for(i=j+1;i<nlines;i++){
				if(breakpoints[i].wmax!=*w1) break;
			}
			lx=i;
		}
		for(i=lx;i>0;){
			i--;
			breakpoints[i].wmax=*w1;
			if(breakpoints[i].width>*w1){*w1=breakpoints[i].width; lx=i;}
		}
	}
lines_decided:
	free(candidates);
	vstack.boxes= new Boxed[nlines];
	vstack.n=nlines;
	l1=0;
	for(i=0;i<nlines;i++){
		k1=l1;
		l1=possiblebreaks[breakpoints[i].pos];
		vstack.boxes[i].first=k1;
		vstack.boxes[i].n=absbreak(l1)-k1;
		GetTextExtentPoint_u16(hdc,Texto+k1,vstack.boxes[i].n,&vstack.boxes[i].box.sz);
		vstack.boxes[i].baselinepos=baselinepos;
		if(isblankbreak(l1)) l1=absbreak(l1)+1;
	}
	free(breakpoints);
	free(possiblebreaks);
	if(Texto!=texto) free(copia);
	return vstack;
}

void BasicLabel::placeboxes(void){
	int currenttop;
	currenttop=margins.top+(int)floorf(this->contentalignment.vert*(InteriorHeight()-totalheight)+0.5F);
	durchlaufei(Boxed,boxes,nboxes){
		ptri->box.pos.x=margins.left+(int)floorf(this->contentalignment.horz*(InteriorWidth()-ptri->box.sz.cx)+0.5F);
		ptri->box.pos.y=currenttop+ptri->baselinepos;
		currenttop+=ptri->box.sz.cy+interlinespace;
	}
	update_aligny();
}

__declspec(dllexport) void BasicLabel::setlabel(void){
	uint bln=nboxes;
	char16_t *texto;	//in case this->texto points to a const-char8_t array
	uint n;
	HDC hdc;
	TEXTMETRIC metrics;
	HFONT hfont;
	const POINT pos0={0,0};

	free_null_if(boxes);
	hfont=NULL;
	if(!(this->texto==NULL || *this->texto=='\0' || (*this->texto=='\n' && this->texto[1]=='\0'))){
		const char16_t *end;
		for(end=this->texto;*end!='\0';end++);
		if(*(end-1)=='\n' || *(end-1)=='\r') end--;
		while(end--!=this->texto && (*end==' ' || *end=='\t'));
		if(++end!=this->texto) hfont=CreateFontIndirect(this->font);
		n=(pdif)(end-this->texto);
	}
	if(hfont==NULL){
		boxes=new Boxed[0];
		nboxes=0;
		if(this->width==0 && this->height==0) return;
		if(autosizex) this->width=0;
		if(autosizey) this->height=0;
		goto done;
	}

	texto=n_malloc(char16_t,n+1);
	memcpy_char16(texto,this->texto,n);
	texto[n]='\0';

	int maxhsize, maxvsize;		//si autosizex=false, setting Size, Width or Height changes size and hence this is the value to be used.
	if(autosizex) maxhsize=maxwidth;	else maxhsize=this->width;		maxhsize-=margins.H();
	if(autosizey) maxvsize=maxheight;	else maxvsize=this->height;		maxvsize-=margins.V();

	hdc=GetDC(this->hwnd);
	SelectObject(hdc,hfont);
	GetTextMetrics(hdc,&metrics);

	onelinebox.pos=pos0;
	GetTextExtentPoint_u16(hdc,texto,n,&onelinebox.sz);
	int lineheight=metrics.tmHeight;
	int baseline=metrics.tmAscent;

	uint k;
	uint *prov, *newlines;
	prov=n_malloc(uint,n);
	k=0;
	for(uint i=0;i<n;i++){
		if(texto[i]=='\r' || texto[i]=='\n') prov[k++]=i;
	}
	newlines= n_malloc(uint,k+1);
	memcpy_uint(newlines,prov,k);
	newlines[k++]=n;
	free(prov);

	VStack* vstacks=n_malloc(VStack,k);
	uint* firstchars=n_malloc(uint,k);
	int* groupwidths=n_malloc(int,k);
	{uint ll=-1;
	VStack *ptrv=vstacks;
	int *ptrw=groupwidths;
	for(uint i=0;i<k;i++,ptrv++,ptrw++){
		uint l=ll+1;
		ll=newlines[i];
		while(l<ll && isblank(texto[l])) l++;	//ll may be igual a n
		firstchars[i]=l;
		if(ll==l){	//firstchars[i]==newlines[i]
			ptrv->boxes=new Boxed[0];
			ptrv->n=0;
			*ptrw=0;
		}else{
			char16_t c=texto[ll];
			texto[ll]='\0';
			*ptrv=decide_boxes(hdc,maxhsize,baseline,wordwrap,texto+l,ptrw);
			texto[ll]=c;
		}
		if(ptrv->n==0){	//so that the MidLine valignment mode works properly
			free(ptrv->boxes);
			ptrv->boxes=new Boxed[1];
			ptrv->n=1;
			ptrv->boxes[0].first=0;	//l will be added later
			ptrv->boxes[0].n=0;
			ptrv->boxes[0].box.pos=pos0;
			ptrv->boxes[0].box.sz.cx=0;
			ptrv->boxes[0].box.sz.cy=lineheight;
			ptrv->boxes[0].baselinepos=baseline;
		}
	}}
	nboxes=0;
	{durchlaufei(VStack,vstacks,k) nboxes+=ptri->n;}
	boxes=new Boxed[nboxes];
	{Boxed *ptrb=boxes;
	VStack *ptrv=vstacks;
	uint *ptrf=firstchars;
	dontimes(k,ptrv++){
		uint fc=*ptrf++;
		durchlaufej(Boxed,ptrv->boxes,ptrv->n){
			*ptrb=*ptrj;
			ptrb++->first+=fc;
		}
		free(ptrv->boxes);
	}}
	free(vstacks);
	free(texto);
	DeleteObject(hfont);

	SIZE sz;
	if(autosizex){
		int w1=0;
		durchlaufei(int,groupwidths,k){if(*ptri>w1) w1=*ptri;}
		if(w1>maxhsize) sz.cx=maxhsize;
		else sz.cx=w1;
		sz.cx+=margins.H();
	}else{
		sz.cx=this->width;
	}
	totalheight=0;
	{durchlaufei(Boxed,boxes,nboxes){totalheight+=interlinespace+ptri->box.sz.cy;}}
	if(autosizey){
		if(totalheight>maxheight) sz.cy=maxheight;
		else sz.cy=totalheight;
		sz.cy+=margins.V();
	}else{
		sz.cy=this->height;
	}
	//if(sz.cx!=this->width || sz.cy!=this->height)
	this->width=sz.cx;
	this->height=sz.cy;
	placeboxes();
done:
	if(bln!=nboxes) /*OnLinesChanged(EventArgs.Empty)*/;
	//if(bsz){
	//	OnInternalSizeChanged(EventArgs.Empty);
	//	base.Size=size;	//Actually set the size. This calls OnSizeChanged()
	//}
	//if(this.Location!=base.Location){
	//	OnInternalLocationChanged(EventArgs.Empty);
	//	base.Location=this.Location;	//Set the Location. This calls OnLocationChanged();
	//}
	InvalidateRect(hwnd,NULL,false);
	this->Draw(true);
	//this.Invalidate();
}

void BasicLabel::setvlabel(void){
	if(boxes==NULL || this->nboxes==0) return;

	totalheight=boxes[0].box.sz.cx;
	for(uint i=1;i<nboxes;i++)
		totalheight+=interlinespace+boxes[i].box.sz.cx;
	int sy;
	if(autosizey){
		if(totalheight>maxheight) sy=maxheight;
		else sy=totalheight;
		sy+=margins.V();
	}else{
		sy=this->height;
	}
	int currenttop;
	currenttop=margins.top+(int)floorf(contentalignment.vert*(this->InteriorHeight()-totalheight)+0.5F);
	{durchlaufei(Boxed,boxes,nboxes){
		ptri->box.pos.y=currenttop;
		currenttop+=interlinespace+ptri->box.sz.cy;
	}}
	if(sy!=this->height){
		//OnInternalSizeChanged(EventArgs.Empty);
		this->height=sy;
	}
	update_aligny();
	InvalidateRect(hwnd,NULL,false);
	this->Draw(true);
	//this.Invalidate();
}

__declspec(dllexport) void BasicLabel::Paint(PAINTSTRUCT *ps){
	if(boxes==NULL || nboxes==0) return;
	HFONT hfont=CreateFontIndirect(this->font);
	PrepareForText(ps->hdc,hfont,COLOR_DEFAULT);
	durchlaufei(Boxed,boxes,nboxes){
		TextOut_u16(ps->hdc,ptri->box.pos.x,ptri->box.pos.y,texto+ptri->first,ptri->n);
		//DrawRectangle(new Pen(Color.Blue, 1), new Rectangle(boxes[i].box.Location, boxes[i].box.Size-new Size(1,1)));
	}
	//DrawRectangle(new Pen(Color.Yellow, 1), new Rectangle(new Point(margins.Left,margins.Top), new Size(this.InteriorWidth-1,this.InteriorHeight-1)));
	//DrawRectangle(new Pen(Color.Red, 1), new Rectangle(new Point(0,0), this.Bounds.Size-new Size(1,1)));
	DeleteObject(hfont);
}
