//Positions within a window
#define WPART_OUTSIDE			HTNOWHERE
#define WPART_CLIENT				HTCLIENT
#define WPART_BORDER_ANY	HTBORDER
#define WPART_BORDER_NW		HTTOPLEFT
#define WPART_BORDER_N		HTTOP
#define WPART_BORDER_NE		HTTOPRIGHT
#define WPART_BORDER_E		HTRIGHT
#define WPART_BORDER_SE		HTBOTTOMRIGHT
#define WPART_BORDER_S			HTBOTTOM
#define WPART_BORDER_SW		HTBOTTOMLEFT
#define WPART_BORDER_W		HTLEFT
#define WPART_CAPTION			HTCAPTION
//Positions within caption
//This would start at zero again, where not fot the fact that I want them to be coincident with the HT constants
#define WPARTCAP_NORMAL		HTCAPTION
#define WPARTCAP_CLOSE			HTCLOSE
#define WPARTCAP_MAXIMIZE	HTMAXBUTTON
#define WPARTCAP_MINIMIZE	HTMINBUTTON

//odd numbers are sizable borders, even numbers are not
#define WBORDER_NONE 0
#define WBORDER_SYSTEM_SIZ 1
#define WBORDER_SYSTEM_FIXED 2
#define WBORDER_LAST_ZERO 2
#define WBORDER_SINGLE 4		//single line
#define WBORDER_3D_FINO 6		//simple 3D double-line
#define WBORDER_3D_MFINO 8	//simple 3D triple-line
#define WBORDER_3D_SIZ 9
#define WBORDER_3D 10			//simple 3D four-line
#define WBORDER_ROUNDED_BORDERS 11
#define WBORDER_1L_RT	12		//1 line, rounded top
#define WBORDER_1L_RTB 14		//rounded both
#define WBORDER_1L_RB	16		//rounded bottom
#define WBORDER_4L_RT_SIZ	17
#define WBORDER_4L_RT		18	//3D (2 lines), rounded top
#define WBORDER_4L_RTB_SIZ 19
#define WBORDER_4L_RTB		20	//rounded both
#define WBORDER_4L_RB_SIZ	21
#define WBORDER_4L_RB		22	//rounded bottom

IMP_EXP extern const int WindowBorderWidths[];

struct WBorderSimple{
	COLORREF se0, nw0,
		se1, nw1,
		se23, nw23;
};

union WBorderParams{
 struct WBorderSimple simple;
};

IMP_EXP extern const WBorderParams BorderPars_color0;
IMP_EXP extern const WBorderParams BorderPars_color7;

class ATWindow : public RootGraphicWindow{
protected:
	IMP_EXP virtual LRESULT HostedWndProc(HWP_PARAMS) override;
public:
	int clientwidth, clientheight;
	int wborderstyle;
	WBorderParams *borderparams;
	int wd_iz, wd_de, wd_ar, wd_ab;

	IMP_EXP virtual ~ATWindow();
	inline void SetWBorderStyle(int b){wborderstyle=b; wd_iz=wd_de=wd_ar=wd_ab=WindowBorderWidths[b];}
	inline void WindowtoClient(POINT *p){p->x-=wd_iz; p->y-=wd_ar;}
	inline void ClienttoWindow(POINT *p){p->x+=wd_iz; p->y+=wd_ar;}
	inline int GetWidth(){return clientwidth+wd_iz+wd_de;}
	inline int GetHeight(){return clientheight+wd_ar+wd_ab;}

	inline bint is_sizable(void){return (bint)(wborderstyle&1);}
	IMP_EXP int TestPos(int x, int y);
	IMP_EXP void DrawBorder(HDC hdc);
	IMP_EXP virtual void Paint(PAINTSTRUCT *ps) override;
};
