#include "ATWindows.h"
__declspec(dllexport) extern const int WindowBorderWidths[]={\
	0,0,0,0,1,	//0-4
	2,2,3,3,4,4,	//3-8
	1,1,1,1,1,1,	//9-14
	4,4,4,4,4,4	//15-20
};

__declspec(dllexport) extern const WBorderParams BorderPars_color0={\
	0, RGB(212,208,200),
	RGB(128,128,128), 0x00FFFFFF,
	RGB(212,208,200), RGB(212,208,200)
};
__declspec(dllexport) extern const WBorderParams BorderPars_color7={\
	0x00606060, RGB(212,208,200),
	0x00A0A0A0, 0x00FFFFFF,
	AT_color0, AT_color0
};

__declspec(dllexport) ATWindow::~ATWindow(){
	if(borderparams!=NULL && borderparams!=&BorderPars_color0
		&& borderparams!=&BorderPars_color7) free(borderparams);
}

/*__declspec(dllexport) HRGN ATWindow::GetBorderRegion(void){
}*/

__declspec(dllexport) int ATWindow::TestPos(int x, int y){
	if(x<0 || x>=GetWidth() || y<0 || y>=GetHeight()) return WPART_OUTSIDE;
	if(wborderstyle<=WBORDER_LAST_ZERO) return WPART_CLIENT;
	if(!(wborderstyle&1)){
		if(x<wd_iz || x>=wd_iz+clientwidth || y<wd_ar || y>=wd_ar+clientheight) return WPART_BORDER_ANY;
		//cdigo para bordes redondos
	}else{	//Todos los bordes sizables tienen, de momento, al menos un ancho de 4px
		if(x<wd_iz){
			if(y<wd_ar) return WPART_BORDER_NW;
			if(y<wd_ar+clientheight) return WPART_BORDER_W;
			return WPART_BORDER_SW;
		}if(x>=wd_iz+clientwidth){
			if(y<wd_ar) return WPART_BORDER_NE;
			if(y<wd_ar+clientheight) return WPART_BORDER_E;
			return WPART_BORDER_SE;
		}
		if(y<wd_ar) return WPART_BORDER_N;
		if(y>=wd_ar+clientheight) return WPART_BORDER_S;
		//cdigo para bordes redondos
	}
	return WPART_CLIENT;
}

__declspec(dllexport) void ATWindow::DrawBorder(HDC hdc){
	if(wborderstyle<=WBORDER_LAST_ZERO) return;
	SelectObject(hdc, GetStockObject(DC_PEN));
	if(wborderstyle<WBORDER_ROUNDED_BORDERS){
		MoveToEx(hdc,0,GetHeight()-1,NULL);
		SetDCPenColor(hdc,borderparams->simple.nw0);
			LineTo(hdc,0,0);
			LineTo(hdc,GetWidth()-1,0);
		SetDCPenColor(hdc,borderparams->simple.se0);
			LineTo(hdc,GetWidth()-1,GetHeight()-1);
			LineTo(hdc,-1,GetHeight()-1);
		if(wborderstyle<=WBORDER_SINGLE) return;
		MoveToEx(hdc,1,GetHeight()-2,NULL);
		SetDCPenColor(hdc,borderparams->simple.nw1);
			LineTo(hdc,1,1);
			LineTo(hdc,GetWidth()-2,1);
		SetDCPenColor(hdc,borderparams->simple.se1);
			LineTo(hdc,GetWidth()-2,GetHeight()-2);
			LineTo(hdc,0,GetHeight()-2);
		if(wborderstyle<=WBORDER_3D_FINO) return;
		MoveToEx(hdc,2,GetHeight()-3,NULL);
		SetDCPenColor(hdc,borderparams->simple.nw23);
			LineTo(hdc,2,2);
			LineTo(hdc,GetWidth()-3,2);
		SetDCPenColor(hdc,borderparams->simple.se23);
			LineTo(hdc,GetWidth()-3,GetHeight()-3);
			LineTo(hdc,1,GetHeight()-3);
		if(wd_iz<4) return;
		MoveToEx(hdc,3,GetHeight()-4,NULL);
		SetDCPenColor(hdc,borderparams->simple.nw23);
			LineTo(hdc,3,3);
			LineTo(hdc,GetWidth()-4,3);
		SetDCPenColor(hdc,borderparams->simple.se23);
			LineTo(hdc,GetWidth()-4,GetHeight()-4);
			LineTo(hdc,2,GetHeight()-4);
	}else{
	}
	return;
}

void ATWindow::Paint(PAINTSTRUCT *ps){
	this->DrawBorder(ps->hdc);
}

__declspec(dllexport) LRESULT ATWindow::HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
	switch(message){
		case WM_NCHITTEST:
			{LONG style;
			POINT p;
			style=(LONG)GetWindowLongPtr(hwnd,GWL_STYLE);
			if(!(style&WS_POPUP) || (style&WS_OVERLAPPEDWINDOW)) break;
			p.x=LOWORD(lParam),
			p.y=HIWORD(lParam);
			ScreenToClient(hwnd,&p);
			return this->TestPos(p.x,p.y);}
		case WM_SIZE:
			if(wborderstyle<=WBORDER_LAST_ZERO) break;
			//GetBorderRegion();
			{RECT rect;
				rect.left=0; rect.top=0;
				rect.right=GetWidth(); rect.bottom=wd_ar;
			InvalidateRect(hwnd,&rect,false);
				rect.bottom=GetHeight();
				rect.top=rect.bottom-wd_ab;
			InvalidateRect(hwnd,&rect,false);
				rect.top=0; rect.bottom=GetHeight();
				rect.right=wd_iz;
			InvalidateRect(hwnd,&rect,false);
				rect.right=GetWidth();
				rect.left=rect.right-wd_de;
			InvalidateRect(hwnd,&rect,false);
			}
			break;
	}
	return this->RootGraphicWindow::HostedWndProc(message, wParam, lParam);
}
