﻿#include <ATcrt/ATmemstr.h>
#include <malloc.h>
#include <stdio.h>
#include "defaultextension.h"
#include "relativa/Aerotri_defs_internal.h"
#include <math.h>
#include "relativa/lecturaf.h"
#include <ATcrt/ATArrays.h>
#include "relativa/hash_nombre.h"

int wmain(int argc, wchar_t* argv[]){
	int nret;
	char16_t mensaje[512];
	u8int idioma;
	Vector_Fotograma fotogramas1, fotogramas2;
	Vector_Pesopf pesospf1, pesospf2;
	char *nombresf1, *nombresf2, *nombres1, *nombres2;
	uint *puntos1, *puntos2;
	uint npuntos1, npuntos2 ,np2;
	uint *f2af1, *p2ap1;
	uint nfin;
	u8int mar;
	char16_t fichero1[MAX_PATH], fichero2[MAX_PATH], ficheroftm[MAX_PATH];

	idioma=0;
	mensaje[0]=0;
	if(argc<4){
		fputws(L"Uso del programa: mergeftm <fichero ftm 1> <fichero ftm 2> <fichero ftm a generar>\n\n"
			L"Si hay puntos repetidos se mantienen las fotocoordenadas del fichero ftm 1", stdout);
		return 0;
	}
#ifdef _DEBUG
	fputws(L"Presione una tecla para continuar...", stdout);
	getchar();
#endif

	strncpy16(fichero1,(char16_t*)argv[argc-3],MAX_PATH);
	strncpy16(fichero2,(char16_t*)argv[argc-2],MAX_PATH);
	strncpy16(ficheroftm,(char16_t*)argv[argc-1],MAX_PATH);
	if(fichero1[MAX_PATH-8] | fichero2[MAX_PATH-8] | ficheroftm[MAX_PATH-8]){
		fputws(L"Error. Los nombres de los ficheros son demasiado largos",stderr);
		return 10;
	}
	append_default_ext(fichero1,u"ftm",4,0);
	append_default_ext(fichero2,u"ftm",4,1);
	append_default_ext(ficheroftm,u"ftm",4,1);

	lecturaf_set_globals(0,mensaje,1);
	mar=FOTOSFORMAT_Aerotri;
	nret=lee_ficherof(fichero1,&mar,NULL,0,&fotogramas1,&nombresf1,&pesospf1,&nombres1,&puntos1,&npuntos1,-1.F);
	if(fotogramas1.ppio==NULL || nret){
		fputws(L"Error en el fichero de fotogramas:\n",stderr);
		fputws((wchar_t*)mensaje,stderr);
		nret=1;
	}
	if(!nret){
		mar=1;
		nret=lee_ficherof(fichero2,&mar,NULL,0,&fotogramas2,&nombresf2,&pesospf2,&nombres2,&puntos2,&npuntos2,-1.F);
		if(fotogramas2.ppio==NULL || nret){
			fputws(L"Error en el fichero de fotogramas:\n",stderr);
			fputws((wchar_t*)mensaje,stderr);
			nret=1;
		}
	}
	if(nret){
		if(fotogramas1.ppio!=NULL){
			free(puntos1);	free(nombres1);		free(nombresf1);
			free(fotogramas1.ppio);
		}
		if(fotogramas2.ppio!=NULL){
			free(puntos2);	free(nombres2);		free(nombresf2);
			free(fotogramas2.ppio);
		}
		return nret;
	}

	{durchVectori(Fotograma,fotogramas1) ptri->nom=nombresf1+ptri->index;}
	{durchVectori(Pesopf,pesospf1) ptri->nom=nombresf1+ptri->index;}
	{durchVectori(Fotograma,fotogramas2) ptri->nom=nombresf2+ptri->index;}
	{durchVectori(Pesopf,pesospf2) ptri->nom=nombresf2+ptri->index;}

	f2af1=NULL;
	p2ap1=NULL;
	aj_malloc_n(f2af1,uint,fotogramas2.n);
	aj_malloc_n(p2ap1,uint,npuntos2);

#define addto_delete_ind(p,q)
	{crea_rellena_hreordenV(reorden_f,Fotograma,fotogramas1,std_getnom);
	asocia_a_hreorden(reorden_f,Fotograma,fotogramas2.ppio,fotogramas2.n,std_getnom,f2af1);
	free(reorden_f.ppio);}

#define getnom_nombres1(ptr) nombres1+*(ptr)
#define getnom_nombres2(ptr) nombres2+*(ptr)

	{crea_rellena_hreorden(reorden_p,uint,puntos1,npuntos1,getnom_nombres1);
	asocia_a_hreorden(reorden_p,uint,puntos2,npuntos2,getnom_nombres2,p2ap1);
	free(reorden_p.ppio);}
	np2=0;
	{durchlaufei(uint,p2ap1,npuntos2) if(*ptri==-1) np2++;}
	puntos1=(uint*)realloc(puntos1,(npuntos1+np2)*usizeof(uint));
	
	nfin=puntos1[npuntos1-1];
	nfin+=strlen8(nombres1+nfin)+1;
	{durchlaufei(uint,p2ap1,npuntos2){
		if(*ptri==-1){
			uint k=(pdif)(ptri-p2ap1);
			puntos1[npuntos1]=nfin;
			nfin+=strlen8(nombres2+puntos2[k])+1;
			*ptri=npuntos1++;
		}
	}}
	nombres1=realloc(nombres1,(nfin+1)*usizeof(char));
	npuntos1-=np2;
	{durchlaufei(uint,p2ap1,npuntos2){
		if(*ptri>=npuntos1){
			uint k=(pdif)(ptri-p2ap1);
			strcpy(nombres1+puntos1[*ptri],nombres2+puntos2[k]);
		}
	}}
	nombres1[nfin]='\0';

	{durchlaufe2(Fotograma,fotogramas2.ppio,fotogramas2.n,uint,f2af1){
		{durchVectorj(Puntof,ptr->puntos) ptrj->index=p2ap1[ptrj->index];}
		if(*ptr_b==-1){
			Vadd(fotogramas1,Fotograma,*ptr,goto salida_outofmem);
			ptr->puntos.ppio=NULL;
		}else{
			Fotograma *pf1;
			Hash_huint hash1;
			pf1=fotogramas1.ppio+*ptr_b;
			HsetupЯ(huint,hash1,pf1->puntos.n,goto salida_outofmem);
			{durchlaufei(Puntof,pf1->puntos.ppio,pf1->puntos.n){addh_huint(&hash1,ptri->index,);}}
			{durchVectorj(Puntof,ptr->puntos){
				huint *ph=geth_huint(&hash1,ptrj->index);
				if(ph!=NULL) continue;
				Vadd(pf1->puntos,Puntof,*ptrj,goto salida_outofmem);
			}}
			free(hash1.ppio);
		}
	}}

	nret=escribe_ftm(ficheroftm,fotogramas1.ppio,nombres1,puntos1,fotogramas1.n,pesospf1.ppio,pesospf1.n,-1.F,1);

	if(nret){
		fputws(L"Error al escribir el fichero de fotogramas a generar:\n",stderr);
		fputws((wchar_t*)mensaje,stderr);
		nret=3;
	}

salida:
	freeif(p2ap1);
	freeif(f2af1);

	freeif(pesospf2.ppio);
	free(puntos2); free(nombres2); free(nombresf2);
	{durchVectori(Fotograma,fotogramas2) freeif(ptri->puntos.ppio);}
	free(fotogramas2.ppio);

	freeif(pesospf1.ppio);
	free(puntos1); free(nombres1); free(nombresf1);
	{durchVectori(Fotograma,fotogramas1) free(ptri->puntos.ppio);}
	free(fotogramas1.ppio);

	return nret;

salida_outofmem:
	nret=AT_NOMEM; goto salida;
}
