#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define PI 3.14159265358979324
#define PI_2 1.57079632679489662
typedef double Double;

static inline Double Nrho(Double a,Double e, Double sinphi){
	Double x;
	x=(1-e*sinphi*sinphi);
	x*=(1-e)*x*x;
	return x*a*a;
}
double phi_lam(Double a, Double e, Double lam){
	Double A,B,C,D;
	Double e4,e6;
	Double phi;
	e4=e*e;
	e6=e4*e;

	A=1+3/4.0*e+45/64.0*e4+175/256.0*e6;
	B=3/4.0*e+15/16.0*e4+525/512.0*e6;
	C=15/64.0*e4+105/256.0*e6;
	D=35/512.0*e6;

	A=1/A;
	B*=A/2;	C*=A/4;	D*=A/6;

	lam*=A/(a*(1-e));
	phi=lam;
	for(;;){
		Double phip=phi;
		phi=lam+B*sin(2*phip)-C*sin(4*phip)+D*sin(6*phip);
		if(fabs(phip-phi)<1e-8) break;
	}
	return phi;
}
Double k_UTM_GRS80(Double X, Double Y, Double a){
	Double factor;
	Double ka,kb;
	Double a0,a2,a4,a6,a8;
	Double b0,b2;
	Double x2, y2, y4;

	//Constantes para los valores a y e del elipsoide GRS80
	a0=0.01237370;
	a2=-4.1275e-6;
	a4=3.546e-8;
	a6=-1.35e-10;
	a8=3.75e-13;
	b0=2.62e-5;
	b2=-3.53e-8;

	factor=6378137.0/a;	//ajustamos a la 'a' del elip. GRS80.
	factor/=1000000;
	X*=factor;	Y*=factor;

	x2=X*X;
	y2=Y*Y;	y4=y2*y2;

	ka=a0+a2*y2+a4*y4+a6*y4*y2+a8*y4*y4;	ka*=x2;
	kb=b0+b2*y2;									kb*=x2*x2;

	return (1 + ka+kb);
}
Double ajuste_kUTM(Double a, Double e, Double x, Double y){
	Double phi,Nrmio,NrGRS80;

	{Double factor=6378137.0/a;
	x*=factor;		y*=factor;}
	
	phi=phi_lam(6378137.0, e, y);
	Nrmio=Nrho(6378137.0,e,phi);
	phi=phi_lam(6378137.0, 0.00669438, fabs(y));
	if(phi>PI_2) phi=PI_2;
	NrGRS80=Nrho(6378137, 0.00669438,phi);

	return 1+0.5*x*x*(1/Nrmio-1/NrGRS80);
}

static inline Double kUTM_x(Double a,Double e, Double x,Double y,Double k0){
	Double k;
	x/=k0;		y/=k0;
	k=k_UTM_GRS80(x,y,a);
	if(e<0.0066 || e>0.00685) k*=ajuste_kUTM(a,e,x,y);
	return k*k0;
}

int main(int argc, char* argv[]){
	Double  a,e,xO,yS,k0, x,y;
	Double k;

	if(argc<3){
		puts(u8"\nUso del programa: kUTM <X> <Y>\n");
		puts(u8"O bien: kUTM <opciones> <X> <Y>\n");
		puts(u8"La primera forma calcula k para las coordenadas indicadas\n"
			u8"y los parámetros por defecto: elipsoide GRS80, escala central 0.9996\n"
			u8"desplazamiento X = 500000, desplazamiento Y = 0\n");
		puts(u8"La forma con opciones permite modificar estos parámetros.\n"
			u8"Las opciones son las siguientes:\n"
			u8"-a <número>: indica el semieje mayor del elipsoide (a)\n"
			u8"-e <número>: primera excentricidad al cuadrado (e^2)\n"
			u8"-k0 <número>: factor de escala de la proyección en el meridiano central\n"
			u8"-xO <número>: coordenada X de los puntos sobre el meridiano central\n"
			u8"-yS <número>: coordenada Y de los puntos sobre el Ecuador\n");
		return 0;
	}
#ifdef _DEBUG
	puts(u8"Presione una tecla para continuar...");
	getchar();
#endif


	a=6378137.0;
	e=0.00669438;
	k0=0.9996;
	xO=500000.0;
	yS=0.0;

	if(argc>3){
		char **argv_fin, **ptr;
		argv_fin=argv+ (argc-2);
		ptr=argv+1;
		while(ptr+1<argv_fin){	//+1 porque no hay opciones sin argumentos
			Double ff;
			char *arg=*ptr;
			if(arg[0]!='-'){ptr+=2; continue;}
			ff=atof(ptr[1]);
			if(arg[2]=='\0'){
				if(arg[1]=='a') a=ff;
				else if(arg[1]=='e') e=ff;
			}else if(arg[3]=='\0'){
				if(arg[1]=='k' && arg[2]=='0') k0=ff;
				else if(arg[1]=='x' && arg[2]=='O') xO=ff;
				else if(arg[1]=='y' && arg[2]=='S') yS=ff;
			}
			ptr+=2;
		}
	}

	x=atof(argv[argc-2]);
	y=atof(argv[argc-1]);
	x-=xO;
	y-=yS;

	k=kUTM_x(a,e, x,y,k0);

	printf(u8"k= %11.9f",k);

	return 0;
}
