#include <ATcrt/ATmemstr.h>
#include <stdio.h>
#include <ATcrt/ATfileoutput.h>
#include "defaultextension.h"
#include "relativa/distorsion.h"

int wmain(int argc, wchar_t* argv[]){
	int nret;
	char16_t mensaje[512];
	u8int idioma;
	OrientacionInterna interna1;
	InternaKPB mala;
	u8int inexacto;
	float desp;
	char16_t ficheroint[MAX_PATH], ficherocmr[MAX_PATH];

	idioma=0;
	mensaje[0]=0;
	if(argc<3){
		fputws(L"Uso del programa: int2cmr <fichero int> <fichero cmr a generar>", stdout);
		return 0;
	}
#ifdef _DEBUG
	fputws(L"Presione una tecla para continuar...", stdout);
	getchar();
#endif

	strncpy16(ficheroint,(char16_t*)argv[argc-2],MAX_PATH);
	strncpy16(ficherocmr,(char16_t*)argv[argc-1],MAX_PATH);
	if(ficherocmr[MAX_PATH-8]!='\0' || ficheroint[MAX_PATH-8]!='\0'){
		fputws(L"Error. Los nombres de los ficheros son demasiado largos",stderr);
		return 10;
	}
	append_default_ext(ficheroint,u"int",4,0);
	append_default_ext(ficherocmr,u"cmr",4,1);

	nret=lee_ficheroint(ficheroint,0,&interna1,mensaje,idioma);
	if(nret){
		fputws(L"Error en el primer fichero:\n",stderr);
		fputws((wchar_t*)mensaje,stderr);
		free_interna(&interna1);
		return 1;
	}

	inexacto=(u8int)interna_kpb___Aerotri(&interna1,&mala,&desp);
	free_interna(&interna1);
	if(inexacto==4){
		fputws(L"La interna de Aerotri no se puede transformar a formato cmr.\nLa transformacin afn es demasiado compleja",stderr);
		return 4;
	}
	if(inexacto==5){
		fputws(L"La interna de Aerotri no se puede transformar a formato cmr.\nEl modelo polinmico ha de ser Impar",stderr);
		return 4;
	}
	if(mala.k[4]!=0) inexacto|=2;

	nret=escribe_ficheroint_cmr(ficherocmr,&mala,mensaje,idioma);
	if(nret){
		fputws(L"Error en al escribir el fichero cmr:\n",stderr);
		fputws((wchar_t*)mensaje,stderr);
		return 3;
	}

	if(inexacto==1) fputws(L"La transformacin a formato cmr es exacta. No obstante ha sido necesario desplazar el punto principal.\n",stdout);
	else{
		if(inexacto&2) fputws(L"La transformacin a formato cmr no es exacta\n",stdout);
		if(inexacto&1) fputws(L"Adems, ha sido necesario desplazar el punto principal.\n",stdout);
	}
	if(inexacto&1){
		fputws(L"Las orientaciones obtenidas con uno y otro fichero sern distintas.\n",stdout);
	}
	if(inexacto) return 5;
	return 0;
}
