﻿#include <ATcrt/ATmemstr.h>
#include <malloc.h>
#include <stdio.h>
#include <math.h>
#include <ATcrt/ATpaths.h>
#include <ATcrt/ATstring.h>
#include <ATcrt/ATfileinput.h>
#include "defaultextension.h"
#include "relativa/Aerotri_defs_internal.h"
#include "relativa/Clases2d3d.h"
#include "relativa/Rotacion.h"
#include "relativa/epipolar.h"
int escribe_imaster_rel(char* ficheroori, char* nombre1, char* nombre2, PuntoXYZM_double* centro1,double N1[][3], PuntoXYZM_double* centro2,double N2[][3], char16_t *mensaje, u8int idioma);

int wmain(int argc, wchar_t* argv[]){
	int nret;
	char16_t mensaje[512];
	u8int idioma;
	Bufferti8 buffer;
	PuntoXYZM_double CP1, CP2;
	Giro3D_double G;
	double N[3][3];
	const double ccpi_1=0.01745329252;
	char16_t fichero1[MAX_PATH], fichero2[MAX_PATH], ficherorel[MAX_PATH];
#define finot_get_double(buffer,x) ifnot_get_double_do(finishline_advance,buffer,x)

	idioma=0;
	mensaje[0]=0;
	if(argc<3){
		fputws(L"Uso del programa: ext2rel <ficheroextprimero> <ficheroextsegundo>\n"
					L"La extensión supuesta por defecto es .ext\n", stdout);
		return 0;
	}
#ifdef _DEBUG
	fputws(L"Presione una tecla para continuar...", stdout);
	getchar();
#endif

	strncpy16(fichero1,(char16_t*)argv[argc-2],MAX_PATH);
	strncpy16(fichero2,(char16_t*)argv[argc-1],MAX_PATH);
	if(fichero1[MAX_PATH-12]!='\0' || fichero2[MAX_PATH-12]!='\0'){
		fputws(L"Error. Los nombres de los ficheros son demasiado largos",stderr);
		return 10;
	}
	append_default_ext(fichero1,u"ext",4,0);
	append_default_ext(fichero2,u"ext",4,0);

	nret=tiopen_mixed(&buffer,fichero1);
	if(nret<0){
		fputws(L"No se puede abrir el primer fichero para leer",stderr);
		return 1;
	}
	advance(buffer);
	finishline_advance(buffer);
	finot_get_double(buffer,CP1.P.X) goto error_file1;
	finot_get_double(buffer,CP1.P.Y) goto error_file1;
	finot_get_double(buffer,CP1.P.Z) goto error_file1;
	finot_get_double(buffer,G.ω) goto error_file1;
	finot_get_double(buffer,G.φ) goto error_file1;
	if(*buffer.pc=='\0'){
		fputws(L"El primer fichero está incompleto",stderr);
		return 1;
	}
	finot_get_double(buffer,G.κ) goto error_file1;
	ticlose(buffer);
	P_mul(G,ccpi_1);
	MatrizRot_KFO(G,CP1.M);

	nret=tiopen_mixed(&buffer,fichero2);
	if(nret<0){
		fputws(L"No se puede abrir el segundo fichero para leer",stderr);
		return 2;
	}
	advance(buffer);
	finishline_advance(buffer);
	finot_get_double(buffer,CP2.P.X) goto error_file2;
	finot_get_double(buffer,CP2.P.Y) goto error_file2;
	finot_get_double(buffer,CP2.P.Z) goto error_file2;
	finot_get_double(buffer,G.ω) goto error_file2;
	finot_get_double(buffer,G.φ) goto error_file2;
	if(*buffer.pc=='\0'){
		fputws(L"El segundo fichero está incompleto",stderr);
		return 2;
	}
	finot_get_double(buffer,G.κ) goto error_file2;
	ticlose(buffer);
	P_mul(G,ccpi_1);
	MatrizRot_KFO(G,CP2.M);

	epipolar(&CP1,&CP2,N);
	{char16_t *s, *ext, *s1, *s2, *fin;
	path_get_filename16(fichero1,s1);
	path_get_extension16(s1,ext);
	fin=ext; do fin++; while(*fin);
	if(*ext!='.' || (pdif)(fin-ext)>5) ext=fin;
	*ext='\0';
	s=strpcpy16(ficherorel,fichero1);
	*s++='-';
	path_get_filename16(fichero2,s2);
	path_get_extension16(s2,ext);
	fin=ext; do fin++; while(*fin);
	if(*ext!='.' || (pdif)(fin-ext)>5) ext=fin;
	*ext='\0';
	s=strpcpy16(s,s2);
	*s++=u'.'; *s++=u'r'; *s++=u'e'; *s++=u'l'; *s='\0';
	{char sc_rel[MAX_PATH], sc1[MAX_PATH], sc2[MAX_PATH];
	char *s8;
	s8=sc_rel, s=ficherorel; do *s8++=(char)*s; while(*s++);
	s8=sc1, s=s1; do *s8++=(char)*s; while(*s++);
	s8=sc2, s=s2; do *s8++=(char)*s; while(*s++);
	nret=escribe_imaster_rel(sc_rel,sc1,sc2,&CP1,N,&CP2,N,mensaje,idioma);
	if(nret){
		fputws(L"Se produjo un error en la escritura del fichero rel:\n\n",stderr);
		fputws((wchar_t*)mensaje,stderr);
		return 3;
	}
	}}
	return 0;

error_file1:
	fputws(L"Error en la lectura del primer fichero:\n Mientras se estaba leyendo un número se encontró en carácter '",stderr);
	fputc(*buffer.pc,stderr); fputwc(L'\'',stderr);
	return 1;
error_file2:
	fputws(L"Error en la lectura del segundo fichero:\n Mientras se estaba leyendo un número se encontró en carácter '",stderr);
	fputc(*buffer.pc,stderr); fputwc(L'\'',stderr);
	return 2;
}
