#include <ATcrt/ATmemstr.h>
#include <ATcrt/ATstring.h>
#include <stdio.h>
#include <math.h>
#include "defaultextension.h"
#include "relativa/distorsion.h"

s8int log10n_d(double x){
	s8int log;
	if(x==0) return -127;
	if(x<0) x=-x;

	/*s8int */log=0;
	while(x<1) x*=10,log--;
	if(x>10){double y; for(y=10; x>=y; y*=10,log++);}
	return log;
}

u8int numarg(wchar_t *s){
	if(s[0]=='-'){
		if(s[1]=='f' && s[2]=='\0') return 1;
		if(s[1]=='p' && s[2]=='p' && s[3]=='-' && s[4]=='\0') return 2;
	}
	return 0;
}

int main(int argc, wchar_t* argv[]){
	int nret;
	char16_t mensaje[512];
	u8int idioma;
	u8int decim,decf;
	OrientacionInterna interna;
	bint bfocal, bpp;
	char16_t ficherocmr[MAX_PATH], ficheroint[MAX_PATH];

	idioma=0;
	mensaje[0]=0;
	if(argc<3){
		fputws(L"Uso del programa: cmr2int [-f -pp-] <fichero cmr> <fichero int a generar>\n"
					L"La opcin -f obliga a mantener el valor de la focal\n"
					L"La opcin -pp- permite mover el punto principal", stdout);
		return 0;
	}
#ifdef _DEBUG
	fputws(L"Presione una tecla para continuar...", stdout);
	getchar();
#endif

	strncpy16(ficherocmr,(char16_t*)argv[argc-2],MAX_PATH);
	strncpy16(ficheroint,(char16_t*)argv[argc-1],MAX_PATH);
	if(ficherocmr[MAX_PATH-8]!='\0' || ficheroint[MAX_PATH-8]!='\0'){
		fputws(L"Error. Los nombres de los ficheros son demasiado largos",stderr);
		return 10;
	}
	append_default_ext(ficherocmr,u"cmr",4,0);
	append_default_ext(ficheroint,u"int",4,1);

	bfocal=true;
	bpp=false;
	if(argc>=4){
		u8int k=numarg(argv[argc-3]);
		if(k==1) bfocal=false;
		else if(k==2) bpp=true;
	}
	if(argc>=5){
		u8int k=numarg(argv[argc-4]);
		if(k==1) bfocal=false;
		else if(k==2) bpp=true;
	}
	nret=lee_ficheroint_bfpp(ficherocmr,2,&interna,bfocal,bpp,mensaje,idioma);
	if(nret){
		fputws(L"Error en el primer fichero:\n",stderr);
		fputws((wchar_t*)mensaje,stderr);
		free_interna(&interna);
		return 1;
	}

	decf=6-log10n_d(interna.valI.f);
	decim=6-log10n_d(interna.valI.f/interna.afin_1.a);
	if(decf<0) decf=0;
	if(decim<0) decim=0;
	nret=escribe_ficheroint(ficheroint,&interna,decim,decf,mensaje,0);
	free_interna(&interna);
	if(nret){
		mensaje[511]=u'\0';
		fputws(L"Error en la escritura del fichero de interna:\n    ",stderr);
		fputws((wchar_t*)mensaje,stderr);
		return 3;
	}
	return 0;
}
