#include "ATcrt\system.h"
#include "ATcrt/ATmem.h"
#include "ATcrt/ATmemstr.h"
#include <stdio.h>
#include <malloc.h>
#include <float.h>
#include <math.h>
#include "relativa\Aerotri_defs_internal.h"
#include "relativa\lecturaf.h"
#include "relativa\hash_nombre.h"
#include "relativa\rotacion.h"
#include "relativa\Clases_genDibujo.h"
#include "relativa\grafico_gen.h"

int wmain(int argc, wchar_t* argv[]){
	int nret;
	char16_t mensaje[512];
	u8int idioma;
	u8int prm, mar;
	Vector_CentroProy centros;
	char* nombresCP;
	Vector_PuntoM puntosM;
	char* nombresM;
	s8int uni;
	s8int decf, decp;
	Sistema sis;
	u16int flags, flags_errors;
	Vector_Fotograma fotogramas;
	char *nombresf, *nombres;
	uint* puntos;
	uint npuntos;
	struct CentroPunto{
		CentroProy *pcentro;
		uint npunto;
	};
	struct{
		struct CentroPunto mx, MX,
								my, MY;
	} cpmax;

	CentroProyDibujo *centrosDibujo;
	PuntoXYZ_Double *centrosD_bordes;

	PLIST plist;

	idioma=0;
	mensaje[0]=0;
	if(argc<4){
		_putws(L"Uso del programa: ajs2gra <fichero ajs> <fichero ftm> <fichero gra a generar>\n"
					L"El fichero ajs es un fichero de valores ajustados, aproximados o apoyo de Aerotri.\nNormalmente tienen extensiones .ajs, .prm y .pym respectivamente.\n"
					L"El fichero ftm es un fichero de fotogramas con formato Aerotri");
		return 0;
	}
#ifdef _DEBUG
	_putws(L"Presione una tecla para continuar...");
	getchar();
#endif

	plist=get_new_plist();
	nret=0;

	lecturaf_set_globals(idioma,mensaje,0);
	mar=FOTOSFORMAT_Aerotri;
	prm=CCPPFORMAT_Aerotriccpp;
	uni=2;
	decp=decf=0;

	nret=lee_ficheroapr_noprec_sis((char16_t*)argv[1], &prm, 1, &centros,&nombresCP, &puntosM,&nombresM, &flags, &flags_errors, 6,&decf,&decp, &sis);
	if(centros.ppio!=NULL){
		Addto_delete(centros.ppio); Addto_delete(nombresCP);
		durchVectori(CentroProy,centros) ptri->nom=nombresCP+ptri->index;
	}
	if(puntosM.ppio!=NULL){
		Addto_delete(puntosM.ppio); Addto_delete(nombresM);
		durchVectori(PuntoM,puntosM) ptri->nom=nombresM+ptri->index;
	}
	if(nret){
		fputws(L"Error en la lectura del fichero ajs",stderr);
		myreturn(1);
	}
	if(centros.ppio==NULL && puntosM.ppio==NULL){
		fputws(L"El fichero ajs no contiene centros de proyeccin ni puntos",stderr);
		myreturn(4);
	}
	if(centros.ppio!=NULL){
		uint* p_acum;
		uint* p_en_f;
		Extremos2D_fl dim_f;
		float semix,semiy;
		uint* pf_a_pm;

		nret=lee_ficherof((char16_t*)argv[2],&mar,NULL,0,&fotogramas,&nombresf,NULL,&nombres,&puntos,&npuntos,-1);
		if(fotogramas.ppio!=NULL){
			Addto_delete(fotogramas.ppio);
			Addto_delete(nombresf);
			Addto_delete(nombres);
			Addto_delete(puntos);
		}
		{durchVectori(Fotograma,fotogramas){
			Addto_delete(ptri->puntos.ppio);
			ptri->nom=nombresf+ptri->index;
		}}
		if(nret){
			fputws(L"Error en la lectura del fichero de fotogramas",stderr);
			nret=2; goto salida;
		}
		if(fotogramas.n==0){
			fputws(L"El fichero de fotogramas no contiene ningn fotograma",stderr);
			nret=2; goto salida;
		}

		aj_malloc_add(p_acum,uint,fotogramas.n+1);
		p_acum[0]=0;
		for(uint i=0;i<fotogramas.n;i++){
			p_acum[i+1]=p_acum[i]+fotogramas.ppio[i].puntos.n;
		}
		if(p_acum[fotogramas.n]<3){
			fputws(L"Los fotogramas no contienen puntos",stderr);
			nret=2; goto salida;
		}

		{Hash_reorden fotos_hash;
		HStdSetup(reorden,fotos_hash,fotogramas.n);
		{durchVectori_fwd(Fotograma,fotogramas){
			inserth_reorden(&fotos_hash,ptri->nom,i);
		}}
		durchVectori(CentroProy,centros){
			reorden *pelem=geth_reorden(&fotos_hash,ptri->nom);
			if(pelem!=NULL){
				ptri->fot=fotogramas.ppio+pelem->n;
				if(ptri->fot->puntos.n<3) ptri->fot=NULL;
			}
			else ptri->fot=NULL;
		}
		Free_remove(fotos_hash.ppio);
		}
		aj_malloc_add(pf_a_pm,uint,npuntos);
		{Hash_reorden puntosM_hash;
		HStdSetup(reorden,puntosM_hash,puntosM.n);
		{PuntoM *ptri=puntosM.ppio;
		for(uint i=0;i<puntosM.n;i++,ptri++){
			if(ptri->bbb==0) continue;
			inserth_reorden(&puntosM_hash,ptri->nom,i);
		}}
		durchlaufe2(uint,pf_a_pm,npuntos,uint,puntos){
			reorden *pelem=geth_reorden(&puntosM_hash,nombres+*ptr_b);
			if(pelem==NULL) *ptr=-1;
			else *ptr=pelem->n;
		}
		Free_remove(puntosM_hash.ppio);
		}

		aj_malloc_add(p_en_f,uint,p_acum[fotogramas.n]);
		{uint *pint=p_en_f;
		durchVectori(Fotograma,fotogramas){
			durchVectorj(Puntof,ptri->puntos) *pint++=ptrj->index;
		}}
		{dim_f.mx=FLT_MAX;	dim_f.MX=-FLT_MAX;
		dim_f.my=FLT_MAX;	dim_f.MY=-FLT_MAX;
		durchVectori(CentroProy,centros){
			if(ptri->fot==NULL) continue;
			durchVectorj(Puntof,ptri->fot->puntos){
				Puntoxy_float p;
				p.x=(float)ptrj->p.x;	p.y=(float)ptrj->p.y;
				if(p.x<dim_f.mx){
					dim_f.mx=p.x;
					cpmax.mx.pcentro=ptri;
					cpmax.mx.npunto=ptrj->index;
				}
				if(p.x>dim_f.MX){
					dim_f.MX=p.x;
					cpmax.MX.pcentro=ptri;
					cpmax.MX.npunto=ptrj->index;
				}
				if(p.y<dim_f.my){
					dim_f.my=p.y;
					cpmax.my.pcentro=ptri;
					cpmax.my.npunto=ptrj->index;
				}
				if(p.y>dim_f.MY){
					dim_f.MY=p.y;
					cpmax.MY.pcentro=ptri;
					cpmax.MY.npunto=ptrj->index;
				}
			}
		}}
		semix=0.5F*(dim_f.MX+dim_f.mx);
		semiy=0.5F*(dim_f.MY+dim_f.my);
		{durchVectori(Fotograma,fotogramas){
			durchVectorj(Puntof,ptri->puntos){
				ptrj->p.x-=semix;
				ptrj->p.y-=semiy;
			}
		}}
		//dim_f.mx-=semix; dim_f.MX-=semix;
		//dim_f.my-=semiy; dim_f.MY-=semiy;

		{PuntoXYZ_Double Q;
		P_op(Q,=,puntosM.ppio[pf_a_pm[cpmax.mx.npunto]].P,-,cpmax.mx.pcentro->P);
		AutoGira(&Q,cpmax.mx.pcentro->M);
		dim_f.mx=-(float)Q.X/(float)Q.Z;
		P_op(Q,=,puntosM.ppio[pf_a_pm[cpmax.MX.npunto]].P,-,cpmax.MX.pcentro->P);
		AutoGira(&Q,cpmax.MX.pcentro->M);
		dim_f.MX=-(float)Q.X/(float)Q.Z;
		P_op(Q,=,puntosM.ppio[pf_a_pm[cpmax.my.npunto]].P,-,cpmax.my.pcentro->P);
		AutoGira(&Q,cpmax.my.pcentro->M);
		dim_f.my=-(float)Q.Y/(float)Q.Z;
		P_op(Q,=,puntosM.ppio[pf_a_pm[cpmax.MY.npunto]].P,-,cpmax.MY.pcentro->P);
		AutoGira(&Q,cpmax.MY.pcentro->M);
		dim_f.MY=-(float)Q.Y/(float)Q.Z;}

		if(dim_f.mx>dim_f.MX){
			float aux=dim_f.mx; dim_f.mx=dim_f.MX; dim_f.MX=aux;
			{durchVectori(Fotograma,fotogramas){
				durchVectorj(Puntof,ptri->puntos) ptrj->p.x=-ptrj->p.x;}}
		}
		if(dim_f.my>dim_f.MY){
			float aux=dim_f.my; dim_f.my=dim_f.MY; dim_f.MY=aux;
			{durchVectori(Fotograma,fotogramas){
				durchVectorj(Puntof,ptri->puntos) ptrj->p.y=-ptrj->p.y;}}
		}

		aj_malloc_add(centrosDibujo,CentroProyDibujo,centros.n);
		aj_malloc_add(centrosD_bordes,PuntoXYZ_Double,12*centros.n);
		{PuntoXYZ_Double *ppunto=centrosD_bordes;
		durchlaufe2(CentroProyDibujo,centrosDibujo,centros.n, CentroProy,centros.ppio){
			*(CentroProy*)ptr=*ptr_b;
			if(ptr->fot!=NULL) 	ptr->npuntos=12;
			else ptr->npuntos=0;
			ptr->borde=ppunto; ppunto+=12;
		}}
		Calcula_CentroProyDibujo(centrosDibujo,centros.n,fotogramas.ppio,puntosM.ppio,p_en_f,p_acum,pf_a_pm,dim_f);
	}else{
		centrosDibujo=NULL;
	}

	{durchVectori(PuntoM,puntosM) ptri->bbb=0;}
	if(decp>decf) decf=decp;
	if(decf>7) decf=7;
	nret=Crea_fdibujo((char16_t*)argv[3],decf,&sis, centrosDibujo,centros.n, puntosM.ppio,puntosM.n);
	if(nret){
		fputws(L"Se produjo un error al intentar escribir el fichero gra",stderr);
		nret=3; goto salida;
	}

salida:
	myreturn(nret);
salida_outofmem:
	fputws(L"El programa se ha quedado sin memoria",stderr);
	myreturn(-2);
}
